/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.javaee.web.model.xml.Servlet;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.ws.SpringWebServicesBundle;
import com.intellij.spring.ws.inspections.CreateSpringWebServiceApplicationContextFix;
import com.intellij.spring.ws.util.SpringWebServicesUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringMessageDispatcherWebXmlInspection
extends BasicDomElementsInspection<WebApp> {
    public SpringMessageDispatcherWebXmlInspection() {
        super(WebApp.class, new Class[0]);
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        Set<XmlFile> files;
        Servlet servlet;
        if (element instanceof Servlet && SpringWebServicesUtil.isMessageDispatcherServlet(servlet = (Servlet)element) && (files = SpringWebServicesUtil.getMessageDispatcherServletContexts(servlet)).size() == 0) {
            String servletName = servlet.getServletName().getStringValue();
            WebApp webApp = (WebApp)servlet.getParentOfType(WebApp.class, false);
            if (!StringUtil.isEmptyOrSpaces((String)servletName) && !this.containsPathSeparators(servletName) && SpringWebServicesUtil.getContextConfigurationParam(servlet) == null) {
                String path = SpringWebServicesUtil.getApplicationContextRelativePath(servletName);
                holder.createProblem((DomElement)servlet.getServletName(), HighlightSeverity.ERROR, SpringWebServicesBundle.message("SpringMessageDispatcherWebXmlInspection.cannot.find.app.context", path), this.getLocalFixes(servletName, webApp));
            }
        }
    }

    private boolean containsPathSeparators(@NotNull String name) {
        if (name == null) {
            SpringMessageDispatcherWebXmlInspection.$$$reportNull$$$0(0);
        }
        return name.indexOf(47) >= 0 || name.indexOf(File.separatorChar) >= 0;
    }

    private LocalQuickFix[] getLocalFixes(@NotNull String servletName, @Nullable WebApp webApp) {
        PsiDirectory psiDirectory;
        if (servletName == null) {
            SpringMessageDispatcherWebXmlInspection.$$$reportNull$$$0(1);
        }
        if (webApp != null && (psiDirectory = this.getWebInfPsiDirectory(webApp)) != null) {
            return new LocalQuickFix[]{new CreateSpringWebServiceApplicationContextFix(servletName, psiDirectory)};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @Nullable
    private PsiDirectory getWebInfPsiDirectory(@NotNull WebApp webApp) {
        PsiDirectory psiDirectory;
        PsiFile containingFile;
        if (webApp == null) {
            SpringMessageDispatcherWebXmlInspection.$$$reportNull$$$0(2);
        }
        if ((containingFile = webApp.getContainingFile()) != null && (psiDirectory = containingFile.getParent()) != null && "WEB-INF".equals(psiDirectory.getName())) {
            return psiDirectory;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servletName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webApp";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/ws/inspections/SpringMessageDispatcherWebXmlInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "containsPathSeparators";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocalFixes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getWebInfPsiDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

