/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.ws.SpringWebServicesBundle;
import com.intellij.spring.ws.util.SpringWebServicesUtil;
import org.jetbrains.annotations.NotNull;

public class CreateSpringWebServiceApplicationContextFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(CreateSpringWebServiceApplicationContextFix.class);
    private final String myServletName;
    private final SmartPsiElementPointer<PsiDirectory> myPsiDirectoryPointer;

    public CreateSpringWebServiceApplicationContextFix(@NotNull String servletName, @NotNull PsiDirectory psiDirectory) {
        if (servletName == null) {
            CreateSpringWebServiceApplicationContextFix.$$$reportNull$$$0(0);
        }
        if (psiDirectory == null) {
            CreateSpringWebServiceApplicationContextFix.$$$reportNull$$$0(1);
        }
        this.myServletName = servletName;
        this.myPsiDirectoryPointer = SmartPointerManager.getInstance((Project)psiDirectory.getProject()).createSmartPsiElementPointer((PsiElement)psiDirectory);
    }

    @NotNull
    public String getName() {
        String string = SpringWebServicesBundle.message("CreateSpringWebServiceApplicationContextFix.display.name", SpringWebServicesUtil.getApplicationContextFileName(this.myServletName));
        if (string == null) {
            CreateSpringWebServiceApplicationContextFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = SpringWebServicesBundle.message("CreateSpringWebServiceApplicationContextFix.family.name", new Object[0]);
        if (string == null) {
            CreateSpringWebServiceApplicationContextFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            CreateSpringWebServiceApplicationContextFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            CreateSpringWebServiceApplicationContextFix.$$$reportNull$$$0(5);
        }
        String fileName = SpringWebServicesUtil.getApplicationContextFileName(this.myServletName);
        try {
            WriteCommandAction.writeCommandAction((Project)project).run(() -> SpringCommonUtils.createSpringXmlConfigFile((String)fileName, (PsiDirectory)((PsiDirectory)this.myPsiDirectoryPointer.getElement())));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servletName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/ws/inspections/CreateSpringWebServiceApplicationContextFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/ws/inspections/CreateSpringWebServiceApplicationContextFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

