/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.actions.generate.patterns.transport;

import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.module.Module;
import com.intellij.spring.model.actions.patterns.frameworks.AbstractFrameworkSupportProvider;
import com.intellij.spring.model.actions.patterns.frameworks.ui.LibrariesInfo;
import com.intellij.spring.model.actions.patterns.frameworks.ui.TemplateInfo;
import com.intellij.spring.ws.SpringWebServicesBundle;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public final class JmsTransportFrameworkSupportProvider
extends AbstractFrameworkSupportProvider {
    @NonNls
    private static final String JMS_TRANSPORT_STRING_ID = "jms_transport";
    private static JmsTransportFrameworkSupportProvider myInstance;

    private JmsTransportFrameworkSupportProvider() {
    }

    public static JmsTransportFrameworkSupportProvider getInstance() {
        if (myInstance == null) {
            myInstance = new JmsTransportFrameworkSupportProvider();
        }
        return myInstance;
    }

    public LibrariesInfo getLibrariesInfo(Module module) {
        return new LibrariesInfo(LibraryInfo.EMPTY_ARRAY, module, JMS_TRANSPORT_STRING_ID);
    }

    public List<TemplateInfo> getTemplateInfos(Module module) {
        LinkedList<TemplateInfo> infos = new LinkedList<TemplateInfo>();
        TemplateSettings settings = TemplateSettings.getInstance();
        TemplateInfo payloadEndpoint = new TemplateInfo(module, settings.getTemplateById("payloadEndpoint"), SpringWebServicesBundle.message("spring.patterns.payload.endpoint", new Object[0]), null, false);
        TemplateInfo messageFactory = new TemplateInfo(module, settings.getTemplateById("messageFactory"), SpringWebServicesBundle.message("spring.ws.patterns.message.factory", new Object[0]), null, true);
        TemplateInfo messageListener = new TemplateInfo(module, settings.getTemplateById("messageListener"), SpringWebServicesBundle.message("spring.ws.patterns.message.listener", new Object[0]), null, true);
        TemplateInfo connectionFactory = new TemplateInfo(module, settings.getTemplateById("connectionFactory"), SpringWebServicesBundle.message("spring.ws.patterns.connection.factory", new Object[0]), null, true);
        TemplateInfo soapMessageDispatcher = new TemplateInfo(module, settings.getTemplateById("soapMessageDispatcher"), SpringWebServicesBundle.message("spring.ws.patterns.soap.message.dispatcher", new Object[0]), null, true);
        TemplateInfo messageListenerContainer = new TemplateInfo(module, settings.getTemplateById("messageListenerContainer"), SpringWebServicesBundle.message("spring.ws.patterns.soap.message.listener.container", new Object[0]), null, true);
        infos.add(payloadEndpoint);
        infos.add(connectionFactory);
        infos.add(messageFactory);
        infos.add(soapMessageDispatcher);
        infos.add(messageListener);
        infos.add(messageListenerContainer);
        return infos;
    }

    public String getDescription() {
        return SpringWebServicesBundle.message("spring.ws.patterns.jms.transport", new Object[0]);
    }
}

