/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class LocationOnDragTracker {
    private Point myOffsetXY;
    private Rectangle myMonitorBounds;
    private double myScale;

    private LocationOnDragTracker(MouseEvent e) {
        e = SwingUtilities.convertMouseEvent(e.getComponent(), e, UIUtil.getWindow(e.getComponent()));
        this.myOffsetXY = e.getPoint();
        this.myMonitorBounds = e.getComponent().getGraphicsConfiguration().getBounds();
        this.myScale = JBUIScale.sysScale(e.getComponent());
    }

    public static LocationOnDragTracker startDrag(@NotNull MouseEvent pressEvent) {
        if (pressEvent == null) {
            LocationOnDragTracker.$$$reportNull$$$0(0);
        }
        assert (pressEvent.getID() == 501);
        return new LocationOnDragTracker(pressEvent);
    }

    public void updateLocationOnDrag(@NotNull Component draggedComp) {
        PointerInfo mouseInfo;
        if (draggedComp == null) {
            LocationOnDragTracker.$$$reportNull$$$0(1);
        }
        if ((mouseInfo = MouseInfo.getPointerInfo()) == null) {
            return;
        }
        Point mouseLocation = mouseInfo.getLocation();
        Point offsetXY = this.myOffsetXY.getLocation();
        if (!this.myMonitorBounds.contains(mouseLocation)) {
            for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                if (!gd.getDefaultConfiguration().getBounds().contains(mouseLocation)) continue;
                double scale = JBUIScale.sysScale(gd.getDefaultConfiguration());
                int offX = (int)((double)this.myOffsetXY.x * this.myScale / scale);
                int offY = (int)((double)this.myOffsetXY.y * this.myScale / scale);
                this.myOffsetXY = new Point(offX, offY);
                this.myMonitorBounds = gd.getDefaultConfiguration().getBounds();
                this.myScale = scale;
                offsetXY.setLocation(this.myOffsetXY);
            }
        }
        Point newLocation = mouseLocation.getLocation();
        newLocation.translate(-offsetXY.x, -offsetXY.y);
        draggedComp.setLocation(newLocation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pressEvent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "draggedComp";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ui/LocationOnDragTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startDrag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateLocationOnDrag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

