/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.io.Murmur3_32Hash;
import com.intellij.util.lang.ImmutableZipEntry;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.zip.ZipException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ImmutableZipFile
implements Closeable {
    private static final int MIN_EOCD_SIZE = 22;
    private final ImmutableZipEntry[] nameMap;
    private final ImmutableZipEntry[] entries;
    ByteBuffer mappedBuffer;
    final int fileSize;

    private ImmutableZipFile(ImmutableZipEntry[] nameMap, ImmutableZipEntry[] entries, ByteBuffer mappedBuffer, int fileSize) {
        this.mappedBuffer = mappedBuffer;
        this.fileSize = fileSize;
        this.nameMap = nameMap;
        this.entries = entries;
    }

    @NotNull
    public static ImmutableZipFile load(@NotNull Path file) throws IOException {
        if (file == null) {
            ImmutableZipFile.$$$reportNull$$$0(0);
        }
        return ImmutableZipFile.load(file, null);
    }

    @NotNull
    public static ImmutableZipFile load(@NotNull Path file, @Nullable Consumer<ByteBuffer> commentConsumer) throws IOException {
        ByteBuffer mappedBuffer;
        int fileSize;
        if (file == null) {
            ImmutableZipFile.$$$reportNull$$$0(1);
        }
        try (FileChannel fileChannel = FileChannel.open(file, EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]);){
            fileSize = (int)fileChannel.size();
            try {
                mappedBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileSize);
            }
            catch (UnsupportedOperationException e) {
                ByteBuffer buffer = ByteBuffer.allocate(fileSize);
                while (buffer.hasRemaining()) {
                    fileChannel.read(buffer);
                }
                buffer.rewind();
                mappedBuffer = buffer;
            }
            mappedBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        ImmutableZipFile immutableZipFile = ImmutableZipFile.populateFromCentralDirectory(mappedBuffer, fileSize, commentConsumer);
        if (immutableZipFile == null) {
            ImmutableZipFile.$$$reportNull$$$0(2);
        }
        return immutableZipFile;
    }

    public ImmutableZipEntry[] getEntries() {
        return this.entries;
    }

    public ImmutableZipEntry[] getRawNameSet() {
        return this.nameMap;
    }

    @Override
    public void close() throws IOException {
        ByteBuffer buffer = this.mappedBuffer;
        if (buffer != null) {
            this.mappedBuffer = null;
            ImmutableZipFile.unmapBuffer(buffer);
        }
    }

    public ImmutableZipEntry getEntry(String name) {
        int index = ImmutableZipFile.probe(name, Murmur3_32Hash.MURMUR3_32.hashString(name, 0, name.length()), this.nameMap);
        return index >= 0 ? this.nameMap[index] : null;
    }

    public ImmutableZipEntry getEntry(String name, int murmur3HashCode) {
        int index = ImmutableZipFile.probe(name, murmur3HashCode, this.nameMap);
        return index >= 0 ? this.nameMap[index] : null;
    }

    private static ImmutableZipFile populateFromCentralDirectory(@NotNull ByteBuffer buffer, int fileSize, @Nullable Consumer<ByteBuffer> commentConsumer) throws IOException {
        int entrySetLength;
        ImmutableZipEntry[] entrySet;
        int fileEntryCount;
        ImmutableZipEntry[] entries;
        if (buffer == null) {
            ImmutableZipFile.$$$reportNull$$$0(3);
        }
        int offset = ImmutableZipFile.readEndSignature(buffer, fileSize);
        int entryCount = buffer.getShort(offset + 10) & 0xFFFF;
        int centralDirSize = buffer.getInt(offset + 12);
        int centralDirPosition = buffer.getInt(offset + 16);
        if (commentConsumer != null) {
            buffer.position(offset + 20);
            int commentLength = buffer.getShort() & 0xFFFF;
            if (commentLength > 0) {
                commentConsumer.accept(buffer);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
            }
        }
        if (entryCount == 65535) {
            entryCount = centralDirPosition / 47;
        }
        if ((entries = new ImmutableZipEntry[entryCount]).length != (fileEntryCount = ImmutableZipFile.readCentralDirectory(buffer, centralDirPosition, centralDirSize, entrySet = new ImmutableZipEntry[entrySetLength = entryCount * 2], entries))) {
            ImmutableZipEntry[] resizedEntries = new ImmutableZipEntry[fileEntryCount];
            System.arraycopy(entries, 0, resizedEntries, 0, fileEntryCount);
            entries = resizedEntries;
        }
        buffer.clear();
        return new ImmutableZipFile(entrySet, entries, buffer, fileSize);
    }

    private static int readCentralDirectory(ByteBuffer buffer, int centralDirPosition, int centralDirSize, ImmutableZipEntry[] entrySet, ImmutableZipEntry[] entries) throws EOFException {
        int commentLength;
        int extraFieldLength;
        int nameLengthInBytes;
        int entryIndex = 0;
        byte[] tempNameBytes = new byte[4096];
        ImmutableZipEntry prevEntry = null;
        int prevEntryExpectedDataOffset = -1;
        int endOffset = centralDirPosition + centralDirSize;
        for (int offset = centralDirPosition; offset < endOffset; offset += nameLengthInBytes + extraFieldLength + commentLength) {
            ImmutableZipEntry entry;
            int extraSuffixLength;
            if (buffer.getInt(offset) != 33639248) {
                throw new EOFException("Expected central directory size " + centralDirSize + " but only at " + offset + " no valid central directory file header signature");
            }
            int compressedSize = buffer.getInt(offset + 20);
            int uncompressedSize = buffer.getInt(offset + 24);
            int headerOffset = buffer.getInt(offset + 42);
            int method = buffer.getShort(offset + 10) & 0xFFFF;
            nameLengthInBytes = buffer.getShort(offset + 28) & 0xFFFF;
            extraFieldLength = buffer.getShort(offset + 30) & 0xFFFF;
            commentLength = buffer.getShort(offset + 32) & 0xFFFF;
            if (prevEntry != null && prevEntryExpectedDataOffset == headerOffset - prevEntry.getCompressedSize()) {
                prevEntry.setDataOffset(prevEntryExpectedDataOffset);
            }
            buffer.position(offset += 46);
            if (buffer.get(offset + nameLengthInBytes - 1) == 47) {
                uncompressedSize = -2;
                compressedSize = -2;
                extraSuffixLength = 1;
            } else {
                extraSuffixLength = 0;
            }
            buffer.get(tempNameBytes, 0, nameLengthInBytes);
            String name = new String(tempNameBytes, 0, nameLengthInBytes - extraSuffixLength, StandardCharsets.UTF_8);
            int entrySetIndex = ImmutableZipFile.probe(name, Murmur3_32Hash.MURMUR3_32.hashBytes(tempNameBytes, 0, nameLengthInBytes - extraSuffixLength), entrySet);
            if (entrySetIndex >= 0) {
                prevEntry = null;
                continue;
            }
            prevEntry = entry = new ImmutableZipEntry(name, compressedSize, uncompressedSize, headerOffset, nameLengthInBytes, method);
            prevEntryExpectedDataOffset = headerOffset + 30 + nameLengthInBytes + extraFieldLength;
            entrySet[-(entrySetIndex + 1)] = entry;
            entries[entryIndex++] = entry;
        }
        return entryIndex;
    }

    private static int readEndSignature(@NotNull ByteBuffer buffer, int fileSize) throws IOException {
        if (buffer == null) {
            ImmutableZipFile.$$$reportNull$$$0(4);
        }
        for (int offset = fileSize - 22; offset >= 0; --offset) {
            if (buffer.getInt(offset) != 101010256) continue;
            return offset;
        }
        throw new ZipException("Archive is not a ZIP archive");
    }

    private static int probe(String key, int keyHash, ImmutableZipEntry[] set) {
        int index = Math.floorMod(keyHash, set.length);
        ImmutableZipEntry found;
        while ((found = set[index]) != null) {
            if (key.equals(found.getName())) {
                return index;
            }
            if (++index != set.length) continue;
            index = 0;
        }
        return -index - 1;
    }

    private static void unmapBuffer(@NotNull ByteBuffer buffer) throws IOException {
        if (buffer == null) {
            ImmutableZipFile.$$$reportNull$$$0(5);
        }
        if (!buffer.isDirect()) {
            return;
        }
        try {
            Field unsafeField = Class.forName("sun.misc.Unsafe").getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Object unsafe = unsafeField.get(null);
            MethodType type = MethodType.methodType(Void.TYPE, ByteBuffer.class);
            MethodHandle handle = MethodHandles.lookup().findVirtual(unsafe.getClass(), "invokeCleaner", type);
            handle.invoke(unsafe, buffer);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/ImmutableZipFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/ImmutableZipFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "populateFromCentralDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readEndSignature";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unmapBuffer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

