/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.Condition;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Collection;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InvertedIndexUtil {
    @NotNull
    public static <K, V, I> IntSet collectInputIdsContainingAllKeys(@NotNull InvertedIndex<? super K, V, I> index, @NotNull Collection<? extends K> dataKeys, @Nullable Condition<? super K> keyChecker, @Nullable Condition<? super V> valueChecker, @Nullable IntPredicate idChecker, @Nullable Runnable checkCancelledRunnable) throws StorageException {
        if (index == null) {
            InvertedIndexUtil.$$$reportNull$$$0(0);
        }
        if (dataKeys == null) {
            InvertedIndexUtil.$$$reportNull$$$0(1);
        }
        IntOpenHashSet mainIntersection = null;
        for (K dataKey : dataKeys) {
            if (keyChecker != null && !keyChecker.value(dataKey)) continue;
            IntOpenHashSet copy = new IntOpenHashSet();
            ValueContainer<V> container = index.getData(dataKey);
            if (checkCancelledRunnable != null) {
                checkCancelledRunnable.run();
            }
            ValueContainer.ValueIterator<V> valueIt = container.getValueIterator();
            while (valueIt.hasNext()) {
                IntPredicate predicate;
                Object value = valueIt.next();
                if (valueChecker != null && !valueChecker.value(value)) continue;
                if (checkCancelledRunnable != null) {
                    checkCancelledRunnable.run();
                }
                ValueContainer.IntIterator iterator = valueIt.getInputIdsIterator();
                if (mainIntersection == null || iterator.size() < mainIntersection.size() || (predicate = valueIt.getValueAssociationPredicate()) == null) {
                    while (iterator.hasNext()) {
                        int id = iterator.next();
                        if ((mainIntersection != null || idChecker != null && !idChecker.test(id)) && (mainIntersection == null || !mainIntersection.contains(id))) continue;
                        copy.add(id);
                    }
                    continue;
                }
                IntIterator intIterator = mainIntersection.iterator();
                while (intIterator.hasNext()) {
                    int id = intIterator.nextInt();
                    if (!predicate.test(id) || idChecker != null && !idChecker.test(id)) continue;
                    copy.add(id);
                }
            }
            mainIntersection = copy;
            if (!mainIntersection.isEmpty()) continue;
            IntSets.EmptySet emptySet = IntSets.EMPTY_SET;
            if (emptySet == null) {
                InvertedIndexUtil.$$$reportNull$$$0(2);
            }
            return emptySet;
        }
        AbstractIntCollection abstractIntCollection = mainIntersection == null ? IntSets.EMPTY_SET : mainIntersection;
        if (abstractIntCollection == null) {
            InvertedIndexUtil.$$$reportNull$$$0(3);
        }
        return abstractIntCollection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKeys";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/InvertedIndexUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/InvertedIndexUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInputIdsContainingAllKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInputIdsContainingAllKeys";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

