/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class NioFiles {
    private NioFiles() {
    }

    @NotNull
    public static Path createDirectories(@NotNull Path path) throws IOException {
        block7: {
            if (path == null) {
                NioFiles.$$$reportNull$$$0(0);
            }
            try {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
                        throw new FileAlreadyExistsException(path.toString(), null, "already exists");
                    }
                    Path parent = path.getParent();
                    if (parent != null) {
                        NioFiles.createDirectories(parent);
                    }
                    Files.createDirectory(path, new FileAttribute[0]);
                }
            }
            catch (FileAlreadyExistsException err) {
                if (Files.isDirectory(path, new LinkOption[0])) break block7;
                throw err;
            }
        }
        Path path2 = path;
        if (path2 == null) {
            NioFiles.$$$reportNull$$$0(1);
        }
        return path2;
    }

    public static void setReadOnly(@NotNull Path path, boolean value) throws IOException {
        PosixFileAttributeView posixView;
        if (path == null) {
            NioFiles.$$$reportNull$$$0(2);
        }
        if ((posixView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0])) != null) {
            boolean modified;
            Set<PosixFilePermission> permissions = posixView.readAttributes().permissions();
            boolean bl = modified = value ? permissions.removeAll(Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE)) : permissions.add(PosixFilePermission.OWNER_WRITE);
            if (modified) {
                posixView.setPermissions(permissions);
            }
        } else {
            DosFileAttributeView dosView = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
            if (dosView != null) {
                dosView.setReadOnly(value);
            } else {
                throw new IOException("Not supported: " + path.getFileSystem());
            }
        }
    }

    public static void setExecutable(@NotNull Path file) throws IOException {
        Set<PosixFilePermission> permissions;
        PosixFileAttributeView view;
        if (file == null) {
            NioFiles.$$$reportNull$$$0(3);
        }
        if ((view = Files.getFileAttributeView(file, PosixFileAttributeView.class, new LinkOption[0])) != null && (permissions = view.readAttributes().permissions()).add(PosixFilePermission.OWNER_EXECUTE)) {
            view.setPermissions(permissions);
        }
    }

    @NotNull
    public static List<Path> list(@NotNull Path directory) {
        ArrayList<Path> arrayList;
        if (directory == null) {
            NioFiles.$$$reportNull$$$0(4);
        }
        try {
            ArrayList<Path> files = new ArrayList<Path>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
                for (Path path : stream) {
                    files.add(path);
                }
            }
            arrayList = files;
        }
        catch (IOException e) {
            List<Path> list = Collections.emptyList();
            if (list == null) {
                NioFiles.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (arrayList == null) {
            NioFiles.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public static void deleteRecursively(@NotNull Path fileOrDirectory) throws IOException {
        if (fileOrDirectory == null) {
            NioFiles.$$$reportNull$$$0(7);
        }
        FileUtilRt.deleteRecursivelyNIO(fileOrDirectory, null);
    }

    public static void deleteRecursively(@NotNull Path fileOrDirectory, @NotNull Consumer<Path> callback) throws IOException {
        if (fileOrDirectory == null) {
            NioFiles.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            NioFiles.$$$reportNull$$$0(9);
        }
        FileUtilRt.deleteRecursivelyNIO(fileOrDirectory, o -> callback.accept((Path)o));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/NioFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/NioFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectories";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDirectories";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnly";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setExecutable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deleteRecursively";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

