/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ObjectTree;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class Disposer {
    private static final ObjectTree ourTree = new ObjectTree();
    private static boolean ourDebugMode;
    private static final Map<String, Disposable> ourKeyDisposables;

    public static boolean isDebugDisposerOn() {
        return "on".equals(System.getProperty("idea.disposer.debug"));
    }

    private Disposer() {
    }

    @NotNull
    @Contract(pure=true, value="->new")
    public static Disposable newDisposable() {
        return Disposer.newDisposable("newDisposable");
    }

    @NotNull
    @Contract(pure=true, value="_->new")
    public static Disposable newDisposable(final @NotNull @NonNls String debugName) {
        if (debugName == null) {
            Disposer.$$$reportNull$$$0(0);
        }
        return new Disposable(){

            @Override
            public void dispose() {
            }

            public String toString() {
                return debugName;
            }
        };
    }

    @Contract(pure=true, value="_,_->new")
    @NotNull
    public static Disposable newDisposable(@NotNull Disposable parentDisposable, @NotNull String debugName) {
        if (parentDisposable == null) {
            Disposer.$$$reportNull$$$0(1);
        }
        if (debugName == null) {
            Disposer.$$$reportNull$$$0(2);
        }
        Disposable result = Disposer.newDisposable(debugName);
        Disposer.register(parentDisposable, result);
        Disposable disposable = result;
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(3);
        }
        return disposable;
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child) throws IncorrectOperationException {
        RuntimeException e;
        if (parent == null) {
            Disposer.$$$reportNull$$$0(4);
        }
        if (child == null) {
            Disposer.$$$reportNull$$$0(5);
        }
        if ((e = ourTree.register(parent, child)) != null) {
            throw e;
        }
    }

    public static boolean tryRegister(@NotNull Disposable parent, @NotNull Disposable child) {
        if (parent == null) {
            Disposer.$$$reportNull$$$0(6);
        }
        if (child == null) {
            Disposer.$$$reportNull$$$0(7);
        }
        return ourTree.register(parent, child) == null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public static void register(@NotNull Disposable parent, @NotNull Disposable child, @NonNls @NotNull String key) {
        if (parent == null) {
            Disposer.$$$reportNull$$$0(8);
        }
        if (child == null) {
            Disposer.$$$reportNull$$$0(9);
        }
        if (key == null) {
            Disposer.$$$reportNull$$$0(10);
        }
        Disposer.register(parent, child);
        Disposable v = Disposer.get(key);
        if (v != null) {
            throw new IllegalArgumentException("Key " + key + " already registered: " + v);
        }
        ourKeyDisposables.put(key, child);
        Disposer.register(child, new KeyDisposable(key));
    }

    public static boolean isDisposed(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(11);
        }
        return ourTree.getDisposalInfo(disposable) != null;
    }

    @Deprecated
    public static boolean isDisposing(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(12);
        }
        return Disposer.isDisposed(disposable);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public static Disposable get(@NotNull String key) {
        if (key == null) {
            Disposer.$$$reportNull$$$0(13);
        }
        return ourKeyDisposables.get(key);
    }

    public static void dispose(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(14);
        }
        Disposer.dispose(disposable, true);
    }

    @ApiStatus.Internal
    public static void disposeChildren(@NotNull Disposable disposable, @Nullable Predicate<? super Disposable> predicate) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(15);
        }
        ourTree.executeAllChildren(disposable, predicate);
    }

    public static void dispose(@NotNull Disposable disposable, boolean processUnregistered) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(16);
        }
        ourTree.executeAll(disposable, processUnregistered);
    }

    @NotNull
    public static ObjectTree getTree() {
        ObjectTree objectTree = ourTree;
        if (objectTree == null) {
            Disposer.$$$reportNull$$$0(17);
        }
        return objectTree;
    }

    public static void assertIsEmpty() {
        Disposer.assertIsEmpty(false);
    }

    public static void assertIsEmpty(boolean throwError) {
        if (ourDebugMode) {
            ourTree.assertIsEmpty(throwError);
        }
    }

    public static boolean setDebugMode(boolean debugMode) {
        if (debugMode) {
            debugMode = !"off".equals(System.getProperty("idea.disposer.debug"));
        }
        boolean oldValue = ourDebugMode;
        ourDebugMode = debugMode;
        return oldValue;
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    @Nullable
    public static <T extends Disposable> T findRegisteredObject(@NotNull Disposable parentDisposable, @NotNull T object) {
        if (parentDisposable == null) {
            Disposer.$$$reportNull$$$0(18);
        }
        if (object == null) {
            Disposer.$$$reportNull$$$0(19);
        }
        return ourTree.findRegisteredObject(parentDisposable, object);
    }

    public static Throwable getDisposalTrace(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(20);
        }
        return ObjectUtils.tryCast(Disposer.getTree().getDisposalInfo(disposable), Throwable.class);
    }

    @TestOnly
    @Nullable
    public static Throwable getRegistrationTrace(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(21);
        }
        return Disposer.getTree().getRegistrationTrace(disposable);
    }

    @ApiStatus.Internal
    public static void clearDisposalTraces() {
        ourTree.clearDisposedObjectTraces();
    }

    static {
        ourKeyDisposables = ContainerUtil.createConcurrentWeakMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/Disposer";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/Disposer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newDisposable";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newDisposable";
                break;
            }
            case 3: 
            case 17: {
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryRegister";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDisposed";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDisposing";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "disposeChildren";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredObject";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDisposalTrace";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRegistrationTrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class KeyDisposable
    implements Disposable {
        @NotNull
        private final String myKey;

        KeyDisposable(@NotNull String key) {
            if (key == null) {
                KeyDisposable.$$$reportNull$$$0(0);
            }
            this.myKey = key;
        }

        @Override
        public void dispose() {
            ourKeyDisposables.remove(this.myKey);
        }

        public String toString() {
            return "KeyDisposable (" + this.myKey + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/Disposer$KeyDisposable", "<init>"));
        }
    }
}

