/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.extensions;

import io.kinference.ndarray.Strides;
import io.kinference.ndarray.arrays.MutableNDArray;
import io.kinference.ndarray.arrays.NDArray;
import io.kinference.ndarray.extensions.GatherKt;
import io.kinference.ndarray.extensions.NDArrayExtensionsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a2\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004\u001a \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000f\u001a,\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0012*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00042\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0012*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0016"}, d2={"computeSplitShape", "", "shape", "axis", "", "split", "keepDims", "", "splitFragment", "Lio/kinference/ndarray/arrays/MutableNDArray;", "Lio/kinference/ndarray/arrays/NDArray;", "beforeAxisDims", "fromAxisDims", "fragmentSize", "splitStrides", "Lio/kinference/ndarray/Strides;", "offset", "splitParts", "", "parts", "strides", "splitWithAxis", "ndarray"})
public final class SplitKt {
    @NotNull
    public static final int[] computeSplitShape(@NotNull int[] shape, int axis, int split, boolean keepDims) {
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        int[] newShape = null;
        if (keepDims) {
            int[] nArray = shape;
            boolean bl = false;
            int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
            Intrinsics.checkExpressionValueIsNotNull((Object)nArray2, (String)"java.util.Arrays.copyOf(this, size)");
            newShape = nArray2;
            newShape[axis] = split;
        } else {
            newShape = new int[shape.length - 1];
            ArraysKt.copyInto((int[])shape, (int[])newShape, (int)0, (int)0, (int)axis);
            ArraysKt.copyInto$default((int[])shape, (int[])newShape, (int)axis, (int)(axis + 1), (int)0, (int)8, null);
        }
        return newShape;
    }

    @NotNull
    public static final List<MutableNDArray> splitWithAxis(@NotNull NDArray $this$splitWithAxis, int parts, int axis, boolean keepDims) {
        Intrinsics.checkParameterIsNotNull((Object)$this$splitWithAxis, (String)"$this$splitWithAxis");
        int n = axis;
        n = 0 <= n && $this$splitWithAxis.getShape().length > n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Index " + axis + " out of shape bound: (0, " + ($this$splitWithAxis.getRank() - 1);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int actualAxis = NDArrayExtensionsKt.indexAxis($this$splitWithAxis, axis);
        int elementsByIndex = $this$splitWithAxis.getShape()[actualAxis];
        double bl3 = (double)elementsByIndex / (double)parts;
        int n2 = 0;
        int mainSplit = (int)Math.ceil(bl3);
        int[] nArray = new int[parts];
        n2 = 0;
        while (n2 < parts) {
            int n3;
            int n4 = n2;
            int n5 = n2++;
            int[] nArray2 = nArray;
            boolean bl4 = false;
            nArray2[n5] = n3 = mainSplit;
        }
        int[] split = nArray;
        int tail = elementsByIndex % parts;
        if (tail != 0) {
            split[parts - 1] = tail;
        }
        return SplitKt.splitWithAxis($this$splitWithAxis, split, actualAxis, keepDims);
    }

    public static /* synthetic */ List splitWithAxis$default(NDArray nDArray, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            bl = true;
        }
        return SplitKt.splitWithAxis(nDArray, n, n2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<MutableNDArray> splitWithAxis(@NotNull NDArray $this$splitWithAxis, @NotNull int[] split, int axis, boolean keepDims) {
        Intrinsics.checkParameterIsNotNull((Object)$this$splitWithAxis, (String)"$this$splitWithAxis");
        Intrinsics.checkParameterIsNotNull((Object)split, (String)"split");
        int beforeAxisDims = GatherKt.computeBlockSize$default($this$splitWithAxis, 0, axis, 1, null);
        int fromAxisDims = GatherKt.computeBlockSize$default($this$splitWithAxis, axis, 0, 2, null);
        int afterAxisDims = axis + 1 == $this$splitWithAxis.getRank() ? 1 : GatherKt.computeBlockSize$default($this$splitWithAxis, axis + 1, 0, 2, null);
        int inputOffset = 0;
        int n = split.length;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<MutableNDArray> arrayList = new ArrayList<MutableNDArray>(n);
        boolean bl3 = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            void i;
            int n4 = n2++;
            boolean bl4 = false;
            int n5 = n4;
            ArrayList<MutableNDArray> arrayList2 = arrayList;
            boolean bl5 = false;
            int splitSize = split[i];
            int[] outputDims = SplitKt.computeSplitShape($this$splitWithAxis.getStrides().getShape(), axis, split[i], keepDims);
            Strides outStrides = new Strides(outputDims);
            int fragmentSize = splitSize * afterAxisDims;
            MutableNDArray dst = SplitKt.splitFragment($this$splitWithAxis, beforeAxisDims, fromAxisDims, fragmentSize, outStrides, inputOffset);
            inputOffset += fragmentSize;
            MutableNDArray mutableNDArray = dst;
            arrayList2.add(mutableNDArray);
        }
        return arrayList;
    }

    public static /* synthetic */ List splitWithAxis$default(NDArray nDArray, int[] nArray, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return SplitKt.splitWithAxis(nDArray, nArray, n, bl);
    }

    @NotNull
    public static final MutableNDArray splitFragment(@NotNull NDArray $this$splitFragment, int beforeAxisDims, int fromAxisDims, int fragmentSize, @NotNull Strides splitStrides, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)$this$splitFragment, (String)"$this$splitFragment");
        Intrinsics.checkParameterIsNotNull((Object)splitStrides, (String)"splitStrides");
        MutableNDArray dst = $this$splitFragment.allocateNDArray(splitStrides);
        int len = beforeAxisDims * fragmentSize;
        if (fromAxisDims == fragmentSize) {
            dst.copyFrom(0, $this$splitFragment, 0, len);
            return dst;
        }
        boolean bl = false;
        int n = 0;
        n = 0;
        int n2 = beforeAxisDims;
        while (n < n2) {
            int it = n++;
            boolean bl2 = false;
            int start = offset + fromAxisDims * it;
            dst.copyFrom(it * fragmentSize, $this$splitFragment, start, start + fragmentSize);
        }
        return dst;
    }

    @NotNull
    public static final List<MutableNDArray> splitParts(@NotNull NDArray $this$splitParts, int parts, @NotNull Strides strides) {
        Intrinsics.checkParameterIsNotNull((Object)$this$splitParts, (String)"$this$splitParts");
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        boolean bl = $this$splitParts.getLinearSize() % parts == 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = strides.getLinearSize() == $this$splitParts.getLinearSize() / parts;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int offset = 0;
        int partSize = strides.getLinearSize();
        bl3 = false;
        bl4 = false;
        ArrayList<MutableNDArray> arrayList = new ArrayList<MutableNDArray>(parts);
        boolean bl7 = false;
        int n = 0;
        n = 0;
        int n2 = parts;
        while (n < n2) {
            int n3 = n++;
            boolean bl8 = false;
            int n4 = n3;
            ArrayList<MutableNDArray> arrayList2 = arrayList;
            boolean bl9 = false;
            MutableNDArray newArray = $this$splitParts.allocateNDArray(strides);
            newArray.copyFrom(0, $this$splitParts, offset, offset + partSize);
            offset += partSize;
            MutableNDArray mutableNDArray = newArray;
            arrayList2.add(mutableNDArray);
        }
        return arrayList;
    }
}

