/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.extensions;

import io.kinference.ndarray.Strides;
import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.LongNDArray;
import io.kinference.ndarray.arrays.MutableNDArray;
import io.kinference.ndarray.arrays.MutableNumberNDArray;
import io.kinference.ndarray.arrays.NDArray;
import io.kinference.ndarray.arrays.NumberNDArray;
import io.kinference.ndarray.arrays.pointers.LongPointer;
import io.kinference.ndarray.arrays.tiled.LongTiledArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0010\u0004\n\u0002\b\u0003\u001a\u0018\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u0003\u001a\"\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0010\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015*\u00020\u0003\u001a$\u0010\u0016\u001a\u00020\n*\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u0003\u001a\u001c\u0010\u0018\u001a\u00020\u0002*\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u000f\u001a\u0018\u0010\u0018\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00030\u001a2\u0006\u0010\u0017\u001a\u00020\u000f\u001a\u0012\u0010\u001b\u001a\u00020\u000f*\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u000f\u001a\n\u0010\u001c\u001a\u00020\n*\u00020\u0003\u001a\u001a\u0010\u001d\u001a\u00020\u0002*\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u000f\u001a\u0012\u0010\u001e\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0003\u001a\u0016\u0010 \u001a\u00020\u0002*\u00020\u00022\n\u0010\u0011\u001a\u00020\u0010\"\u00020\u000f\u001a\u001d\u0010!\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0017\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\"\u001a\u001c\u0010#\u001a\u00020\u0002*\u00020\u00022\u0010\b\u0002\u0010$\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010\u0015\u001a\u0016\u0010&\u001a\u00020\u0002*\u00020\u00022\n\u0010\u0011\u001a\u00020\u0010\"\u00020\u000f\u001a\n\u0010'\u001a\u00020\u0002*\u00020\u0002\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\b\u00a8\u0006("}, d2={"rows", "", "Lio/kinference/ndarray/arrays/MutableNDArray;", "Lio/kinference/ndarray/arrays/NDArray;", "getRows", "(Lio/kinference/ndarray/arrays/NDArray;)[Lio/kinference/ndarray/arrays/MutableNDArray;", "Lio/kinference/ndarray/arrays/MutableNumberNDArray;", "Lio/kinference/ndarray/arrays/NumberNDArray;", "(Lio/kinference/ndarray/arrays/NumberNDArray;)[Lio/kinference/ndarray/arrays/MutableNumberNDArray;", "canDequantizePerTensor", "", "zeroPoint", "scale", "viewHelper", "Lkotlin/Pair;", "", "", "axes", "strides", "Lio/kinference/ndarray/Strides;", "as2DList", "", "canDequantizePerAxis", "axis", "concatenate", "other", "", "indexAxis", "isScalar", "mergeOnAxis", "reshape", "tensorShape", "squeeze", "stack", "([Lio/kinference/ndarray/arrays/NDArray;I)Lio/kinference/ndarray/arrays/NDArray;", "transpose", "permutations", "", "unsqueeze", "wrapOneDim", "ndarray"})
public final class NDArrayExtensionsKt {
    public static final boolean isScalar(@NotNull NDArray $this$isScalar) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isScalar, (String)"$this$isScalar");
        int[] nArray = $this$isScalar.getShape();
        boolean bl = false;
        return nArray.length == 0;
    }

    public static final boolean canDequantizePerAxis(@NotNull NDArray $this$canDequantizePerAxis, int axis, @Nullable NDArray zeroPoint, @NotNull NDArray scale) {
        Intrinsics.checkParameterIsNotNull((Object)$this$canDequantizePerAxis, (String)"$this$canDequantizePerAxis");
        Intrinsics.checkParameterIsNotNull((Object)scale, (String)"scale");
        return scale.getRank() == 1 && scale.getLinearSize() == $this$canDequantizePerAxis.getShape()[axis] && (zeroPoint == null || zeroPoint.getRank() == 1 && zeroPoint.getLinearSize() == $this$canDequantizePerAxis.getShape()[axis]);
    }

    public static final boolean canDequantizePerTensor(@Nullable NDArray zeroPoint, @NotNull NDArray scale) {
        Intrinsics.checkParameterIsNotNull((Object)scale, (String)"scale");
        return scale.getLinearSize() == 1 && (zeroPoint == null || zeroPoint.getLinearSize() == 1);
    }

    @NotNull
    public static final MutableNDArray wrapOneDim(@NotNull MutableNDArray $this$wrapOneDim) {
        Intrinsics.checkParameterIsNotNull((Object)$this$wrapOneDim, (String)"$this$wrapOneDim");
        return $this$wrapOneDim.reshape(UtilsKt.concat(1, $this$wrapOneDim.getShape()));
    }

    public static final int indexAxis(@NotNull NDArray $this$indexAxis, int axis) {
        Intrinsics.checkParameterIsNotNull((Object)$this$indexAxis, (String)"$this$indexAxis");
        return axis < 0 ? $this$indexAxis.getRank() + axis : axis;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MutableNDArray[] getRows(@NotNull NDArray $this$rows) {
        Intrinsics.checkParameterIsNotNull((Object)$this$rows, (String)"$this$rows");
        int n = $this$rows.getShape()[0];
        MutableNDArray[] mutableNDArrayArray = new MutableNDArray[n];
        int n2 = 0;
        while (n2 < n) {
            void i;
            MutableNDArray mutableNDArray;
            int n3 = n2;
            int n4 = n2++;
            MutableNDArray[] mutableNDArrayArray2 = mutableNDArrayArray;
            boolean bl = false;
            mutableNDArrayArray2[n4] = mutableNDArray = $this$rows.row((int)i);
        }
        return mutableNDArrayArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MutableNumberNDArray[] getRows(@NotNull NumberNDArray $this$rows) {
        Intrinsics.checkParameterIsNotNull((Object)$this$rows, (String)"$this$rows");
        int n = $this$rows.getShape()[0];
        MutableNumberNDArray[] mutableNumberNDArrayArray = new MutableNumberNDArray[n];
        int n2 = 0;
        while (n2 < n) {
            void i;
            MutableNumberNDArray mutableNumberNDArray;
            int n3 = n2;
            int n4 = n2++;
            MutableNumberNDArray[] mutableNumberNDArrayArray2 = mutableNumberNDArrayArray;
            boolean bl = false;
            mutableNumberNDArrayArray2[n4] = mutableNumberNDArray = $this$rows.row((int)i);
        }
        return mutableNumberNDArrayArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MutableNDArray squeeze(@NotNull MutableNDArray $this$squeeze, int ... axes) {
        boolean bl;
        boolean $i$f$all;
        List actualAxes;
        block9: {
            List list;
            Integer n;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            boolean $i$f$map;
            Object $this$map$iv;
            Intrinsics.checkParameterIsNotNull((Object)$this$squeeze, (String)"$this$squeeze");
            Intrinsics.checkParameterIsNotNull((Object)axes, (String)"axes");
            int[] nArray = axes;
            boolean bl2 = false;
            Object object = nArray;
            boolean bl3 = false;
            if (!(((int[])object).length == 0)) {
                $this$map$iv = axes;
                $i$f$map = false;
                object = $this$map$iv;
                destination$iv$iv = new ArrayList(((int[])$this$map$iv).length);
                $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv;
                int n2 = ((Iterable)iterator).length;
                for (int i = 0; i < n2; ++i) {
                    void it;
                    Object item$iv$iv;
                    Object object2 = item$iv$iv = iterator[i];
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    n = NDArrayExtensionsKt.indexAxis($this$squeeze, (int)it);
                    collection.add(n);
                }
                list = (List)destination$iv$iv;
            } else {
                IndexedValue it;
                Object $this$filterTo$iv$iv;
                Iterable $this$filter$iv = ArraysKt.withIndex((int[])$this$squeeze.getShape());
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object e : $this$filterTo$iv$iv) {
                    it = (IndexedValue)e;
                    boolean bl5 = false;
                    if (!(((Number)it.getValue()).intValue() == 1)) continue;
                    destination$iv$iv.add(e);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object t : $this$mapTo$iv$iv) {
                    it = (IndexedValue)t;
                    collection = destination$iv$iv;
                    boolean bl6 = false;
                    n = it.getIndex();
                    collection.add(n);
                }
                list = (List)destination$iv$iv;
            }
            actualAxes = list;
            Iterable $this$all$iv = actualAxes;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                object = $this$all$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    int it = ((Number)element$iv).intValue();
                    boolean bl7 = false;
                    if ($this$squeeze.getShape()[it] == 1) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        boolean $this$all$iv = bl;
        $i$f$all = false;
        boolean bl8 = false;
        bl8 = false;
        boolean bl9 = false;
        if (!$this$all$iv) {
            boolean bl10 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        List shapeIndices = CollectionsKt.minus((Iterable)((Iterable)ArraysKt.getIndices((int[])$this$squeeze.getShape())), (Iterable)actualAxes);
        int[] newShape = ArraysKt.sliceArray((int[])$this$squeeze.getShape(), (Collection)shapeIndices);
        return $this$squeeze.reshape(newShape);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MutableNDArray unsqueeze(@NotNull MutableNDArray $this$unsqueeze, int ... axes) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$unsqueeze, (String)"$this$unsqueeze");
        Intrinsics.checkParameterIsNotNull((Object)axes, (String)"axes");
        int[] $this$map$iv = axes;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var8_7 = $this$mapTo$iv$iv;
        int n = ((void)var8_7).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_11 = item$iv$iv = var8_7[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n2 = NDArrayExtensionsKt.indexAxis($this$unsqueeze, (int)it);
            collection.add(n2);
        }
        List actualAxes = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        List newShape = ArraysKt.toMutableList((int[])$this$unsqueeze.getShape());
        object = actualAxes.iterator();
        while (object.hasNext()) {
            int axis = ((Number)object.next()).intValue();
            newShape.add(axis, 1);
        }
        return $this$unsqueeze.reshape(CollectionsKt.toIntArray((Collection)newShape));
    }

    @NotNull
    public static final MutableNDArray transpose(@NotNull MutableNDArray $this$transpose, @Nullable List<? extends Number> permutations) {
        Intrinsics.checkParameterIsNotNull((Object)$this$transpose, (String)"$this$transpose");
        Collection collection = permutations;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = collection == null || collection.isEmpty() || permutations.size() == $this$transpose.getRank();
        bl = false;
        bl2 = false;
        if (!bl3) {
            boolean bl4 = false;
            String string = "Axes permutations list size should match the number of axes";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if ($this$transpose.getRank() == 2) {
            return $this$transpose.transpose2D();
        }
        Collection collection2 = permutations;
        bl2 = false;
        boolean bl5 = false;
        int[] actualPerm = collection2 == null || collection2.isEmpty() ? UtilsKt.toIntArray(RangesKt.reversed((IntProgression)((IntProgression)ArraysKt.getIndices((int[])$this$transpose.getShape())))) : UtilsKt.toIntArray((Collection<? extends Number>)permutations);
        return $this$transpose.transpose(actualPerm);
    }

    public static /* synthetic */ MutableNDArray transpose$default(MutableNDArray mutableNDArray, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        return NDArrayExtensionsKt.transpose(mutableNDArray, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MutableNDArray mergeOnAxis(@NotNull NDArray $this$mergeOnAxis, @NotNull NDArray other, int axis) {
        MutableNDArray snd;
        boolean i$iv22;
        void $this$zip$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$mergeOnAxis, (String)"$this$mergeOnAxis");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        MutableNDArray[] mutableNDArrayArray = NDArrayExtensionsKt.getRows($this$mergeOnAxis);
        MutableNDArray[] other$iv = NDArrayExtensionsKt.getRows(other);
        boolean $i$f$zip = false;
        int n = ((void)$this$zip$iv).length;
        int n2 = other$iv.length;
        int n3 = 0;
        int size$iv = Math.min(n, n2);
        ArrayList<MutableNDArray> list$iv2 = new ArrayList<MutableNDArray>(size$iv);
        n2 = 0;
        n3 = size$iv;
        while (n2 < n3) {
            void fst;
            MutableNDArray mutableNDArray = other$iv[i$iv22];
            void var12_18 = $this$zip$iv[i$iv22];
            ArrayList<MutableNDArray> arrayList = list$iv2;
            boolean bl = false;
            MutableNDArray mutableNDArray2 = NDArrayExtensionsKt.concatenate((NDArray)fst, snd, axis - 1);
            arrayList.add(mutableNDArray2);
            i$iv22 += 1;
        }
        MutableNDArray[] $this$toTypedArray$iv = (MutableNDArray[])list$iv2;
        boolean $i$f$toTypedArray = false;
        MutableNDArray[] thisCollection$iv = $this$toTypedArray$iv;
        MutableNDArray[] mutableNDArrayArray2 = thisCollection$iv.toArray(new MutableNDArray[0]);
        if (mutableNDArrayArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        MutableNDArray[] rows = mutableNDArrayArray2;
        MutableNDArray result = rows[0];
        int dim = $this$mergeOnAxis.getShape()[0];
        if (dim > 1) {
            thisCollection$iv = rows;
            boolean list$iv2 = false;
            i$iv22 = false;
            MutableNDArray[] $this$apply22 = thisCollection$iv;
            boolean bl = false;
            $this$apply22[0] = NDArrayExtensionsKt.wrapOneDim(rows[0]);
            Object[] $this$reduce$iv = thisCollection$iv;
            boolean $i$f$reduce = false;
            Object[] i$iv22 = $this$reduce$iv;
            int $this$apply22 = 0;
            if (i$iv22.length == 0) {
                throw (Throwable)new UnsupportedOperationException("Empty array can't be reduced.");
            }
            Object accumulator$iv = $this$reduce$iv[0];
            $this$apply22 = 1;
            int n4 = ArraysKt.getLastIndex((Object[])$this$reduce$iv);
            if ($this$apply22 <= n4) {
                while (true) {
                    void tensor;
                    void index$iv;
                    snd = (MutableNDArray)$this$reduce$iv[index$iv];
                    MutableNDArray acc = (MutableNDArray)accumulator$iv;
                    boolean bl2 = false;
                    accumulator$iv = NDArrayExtensionsKt.concatenate$default(acc, NDArrayExtensionsKt.wrapOneDim((MutableNDArray)tensor), 0, 2, null);
                    if (index$iv == n4) break;
                    ++index$iv;
                }
            }
            result = (MutableNDArray)accumulator$iv;
        }
        if (dim == 1 && axis > 0) {
            result = NDArrayExtensionsKt.wrapOneDim(result);
        }
        return result;
    }

    @NotNull
    public static final MutableNDArray concatenate(@NotNull NDArray $this$concatenate, @NotNull NDArray other, int axis) {
        int[] $this$apply;
        boolean bl;
        int n;
        Object object;
        int[] nArray;
        Intrinsics.checkParameterIsNotNull((Object)$this$concatenate, (String)"$this$concatenate");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int actualAxis = NDArrayExtensionsKt.indexAxis($this$concatenate, axis);
        if (actualAxis != 0) {
            return NDArrayExtensionsKt.mergeOnAxis($this$concatenate, other, actualAxis);
        }
        int[] fstDim = $this$concatenate.getShape();
        int[] sndDim = other.getShape();
        if (fstDim.length > 1 && sndDim.length == 1) {
            sndDim = new int[]{1, sndDim[0]};
        }
        if (fstDim.length == 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = fstDim[0] + sndDim[0];
        } else {
            object = fstDim;
            n = fstDim.length;
            bl = false;
            int[] nArray3 = Arrays.copyOf(object, n);
            Intrinsics.checkExpressionValueIsNotNull((Object)nArray3, (String)"java.util.Arrays.copyOf(this, newSize)");
            object = nArray3;
            n = 0;
            bl = false;
            $this$apply = object;
            boolean bl2 = false;
            $this$apply[0] = fstDim[0] + sndDim[0];
            nArray = object;
        }
        int[] newShape = nArray;
        object = $this$concatenate.allocateNDArray(new Strides(newShape));
        n = 0;
        bl = false;
        $this$apply = object;
        boolean bl3 = false;
        MutableNDArray.DefaultImpls.copyFrom$default((MutableNDArray)$this$apply, 0, $this$concatenate, 0, 0, 12, null);
        MutableNDArray.DefaultImpls.copyFrom$default((MutableNDArray)$this$apply, $this$concatenate.getLinearSize(), other, 0, 0, 12, null);
        return object;
    }

    public static /* synthetic */ MutableNDArray concatenate$default(NDArray nDArray, NDArray nDArray2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return NDArrayExtensionsKt.concatenate(nDArray, nDArray2, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final NDArray concatenate(@NotNull Collection<? extends NDArray> $this$concatenate, int axis) {
        Intrinsics.checkParameterIsNotNull($this$concatenate, (String)"$this$concatenate");
        Iterable $this$reduce$iv = $this$concatenate;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void tensor;
            NDArray nDArray = (NDArray)iterator$iv.next();
            NDArray acc = (NDArray)accumulator$iv;
            boolean bl = false;
            accumulator$iv = NDArrayExtensionsKt.concatenate(acc, (NDArray)tensor, axis);
        }
        return (NDArray)accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final NDArray stack(@NotNull NDArray[] $this$stack, int axis) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$stack, (String)"$this$stack");
        int[] fstShape = ((NDArray)ArraysKt.first((Object[])$this$stack)).getShape();
        int[] newShape = new int[fstShape.length + 1];
        ArraysKt.copyInto((int[])fstShape, (int[])newShape, (int)0, (int)0, (int)axis);
        newShape[axis] = 1;
        ArraysKt.copyInto$default((int[])fstShape, (int[])newShape, (int)(axis + 1), (int)axis, (int)0, (int)8, null);
        NDArray[] $this$map$iv = $this$stack;
        boolean $i$f$map = false;
        NDArray[] nDArrayArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var9_9 = $this$mapTo$iv$iv;
        int n = ((void)var9_9).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var13_13 = item$iv$iv = var9_9[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            NDArray nDArray = it.reshapeView(newShape);
            collection.add(nDArray);
        }
        return NDArrayExtensionsKt.concatenate((List)destination$iv$iv, axis);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<NDArray> as2DList(@NotNull NDArray $this$as2DList) {
        Intrinsics.checkParameterIsNotNull((Object)$this$as2DList, (String)"$this$as2DList");
        if ($this$as2DList.getRank() == 2) {
            return CollectionsKt.listOf((Object)$this$as2DList);
        }
        if ($this$as2DList.getRank() == 1) {
            return CollectionsKt.listOf((Object)NDArrayExtensionsKt.wrapOneDim($this$as2DList.copyIfNotMutable()));
        }
        int[] matrixShape = new int[]{$this$as2DList.getShape()[NDArrayExtensionsKt.indexAxis($this$as2DList, -2)], $this$as2DList.getShape()[NDArrayExtensionsKt.indexAxis($this$as2DList, -1)]};
        Strides matrixStrides = new Strides(matrixShape);
        int matrixSize = matrixStrides.getLinearSize();
        int n = $this$as2DList.getStrides().getLinearSize() / matrixSize;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<MutableNDArray> arrayList = new ArrayList<MutableNDArray>(n);
        boolean bl3 = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            void index;
            int n4 = n2++;
            boolean bl4 = false;
            int n5 = n4;
            ArrayList<MutableNDArray> arrayList2 = arrayList;
            boolean bl5 = false;
            MutableNDArray mutableNDArray = $this$as2DList.allocateNDArray(matrixStrides);
            boolean bl6 = false;
            boolean bl7 = false;
            MutableNDArray $this$apply = mutableNDArray;
            boolean bl8 = false;
            int start = matrixSize * index;
            $this$apply.copyFrom(0, $this$as2DList, start, start + matrixSize);
            MutableNDArray mutableNDArray2 = mutableNDArray;
            arrayList2.add(mutableNDArray2);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<Integer, int[]> viewHelper(@NotNull int[] axes, @NotNull Strides strides) {
        void $this$foldIndexed$iv;
        Intrinsics.checkParameterIsNotNull((Object)axes, (String)"axes");
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        int[] nArray = axes;
        int initial$iv = 0;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        int accumulator$iv = initial$iv;
        for (void element$iv : $this$foldIndexed$iv) {
            void i;
            void acc;
            int n = index$iv++;
            void var12_12 = element$iv;
            int n2 = accumulator$iv;
            int index = n;
            boolean bl = false;
            accumulator$iv = acc + i * strides.getStrides()[index];
        }
        int newOffset = accumulator$iv;
        int[] nArray2 = strides.getShape();
        int n = axes.length;
        int n3 = strides.getShape().length;
        boolean bl = false;
        int[] newShape = ArraysKt.copyOfRange((int[])nArray2, (int)n, (int)n3);
        return TuplesKt.to((Object)newOffset, (Object)newShape);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MutableNDArray reshape(@NotNull MutableNDArray $this$reshape, @NotNull NDArray tensorShape) {
        int n;
        int[] newShape;
        int n22;
        Intrinsics.checkParameterIsNotNull((Object)$this$reshape, (String)"$this$reshape");
        Intrinsics.checkParameterIsNotNull((Object)tensorShape, (String)"tensorShape");
        boolean bl = tensorShape instanceof LongNDArray;
        boolean bl2 = false;
        int n3 = 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "Tensor shape must have Long type";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        LongPointer pointer = LongTiledArray.pointer$default(((LongNDArray)tensorShape).getArray(), 0, 1, null);
        n3 = tensorShape.getLinearSize();
        int[] bl3 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5 = i;
            int n6 = i;
            int[] nArray = bl3;
            n22 = 0;
            LongPointer this_$iv = pointer;
            boolean $i$f$getAndIncrement = false;
            long value$iv = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
            LongPointer this_$iv$iv = this_$iv;
            boolean $i$f$increment = false;
            if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                LongPointer longPointer = this_$iv$iv;
                int n7 = longPointer.getIndexInBlock();
                longPointer.setIndexInBlock(n7 + 1);
            } else {
                LongPointer this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$blockIncrement = false;
                if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                    LongPointer longPointer = this_$iv$iv$iv;
                    int n8 = longPointer.getBlockNum();
                    longPointer.setBlockNum(n8 + 1);
                    this_$iv$iv$iv.setIndexInBlock(0);
                    this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                } else {
                    this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                }
            }
            nArray[n6] = n4 = (int)value$iv;
        }
        int[] $this$count$iv22 = newShape = bl3;
        boolean $i$f$count = false;
        int count$iv2 = 0;
        int[] it = $this$count$iv22;
        n22 = it.length;
        for (int this_$iv = 0; this_$iv < n22; ++this_$iv) {
            int element$iv;
            int it2 = element$iv = it[this_$iv];
            n = 0;
            if (!(it2 == -1)) continue;
            ++count$iv2;
        }
        int $this$count$iv22 = count$iv2 <= 1 ? 1 : 0;
        $i$f$count = false;
        count$iv2 = 0;
        if ($this$count$iv22 == 0) {
            boolean bl4 = false;
            String count$iv2 = "At most one dimension of the new shape can be -1";
            throw (Throwable)new IllegalArgumentException(count$iv2.toString());
        }
        int[] count$iv2 = newShape;
        int bl4 = count$iv2.length;
        $this$count$iv22 = 0;
        while ($this$count$iv22 < bl4) {
            void i;
            int axisShape = count$iv2[$this$count$iv22];
            if (axisShape == 0) {
                newShape[i] = $this$reshape.getShape()[i];
            }
            ++i;
        }
        int negativeIdx = ArraysKt.indexOf((int[])newShape, (int)-1);
        if (negativeIdx != -1) {
            void $this$fold$iv;
            void $this$filterTo$iv$iv;
            Object $this$filter$iv = newShape;
            boolean $i$f$filter = false;
            int[] n22 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void it2 = $this$filterTo$iv$iv;
            n = ((void)it2).length;
            for (int this_$iv$iv = 0; this_$iv$iv < n; ++this_$iv$iv) {
                void element$iv$iv;
                void it3 = element$iv$iv = it2[this_$iv$iv];
                boolean bl5 = false;
                if (!(it3 != -1)) continue;
                destination$iv$iv.add((int)element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            int initial$iv = 1;
            boolean $i$f$fold = false;
            int accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void p2;
                n = ((Number)element$iv).intValue();
                int p1 = accumulator$iv;
                boolean bl6 = false;
                accumulator$iv = p1 * p2;
            }
            int elementsCount = accumulator$iv;
            newShape[negativeIdx] = $this$reshape.getStrides().getLinearSize() / elementsCount;
        }
        return $this$reshape.reshape(newShape);
    }
}

