/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.extensions;

import io.kinference.ndarray.Strides;
import io.kinference.ndarray.arrays.BooleanNDArray;
import io.kinference.ndarray.arrays.ByteNDArray;
import io.kinference.ndarray.arrays.DoubleNDArray;
import io.kinference.ndarray.arrays.FloatNDArray;
import io.kinference.ndarray.arrays.IntNDArray;
import io.kinference.ndarray.arrays.LongNDArray;
import io.kinference.ndarray.arrays.MutableBooleanNDArray;
import io.kinference.ndarray.arrays.MutableByteNDArray;
import io.kinference.ndarray.arrays.MutableDoubleNDArray;
import io.kinference.ndarray.arrays.MutableFloatNDArray;
import io.kinference.ndarray.arrays.MutableIntNDArray;
import io.kinference.ndarray.arrays.MutableLongNDArray;
import io.kinference.ndarray.arrays.MutableNDArray;
import io.kinference.ndarray.arrays.MutableShortNDArray;
import io.kinference.ndarray.arrays.MutableUByteNDArray;
import io.kinference.ndarray.arrays.NDArray;
import io.kinference.ndarray.arrays.ShortNDArray;
import io.kinference.ndarray.arrays.UByteNDArray;
import io.kinference.ndarray.arrays.tiled.BooleanTiledArray;
import io.kinference.ndarray.arrays.tiled.ByteTiledArray;
import io.kinference.ndarray.arrays.tiled.DoubleTiledArray;
import io.kinference.ndarray.arrays.tiled.FloatTiledArray;
import io.kinference.ndarray.arrays.tiled.IntTiledArray;
import io.kinference.ndarray.arrays.tiled.LongTiledArray;
import io.kinference.ndarray.arrays.tiled.ShortTiledArray;
import io.kinference.ndarray.arrays.tiled.UByteTiledArray;
import io.kinference.ndarray.extensions.ArrayFactoriesKt$WhenMappings;
import io.kinference.primitives.types.DataType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.UByte;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b\u001aA\u0010\f\u001a\u00020\r\"\u0006\b\u0000\u0010\u000e\u0018\u00012\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0014\b\b\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0086\b\u001a\u001e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\r\u001a\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0010\u001a\u0016\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001d"}, d2={"SUPPORTED_TYPES", "", "Lio/kinference/primitives/types/DataType;", "getSUPPORTED_TYPES", "()Ljava/util/Set;", "allocateNDArray", "Lio/kinference/ndarray/arrays/MutableNDArray;", "type", "strides", "Lio/kinference/ndarray/Strides;", "shape", "", "createArray", "", "T", "divider", "", "init", "Lkotlin/Function1;", "createMutableNDArray", "value", "createNDArray", "Lio/kinference/ndarray/arrays/NDArray;", "createScalarNDArray", "createZerosArray", "size", "inferType", "type1", "type2", "ndarray"})
public final class ArrayFactoriesKt {
    @NotNull
    private static final Set<DataType> SUPPORTED_TYPES = SetsKt.setOf((Object[])new DataType[]{DataType.DOUBLE, DataType.FLOAT, DataType.LONG, DataType.INT, DataType.SHORT});

    @NotNull
    public static final /* synthetic */ <T> Object createArray(@NotNull DataType type, @NotNull int[] shape, int divider, @NotNull Function1<? super Integer, ? extends T> init) {
        Object object;
        int $i$f$createArray = 0;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        switch (ArrayFactoriesKt$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                object = DoubleTiledArray.Companion.invoke(shape, divider, (Function1<? super Integer, Double>)((Function1)new Function1<Integer, Double>(init){
                    final /* synthetic */ Function1 $init;

                    public final double invoke(int it) {
                        Object object = this.$init.invoke((Object)it);
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
                        }
                        return (Double)object;
                    }
                    {
                        this.$init = function1;
                        super(1);
                    }
                }));
                break;
            }
            case 2: {
                object = FloatTiledArray.Companion.invoke(shape, divider, (Function1<? super Integer, Float>)((Function1)new Function1<Integer, Float>(init){
                    final /* synthetic */ Function1 $init;

                    public final float invoke(int it) {
                        Object object = this.$init.invoke((Object)it);
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                        }
                        return ((Float)object).floatValue();
                    }
                    {
                        this.$init = function1;
                        super(1);
                    }
                }));
                break;
            }
            case 3: {
                object = LongTiledArray.Companion.invoke(shape, divider, (Function1<? super Integer, Long>)((Function1)new Function1<Integer, Long>(init){
                    final /* synthetic */ Function1 $init;

                    public final long invoke(int it) {
                        Object object = this.$init.invoke((Object)it);
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                        }
                        return (Long)object;
                    }
                    {
                        this.$init = function1;
                        super(1);
                    }
                }));
                break;
            }
            case 4: {
                object = IntTiledArray.Companion.invoke(shape, divider, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(init){
                    final /* synthetic */ Function1 $init;

                    public final int invoke(int it) {
                        Object object = this.$init.invoke((Object)it);
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                        }
                        return (Integer)object;
                    }
                    {
                        this.$init = function1;
                        super(1);
                    }
                }));
                break;
            }
            case 5: {
                object = ShortTiledArray.Companion.invoke(shape, divider, (Function1<? super Integer, Short>)((Function1)new Function1<Integer, Short>(init){
                    final /* synthetic */ Function1 $init;

                    public final short invoke(int it) {
                        Object object = this.$init.invoke((Object)it);
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Short");
                        }
                        return (Short)object;
                    }
                    {
                        this.$init = function1;
                        super(1);
                    }
                }));
                break;
            }
            case 6: {
                object = BooleanTiledArray.Companion.invoke(shape, divider, (Function1<? super Integer, Boolean>)((Function1)new Function1<Integer, Boolean>(init){
                    final /* synthetic */ Function1 $init;

                    public final boolean invoke(int it) {
                        Object object = this.$init.invoke((Object)it);
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                        }
                        return (Boolean)object;
                    }
                    {
                        this.$init = function1;
                        super(1);
                    }
                }));
                break;
            }
            case 7: {
                object = ByteTiledArray.Companion.invoke(shape, divider, (Function1<? super Integer, Byte>)((Function1)new Function1<Integer, Byte>(init){
                    final /* synthetic */ Function1 $init;

                    public final byte invoke(int it) {
                        Object object = this.$init.invoke((Object)it);
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Byte");
                        }
                        return (Byte)object;
                    }
                    {
                        this.$init = function1;
                        super(1);
                    }
                }));
                break;
            }
            case 8: {
                object = UByteTiledArray.Companion.invoke(shape, divider, (Function1<? super Integer, UByte>)((Function1)new Function1<Integer, UByte>(init){
                    final /* synthetic */ Function1 $init;

                    public final byte invoke(int it) {
                        Object object = this.$init.invoke((Object)it);
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.UByte");
                        }
                        return ((UByte)object).unbox-impl();
                    }
                    {
                        this.$init = function1;
                        super(1);
                    }
                }));
                break;
            }
            default: {
                String string = "Unsupported data type: " + type;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return object;
    }

    public static /* synthetic */ Object createArray$default(DataType type, int[] shape, int divider, Function1 init, int n, Object object) {
        Object object2;
        if ((n & 4) != 0) {
            divider = 1;
        }
        boolean $i$f$createArray = false;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        Intrinsics.checkParameterIsNotNull((Object)init, (String)"init");
        switch (ArrayFactoriesKt$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                object2 = DoubleTiledArray.Companion.invoke(shape, divider, (Function1<? super Integer, Double>)((Function1)new /* invalid duplicate definition of identical inner class */));
                break;
            }
            case 2: {
                object2 = FloatTiledArray.Companion.invoke(shape, divider, (Function1<? super Integer, Float>)((Function1)new /* invalid duplicate definition of identical inner class */));
                break;
            }
            case 3: {
                object2 = LongTiledArray.Companion.invoke(shape, divider, (Function1<? super Integer, Long>)((Function1)new /* invalid duplicate definition of identical inner class */));
                break;
            }
            case 4: {
                object2 = IntTiledArray.Companion.invoke(shape, divider, (Function1<? super Integer, Integer>)((Function1)new /* invalid duplicate definition of identical inner class */));
                break;
            }
            case 5: {
                object2 = ShortTiledArray.Companion.invoke(shape, divider, (Function1<? super Integer, Short>)((Function1)new /* invalid duplicate definition of identical inner class */));
                break;
            }
            case 6: {
                object2 = BooleanTiledArray.Companion.invoke(shape, divider, (Function1<? super Integer, Boolean>)((Function1)new /* invalid duplicate definition of identical inner class */));
                break;
            }
            case 7: {
                object2 = ByteTiledArray.Companion.invoke(shape, divider, (Function1<? super Integer, Byte>)((Function1)new /* invalid duplicate definition of identical inner class */));
                break;
            }
            case 8: {
                object2 = UByteTiledArray.Companion.invoke(shape, divider, (Function1<? super Integer, UByte>)((Function1)new /* invalid duplicate definition of identical inner class */));
                break;
            }
            default: {
                object = "Unsupported data type: " + type;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
        }
        return object2;
    }

    @NotNull
    public static final MutableNDArray createMutableNDArray(@NotNull DataType type, @NotNull Object value, @NotNull Strides strides) {
        MutableNDArray mutableNDArray;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        switch (ArrayFactoriesKt$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                mutableNDArray = new MutableDoubleNDArray((DoubleTiledArray)value, strides);
                break;
            }
            case 2: {
                mutableNDArray = new MutableFloatNDArray((FloatTiledArray)value, strides);
                break;
            }
            case 3: {
                mutableNDArray = new MutableLongNDArray((LongTiledArray)value, strides);
                break;
            }
            case 4: {
                mutableNDArray = new MutableIntNDArray((IntTiledArray)value, strides);
                break;
            }
            case 5: {
                mutableNDArray = new MutableShortNDArray((ShortTiledArray)value, strides);
                break;
            }
            case 6: {
                mutableNDArray = new MutableBooleanNDArray((BooleanTiledArray)value, strides);
                break;
            }
            case 7: {
                mutableNDArray = new MutableByteNDArray((ByteTiledArray)value, strides);
                break;
            }
            case 8: {
                mutableNDArray = new MutableUByteNDArray((UByteTiledArray)value, strides);
                break;
            }
            default: {
                String string = "Unsupported data type " + type;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return mutableNDArray;
    }

    @NotNull
    public static final MutableNDArray createMutableNDArray(@NotNull DataType type, @NotNull Object value, @NotNull int[] shape) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        return ArrayFactoriesKt.createMutableNDArray(type, value, new Strides(shape));
    }

    @NotNull
    public static final NDArray createNDArray(@NotNull DataType type, @NotNull Object value, @NotNull Strides strides) {
        NDArray nDArray;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        switch (ArrayFactoriesKt$WhenMappings.$EnumSwitchMapping$2[type.ordinal()]) {
            case 1: {
                nDArray = new DoubleNDArray((DoubleTiledArray)value, strides);
                break;
            }
            case 2: {
                nDArray = new FloatNDArray((FloatTiledArray)value, strides);
                break;
            }
            case 3: {
                nDArray = new LongNDArray((LongTiledArray)value, strides);
                break;
            }
            case 4: {
                nDArray = new IntNDArray((IntTiledArray)value, strides);
                break;
            }
            case 5: {
                nDArray = new ShortNDArray((ShortTiledArray)value, strides);
                break;
            }
            case 6: {
                nDArray = new BooleanNDArray((BooleanTiledArray)value, strides);
                break;
            }
            case 7: {
                nDArray = new ByteNDArray((ByteTiledArray)value, strides);
                break;
            }
            case 8: {
                nDArray = new UByteNDArray((UByteTiledArray)value, strides);
                break;
            }
            default: {
                String string = "Unsupported data type " + type;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return nDArray;
    }

    @NotNull
    public static final NDArray createNDArray(@NotNull DataType type, @NotNull Object value, @NotNull int[] shape) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        return ArrayFactoriesKt.createNDArray(type, value, new Strides(shape));
    }

    @NotNull
    public static final Object createZerosArray(@NotNull DataType type, int size) {
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        switch (ArrayFactoriesKt$WhenMappings.$EnumSwitchMapping$3[type.ordinal()]) {
            case 1: {
                objectArray = new double[size];
                break;
            }
            case 2: {
                objectArray = new float[size];
                break;
            }
            case 3: {
                objectArray = new long[size];
                break;
            }
            case 4: {
                objectArray = new int[size];
                break;
            }
            case 5: {
                objectArray = new short[size];
                break;
            }
            case 6: {
                objectArray = new boolean[size];
                break;
            }
            default: {
                String string = "Unsupported data type " + type;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return objectArray;
    }

    @NotNull
    public static final NDArray createScalarNDArray(@NotNull DataType type, @NotNull Object value) {
        NDArray nDArray;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        switch (ArrayFactoriesKt$WhenMappings.$EnumSwitchMapping$4[type.ordinal()]) {
            case 1: {
                nDArray = DoubleNDArray.Companion.scalar((Double)value);
                break;
            }
            case 2: {
                nDArray = FloatNDArray.Companion.scalar(((Float)value).floatValue());
                break;
            }
            case 3: {
                nDArray = LongNDArray.Companion.scalar((Long)value);
                break;
            }
            case 4: {
                nDArray = IntNDArray.Companion.scalar((Integer)value);
                break;
            }
            case 5: {
                nDArray = ShortNDArray.Companion.scalar((Short)value);
                break;
            }
            case 6: {
                nDArray = BooleanNDArray.Companion.scalar((Boolean)value);
                break;
            }
            case 7: {
                nDArray = ByteNDArray.Companion.scalar((Byte)value);
                break;
            }
            case 8: {
                nDArray = UByteNDArray.Companion.scalar-7apg3OU(((UByte)value).unbox-impl());
                break;
            }
            default: {
                String string = "Unsupported data type " + type;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return nDArray;
    }

    @NotNull
    public static final MutableNDArray allocateNDArray(@NotNull DataType type, @NotNull Strides strides) {
        MutableNDArray mutableNDArray;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        switch (ArrayFactoriesKt$WhenMappings.$EnumSwitchMapping$5[type.ordinal()]) {
            case 1: {
                mutableNDArray = new MutableDoubleNDArray(DoubleTiledArray.Companion.invoke$default(DoubleTiledArray.Companion, strides, 0, 2, null), strides);
                break;
            }
            case 2: {
                mutableNDArray = new MutableFloatNDArray(FloatTiledArray.Companion.invoke$default(FloatTiledArray.Companion, strides, 0, 2, null), strides);
                break;
            }
            case 3: {
                mutableNDArray = new MutableLongNDArray(LongTiledArray.Companion.invoke$default(LongTiledArray.Companion, strides, 0, 2, null), strides);
                break;
            }
            case 4: {
                mutableNDArray = new MutableIntNDArray(IntTiledArray.Companion.invoke$default(IntTiledArray.Companion, strides, 0, 2, null), strides);
                break;
            }
            case 5: {
                mutableNDArray = new MutableShortNDArray(ShortTiledArray.Companion.invoke$default(ShortTiledArray.Companion, strides, 0, 2, null), strides);
                break;
            }
            case 6: {
                mutableNDArray = new MutableBooleanNDArray(BooleanTiledArray.Companion.invoke$default(BooleanTiledArray.Companion, strides, 0, 2, null), strides);
                break;
            }
            case 7: {
                mutableNDArray = new MutableByteNDArray(ByteTiledArray.Companion.invoke$default(ByteTiledArray.Companion, strides, 0, 2, null), strides);
                break;
            }
            case 8: {
                mutableNDArray = new MutableUByteNDArray(UByteTiledArray.Companion.invoke$default(UByteTiledArray.Companion, strides, 0, 2, null), strides);
                break;
            }
            default: {
                String string = "Unsupported data type " + type;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return mutableNDArray;
    }

    @NotNull
    public static final MutableNDArray allocateNDArray(@NotNull DataType type, @NotNull int[] shape) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        return ArrayFactoriesKt.allocateNDArray(type, new Strides(shape));
    }

    @NotNull
    public static final Set<DataType> getSUPPORTED_TYPES() {
        return SUPPORTED_TYPES;
    }

    @NotNull
    public static final DataType inferType(@NotNull DataType type1, @NotNull DataType type2) {
        DataType dataType;
        Intrinsics.checkParameterIsNotNull((Object)type1, (String)"type1");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type2");
        if (!SUPPORTED_TYPES.contains(type1) || !SUPPORTED_TYPES.contains(type2)) {
            String string = "Unsupported type";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (type1 == DataType.DOUBLE || type2 == DataType.DOUBLE) {
            dataType = DataType.DOUBLE;
        } else if (type1 == DataType.FLOAT || type2 == DataType.FLOAT) {
            dataType = DataType.FLOAT;
        } else if (type1 == DataType.LONG || type2 == DataType.LONG) {
            dataType = DataType.LONG;
        } else if (type1 == DataType.INT || type2 == DataType.INT) {
            dataType = DataType.INT;
        } else if (type1 == DataType.SHORT || type2 == DataType.SHORT) {
            dataType = DataType.SHORT;
        } else {
            String string = "Unsupported type";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return dataType;
    }
}

