/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays.tiled;

import io.kinference.ndarray.Strides;
import io.kinference.ndarray.arrays.pointers.BooleanPointer;
import io.kinference.ndarray.arrays.pointers.BooleanPointerKt;
import io.kinference.ndarray.arrays.tiled.BooleanTiledArray;
import io.kinference.ndarray.arrays.tiled.LongTiledArray;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 /2\u00020\u0001:\u0001/B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0015\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rB\u0017\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000fJ,\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u001c\u001a\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u0000J\u0016\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003J\"\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\f2\b\b\u0002\u0010$\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020\u0003J\u0011\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u0003H\u0086\u0002J\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030)2\u0006\u0010'\u001a\u00020\u0003J\u0010\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020\u0003J\u0019\u0010-\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\fH\u0086\u0002J\u0006\u0010.\u001a\u00020\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011\u00a8\u00060"}, d2={"Lio/kinference/ndarray/arrays/tiled/BooleanTiledArray;", "", "size", "", "blockSize", "(II)V", "blocks", "", "", "([[Z)V", "init", "Lkotlin/Function1;", "", "(IILkotlin/jvm/functions/Function1;)V", "array", "([ZI)V", "getBlockSize", "()I", "getBlocks", "()[[Z", "[[Z", "blocksNum", "getBlocksNum", "getSize", "copyInto", "", "dest", "destOffset", "srcStart", "srcEnd", "copyOf", "copyOfRange", "fromIndex", "toIndex", "fill", "value", "from", "to", "get", "i", "indexFor", "Lkotlin/Pair;", "pointer", "Lio/kinference/ndarray/arrays/pointers/BooleanPointer;", "startIndex", "set", "toArray", "Companion", "ndarray"})
public final class BooleanTiledArray {
    private final int size;
    private final int blockSize;
    private final int blocksNum;
    @NotNull
    private final boolean[][] blocks;
    public static final int MIN_BLOCK_SIZE = 512;
    @NotNull
    private static final Logger logger;
    public static final Companion Companion;

    public final int getSize() {
        return this.size;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final int getBlocksNum() {
        return this.blocksNum;
    }

    @NotNull
    public final boolean[][] getBlocks() {
        return this.blocks;
    }

    @NotNull
    public final BooleanPointer pointer(int startIndex) {
        return new BooleanPointer(this, startIndex);
    }

    public static /* synthetic */ BooleanPointer pointer$default(BooleanTiledArray booleanTiledArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return booleanTiledArray.pointer(n);
    }

    @NotNull
    public final boolean[] toArray() {
        if (this.size == 0) {
            return new boolean[0];
        }
        boolean[] array = new boolean[this.size];
        int offset = 0;
        for (boolean[] block : this.blocks) {
            ArraysKt.copyInto$default((boolean[])block, (boolean[])array, (int)offset, (int)0, (int)0, (int)12, null);
            offset += this.blockSize;
        }
        return array;
    }

    @NotNull
    public final Pair<Integer, Integer> indexFor(int i) {
        int blockIdx = i / this.blockSize;
        int blockOff = i % this.blockSize;
        return TuplesKt.to((Object)blockIdx, (Object)blockOff);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean get(int i) {
        void blockIdx;
        Pair<Integer, Integer> pair = this.indexFor(i);
        int n = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        return this.blocks[blockIdx][blockOff];
    }

    public final void set(int i, boolean value) {
        Pair<Integer, Integer> pair = this.indexFor(i);
        int n = ((Number)pair.component1()).intValue();
        int blockOff = ((Number)pair.component2()).intValue();
        this.blocks[blockIdx][blockOff] = value;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BooleanTiledArray copyOf() {
        BooleanTiledArray copyArray = new BooleanTiledArray(this.size, this.blockSize);
        int n = 0;
        int n2 = this.blocksNum;
        while (n < n2) {
            void blockNum;
            boolean[] thisBlock = this.blocks[blockNum];
            boolean[] destBlock = copyArray.blocks[blockNum];
            ArraysKt.copyInto$default((boolean[])thisBlock, (boolean[])destBlock, (int)0, (int)0, (int)0, (int)14, null);
            ++blockNum;
        }
        return copyArray;
    }

    public final void copyInto(@NotNull BooleanTiledArray dest, int destOffset, int srcStart, int srcEnd) {
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        if (srcStart == srcEnd) {
            return;
        }
        BooleanPointer thisPtr = new BooleanPointer(this, srcStart);
        BooleanPointer destPtr = new BooleanPointer(dest, destOffset);
        BooleanPointerKt.accept(destPtr, thisPtr, srcEnd - srcStart, (Function2<? super Boolean, ? super Boolean, Boolean>)((Function2)copyInto.1.INSTANCE));
    }

    public static /* synthetic */ void copyInto$default(BooleanTiledArray booleanTiledArray, BooleanTiledArray booleanTiledArray2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = booleanTiledArray.size;
        }
        booleanTiledArray.copyInto(booleanTiledArray2, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final boolean[] copyOfRange(int fromIndex, int toIndex) {
        boolean[] array = new boolean[toIndex - fromIndex];
        BooleanPointer pointer = new BooleanPointer(this, fromIndex);
        int n = 0;
        int n2 = array.length;
        while (n < n2) {
            boolean bl;
            void this_$iv;
            void i;
            BooleanPointer booleanPointer = pointer;
            void var16_17 = i;
            boolean[] blArray = array;
            boolean $i$f$getAndIncrement = false;
            boolean value$iv = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
            void this_$iv$iv = this_$iv;
            boolean $i$f$increment = false;
            if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                void v0 = this_$iv$iv;
                int n3 = v0.getIndexInBlock();
                v0.setIndexInBlock(n3 + 1);
            } else {
                int n4;
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$blockIncrement = false;
                if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                    void v1 = this_$iv$iv$iv;
                    n4 = v1.getBlockNum();
                    v1.setBlockNum(n4 + 1);
                    this_$iv$iv$iv.setIndexInBlock(0);
                    this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                } else {
                    void v2 = this_$iv$iv$iv;
                    n4 = v2.getIndexInBlock();
                    v2.setIndexInBlock(n4 + 1);
                }
            }
            blArray[var16_17] = bl = value$iv;
            ++i;
        }
        return array;
    }

    public final void fill(boolean value, int from, int to) {
        if (from == to) {
            return;
        }
        BooleanPointer pointer = new BooleanPointer(this, from);
        for (int count = to - from; count > 0; count -= this.blockSize) {
            int n;
            boolean[] block = pointer.getCurrentBlock();
            int offset = pointer.getIndexInBlock();
            BooleanPointer this_$iv = pointer;
            boolean $i$f$blockIncrement = false;
            if (this_$iv.getBlockNum() < this_$iv.getArray().getBlocksNum() - 1) {
                BooleanPointer booleanPointer = this_$iv;
                n = booleanPointer.getBlockNum();
                booleanPointer.setBlockNum(n + 1);
                this_$iv.setIndexInBlock(0);
                this_$iv.setCurrentBlock(this_$iv.getArray().getBlocks()[this_$iv.getBlockNum()]);
            } else {
                BooleanPointer booleanPointer = this_$iv;
                n = booleanPointer.getIndexInBlock();
                booleanPointer.setIndexInBlock(n + 1);
            }
            int n2 = this.blockSize;
            int n3 = offset;
            boolean bl = value;
            boolean[] blArray = block;
            boolean bl2 = false;
            int n4 = Math.min(n2, count);
            ArraysKt.fill((boolean[])blArray, (boolean)bl, (int)n3, (int)n4);
        }
    }

    public static /* synthetic */ void fill$default(BooleanTiledArray booleanTiledArray, boolean bl, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = booleanTiledArray.size;
        }
        booleanTiledArray.fill(bl, n, n2);
    }

    public BooleanTiledArray(int size, int blockSize) {
        boolean[][] blArrayArray;
        int n;
        int n2;
        if (blockSize != 0) {
            n2 = size % blockSize == 0 ? 1 : 0;
            boolean bl = false;
            n = 0;
            if (n2 == 0) {
                boolean bl2 = false;
                String string = "Size must divide blockSize";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        n2 = this.blocksNum = blockSize == 0 ? 0 : size / blockSize;
        BooleanTiledArray booleanTiledArray = this;
        boolean[][] blArrayArray2 = new boolean[n2][];
        n = 0;
        while (n < n2) {
            int bl2 = n;
            int n3 = n++;
            blArrayArray = blArrayArray2;
            boolean bl = false;
            boolean[] blArray = new boolean[blockSize];
            blArrayArray[n3] = blArray;
        }
        blArrayArray = blArrayArray2;
        booleanTiledArray.blocks = blArrayArray;
        this.blockSize = blockSize;
        this.size = size;
    }

    public BooleanTiledArray(@NotNull boolean[][] blocks) {
        Intrinsics.checkParameterIsNotNull((Object)blocks, (String)"blocks");
        this.blocks = blocks;
        Object[] objectArray = (Object[])blocks;
        BooleanTiledArray booleanTiledArray = this;
        boolean bl = false;
        boolean bl2 = objectArray.length == 0;
        booleanTiledArray.blockSize = bl2 ? 0 : ((boolean[])ArraysKt.first((Object[])((Object[])blocks))).length;
        this.blocksNum = ((Object[])blocks).length;
        this.size = this.blocksNum * this.blockSize;
    }

    /*
     * WARNING - void declaration
     */
    public BooleanTiledArray(int size, int blockSize, @NotNull Function1<? super Integer, Boolean> init) {
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        this(size, blockSize);
        int count = 0;
        for (boolean[] block : this.blocks) {
            int n = 0;
            int n2 = blockSize;
            while (n < n2) {
                void idx;
                Integer n3 = count;
                ++count;
                block[idx] = (Boolean)init.invoke((Object)n3);
                ++idx;
            }
        }
    }

    public BooleanTiledArray(@NotNull boolean[] array, int blockSize) {
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        this(array.length, blockSize);
        int startIndex = 0;
        int endIndex = blockSize;
        for (boolean[] block : this.blocks) {
            ArraysKt.copyInto((boolean[])array, (boolean[])block, (int)0, (int)startIndex, (int)endIndex);
            startIndex = endIndex;
            endIndex += blockSize;
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(LongTiledArray.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\u2026ngTiledArray::class.java)");
        BooleanTiledArray.logger = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0004H\u0002J\u001b\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u0004H\u0086\u0002J/\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00042\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u0010H\u0086\u0002J\u001b\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\f\u001a\u00020\u0004H\u0086\u0002J/\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\f\u001a\u00020\u00042\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u0010H\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/kinference/ndarray/arrays/tiled/BooleanTiledArray$Companion;", "", "()V", "MIN_BLOCK_SIZE", "", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "blockSizeByStrides", "strides", "Lio/kinference/ndarray/Strides;", "divider", "invoke", "Lio/kinference/ndarray/arrays/tiled/BooleanTiledArray;", "init", "Lkotlin/Function1;", "", "shape", "", "ndarray"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private final int blockSizeByStrides(Strides strides, int divider) {
            int n;
            if (strides.getLinearSize() == 0) {
                n = 0;
            } else {
                int[] nArray = strides.getShape();
                boolean bl = false;
                if (nArray.length == 0) {
                    n = 1;
                } else {
                    int blockSize;
                    int n2;
                    int rowSize = ArraysKt.last((int[])strides.getShape());
                    bl = rowSize % divider == 0;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    bl3 = false;
                    boolean bl4 = false;
                    if (!bl) {
                        boolean bl5 = false;
                        String string = "Failed requirement.";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    int dividedRowSize = rowSize / divider;
                    if (dividedRowSize < 512) {
                        n2 = dividedRowSize;
                    } else {
                        int num = dividedRowSize / 512;
                        while (dividedRowSize % num != 0) {
                            --num;
                        }
                        n2 = dividedRowSize / num;
                    }
                    n = blockSize = n2;
                }
            }
            return n;
        }

        static /* synthetic */ int blockSizeByStrides$default(Companion companion, Strides strides, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 1;
            }
            return companion.blockSizeByStrides(strides, n);
        }

        @NotNull
        public final BooleanTiledArray invoke(@NotNull Strides strides, int divider) {
            Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
            int blockSize = this.blockSizeByStrides(strides, divider);
            return new BooleanTiledArray(strides.getLinearSize(), blockSize);
        }

        public static /* synthetic */ BooleanTiledArray invoke$default(Companion companion, Strides strides, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 1;
            }
            return companion.invoke(strides, n);
        }

        @NotNull
        public final BooleanTiledArray invoke(@NotNull Strides strides, int divider, @NotNull Function1<? super Integer, Boolean> init) {
            Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
            Intrinsics.checkParameterIsNotNull(init, (String)"init");
            int blockSize = this.blockSizeByStrides(strides, divider);
            return new BooleanTiledArray(strides.getLinearSize(), blockSize, init);
        }

        public static /* synthetic */ BooleanTiledArray invoke$default(Companion companion, Strides strides, int n, Function1 function1, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 1;
            }
            return companion.invoke(strides, n, (Function1<? super Integer, Boolean>)function1);
        }

        @NotNull
        public final BooleanTiledArray invoke(@NotNull int[] shape, int divider) {
            Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
            return this.invoke(new Strides(shape), divider);
        }

        public static /* synthetic */ BooleanTiledArray invoke$default(Companion companion, int[] nArray, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 1;
            }
            return companion.invoke(nArray, n);
        }

        @NotNull
        public final BooleanTiledArray invoke(@NotNull int[] shape, int divider, @NotNull Function1<? super Integer, Boolean> init) {
            Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
            Intrinsics.checkParameterIsNotNull(init, (String)"init");
            return this.invoke(new Strides(shape), divider, init);
        }

        public static /* synthetic */ BooleanTiledArray invoke$default(Companion companion, int[] nArray, int n, Function1 function1, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 1;
            }
            return companion.invoke(nArray, n, (Function1<? super Integer, Boolean>)function1);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

