/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays;

import io.kinference.ndarray.Strides;
import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.FloatNDArray;
import io.kinference.ndarray.arrays.IntNDArray;
import io.kinference.ndarray.arrays.MutableFloatNDArray;
import io.kinference.ndarray.arrays.MutableNDArray;
import io.kinference.ndarray.arrays.MutableNumberNDArray;
import io.kinference.ndarray.arrays.MutableShortNDArray;
import io.kinference.ndarray.arrays.NDArray;
import io.kinference.ndarray.arrays.NumberNDArray;
import io.kinference.ndarray.arrays.PrimitiveToPrimitiveFunction;
import io.kinference.ndarray.arrays.ShortMap;
import io.kinference.ndarray.arrays.ShortNDArray;
import io.kinference.ndarray.arrays.pointers.BytePointer;
import io.kinference.ndarray.arrays.pointers.FloatPointer;
import io.kinference.ndarray.arrays.pointers.IntPointer;
import io.kinference.ndarray.arrays.pointers.ShortPointer;
import io.kinference.ndarray.arrays.pointers.UBytePointer;
import io.kinference.ndarray.arrays.tiled.FloatTiledArray;
import io.kinference.ndarray.arrays.tiled.IntTiledArray;
import io.kinference.ndarray.arrays.tiled.ShortTiledArray;
import io.kinference.ndarray.extensions.BroadcastingKt;
import io.kinference.ndarray.extensions.GatherKt;
import io.kinference.ndarray.extensions.NDArrayExtensionsKt;
import io.kinference.primitives.types.DataType;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.UByteArray;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0017\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 u2\u00020\u0001:\u0001uB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rB-\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000eB\u0015\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010$\u001a\u00020%H\u0016J \u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016J)\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010,2\u0006\u0010.\u001a\u00020,2\b\u0010'\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010/J\u0011\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020\u0001H\u0096\u0002J\u0018\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J\u0018\u00103\u001a\u00020#2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J \u00104\u001a\u00020#2\u0006\u00105\u001a\u0002062\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J\u0013\u00107\u001a\u00020)2\b\u00101\u001a\u0004\u0018\u000108H\u0096\u0002J\u0015\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u000208H\u0016\u00a2\u0006\u0002\u0010;J\u0080\u0001\u0010<\u001a\u00020%2\u0006\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\u00052\u0006\u0010?\u001a\u00020\u00052\u0006\u00105\u001a\u0002062\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020,2\u0006\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u0002062\u0006\u0010D\u001a\u00020%2\u0006\u0010E\u001a\u00020\u00052\u0006\u0010F\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u00020)2\u0006\u0010J\u001a\u00020)H\u0016J\b\u0010K\u001a\u00020\u0005H\u0016J\u0010\u0010L\u001a\u00020#2\u0006\u0010M\u001a\u00020NH\u0016J\r\u0010O\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010PJ\r\u0010Q\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010PJ\u0011\u0010R\u001a\u00020#2\u0006\u00101\u001a\u00020\u0001H\u0096\u0002J\u0018\u0010R\u001a\u00020#2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J\u0011\u0010S\u001a\u00020#2\u0006\u00101\u001a\u00020\u0001H\u0096\u0002J\u0018\u0010S\u001a\u00020#2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J \u0010T\u001a\u00020U2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010V\u001a\u00020\t2\u0006\u00102\u001a\u00020\u0010H\u0002J\u0010\u0010W\u001a\u00020,2\u0006\u0010X\u001a\u00020\u0003H\u0016J1\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0Z2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020[0Z2\u0006\u0010]\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010^J\u0010\u0010_\u001a\u00020#2\u0006\u0010_\u001a\u00020\u0005H\u0016J\r\u0010`\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010PJH\u0010a\u001a\u00020U2\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020c2\u0006\u0010e\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010f\u001a\u00020\u00032\u0006\u0010g\u001a\u00020\u00032\u0006\u0010h\u001a\u00020\u0003H\u0002J \u0010a\u001a\u00020#2\u0006\u0010f\u001a\u00020\u00032\u0006\u0010g\u001a\u00020\u00032\u0006\u0010h\u001a\u00020\u0003H\u0016J\u001b\u0010i\u001a\b\u0012\u0004\u0012\u00020,0Z2\u0006\u0010j\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010kJ\r\u0010l\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010PJ\u0011\u0010m\u001a\u00020#2\u0006\u00101\u001a\u00020\u0001H\u0096\u0002J\u0018\u0010m\u001a\u00020#2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J \u0010n\u001a\u00020U2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010V\u001a\u00020\t2\u0006\u00102\u001a\u00020\u0010H\u0002J\u0010\u0010o\u001a\u00020#2\u0006\u0010p\u001a\u00020\fH\u0016J\u0014\u0010q\u001a\u00020\u00002\n\u0010r\u001a\u00020\u0003\"\u00020\u0005H\u0016J\u0010\u0010s\u001a\u00020t2\u0006\u0010-\u001a\u00020\u0001H\u0016R$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R$\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006v"}, d2={"Lio/kinference/ndarray/arrays/ShortNDArray;", "Lio/kinference/ndarray/arrays/NumberNDArray;", "shape", "", "divider", "", "([II)V", "init", "Lkotlin/Function1;", "", "([IILkotlin/jvm/functions/Function1;)V", "strides", "Lio/kinference/ndarray/Strides;", "(Lio/kinference/ndarray/Strides;I)V", "(Lio/kinference/ndarray/Strides;ILkotlin/jvm/functions/Function1;)V", "array", "Lio/kinference/ndarray/arrays/tiled/ShortTiledArray;", "(Lio/kinference/ndarray/arrays/tiled/ShortTiledArray;Lio/kinference/ndarray/Strides;)V", "<set-?>", "getArray", "()Lio/kinference/ndarray/arrays/tiled/ShortTiledArray;", "setArray", "(Lio/kinference/ndarray/arrays/tiled/ShortTiledArray;)V", "blocksInRow", "getBlocksInRow", "()I", "getStrides", "()Lio/kinference/ndarray/Strides;", "setStrides", "(Lio/kinference/ndarray/Strides;)V", "type", "Lio/kinference/primitives/types/DataType;", "getType", "()Lio/kinference/primitives/types/DataType;", "allocateNDArray", "Lio/kinference/ndarray/arrays/MutableNumberNDArray;", "copyIfNotMutable", "Lio/kinference/ndarray/arrays/MutableNDArray;", "cumulativeSum", "axis", "exclusive", "", "reverse", "dequantize", "Lio/kinference/ndarray/arrays/NDArray;", "zeroPoint", "scale", "(Lio/kinference/ndarray/arrays/NDArray;Lio/kinference/ndarray/arrays/NDArray;Ljava/lang/Integer;)Lio/kinference/ndarray/arrays/NDArray;", "div", "other", "destination", "dot", "dotTransposedWithAlpha", "alpha", "", "equals", "", "erfFor", "value", "(Ljava/lang/Object;)Ljava/lang/Short;", "gemm", "m", "n", "k", "lda", "b", "ldb", "beta", "c", "ldc", "aOffset", "bOffset", "cOffset", "transposeA", "transposeB", "hashCode", "map", "function", "Lio/kinference/ndarray/arrays/PrimitiveToPrimitiveFunction;", "max", "()Ljava/lang/Short;", "min", "minus", "plus", "plusScalar", "", "scalar", "reshapeView", "newShape", "resortBlocks", "", "", "blocks", "colSize", "([[SII)[[S", "row", "singleValue", "slice", "dst", "Lio/kinference/ndarray/arrays/pointers/ShortPointer;", "src", "offset", "starts", "ends", "steps", "splitHorizontalByBlocks", "parts", "(I)[Lio/kinference/ndarray/arrays/NDArray;", "sum", "times", "timesScalar", "toMutable", "newStrides", "view", "axes", "withZeroPoint", "Lio/kinference/ndarray/arrays/IntNDArray;", "Companion", "ndarray"})
public class ShortNDArray
implements NumberNDArray {
    @NotNull
    private ShortTiledArray array;
    @NotNull
    private final DataType type;
    @NotNull
    private Strides strides;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ShortTiledArray getArray() {
        return this.array;
    }

    protected final void setArray(@NotNull ShortTiledArray shortTiledArray) {
        Intrinsics.checkParameterIsNotNull((Object)shortTiledArray, (String)"<set-?>");
        this.array = shortTiledArray;
    }

    protected final int getBlocksInRow() {
        int n;
        if (this.strides.getLinearSize() == 0) {
            n = 0;
        } else {
            int[] nArray = this.strides.getShape();
            boolean bl = false;
            n = nArray.length == 0 ? 1 : ArraysKt.last((int[])this.strides.getShape()) / this.array.getBlockSize();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ShortNDArray view(int ... axes) {
        void $this$foldIndexed$iv;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)axes, (String)"axes");
        int[] nArray = axes;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            void i;
            int axis = nArray[n3];
            boolean bl = this.getShape()[i] > axis;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            n = 0;
            if (!bl) {
                boolean bl4 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ++i;
        }
        int[] axis = axes;
        int initial$iv22 = 0;
        int $i$f$foldIndexed = 0;
        int index$iv = 0;
        int accumulator$iv = initial$iv22;
        for (void element$iv : $this$foldIndexed$iv) {
            void i;
            void acc;
            int n4 = index$iv++;
            void var12_19 = element$iv;
            int n5 = accumulator$iv;
            int index = n4;
            boolean bl = false;
            accumulator$iv = acc + i * this.strides.getStrides()[index];
        }
        int offset = accumulator$iv;
        int[] initial$iv22 = this.getShape();
        $i$f$foldIndexed = axes.length;
        index$iv = this.getShape().length;
        accumulator$iv = 0;
        int[] newShape = ArraysKt.copyOfRange((int[])initial$iv22, (int)$i$f$foldIndexed, (int)index$iv);
        Strides newStrides = new Strides(newShape);
        if (this.array.getBlockSize() == 0) {
            return new ShortNDArray(this.array, newStrides);
        }
        int offsetBlocks = offset / this.array.getBlockSize();
        int countBlocks = newStrides.getLinearSize() / this.array.getBlockSize();
        Object[] objectArray = (Object[])this.array.getBlocks();
        n = offsetBlocks + countBlocks;
        int n6 = 0;
        short[][] copyBlocks = (short[][])ArraysKt.copyOfRange((Object[])objectArray, (int)offsetBlocks, (int)n);
        ShortTiledArray newArray = new ShortTiledArray(copyBlocks);
        return new ShortNDArray(newArray, newStrides);
    }

    @Override
    @NotNull
    public DataType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public final Strides getStrides() {
        return this.strides;
    }

    protected final void setStrides(@NotNull Strides strides) {
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"<set-?>");
        this.strides = strides;
    }

    @Override
    @NotNull
    public Short singleValue() {
        boolean bl = NDArrayExtensionsKt.isScalar(this) || this.array.getSize() == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "NDArray contains more than 1 value";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.array.getBlocks()[0][0];
    }

    @Override
    @NotNull
    public MutableNumberNDArray allocateNDArray(@NotNull Strides strides) {
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        return new MutableShortNDArray(ShortTiledArray.Companion.invoke$default(ShortTiledArray.Companion, strides, 0, 2, null), strides);
    }

    @Override
    @NotNull
    public NDArray reshapeView(@NotNull int[] newShape) {
        Intrinsics.checkParameterIsNotNull((Object)newShape, (String)"newShape");
        Strides newStrides = new Strides(newShape);
        boolean bl = newStrides.getLinearSize() == this.getLinearSize();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new ShortNDArray(this.array, newStrides);
    }

    @Override
    @NotNull
    public MutableNumberNDArray toMutable(@NotNull Strides newStrides) {
        Intrinsics.checkParameterIsNotNull((Object)newStrides, (String)"newStrides");
        return new MutableShortNDArray(this.array.copyOf(), newStrides);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNumberNDArray map(@NotNull PrimitiveToPrimitiveFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        ShortMap cfr_ignored_0 = (ShortMap)function;
        MutableNumberNDArray mutableNumberNDArray = this.allocateNDArray(this.strides);
        if (mutableNumberNDArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.MutableShortNDArray");
        }
        MutableShortNDArray destination = (MutableShortNDArray)mutableNumberNDArray;
        int n = 0;
        int n2 = this.array.getBlocksNum();
        while (n < n2) {
            void blockNum;
            short[] thisBlock = this.array.getBlocks()[blockNum];
            short[] destBlock = destination.getArray().getBlocks()[blockNum];
            int n3 = 0;
            int n4 = thisBlock.length;
            while (n3 < n4) {
                void idx;
                destBlock[idx] = ((ShortMap)function).apply(thisBlock[idx]);
                ++idx;
            }
            ++blockNum;
        }
        return destination;
    }

    @Override
    @NotNull
    public Short erfFor(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Short cfr_ignored_0 = (Short)value;
        double d = ((Number)value).shortValue();
        boolean bl = false;
        double sign = Math.signum(d);
        double d2 = ((Number)value).shortValue();
        boolean bl2 = false;
        double doubleValue = Math.abs(d2);
        double t = 1.0 / (1.0 + 0.3275911 * doubleValue);
        double sum = t * (UtilsKt.getERF_COEF()[0] + t * (UtilsKt.getERF_COEF()[1] + t * (UtilsKt.getERF_COEF()[2] + t * (UtilsKt.getERF_COEF()[3] + t * UtilsKt.getERF_COEF()[4]))));
        double d3 = -doubleValue * doubleValue;
        double d4 = sum;
        double d5 = 1.0;
        double d6 = sign;
        boolean bl3 = false;
        double d7 = Math.exp(d3);
        return (short)(d6 * (d5 - d4 * d7));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public IntNDArray withZeroPoint(@NotNull NumberNDArray zeroPoint) {
        IntNDArray intNDArray;
        IntTiledArray arr;
        block46: {
            int end$iv;
            int[] dstBlock$iv;
            int buf$iv;
            void rec$iv;
            void src$iv;
            void $this$acceptWithRecursive$iv;
            block43: {
                int dstOffset$iv;
                block44: {
                    IntTiledArray arr22;
                    block45: {
                        int end$iv2;
                        int[] dstBlock$iv2;
                        void other$iv2;
                        void $this$accept$iv2;
                        short zero;
                        block41: {
                            int dstOffset$iv2;
                            block42: {
                                block40: {
                                    Intrinsics.checkParameterIsNotNull((Object)zeroPoint, (String)"zeroPoint");
                                    ShortNDArray cfr_ignored_0 = (ShortNDArray)zeroPoint;
                                    if (zeroPoint.getLinearSize() != 1) break block40;
                                    zero = ((ShortNDArray)zeroPoint).array.getBlocks()[0][0];
                                    arr22 = IntTiledArray.Companion.invoke$default(IntTiledArray.Companion, this.strides, 0, 2, null);
                                    IntPointer intPointer = IntTiledArray.pointer$default(arr22, 0, 1, null);
                                    ShortPointer shortPointer = ShortTiledArray.pointer$default(this.array, 0, 1, null);
                                    int count$iv = arr22.getSize();
                                    boolean $i$f$accept = false;
                                    void $this$isCompatibleBySize$iv$iv22 = $this$accept$iv2;
                                    boolean $i$f$isCompatibleBySize = false;
                                    boolean $this$isCompatibleBySize$iv$iv22 = $this$isCompatibleBySize$iv$iv22.getArray().getSize() - $this$isCompatibleBySize$iv$iv22.getLinearIndex() >= count$iv && other$iv2.getArray().getSize() - other$iv2.getLinearIndex() >= count$iv;
                                    $i$f$isCompatibleBySize = false;
                                    boolean bl = false;
                                    if (!$this$isCompatibleBySize$iv$iv22) {
                                        boolean bl2 = false;
                                        String string = "Pointers not compatible by available elements";
                                        throw (Throwable)new IllegalArgumentException(string.toString());
                                    }
                                    void $this$isCompatibleWith$iv$iv = $this$accept$iv2;
                                    boolean $i$f$isCompatibleWith = false;
                                    if (!($this$isCompatibleWith$iv$iv.getIndexInBlock() == other$iv2.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == other$iv2.getArray().getBlockSize())) break block41;
                                    break block42;
                                }
                                arr = IntTiledArray.Companion.invoke$default(IntTiledArray.Companion, this.strides, 0, 2, null);
                                IntPointer arr22 = IntTiledArray.pointer$default(arr, 0, 1, null);
                                ShortPointer $this$accept$iv2 = ShortTiledArray.pointer$default(this.array, 0, 1, null);
                                ShortPointer other$iv2 = ShortTiledArray.pointer$default(((ShortNDArray)zeroPoint).array, 0, 1, null);
                                int count$iv = arr.getSize();
                                boolean $i$f$acceptWithRecursive = false;
                                void $this$isCompatibleBySize$iv$iv32 = $this$acceptWithRecursive$iv;
                                boolean $i$f$isCompatibleBySize = false;
                                boolean $this$isCompatibleBySize$iv$iv32 = $this$isCompatibleBySize$iv$iv32.getArray().getSize() - $this$isCompatibleBySize$iv$iv32.getLinearIndex() >= count$iv && src$iv.getArray().getSize() - src$iv.getLinearIndex() >= count$iv;
                                $i$f$isCompatibleBySize = false;
                                boolean $i$f$increment2 = false;
                                if (!$this$isCompatibleBySize$iv$iv32) {
                                    boolean bl = false;
                                    String $i$f$increment2 = "Pointers not compatible by available elements";
                                    throw (Throwable)new IllegalArgumentException($i$f$increment2.toString());
                                }
                                buf$iv = rec$iv.getLinearIndex();
                                void $this$isCompatibleWith$iv$iv = $this$acceptWithRecursive$iv;
                                boolean $i$f$isCompatibleWith = false;
                                if (!($this$isCompatibleWith$iv$iv.getIndexInBlock() == src$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == src$iv.getArray().getBlockSize())) break block43;
                                $this$isCompatibleWith$iv$iv = $this$acceptWithRecursive$iv;
                                $i$f$isCompatibleWith = false;
                                if (!($this$isCompatibleWith$iv$iv.getIndexInBlock() == rec$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == rec$iv.getArray().getBlockSize())) break block43;
                                break block44;
                            }
                            for (end$iv2 = count$iv; end$iv2 > 0; end$iv2 -= dstBlock$iv2.length - dstOffset$iv2) {
                                int n;
                                dstBlock$iv2 = $this$accept$iv2.getCurrentBlock();
                                dstOffset$iv2 = $this$accept$iv2.getIndexInBlock();
                                void this_$iv$iv = $this$accept$iv2;
                                boolean $i$f$blockIncrement = false;
                                if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                    void v0 = this_$iv$iv;
                                    int n2 = v0.getBlockNum();
                                    v0.setBlockNum(n2 + 1);
                                    this_$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                }
                                short[] srcBlock$iv = other$iv2.getCurrentBlock();
                                void this_$iv$iv22 = other$iv2;
                                int $i$f$blockIncrement2 = 0;
                                if (this_$iv$iv22.getBlockNum() < this_$iv$iv22.getArray().getBlocksNum() - 1) {
                                    void v1 = this_$iv$iv22;
                                    n = v1.getBlockNum();
                                    v1.setBlockNum(n + 1);
                                    this_$iv$iv22.setIndexInBlock(0);
                                    this_$iv$iv22.setCurrentBlock(this_$iv$iv22.getArray().getBlocks()[this_$iv$iv22.getBlockNum()]);
                                } else {
                                    this_$iv$iv22.setIndexInBlock(this_$iv$iv22.getArray().getBlockSize());
                                }
                                int this_$iv$iv22 = dstOffset$iv2;
                                n = dstBlock$iv2.length;
                                int n3 = dstOffset$iv2 + end$iv2;
                                boolean bl = false;
                                $i$f$blockIncrement2 = Math.min(n, n3);
                                while (this_$iv$iv22 < $i$f$blockIncrement2) {
                                    void src2;
                                    void index$iv;
                                    short s = srcBlock$iv[index$iv];
                                    int n4 = dstBlock$iv2[index$iv];
                                    void var28_81 = index$iv++;
                                    int[] nArray = dstBlock$iv2;
                                    boolean bl3 = false;
                                    void var29_83 = src2 - zero;
                                    nArray[var28_81] = var29_83;
                                }
                            }
                            break block45;
                        }
                        while (end$iv2 > 0) {
                            void src3;
                            short bl3;
                            dstBlock$iv2 = $this$accept$iv2;
                            void this_$iv$iv = $this$accept$iv2;
                            boolean $i$f$get = false;
                            int src2 = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                            this_$iv$iv = other$iv2;
                            boolean $i$f$getAndIncrement = false;
                            short value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                            void this_$iv$iv$iv3 = this_$iv$iv;
                            boolean $i$f$increment = false;
                            if (this_$iv$iv$iv3.getIndexInBlock() < this_$iv$iv$iv3.getArray().getBlockSize() - 1) {
                                void v2 = this_$iv$iv$iv3;
                                int n = v2.getIndexInBlock();
                                v2.setIndexInBlock(n + 1);
                            } else {
                                void this_$iv$iv$iv$iv = this_$iv$iv$iv3;
                                boolean $i$f$blockIncrement6 = false;
                                if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    void v3 = this_$iv$iv$iv$iv;
                                    int n = v3.getBlockNum();
                                    v3.setBlockNum(n + 1);
                                    this_$iv$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            short s = bl3 = value$iv$iv;
                            int $noName_0 = src2;
                            boolean $i$a$-accept-ShortNDArray$withZeroPoint$2 = false;
                            void value$iv$iv2 = src3 - zero;
                            int $i$f$set = 0;
                            this_$iv$iv2.getCurrentBlock()[this_$iv$iv2.getIndexInBlock()] = value$iv$iv2;
                            void this_$iv$iv2 = $this$accept$iv2;
                            boolean $i$f$increment2 = false;
                            if (this_$iv$iv2.getIndexInBlock() < this_$iv$iv2.getArray().getBlockSize() - 1) {
                                void v4 = this_$iv$iv2;
                                $i$f$set = v4.getIndexInBlock();
                                v4.setIndexInBlock($i$f$set + 1);
                            } else {
                                void this_$iv$iv$iv2 = this_$iv$iv2;
                                boolean $i$f$blockIncrement = false;
                                if (this_$iv$iv$iv2.getBlockNum() < this_$iv$iv$iv2.getArray().getBlocksNum() - 1) {
                                    void v5 = this_$iv$iv$iv2;
                                    int this_$iv$iv$iv3 = v5.getBlockNum();
                                    v5.setBlockNum(this_$iv$iv$iv3 + 1);
                                    this_$iv$iv$iv2.setIndexInBlock(0);
                                    this_$iv$iv$iv2.setCurrentBlock(this_$iv$iv$iv2.getArray().getBlocks()[this_$iv$iv$iv2.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv2.setIndexInBlock(this_$iv$iv$iv2.getArray().getBlockSize());
                                }
                            }
                            --end$iv2;
                        }
                    }
                    intNDArray = new IntNDArray(arr22, this.strides);
                    return intNDArray;
                }
                for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                    int $i$f$blockIncrement6;
                    if (!rec$iv.isValid()) {
                        rec$iv.setLinearIndex(buf$iv);
                    }
                    dstBlock$iv = $this$acceptWithRecursive$iv.getCurrentBlock();
                    dstOffset$iv = $this$acceptWithRecursive$iv.getIndexInBlock();
                    void this_$iv$iv = $this$acceptWithRecursive$iv;
                    boolean $i$f$blockIncrement3 = false;
                    if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                        void v7 = this_$iv$iv;
                        int $i$f$increment = v7.getBlockNum();
                        v7.setBlockNum($i$f$increment + 1);
                        this_$iv$iv.setIndexInBlock(0);
                        this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                    } else {
                        this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                    }
                    short[] srcBlock$iv = src$iv.getCurrentBlock();
                    void this_$iv$iv3 = src$iv;
                    boolean $i$f$blockIncrement4 = false;
                    if (this_$iv$iv3.getBlockNum() < this_$iv$iv3.getArray().getBlocksNum() - 1) {
                        void v8 = this_$iv$iv3;
                        int this_$iv$iv$iv$iv = v8.getBlockNum();
                        v8.setBlockNum(this_$iv$iv$iv$iv + 1);
                        this_$iv$iv3.setIndexInBlock(0);
                        this_$iv$iv3.setCurrentBlock(this_$iv$iv3.getArray().getBlocks()[this_$iv$iv3.getBlockNum()]);
                    } else {
                        this_$iv$iv3.setIndexInBlock(this_$iv$iv3.getArray().getBlockSize());
                    }
                    short[] recBlock$iv = rec$iv.getCurrentBlock();
                    void this_$iv$iv322 = rec$iv;
                    int $i$f$blockIncrement5 = 0;
                    if (this_$iv$iv322.getBlockNum() < this_$iv$iv322.getArray().getBlocksNum() - 1) {
                        void v9 = this_$iv$iv322;
                        $i$f$blockIncrement6 = v9.getBlockNum();
                        v9.setBlockNum($i$f$blockIncrement6 + 1);
                        this_$iv$iv322.setIndexInBlock(0);
                        this_$iv$iv322.setCurrentBlock(this_$iv$iv322.getArray().getBlocks()[this_$iv$iv322.getBlockNum()]);
                    } else {
                        this_$iv$iv322.setIndexInBlock(this_$iv$iv322.getArray().getBlockSize());
                    }
                    int this_$iv$iv322 = dstOffset$iv;
                    $i$f$blockIncrement6 = dstBlock$iv.length;
                    int src2 = dstOffset$iv + end$iv;
                    boolean bl = false;
                    $i$f$blockIncrement5 = Math.min($i$f$blockIncrement6, src2);
                    while (this_$iv$iv322 < $i$f$blockIncrement5) {
                        void zero;
                        void src;
                        void index$iv;
                        bl3 = recBlock$iv[index$iv];
                        short s = srcBlock$iv[index$iv];
                        int src3 = dstBlock$iv[index$iv];
                        void var28_82 = index$iv++;
                        int[] nArray = dstBlock$iv;
                        boolean bl4 = false;
                        void var29_84 = src - zero;
                        nArray[var28_82] = var29_84;
                    }
                }
                break block46;
            }
            while (end$iv > 0) {
                void zero;
                void src;
                short s;
                int n;
                boolean $i$f$blockIncrement;
                if (!rec$iv.isValid()) {
                    rec$iv.setLinearIndex(buf$iv);
                }
                dstBlock$iv = $this$acceptWithRecursive$iv;
                void this_$iv$iv = $this$acceptWithRecursive$iv;
                boolean $i$f$get = false;
                int n5 = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                this_$iv$iv = src$iv;
                boolean $i$f$getAndIncrement = false;
                short value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$increment = false;
                if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                    void v10 = this_$iv$iv$iv;
                    int $i$f$blockIncrement6 = v10.getIndexInBlock();
                    v10.setIndexInBlock($i$f$blockIncrement6 + 1);
                } else {
                    void this_$iv$iv$iv$iv = this_$iv$iv$iv;
                    $i$f$blockIncrement = false;
                    if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                        void v11 = this_$iv$iv$iv$iv;
                        n = v11.getBlockNum();
                        v11.setBlockNum(n + 1);
                        this_$iv$iv$iv$iv.setIndexInBlock(0);
                        this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                    } else {
                        this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                    }
                }
                short s2 = value$iv$iv;
                this_$iv$iv = rec$iv;
                $i$f$getAndIncrement = false;
                value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                this_$iv$iv$iv = this_$iv$iv;
                $i$f$increment = false;
                if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                    void v12 = this_$iv$iv$iv;
                    int this_$iv$iv$iv$iv = v12.getIndexInBlock();
                    v12.setIndexInBlock(this_$iv$iv$iv$iv + 1);
                } else {
                    void this_$iv$iv$iv$iv = this_$iv$iv$iv;
                    $i$f$blockIncrement = false;
                    if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                        void v13 = this_$iv$iv$iv$iv;
                        n = v13.getBlockNum();
                        v13.setBlockNum(n + 1);
                        this_$iv$iv$iv$iv.setIndexInBlock(0);
                        this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                    } else {
                        this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                    }
                }
                short $i$a$-accept-ShortNDArray$withZeroPoint$2 = s = value$iv$iv;
                short s3 = s2;
                int $noName_0 = n5;
                boolean bl = false;
                void value$iv$iv3 = src - zero;
                int $i$f$set = 0;
                this_$iv$iv4.getCurrentBlock()[this_$iv$iv4.getIndexInBlock()] = value$iv$iv3;
                void this_$iv$iv4 = $this$acceptWithRecursive$iv;
                boolean $i$f$increment3 = false;
                if (this_$iv$iv4.getIndexInBlock() < this_$iv$iv4.getArray().getBlockSize() - 1) {
                    void v14 = this_$iv$iv4;
                    $i$f$set = v14.getIndexInBlock();
                    v14.setIndexInBlock($i$f$set + 1);
                } else {
                    void this_$iv$iv$iv4 = this_$iv$iv4;
                    boolean $i$f$blockIncrement7 = false;
                    if (this_$iv$iv$iv4.getBlockNum() < this_$iv$iv$iv4.getArray().getBlocksNum() - 1) {
                        void v15 = this_$iv$iv$iv4;
                        int n6 = v15.getBlockNum();
                        v15.setBlockNum(n6 + 1);
                        this_$iv$iv$iv4.setIndexInBlock(0);
                        this_$iv$iv$iv4.setCurrentBlock(this_$iv$iv$iv4.getArray().getBlocks()[this_$iv$iv$iv4.getBlockNum()]);
                    } else {
                        this_$iv$iv$iv4.setIndexInBlock(this_$iv$iv$iv4.getArray().getBlockSize());
                    }
                }
                --end$iv;
            }
        }
        intNDArray = new IntNDArray(arr, this.strides);
        return intNDArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NDArray dequantize(@Nullable NDArray zeroPoint, @NotNull NDArray scale, @Nullable Integer axis) {
        Intrinsics.checkParameterIsNotNull((Object)scale, (String)"scale");
        FloatNDArray cfr_ignored_0 = (FloatNDArray)scale;
        NDArray nDArray = zeroPoint;
        if (!(nDArray instanceof ShortNDArray)) {
            nDArray = null;
        }
        ShortNDArray shortNDArray = (ShortNDArray)nDArray;
        ShortTiledArray zeros = shortNDArray != null ? shortNDArray.array : null;
        MutableFloatNDArray output = new MutableFloatNDArray(new FloatTiledArray(this.array.getSize(), this.array.getBlockSize()), this.strides);
        if (NDArrayExtensionsKt.canDequantizePerTensor(zeroPoint, scale)) {
            float zero = zeros == null ? 0.0f : (float)zeros.getBlocks()[0][0];
            float sc = ((FloatNDArray)scale).getArray().getBlocks()[0][0];
            if (this.getType() == DataType.BYTE) {
                int end$iv;
                float[] dstBlock$iv;
                void other$iv;
                void $this$accept$iv;
                FloatPointer floatPointer = FloatTiledArray.pointer$default(output.getArray(), 0, 1, null);
                ShortPointer shortPointer = ShortTiledArray.pointer$default(this.array, 0, 1, null);
                if (shortPointer == null) {
                    throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.pointers.BytePointer");
                }
                BytePointer bytePointer = (BytePointer)((Object)shortPointer);
                int count$iv = output.getLinearSize();
                boolean $i$f$accept = false;
                void $this$isCompatibleBySize$iv$iv22 = $this$accept$iv;
                boolean $i$f$isCompatibleBySize = false;
                boolean $this$isCompatibleBySize$iv$iv22 = $this$isCompatibleBySize$iv$iv22.getArray().getSize() - $this$isCompatibleBySize$iv$iv22.getLinearIndex() >= count$iv && other$iv.getArray().getSize() - other$iv.getLinearIndex() >= count$iv;
                $i$f$isCompatibleBySize = false;
                boolean bl = false;
                if (!$this$isCompatibleBySize$iv$iv22) {
                    boolean bl2 = false;
                    String string = "Pointers not compatible by available elements";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                void $this$isCompatibleWith$iv$iv = $this$accept$iv;
                boolean $i$f$isCompatibleWith = false;
                if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == other$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == other$iv.getArray().getBlockSize()) {
                    int dstOffset$iv;
                    for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                        int n;
                        dstBlock$iv = $this$accept$iv.getCurrentBlock();
                        dstOffset$iv = $this$accept$iv.getIndexInBlock();
                        void this_$iv$iv = $this$accept$iv;
                        boolean $i$f$blockIncrement = false;
                        if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                            void v3 = this_$iv$iv;
                            int n2 = v3.getBlockNum();
                            v3.setBlockNum(n2 + 1);
                            this_$iv$iv.setIndexInBlock(0);
                            this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                        }
                        byte[] srcBlock$iv = other$iv.getCurrentBlock();
                        void this_$iv$iv22 = other$iv;
                        int $i$f$blockIncrement2 = 0;
                        if (this_$iv$iv22.getBlockNum() < this_$iv$iv22.getArray().getBlocksNum() - 1) {
                            void v4 = this_$iv$iv22;
                            n = v4.getBlockNum();
                            v4.setBlockNum(n + 1);
                            this_$iv$iv22.setIndexInBlock(0);
                            this_$iv$iv22.setCurrentBlock(this_$iv$iv22.getArray().getBlocks()[this_$iv$iv22.getBlockNum()]);
                        } else {
                            this_$iv$iv22.setIndexInBlock(this_$iv$iv22.getArray().getBlockSize());
                        }
                        int this_$iv$iv22 = dstOffset$iv;
                        n = dstBlock$iv.length;
                        int n3 = dstOffset$iv + end$iv;
                        boolean bl3 = false;
                        $i$f$blockIncrement2 = Math.min(n, n3);
                        while (this_$iv$iv22 < $i$f$blockIncrement2) {
                            void src2;
                            float f;
                            void index$iv;
                            byte by = srcBlock$iv[index$iv];
                            float f2 = dstBlock$iv[index$iv];
                            void var48_109 = index$iv++;
                            float[] fArray = dstBlock$iv;
                            boolean bl4 = false;
                            fArray[var48_109] = f = ((float)src2 - zero) * sc;
                        }
                    }
                } else {
                    while (end$iv > 0) {
                        void src;
                        byte src2;
                        dstBlock$iv = $this$accept$iv;
                        void this_$iv$iv = $this$accept$iv;
                        boolean $i$f$get = false;
                        float $noName_0 = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                        this_$iv$iv = other$iv;
                        boolean $i$f$getAndIncrement = false;
                        byte value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                        void this_$iv$iv$iv3 = this_$iv$iv;
                        boolean $i$f$increment = false;
                        if (this_$iv$iv$iv3.getIndexInBlock() < this_$iv$iv$iv3.getArray().getBlockSize() - 1) {
                            void v5 = this_$iv$iv$iv3;
                            int n = v5.getIndexInBlock();
                            v5.setIndexInBlock(n + 1);
                        } else {
                            void this_$iv$iv$iv$iv = this_$iv$iv$iv3;
                            boolean $i$f$blockIncrement4 = false;
                            if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                void v6 = this_$iv$iv$iv$iv;
                                int n = v6.getBlockNum();
                                v6.setBlockNum(n + 1);
                                this_$iv$iv$iv$iv.setIndexInBlock(0);
                                this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                            } else {
                                this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                            }
                        }
                        byte by = src2 = value$iv$iv;
                        float $noName_02 = $noName_0;
                        boolean bl5 = false;
                        float value$iv$iv2 = ((float)src - zero) * sc;
                        int $i$f$set = 0;
                        this_$iv$iv2.getCurrentBlock()[this_$iv$iv2.getIndexInBlock()] = value$iv$iv2;
                        void this_$iv$iv2 = $this$accept$iv;
                        boolean $i$f$increment22 = false;
                        if (this_$iv$iv2.getIndexInBlock() < this_$iv$iv2.getArray().getBlockSize() - 1) {
                            void v7 = this_$iv$iv2;
                            $i$f$set = v7.getIndexInBlock();
                            v7.setIndexInBlock($i$f$set + 1);
                        } else {
                            void this_$iv$iv$iv2 = this_$iv$iv2;
                            boolean $i$f$blockIncrement = false;
                            if (this_$iv$iv$iv2.getBlockNum() < this_$iv$iv$iv2.getArray().getBlocksNum() - 1) {
                                void v8 = this_$iv$iv$iv2;
                                int this_$iv$iv$iv3 = v8.getBlockNum();
                                v8.setBlockNum(this_$iv$iv$iv3 + 1);
                                this_$iv$iv$iv2.setIndexInBlock(0);
                                this_$iv$iv$iv2.setCurrentBlock(this_$iv$iv$iv2.getArray().getBlocks()[this_$iv$iv$iv2.getBlockNum()]);
                            } else {
                                this_$iv$iv$iv2.setIndexInBlock(this_$iv$iv$iv2.getArray().getBlockSize());
                            }
                        }
                        --end$iv;
                    }
                }
            } else {
                int end$iv;
                Object dstBlock$iv;
                FloatPointer $this$accept$iv = FloatTiledArray.pointer$default(output.getArray(), 0, 1, null);
                ShortPointer shortPointer = ShortTiledArray.pointer$default(this.array, 0, 1, null);
                if (shortPointer == null) {
                    throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.pointers.UBytePointer");
                }
                UBytePointer other$iv = (UBytePointer)((Object)shortPointer);
                int count$iv = output.getLinearSize();
                boolean $i$f$accept = false;
                FloatPointer $this$isCompatibleBySize$iv$iv32 = $this$accept$iv;
                boolean $i$f$isCompatibleBySize = false;
                boolean $this$isCompatibleBySize$iv$iv32 = $this$isCompatibleBySize$iv$iv32.getArray().getSize() - $this$isCompatibleBySize$iv$iv32.getLinearIndex() >= count$iv && other$iv.getArray().getSize() - other$iv.getLinearIndex() >= count$iv;
                $i$f$isCompatibleBySize = false;
                boolean $i$f$increment22 = false;
                if (!$this$isCompatibleBySize$iv$iv32) {
                    boolean bl = false;
                    String $i$f$increment22 = "Pointers not compatible by available elements";
                    throw (Throwable)new IllegalArgumentException($i$f$increment22.toString());
                }
                FloatPointer $this$isCompatibleWith$iv$iv = $this$accept$iv;
                boolean $i$f$isCompatibleWith = false;
                if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == other$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == other$iv.getArray().getBlockSize()) {
                    int dstOffset$iv;
                    for (end$iv = count$iv; end$iv > 0; end$iv -= ((Object)dstBlock$iv).length - dstOffset$iv) {
                        int $i$f$increment;
                        dstBlock$iv = $this$accept$iv.getCurrentBlock();
                        dstOffset$iv = $this$accept$iv.getIndexInBlock();
                        FloatPointer this_$iv$iv = $this$accept$iv;
                        boolean $i$f$blockIncrement = false;
                        if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                            FloatPointer floatPointer = this_$iv$iv;
                            int this_$iv$iv$iv3 = floatPointer.getBlockNum();
                            floatPointer.setBlockNum(this_$iv$iv$iv3 + 1);
                            this_$iv$iv.setIndexInBlock(0);
                            this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                        }
                        byte[] srcBlock$iv = other$iv.getCurrentBlock();
                        UBytePointer this_$iv$iv32 = other$iv;
                        int $i$f$blockIncrement3 = 0;
                        if (this_$iv$iv32.getBlockNum() < this_$iv$iv32.getArray().getBlocksNum() - 1) {
                            UBytePointer uBytePointer = this_$iv$iv32;
                            $i$f$increment = uBytePointer.getBlockNum();
                            uBytePointer.setBlockNum($i$f$increment + 1);
                            this_$iv$iv32.setIndexInBlock(0);
                            this_$iv$iv32.setCurrentBlock-GBYM_sE(this_$iv$iv32.getArray().getBlocks()[this_$iv$iv32.getBlockNum()].unbox-impl());
                        } else {
                            this_$iv$iv32.setIndexInBlock(this_$iv$iv32.getArray().getBlockSize());
                        }
                        int this_$iv$iv32 = dstOffset$iv;
                        $i$f$increment = ((Object)dstBlock$iv).length;
                        int this_$iv$iv$iv$iv = dstOffset$iv + end$iv;
                        boolean $i$f$blockIncrement4 = false;
                        $i$f$blockIncrement3 = Math.min($i$f$increment, this_$iv$iv$iv$iv);
                        while (this_$iv$iv32 < $i$f$blockIncrement3) {
                            void index$iv;
                            byte src2 = UByteArray.get-impl((byte[])srcBlock$iv, (int)index$iv);
                            Object $noName_0 = dstBlock$iv[index$iv];
                            void var48_110 = index$iv++;
                            Object object = dstBlock$iv;
                            boolean bl = false;
                            byte by = src2;
                            boolean src = false;
                            byte bl5 = by;
                            boolean bl6 = false;
                            float f = ((float)(bl5 & 0xFF) - zero) * sc;
                            object[var48_110] = f;
                        }
                    }
                } else {
                    while (end$iv > 0) {
                        void src5;
                        byte src3;
                        dstBlock$iv = $this$accept$iv;
                        Object this_$iv$iv = $this$accept$iv;
                        boolean $i$f$get = false;
                        float $noName_0 = ((FloatPointer)this_$iv$iv).getCurrentBlock()[((FloatPointer)this_$iv$iv).getIndexInBlock()];
                        this_$iv$iv = other$iv;
                        boolean $i$f$getAndIncrement = false;
                        byte value$iv$iv = UByteArray.get-impl((byte[])((UBytePointer)this_$iv$iv).getCurrentBlock(), (int)((UBytePointer)this_$iv$iv).getIndexInBlock());
                        Object this_$iv$iv$iv5 = this_$iv$iv;
                        boolean $i$f$increment = false;
                        if (((UBytePointer)this_$iv$iv$iv5).getIndexInBlock() < ((UBytePointer)this_$iv$iv$iv5).getArray().getBlockSize() - 1) {
                            Object object = this_$iv$iv$iv5;
                            int this_$iv$iv$iv$iv = ((UBytePointer)object).getIndexInBlock();
                            ((UBytePointer)object).setIndexInBlock(this_$iv$iv$iv$iv + 1);
                        } else {
                            Object this_$iv$iv$iv$iv = this_$iv$iv$iv5;
                            boolean $i$f$blockIncrement = false;
                            if (((UBytePointer)this_$iv$iv$iv$iv).getBlockNum() < ((UBytePointer)this_$iv$iv$iv$iv).getArray().getBlocksNum() - 1) {
                                Object object = this_$iv$iv$iv$iv;
                                int n = ((UBytePointer)object).getBlockNum();
                                ((UBytePointer)object).setBlockNum(n + 1);
                                ((UBytePointer)this_$iv$iv$iv$iv).setIndexInBlock(0);
                                ((UBytePointer)this_$iv$iv$iv$iv).setCurrentBlock-GBYM_sE(((UBytePointer)this_$iv$iv$iv$iv).getArray().getBlocks()[((UBytePointer)this_$iv$iv$iv$iv).getBlockNum()].unbox-impl());
                            } else {
                                ((UBytePointer)this_$iv$iv$iv$iv).setIndexInBlock(((UBytePointer)this_$iv$iv$iv$iv).getArray().getBlockSize());
                            }
                        }
                        byte by = src3 = value$iv$iv;
                        float $noName_03 = $noName_0;
                        boolean bl = false;
                        void bl5 = src5;
                        boolean bl7 = false;
                        void var29_153 = bl5;
                        boolean bl8 = false;
                        float value$iv$iv3 = ((float)(var29_153 & 0xFF) - zero) * sc;
                        int $i$f$set = 0;
                        this_$iv$iv3.getCurrentBlock()[this_$iv$iv3.getIndexInBlock()] = value$iv$iv3;
                        FloatPointer this_$iv$iv3 = $this$accept$iv;
                        $i$f$increment22 = false;
                        if (this_$iv$iv3.getIndexInBlock() < this_$iv$iv3.getArray().getBlockSize() - 1) {
                            FloatPointer floatPointer = this_$iv$iv3;
                            $i$f$set = floatPointer.getIndexInBlock();
                            floatPointer.setIndexInBlock($i$f$set + 1);
                        } else {
                            FloatPointer this_$iv$iv$iv4 = this_$iv$iv3;
                            boolean $i$f$blockIncrement = false;
                            if (this_$iv$iv$iv4.getBlockNum() < this_$iv$iv$iv4.getArray().getBlocksNum() - 1) {
                                FloatPointer floatPointer = this_$iv$iv$iv4;
                                int this_$iv$iv$iv5 = floatPointer.getBlockNum();
                                floatPointer.setBlockNum(this_$iv$iv$iv5 + 1);
                                this_$iv$iv$iv4.setIndexInBlock(0);
                                this_$iv$iv$iv4.setCurrentBlock(this_$iv$iv$iv4.getArray().getBlocks()[this_$iv$iv$iv4.getBlockNum()]);
                            } else {
                                this_$iv$iv$iv4.setIndexInBlock(this_$iv$iv$iv4.getArray().getBlockSize());
                            }
                        }
                        --end$iv;
                    }
                }
            }
        } else {
            Integer n = axis;
            if (n == null) {
                Intrinsics.throwNpe();
            }
            if (NDArrayExtensionsKt.canDequantizePerAxis(this, n, zeroPoint, scale)) {
                int actualAxis = NDArrayExtensionsKt.indexAxis(this, axis);
                int blockCount = GatherKt.computeBlockSize$default(this, 0, actualAxis, 1, null);
                int blockSize = GatherKt.computeBlockSize$default(this, actualAxis + 1, 0, 2, null);
                int outOffset = 0;
                boolean bl = false;
                int n4 = 0;
                int n5 = blockCount;
                for (n4 = 0; n4 < n5; ++n4) {
                    int it = n4;
                    boolean bl9 = false;
                    ShortTiledArray shortTiledArray = zeros;
                    ShortPointer zeroPointer = shortTiledArray != null ? ShortTiledArray.pointer$default(shortTiledArray, 0, 1, null) : null;
                    FloatPointer scalePointer = FloatTiledArray.pointer$default(((FloatNDArray)scale).getArray(), 0, 1, null);
                    int this_$iv$iv$iv5 = 0;
                    int n6 = this.getShape()[actualAxis];
                    while (this_$iv$iv$iv5 < n6) {
                        void i;
                        boolean $i$f$increment6;
                        FloatPointer this_$iv$iv;
                        boolean src;
                        float $noName_0;
                        int n7;
                        boolean $i$f$blockIncrement;
                        int $i$f$increment3;
                        int value$iv$iv;
                        Object $noName_04;
                        float f;
                        int src4;
                        Object object;
                        void var36_173;
                        Object object2;
                        int n8;
                        void index$iv;
                        int this_$iv$iv42;
                        boolean $i$f$blockIncrement5;
                        int end$iv;
                        int dstOffset$iv;
                        Object dstBlock$iv;
                        boolean $i$f$isCompatibleWith;
                        FloatPointer $this$isCompatibleWith$iv$iv;
                        boolean $this$isCompatibleBySize$iv$iv42;
                        UBytePointer other$iv;
                        FloatPointer $this$accept$iv;
                        boolean $i$f$accept;
                        int count$iv;
                        boolean $i$f$blockIncrement62;
                        float f3;
                        if (zeroPointer != null) {
                            ShortPointer this_$iv;
                            boolean $i$f$getAndIncrement = false;
                            short value$iv = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                            ShortPointer this_$iv$iv5 = this_$iv;
                            boolean $i$f$increment4 = false;
                            if (this_$iv$iv5.getIndexInBlock() < this_$iv$iv5.getArray().getBlockSize() - 1) {
                                ShortPointer shortPointer = this_$iv$iv5;
                                int src5 = shortPointer.getIndexInBlock();
                                shortPointer.setIndexInBlock(src5 + 1);
                            } else {
                                ShortPointer this_$iv$iv$iv = this_$iv$iv5;
                                boolean $i$f$blockIncrement7 = false;
                                if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    ShortPointer shortPointer = this_$iv$iv$iv;
                                    int bl5 = shortPointer.getBlockNum();
                                    shortPointer.setBlockNum(bl5 + 1);
                                    this_$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            f3 = value$iv;
                        } else {
                            f3 = 0.0f;
                        }
                        float zero = f3;
                        FloatPointer this_$iv = scalePointer;
                        boolean $i$f$getAndIncrement2 = false;
                        float value$iv = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                        FloatPointer this_$iv$iv6 = this_$iv;
                        boolean $i$f$increment5 = false;
                        if (this_$iv$iv6.getIndexInBlock() < this_$iv$iv6.getArray().getBlockSize() - 1) {
                            FloatPointer floatPointer = this_$iv$iv6;
                            int $i$f$blockIncrement7 = floatPointer.getIndexInBlock();
                            floatPointer.setIndexInBlock($i$f$blockIncrement7 + 1);
                        } else {
                            FloatPointer this_$iv$iv$iv = this_$iv$iv6;
                            $i$f$blockIncrement62 = false;
                            if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                FloatPointer floatPointer = this_$iv$iv$iv;
                                int n9 = floatPointer.getBlockNum();
                                floatPointer.setBlockNum(n9 + 1);
                                this_$iv$iv$iv.setIndexInBlock(0);
                                this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                            } else {
                                this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                            }
                        }
                        float sc = value$iv;
                        if (this.getType() == DataType.BYTE) {
                            this_$iv = output.getArray().pointer(outOffset);
                            ShortPointer shortPointer = this.array.pointer(outOffset);
                            if (shortPointer == null) {
                                throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.pointers.BytePointer");
                            }
                            BytePointer $i$f$getAndIncrement2 = (BytePointer)((Object)shortPointer);
                            count$iv = blockSize;
                            $i$f$accept = false;
                            FloatPointer $this$isCompatibleBySize$iv$iv42 = $this$accept$iv;
                            boolean $i$f$isCompatibleBySize = false;
                            $this$isCompatibleBySize$iv$iv42 = $this$isCompatibleBySize$iv$iv42.getArray().getSize() - $this$isCompatibleBySize$iv$iv42.getLinearIndex() >= count$iv && ((BytePointer)((Object)other$iv)).getArray().getSize() - ((BytePointer)((Object)other$iv)).getLinearIndex() >= count$iv;
                            $i$f$isCompatibleBySize = false;
                            $i$f$blockIncrement62 = false;
                            if (!$this$isCompatibleBySize$iv$iv42) {
                                boolean bl10 = false;
                                String $i$f$blockIncrement62 = "Pointers not compatible by available elements";
                                throw (Throwable)new IllegalArgumentException($i$f$blockIncrement62.toString());
                            }
                            $this$isCompatibleWith$iv$iv = $this$accept$iv;
                            $i$f$isCompatibleWith = false;
                            if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == ((BytePointer)((Object)other$iv)).getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == ((BytePointer)((Object)other$iv)).getArray().getBlockSize()) {
                                for (end$iv = count$iv; end$iv > 0; end$iv -= ((Object)dstBlock$iv).length - dstOffset$iv) {
                                    int n10;
                                    dstBlock$iv = $this$accept$iv.getCurrentBlock();
                                    dstOffset$iv = $this$accept$iv.getIndexInBlock();
                                    FloatPointer this_$iv$iv7 = $this$accept$iv;
                                    $i$f$blockIncrement5 = false;
                                    if (this_$iv$iv7.getBlockNum() < this_$iv$iv7.getArray().getBlocksNum() - 1) {
                                        FloatPointer floatPointer = this_$iv$iv7;
                                        int n11 = floatPointer.getBlockNum();
                                        floatPointer.setBlockNum(n11 + 1);
                                        this_$iv$iv7.setIndexInBlock(0);
                                        this_$iv$iv7.setCurrentBlock(this_$iv$iv7.getArray().getBlocks()[this_$iv$iv7.getBlockNum()]);
                                    } else {
                                        this_$iv$iv7.setIndexInBlock(this_$iv$iv7.getArray().getBlockSize());
                                    }
                                    byte[] srcBlock$iv = ((BytePointer)((Object)other$iv)).getCurrentBlock();
                                    UBytePointer this_$iv$iv42 = other$iv;
                                    int $i$f$blockIncrement8 = 0;
                                    if (((BytePointer)((Object)this_$iv$iv42)).getBlockNum() < ((BytePointer)((Object)this_$iv$iv42)).getArray().getBlocksNum() - 1) {
                                        UBytePointer uBytePointer = this_$iv$iv42;
                                        n10 = ((BytePointer)((Object)uBytePointer)).getBlockNum();
                                        ((BytePointer)((Object)uBytePointer)).setBlockNum(n10 + 1);
                                        ((BytePointer)((Object)this_$iv$iv42)).setIndexInBlock(0);
                                        ((BytePointer)((Object)this_$iv$iv42)).setCurrentBlock(((BytePointer)((Object)this_$iv$iv42)).getArray().getBlocks()[((BytePointer)((Object)this_$iv$iv42)).getBlockNum()]);
                                    } else {
                                        ((BytePointer)((Object)this_$iv$iv42)).setIndexInBlock(((BytePointer)((Object)this_$iv$iv42)).getArray().getBlockSize());
                                    }
                                    this_$iv$iv42 = dstOffset$iv;
                                    n10 = ((Object)dstBlock$iv).length;
                                    int n12 = dstOffset$iv + end$iv;
                                    boolean bl11 = false;
                                    $i$f$blockIncrement8 = Math.min(n10, n12);
                                    while (this_$iv$iv42 < $i$f$blockIncrement8) {
                                        n8 = srcBlock$iv[index$iv];
                                        object2 = dstBlock$iv[index$iv];
                                        var36_173 = index$iv++;
                                        object = dstBlock$iv;
                                        boolean bl12 = false;
                                        f = ((float)src4 - zero) * sc;
                                        object[var36_173] = f;
                                    }
                                }
                            } else {
                                while (end$iv > 0) {
                                    dstBlock$iv = $this$accept$iv;
                                    Object this_$iv$iv8 = $this$accept$iv;
                                    boolean $i$f$get = false;
                                    $noName_04 = ((FloatPointer)this_$iv$iv8).getCurrentBlock()[((FloatPointer)this_$iv$iv8).getIndexInBlock()];
                                    this_$iv$iv8 = other$iv;
                                    boolean $i$f$getAndIncrement3 = false;
                                    value$iv$iv = ((BytePointer)this_$iv$iv8).getCurrentBlock()[((BytePointer)this_$iv$iv8).getIndexInBlock()];
                                    Object this_$iv$iv$iv7 = this_$iv$iv8;
                                    $i$f$increment3 = 0;
                                    if (((BytePointer)this_$iv$iv$iv7).getIndexInBlock() < ((BytePointer)this_$iv$iv$iv7).getArray().getBlockSize() - 1) {
                                        Object object3 = this_$iv$iv$iv7;
                                        int n13 = ((BytePointer)object3).getIndexInBlock();
                                        ((BytePointer)object3).setIndexInBlock(n13 + 1);
                                    } else {
                                        Object this_$iv$iv$iv$iv = this_$iv$iv$iv7;
                                        $i$f$blockIncrement = false;
                                        if (((BytePointer)this_$iv$iv$iv$iv).getBlockNum() < ((BytePointer)this_$iv$iv$iv$iv).getArray().getBlocksNum() - 1) {
                                            Object object4 = this_$iv$iv$iv$iv;
                                            n7 = ((BytePointer)object4).getBlockNum();
                                            ((BytePointer)object4).setBlockNum(n7 + 1);
                                            ((BytePointer)this_$iv$iv$iv$iv).setIndexInBlock(0);
                                            ((BytePointer)this_$iv$iv$iv$iv).setCurrentBlock(((BytePointer)this_$iv$iv$iv$iv).getArray().getBlocks()[((BytePointer)this_$iv$iv$iv$iv).getBlockNum()]);
                                        } else {
                                            ((BytePointer)this_$iv$iv$iv$iv).setIndexInBlock(((BytePointer)this_$iv$iv$iv$iv).getArray().getBlockSize());
                                        }
                                    }
                                    int n14 = src4 = value$iv$iv;
                                    $noName_0 = $noName_04;
                                    boolean bl13 = false;
                                    float value$iv$iv4 = ((float)src - zero) * sc;
                                    int $i$f$set = 0;
                                    this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()] = value$iv$iv4;
                                    this_$iv$iv = $this$accept$iv;
                                    $i$f$increment6 = false;
                                    if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                                        FloatPointer floatPointer = this_$iv$iv;
                                        $i$f$set = floatPointer.getIndexInBlock();
                                        floatPointer.setIndexInBlock($i$f$set + 1);
                                    } else {
                                        FloatPointer this_$iv$iv$iv6 = this_$iv$iv;
                                        $i$f$blockIncrement5 = false;
                                        if (this_$iv$iv$iv6.getBlockNum() < this_$iv$iv$iv6.getArray().getBlocksNum() - 1) {
                                            FloatPointer floatPointer = this_$iv$iv$iv6;
                                            int this_$iv$iv$iv7 = floatPointer.getBlockNum();
                                            floatPointer.setBlockNum(this_$iv$iv$iv7 + 1);
                                            this_$iv$iv$iv6.setIndexInBlock(0);
                                            this_$iv$iv$iv6.setCurrentBlock(this_$iv$iv$iv6.getArray().getBlocks()[this_$iv$iv$iv6.getBlockNum()]);
                                        } else {
                                            this_$iv$iv$iv6.setIndexInBlock(this_$iv$iv$iv6.getArray().getBlockSize());
                                        }
                                    }
                                    --end$iv;
                                }
                            }
                        } else {
                            boolean bl14;
                            int n15;
                            $this$accept$iv = output.getArray().pointer(outOffset);
                            ShortPointer shortPointer = this.array.pointer(outOffset);
                            if (shortPointer == null) {
                                throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.pointers.UBytePointer");
                            }
                            other$iv = (UBytePointer)((Object)shortPointer);
                            count$iv = blockSize;
                            $i$f$accept = false;
                            FloatPointer $this$isCompatibleBySize$iv$iv = $this$accept$iv;
                            boolean $i$f$isCompatibleBySize = false;
                            $this$isCompatibleBySize$iv$iv42 = $this$isCompatibleBySize$iv$iv.getArray().getSize() - $this$isCompatibleBySize$iv$iv.getLinearIndex() >= count$iv && other$iv.getArray().getSize() - other$iv.getLinearIndex() >= count$iv;
                            $i$f$isCompatibleBySize = false;
                            $i$f$increment6 = false;
                            if (!$this$isCompatibleBySize$iv$iv42) {
                                boolean bl15 = false;
                                String $i$f$increment6 = "Pointers not compatible by available elements";
                                throw (Throwable)new IllegalArgumentException($i$f$increment6.toString());
                            }
                            $this$isCompatibleWith$iv$iv = $this$accept$iv;
                            $i$f$isCompatibleWith = false;
                            if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == other$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == other$iv.getArray().getBlockSize()) {
                                for (end$iv = count$iv; end$iv > 0; end$iv -= ((Object)dstBlock$iv).length - dstOffset$iv) {
                                    dstBlock$iv = $this$accept$iv.getCurrentBlock();
                                    dstOffset$iv = $this$accept$iv.getIndexInBlock();
                                    FloatPointer this_$iv$iv9 = $this$accept$iv;
                                    $i$f$blockIncrement5 = false;
                                    if (this_$iv$iv9.getBlockNum() < this_$iv$iv9.getArray().getBlocksNum() - 1) {
                                        FloatPointer floatPointer = this_$iv$iv9;
                                        int this_$iv$iv$iv7 = floatPointer.getBlockNum();
                                        floatPointer.setBlockNum(this_$iv$iv$iv7 + 1);
                                        this_$iv$iv9.setIndexInBlock(0);
                                        this_$iv$iv9.setCurrentBlock(this_$iv$iv9.getArray().getBlocks()[this_$iv$iv9.getBlockNum()]);
                                    } else {
                                        this_$iv$iv9.setIndexInBlock(this_$iv$iv9.getArray().getBlockSize());
                                    }
                                    byte[] srcBlock$iv = other$iv.getCurrentBlock();
                                    UBytePointer this_$iv$iv10 = other$iv;
                                    int $i$f$blockIncrement9 = 0;
                                    if (this_$iv$iv10.getBlockNum() < this_$iv$iv10.getArray().getBlocksNum() - 1) {
                                        UBytePointer uBytePointer = this_$iv$iv10;
                                        $i$f$increment3 = uBytePointer.getBlockNum();
                                        uBytePointer.setBlockNum($i$f$increment3 + 1);
                                        this_$iv$iv10.setIndexInBlock(0);
                                        this_$iv$iv10.setCurrentBlock-GBYM_sE(this_$iv$iv10.getArray().getBlocks()[this_$iv$iv10.getBlockNum()].unbox-impl());
                                    } else {
                                        this_$iv$iv10.setIndexInBlock(this_$iv$iv10.getArray().getBlockSize());
                                    }
                                    this_$iv$iv42 = dstOffset$iv;
                                    $i$f$increment3 = ((Object)dstBlock$iv).length;
                                    int this_$iv$iv$iv$iv = dstOffset$iv + end$iv;
                                    $i$f$blockIncrement = false;
                                    $i$f$blockIncrement9 = Math.min($i$f$increment3, this_$iv$iv$iv$iv);
                                    while (this_$iv$iv42 < $i$f$blockIncrement9) {
                                        src4 = UByteArray.get-impl((byte[])srcBlock$iv, (int)index$iv);
                                        $noName_04 = dstBlock$iv[index$iv];
                                        var36_173 = index$iv++;
                                        object = dstBlock$iv;
                                        boolean bl16 = false;
                                        n7 = src4;
                                        src = false;
                                        n15 = n7;
                                        bl14 = false;
                                        f = ((float)(n15 & 0xFF) - zero) * sc;
                                        object[var36_173] = f;
                                    }
                                }
                            } else {
                                while (end$iv > 0) {
                                    void src6;
                                    dstBlock$iv = $this$accept$iv;
                                    Object this_$iv$iv11 = $this$accept$iv;
                                    boolean $i$f$get = false;
                                    object2 = ((FloatPointer)this_$iv$iv11).getCurrentBlock()[((FloatPointer)this_$iv$iv11).getIndexInBlock()];
                                    this_$iv$iv11 = other$iv;
                                    boolean $i$f$getAndIncrement4 = false;
                                    value$iv$iv = UByteArray.get-impl((byte[])((UBytePointer)this_$iv$iv11).getCurrentBlock(), (int)((UBytePointer)this_$iv$iv11).getIndexInBlock());
                                    Object this_$iv$iv$iv = this_$iv$iv11;
                                    $i$f$increment3 = 0;
                                    if (((UBytePointer)this_$iv$iv$iv).getIndexInBlock() < ((UBytePointer)this_$iv$iv$iv).getArray().getBlockSize() - 1) {
                                        Object object5 = this_$iv$iv$iv;
                                        int this_$iv$iv$iv$iv = ((UBytePointer)object5).getIndexInBlock();
                                        ((UBytePointer)object5).setIndexInBlock(this_$iv$iv$iv$iv + 1);
                                    } else {
                                        Object this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                        $i$f$blockIncrement = false;
                                        if (((UBytePointer)this_$iv$iv$iv$iv).getBlockNum() < ((UBytePointer)this_$iv$iv$iv$iv).getArray().getBlocksNum() - 1) {
                                            Object object6 = this_$iv$iv$iv$iv;
                                            int n16 = ((UBytePointer)object6).getBlockNum();
                                            ((UBytePointer)object6).setBlockNum(n16 + 1);
                                            ((UBytePointer)this_$iv$iv$iv$iv).setIndexInBlock(0);
                                            ((UBytePointer)this_$iv$iv$iv$iv).setCurrentBlock-GBYM_sE(((UBytePointer)this_$iv$iv$iv$iv).getArray().getBlocks()[((UBytePointer)this_$iv$iv$iv$iv).getBlockNum()].unbox-impl());
                                        } else {
                                            ((UBytePointer)this_$iv$iv$iv$iv).setIndexInBlock(((UBytePointer)this_$iv$iv$iv$iv).getArray().getBlockSize());
                                        }
                                    }
                                    n7 = n8 = value$iv$iv;
                                    $noName_0 = object2;
                                    boolean bl17 = false;
                                    n15 = src6;
                                    bl14 = false;
                                    void var45_184 = n15;
                                    boolean bl18 = false;
                                    float value$iv$iv5 = ((float)(var45_184 & 0xFF) - zero) * sc;
                                    int $i$f$set = 0;
                                    this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()] = value$iv$iv5;
                                    this_$iv$iv = $this$accept$iv;
                                    $i$f$increment6 = false;
                                    if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                                        FloatPointer floatPointer = this_$iv$iv;
                                        $i$f$set = floatPointer.getIndexInBlock();
                                        floatPointer.setIndexInBlock($i$f$set + 1);
                                    } else {
                                        FloatPointer this_$iv$iv$iv8 = this_$iv$iv;
                                        $i$f$blockIncrement5 = false;
                                        if (this_$iv$iv$iv8.getBlockNum() < this_$iv$iv$iv8.getArray().getBlocksNum() - 1) {
                                            FloatPointer floatPointer = this_$iv$iv$iv8;
                                            int n17 = floatPointer.getBlockNum();
                                            floatPointer.setBlockNum(n17 + 1);
                                            this_$iv$iv$iv8.setIndexInBlock(0);
                                            this_$iv$iv$iv8.setCurrentBlock(this_$iv$iv$iv8.getArray().getBlocks()[this_$iv$iv$iv8.getBlockNum()]);
                                        } else {
                                            this_$iv$iv$iv8.setIndexInBlock(this_$iv$iv$iv8.getArray().getBlockSize());
                                        }
                                    }
                                    --end$iv;
                                }
                            }
                        }
                        outOffset += blockSize;
                        ++i;
                    }
                }
            } else {
                String string = "Cannot perform dequantization. Scale and zero point tensors should be either scalars or 1D tensors containing " + this.getShape()[axis] + " elements";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNumberNDArray row(int row2) {
        int end$iv;
        short[] dstBlock$iv;
        void other$iv;
        void $this$accept$iv;
        int rowLength = this.getLinearSize() / this.getShape()[0];
        int start = row2 * rowLength;
        int[] nArray = this.getShape();
        int n = 1;
        int n2 = this.getRank();
        boolean bl = false;
        int[] dims = ArraysKt.copyOfRange((int[])nArray, (int)n, (int)n2);
        ShortTiledArray result = ShortTiledArray.Companion.invoke$default(ShortTiledArray.Companion, new Strides(dims), 0, 2, null);
        ShortPointer shortPointer = ShortTiledArray.pointer$default(result, 0, 1, null);
        ShortPointer shortPointer2 = this.array.pointer(start);
        int count$iv = result.getSize();
        boolean $i$f$accept = false;
        void $this$isCompatibleBySize$iv$iv22 = $this$accept$iv;
        boolean $i$f$isCompatibleBySize = false;
        boolean $this$isCompatibleBySize$iv$iv22 = $this$isCompatibleBySize$iv$iv22.getArray().getSize() - $this$isCompatibleBySize$iv$iv22.getLinearIndex() >= count$iv && other$iv.getArray().getSize() - other$iv.getLinearIndex() >= count$iv;
        $i$f$isCompatibleBySize = false;
        boolean bl2 = false;
        if (!$this$isCompatibleBySize$iv$iv22) {
            boolean bl3 = false;
            String string = "Pointers not compatible by available elements";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        void $this$isCompatibleWith$iv$iv = $this$accept$iv;
        boolean $i$f$isCompatibleWith = false;
        if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == other$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == other$iv.getArray().getBlockSize()) {
            int dstOffset$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                int n3;
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                void this_$iv$iv = $this$accept$iv;
                boolean $i$f$blockIncrement = false;
                if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                    void v0 = this_$iv$iv;
                    int n4 = v0.getBlockNum();
                    v0.setBlockNum(n4 + 1);
                    this_$iv$iv.setIndexInBlock(0);
                    this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                } else {
                    this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                }
                short[] srcBlock$iv = other$iv.getCurrentBlock();
                void this_$iv$iv22 = other$iv;
                int $i$f$blockIncrement2 = 0;
                if (this_$iv$iv22.getBlockNum() < this_$iv$iv22.getArray().getBlocksNum() - 1) {
                    void v1 = this_$iv$iv22;
                    n3 = v1.getBlockNum();
                    v1.setBlockNum(n3 + 1);
                    this_$iv$iv22.setIndexInBlock(0);
                    this_$iv$iv22.setCurrentBlock(this_$iv$iv22.getArray().getBlocks()[this_$iv$iv22.getBlockNum()]);
                } else {
                    this_$iv$iv22.setIndexInBlock(this_$iv$iv22.getArray().getBlockSize());
                }
                int this_$iv$iv22 = dstOffset$iv;
                n3 = dstBlock$iv.length;
                int n5 = dstOffset$iv + end$iv;
                boolean bl4 = false;
                $i$f$blockIncrement2 = Math.min(n3, n5);
                while (this_$iv$iv22 < $i$f$blockIncrement2) {
                    void src;
                    void index$iv;
                    short s = srcBlock$iv[index$iv];
                    short s2 = dstBlock$iv[index$iv];
                    void var27_44 = index$iv++;
                    short[] sArray = dstBlock$iv;
                    boolean bl5 = false;
                    void var28_45 = src;
                    sArray[var27_44] = var28_45;
                }
            }
        } else {
            while (end$iv > 0) {
                void src;
                short s;
                dstBlock$iv = $this$accept$iv;
                void this_$iv$iv = $this$accept$iv;
                boolean $i$f$get = false;
                short s3 = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                this_$iv$iv = other$iv;
                boolean $i$f$getAndIncrement = false;
                short value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$increment = false;
                if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                    void v2 = this_$iv$iv$iv;
                    int n6 = v2.getIndexInBlock();
                    v2.setIndexInBlock(n6 + 1);
                } else {
                    void this_$iv$iv$iv$iv = this_$iv$iv$iv;
                    boolean $i$f$blockIncrement = false;
                    if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                        void v3 = this_$iv$iv$iv$iv;
                        int n7 = v3.getBlockNum();
                        v3.setBlockNum(n7 + 1);
                        this_$iv$iv$iv$iv.setIndexInBlock(0);
                        this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                    } else {
                        this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                    }
                }
                short s4 = s = value$iv$iv;
                short $noName_0 = s3;
                boolean bl6 = false;
                void value$iv$iv2 = src;
                int $i$f$set = 0;
                this_$iv$iv2.getCurrentBlock()[this_$iv$iv2.getIndexInBlock()] = value$iv$iv2;
                void this_$iv$iv2 = $this$accept$iv;
                boolean $i$f$increment2 = false;
                if (this_$iv$iv2.getIndexInBlock() < this_$iv$iv2.getArray().getBlockSize() - 1) {
                    void v4 = this_$iv$iv2;
                    $i$f$set = v4.getIndexInBlock();
                    v4.setIndexInBlock($i$f$set + 1);
                } else {
                    void this_$iv$iv$iv2 = this_$iv$iv2;
                    boolean $i$f$blockIncrement = false;
                    if (this_$iv$iv$iv2.getBlockNum() < this_$iv$iv$iv2.getArray().getBlocksNum() - 1) {
                        void v5 = this_$iv$iv$iv2;
                        int n8 = v5.getBlockNum();
                        v5.setBlockNum(n8 + 1);
                        this_$iv$iv$iv2.setIndexInBlock(0);
                        this_$iv$iv$iv2.setCurrentBlock(this_$iv$iv$iv2.getArray().getBlocks()[this_$iv$iv$iv2.getBlockNum()]);
                    } else {
                        this_$iv$iv$iv2.setIndexInBlock(this_$iv$iv$iv2.getArray().getBlockSize());
                    }
                }
                --end$iv;
            }
        }
        return new MutableShortNDArray(result, new Strides(dims));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNumberNDArray slice(@NotNull int[] starts, @NotNull int[] ends, @NotNull int[] steps) {
        Intrinsics.checkParameterIsNotNull((Object)starts, (String)"starts");
        Intrinsics.checkParameterIsNotNull((Object)ends, (String)"ends");
        Intrinsics.checkParameterIsNotNull((Object)steps, (String)"steps");
        int n = this.getShape().length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            void it;
            int n3 = i;
            int n4 = i;
            int[] nArray2 = nArray;
            boolean bl = false;
            int n5 = ends[it] - starts[it];
            int n6 = 0;
            int length = Math.abs(n5);
            n6 = steps[it];
            int n7 = length;
            boolean bl2 = false;
            int n8 = Math.abs(n6);
            int rest = n7 % n8;
            n6 = steps[it];
            n7 = length;
            bl2 = false;
            n8 = Math.abs(n6);
            nArray2[n4] = n2 = n7 / n8 + (rest != 0 ? 1 : 0);
        }
        int[] newShape = nArray;
        Strides newStrides = new Strides(newShape);
        ShortTiledArray newArray = ShortTiledArray.Companion.invoke$default(ShortTiledArray.Companion, newStrides, 0, 2, null);
        if (newArray.getSize() > 0) {
            this.slice(ShortTiledArray.pointer$default(newArray, 0, 1, null), ShortTiledArray.pointer$default(this.array, 0, 1, null), 0, 0, this.getShape(), starts, ends, steps);
        }
        return new MutableShortNDArray(newArray, newStrides);
    }

    /*
     * WARNING - void declaration
     */
    private final void slice(ShortPointer dst, ShortPointer src, int offset, int axis, int[] shape, int[] starts, int[] ends, int[] steps) {
        IntProgression range;
        int start = starts[axis];
        int end = ends[axis];
        int step = steps[axis];
        IntProgression intProgression = range = step > 0 ? RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)start, (int)end)), (int)step) : RangesKt.step((IntProgression)RangesKt.downTo((int)start, (int)(end + 1)), (int)(-step));
        if (axis == shape.length - 1) {
            IntProgression intProgression2 = range;
            int n = intProgression2.getFirst();
            int n2 = intProgression2.getLast();
            int n3 = intProgression2.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void index;
                    src.setLinearIndex(offset + index);
                    ShortPointer shortPointer = dst;
                    ShortPointer this_$iv = src;
                    boolean $i$f$get = false;
                    short value$iv = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                    int $i$f$set = 0;
                    this_$iv2.getCurrentBlock()[this_$iv2.getIndexInBlock()] = value$iv;
                    ShortPointer this_$iv2 = dst;
                    boolean $i$f$increment = false;
                    if (this_$iv2.getIndexInBlock() < this_$iv2.getArray().getBlockSize() - 1) {
                        ShortPointer shortPointer2 = this_$iv2;
                        $i$f$set = shortPointer2.getIndexInBlock();
                        shortPointer2.setIndexInBlock($i$f$set + 1);
                    } else {
                        ShortPointer this_$iv$iv = this_$iv2;
                        boolean $i$f$blockIncrement = false;
                        if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                            ShortPointer shortPointer3 = this_$iv$iv;
                            int n6 = shortPointer3.getBlockNum();
                            shortPointer3.setBlockNum(n6 + 1);
                            this_$iv$iv.setIndexInBlock(0);
                            this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                        }
                    }
                    if (index != n2) {
                        index += n3;
                        continue;
                    }
                    break;
                }
            }
        } else {
            int ind;
            int dim = 1;
            int n = axis + 1;
            int n7 = shape.length;
            while (n < n7) {
                dim *= shape[ind];
                ++ind;
            }
            IntProgression intProgression3 = range;
            ind = intProgression3.getFirst();
            n7 = intProgression3.getLast();
            int n8 = intProgression3.getStep();
            int n9 = ind;
            int n10 = n7;
            if (n8 >= 0 ? n9 <= n10 : n9 >= n10) {
                while (true) {
                    void index;
                    this.slice(dst, src, offset + index * dim, axis + 1, shape, starts, ends, steps);
                    if (index == n7) break;
                    index += n8;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Short min() {
        short min = Short.MAX_VALUE;
        for (short[] block : this.array.getBlocks()) {
            int n = 0;
            int n2 = block.length;
            while (n < n2) {
                void idx;
                short tmp = block[idx];
                if (tmp < min) {
                    min = tmp;
                }
                ++idx;
            }
        }
        return min;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Short max() {
        short max = Short.MIN_VALUE;
        for (short[] block : this.array.getBlocks()) {
            int n = 0;
            int n2 = block.length;
            while (n < n2) {
                void idx;
                short tmp = block[idx];
                if (tmp > max) {
                    max = tmp;
                }
                ++idx;
            }
        }
        return max;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Short sum() {
        short sum = (short)0;
        for (short[] block : this.array.getBlocks()) {
            int n = 0;
            int n2 = block.length;
            while (n < n2) {
                void idx;
                sum = (short)(sum + block[idx]);
                ++idx;
            }
        }
        return sum;
    }

    @Override
    @NotNull
    public MutableNumberNDArray cumulativeSum(int axis, boolean exclusive, boolean reverse) {
        MutableShortNDArray output = new MutableShortNDArray(ShortTiledArray.Companion.invoke$default(ShortTiledArray.Companion, this.strides, 0, 2, null), this.strides);
        int actualAxis = NDArrayExtensionsKt.indexAxis(this, axis);
        int blockSize = GatherKt.computeBlockSize$default(this, actualAxis + 1, 0, 2, null);
        int batchSize = GatherKt.computeBlockSize$default(this, actualAxis, 0, 2, null);
        int numBatches = GatherKt.computeBlockSize$default(this, 0, actualAxis, 1, null);
        int numBlocks = batchSize / blockSize;
        boolean bl = false;
        int n = 0;
        int n2 = numBatches;
        for (n = 0; n < n2; ++n) {
            int thisOff;
            int currentOff;
            int j;
            int i;
            int n3;
            int n4;
            int dstOff;
            int batchIdx = n;
            boolean bl2 = false;
            int n5 = dstOff = !reverse ? batchIdx * batchSize : (numBatches - batchIdx) * batchSize - 1;
            if (!exclusive) {
                if (!reverse) {
                    output.copyFrom(dstOff, this, dstOff, dstOff + blockSize);
                } else {
                    output.copyFrom(dstOff - blockSize + 1, this, dstOff - blockSize + 1, dstOff + 1);
                }
            }
            if (!reverse) {
                int n6 = 1;
                n4 = numBlocks;
                while (n6 < n4) {
                    int n7 = 0;
                    n3 = blockSize;
                    while (n7 < n3) {
                        currentOff = dstOff + i * blockSize + j;
                        thisOff = !exclusive ? currentOff : currentOff - blockSize;
                        output.getArray().set(currentOff, (short)(output.getArray().get(currentOff - blockSize) + this.array.get(thisOff)));
                        ++j;
                    }
                    ++i;
                }
                continue;
            }
            n4 = numBlocks;
            for (i = 1; i < n4; ++i) {
                n3 = 0;
                for (j = blockSize - 1; j >= 0; --j) {
                    currentOff = dstOff - i * blockSize - j;
                    thisOff = !exclusive ? currentOff : currentOff + blockSize;
                    output.getArray().set(currentOff, (short)(output.getArray().get(currentOff + blockSize) + this.array.get(thisOff)));
                }
            }
        }
        return output;
    }

    @Override
    @NotNull
    public MutableNumberNDArray plus(@NotNull NumberNDArray other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.plus(other, new MutableShortNDArray(ShortTiledArray.Companion.invoke$default(ShortTiledArray.Companion, this.strides, 0, 2, null), this.strides));
    }

    /*
     * WARNING - void declaration
     */
    private final void plusScalar(ShortTiledArray array, short scalar2, ShortTiledArray destination) {
        int n = array.getBlocksNum() == destination.getBlocksNum() && array.getBlockSize() == destination.getBlockSize() ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = 0;
        n2 = array.getBlocksNum();
        while (n < n2) {
            void blockNum;
            short[] arrayBlock = array.getBlocks()[blockNum];
            short[] destBlock = destination.getBlocks()[blockNum];
            int n3 = 0;
            int n4 = arrayBlock.length;
            while (n3 < n4) {
                void idx;
                destBlock[idx] = (short)(arrayBlock[idx] + scalar2);
                ++idx;
            }
            ++blockNum;
        }
    }

    @Override
    @NotNull
    public MutableNumberNDArray plus(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        boolean bl = other instanceof ShortNDArray && destination instanceof MutableShortNDArray;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Operands must have the same types";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (NDArrayExtensionsKt.isScalar(this) && NDArrayExtensionsKt.isScalar(other)) {
            ((MutableShortNDArray)destination).getArray().getBlocks()[0][0] = (short)(this.array.getBlocks()[0][0] + ((ShortNDArray)other).array.getBlocks()[0][0]);
        } else if (NDArrayExtensionsKt.isScalar(this)) {
            this.plusScalar(((ShortNDArray)other).array, this.array.getBlocks()[0][0], ((MutableShortNDArray)destination).getArray());
        } else if (NDArrayExtensionsKt.isScalar(other)) {
            this.plusScalar(this.array, ((ShortNDArray)other).array.getBlocks()[0][0], ((MutableShortNDArray)destination).getArray());
        } else {
            BroadcastingKt.applyWithBroadcast((NDArray)this, (NDArray)other, destination, false, (Function3<? super NDArray, ? super NDArray, ? super MutableNDArray, Unit>)((Function3)plus.2.INSTANCE));
        }
        return destination;
    }

    @Override
    @NotNull
    public MutableNumberNDArray minus(@NotNull NumberNDArray other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.minus(other, new MutableShortNDArray(ShortTiledArray.Companion.invoke$default(ShortTiledArray.Companion, this.strides, 0, 2, null), this.strides));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNumberNDArray minus(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        boolean bl = other instanceof ShortNDArray && destination instanceof MutableShortNDArray;
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            boolean bl32 = false;
            String string = "Operands must have the same types";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (NDArrayExtensionsKt.isScalar(this) && NDArrayExtensionsKt.isScalar(other)) {
            ((MutableShortNDArray)destination).getArray().getBlocks()[0][0] = (short)(this.array.getBlocks()[0][0] - ((ShortNDArray)other).array.getBlocks()[0][0]);
        } else if (NDArrayExtensionsKt.isScalar(other)) {
            int[] nArray = this.getShape();
            int[] nArray2 = destination.getShape();
            n = 0;
            boolean bl4 = Arrays.equals(nArray, nArray2);
            int n2 = 0;
            n = 0;
            n = 0;
            boolean bl32 = false;
            if (!bl4) {
                boolean bl5 = false;
                String bl32 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(bl32.toString());
            }
            short scalar2 = ((ShortNDArray)other).array.getBlocks()[0][0];
            n2 = 0;
            n = this.array.getBlocksNum();
            while (n2 < n) {
                void blockNum;
                short[] leftBlock = this.array.getBlocks()[blockNum];
                short[] destBlock = ((MutableShortNDArray)destination).getArray().getBlocks()[blockNum];
                int n3 = 0;
                int n4 = leftBlock.length;
                while (n3 < n4) {
                    void idx;
                    destBlock[idx] = (short)(leftBlock[idx] - scalar2);
                    ++idx;
                }
                ++blockNum;
            }
        } else {
            if (NDArrayExtensionsKt.isScalar(this)) {
                String string = "Subtraction of a matrix from a scalar is prohibited";
                bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            BroadcastingKt.applyWithBroadcast((NDArray)this, (NDArray)other, destination, true, (Function3<? super NDArray, ? super NDArray, ? super MutableNDArray, Unit>)((Function3)minus.2.INSTANCE));
        }
        return destination;
    }

    @Override
    @NotNull
    public MutableNumberNDArray times(@NotNull NumberNDArray other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.times(other, new MutableShortNDArray(ShortTiledArray.Companion.invoke$default(ShortTiledArray.Companion, this.strides, 0, 2, null), this.strides));
    }

    /*
     * WARNING - void declaration
     */
    private final void timesScalar(ShortTiledArray array, short scalar2, ShortTiledArray destination) {
        int n = array.getBlocksNum() == destination.getBlocksNum() && array.getBlockSize() == destination.getBlockSize() ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = 0;
        n2 = array.getBlocksNum();
        while (n < n2) {
            void blockNum;
            short[] arrayBlock = array.getBlocks()[blockNum];
            short[] destBlock = destination.getBlocks()[blockNum];
            int n3 = 0;
            int n4 = arrayBlock.length;
            while (n3 < n4) {
                void idx;
                destBlock[idx] = (short)(arrayBlock[idx] * scalar2);
                ++idx;
            }
            ++blockNum;
        }
    }

    @Override
    @NotNull
    public MutableNumberNDArray times(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        boolean bl = other instanceof ShortNDArray && destination instanceof MutableShortNDArray;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Operands must have the same types";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (NDArrayExtensionsKt.isScalar(this) && NDArrayExtensionsKt.isScalar(other)) {
            ((MutableShortNDArray)destination).getArray().getBlocks()[0][0] = (short)(this.array.getBlocks()[0][0] * ((ShortNDArray)other).array.getBlocks()[0][0]);
        } else if (NDArrayExtensionsKt.isScalar(this)) {
            this.timesScalar(((ShortNDArray)other).array, this.array.getBlocks()[0][0], ((MutableShortNDArray)destination).getArray());
        } else if (NDArrayExtensionsKt.isScalar(other)) {
            this.timesScalar(this.array, ((ShortNDArray)other).array.getBlocks()[0][0], ((MutableShortNDArray)destination).getArray());
        } else {
            BroadcastingKt.applyWithBroadcast((NDArray)this, (NDArray)other, destination, false, (Function3<? super NDArray, ? super NDArray, ? super MutableNDArray, Unit>)((Function3)times.2.INSTANCE));
        }
        return destination;
    }

    @Override
    @NotNull
    public MutableNumberNDArray div(@NotNull NumberNDArray other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.div(other, new MutableShortNDArray(ShortTiledArray.Companion.invoke$default(ShortTiledArray.Companion, this.strides, 0, 2, null), this.strides));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNumberNDArray div(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        boolean bl = other instanceof ShortNDArray && destination instanceof MutableShortNDArray;
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            boolean bl32 = false;
            String string = "Operands must have the same types";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (NDArrayExtensionsKt.isScalar(this) && NDArrayExtensionsKt.isScalar(other)) {
            ((MutableShortNDArray)destination).getArray().getBlocks()[0][0] = (short)(this.array.getBlocks()[0][0] / ((ShortNDArray)other).array.getBlocks()[0][0]);
        } else if (NDArrayExtensionsKt.isScalar(other)) {
            int[] nArray = this.getShape();
            int[] nArray2 = destination.getShape();
            n = 0;
            boolean bl4 = Arrays.equals(nArray, nArray2);
            int n2 = 0;
            n = 0;
            n = 0;
            boolean bl32 = false;
            if (!bl4) {
                boolean bl5 = false;
                String bl32 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(bl32.toString());
            }
            short scalar2 = ((ShortNDArray)other).array.getBlocks()[0][0];
            n2 = 0;
            n = this.array.getBlocksNum();
            while (n2 < n) {
                void blockNum;
                short[] leftBlock = this.array.getBlocks()[blockNum];
                short[] destBlock = ((MutableShortNDArray)destination).getArray().getBlocks()[blockNum];
                int n3 = 0;
                int n4 = leftBlock.length;
                while (n3 < n4) {
                    void idx;
                    destBlock[idx] = (short)(leftBlock[idx] / scalar2);
                    ++idx;
                }
                ++blockNum;
            }
        } else {
            if (NDArrayExtensionsKt.isScalar(this)) {
                String string = "Division of a scalar into a matrix is prohibited";
                bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            BroadcastingKt.applyWithBroadcast((NDArray)this, (NDArray)other, destination, true, (Function3<? super NDArray, ? super NDArray, ? super MutableNDArray, Unit>)((Function3)div.2.INSTANCE));
        }
        return destination;
    }

    /*
     * WARNING - void declaration
     */
    private final short[][] resortBlocks(short[][] blocks, int colSize, int blocksInRow) {
        Object[] objectArray = (Object[])blocks;
        int n = 0;
        Object[] objectArray2 = Arrays.copyOf(objectArray, objectArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"java.util.Arrays.copyOf(this, size)");
        short[][] result = (short[][])objectArray2;
        int n2 = 0;
        n = blocksInRow;
        while (n2 < n) {
            void i;
            int n3 = 0;
            int n4 = colSize;
            while (n3 < n4) {
                void j;
                result[i * colSize + j] = blocks[j * blocksInRow + i];
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    @NotNull
    public MutableNumberNDArray dot(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        ShortNDArray cfr_ignored_0 = (ShortNDArray)other;
        MutableShortNDArray cfr_ignored_1 = (MutableShortNDArray)destination;
        boolean bl = this.getShape().length == 2 && other.getShape().length == 2;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.getShape()[1] == other.getShape()[0];
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int n = this.getShape()[0];
        int t = this.getShape()[1];
        short[][] resortedLeft = this.resortBlocks(this.array.getBlocks(), this.getShape()[0], this.getBlocksInRow());
        short[][] resortedRight = this.resortBlocks(((ShortNDArray)other).array.getBlocks(), other.getShape()[0], ((ShortNDArray)other).getBlocksInRow());
        short[][] resortedDest = this.resortBlocks(((MutableShortNDArray)destination).getArray().getBlocks(), destination.getShape()[0], ((MutableShortNDArray)destination).getBlocksInRow());
        int lBlockSize = this.array.getBlockSize();
        int rdBlockSize = ((MutableShortNDArray)destination).getArray().getBlockSize();
        int lBlockInRow = this.getBlocksInRow();
        int rBlockInRow = ((ShortNDArray)other).getBlocksInRow();
        Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit> $fun$wrapper$1 = new Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit>(rBlockInRow, t, n, resortedDest, lBlockInRow, resortedLeft, lBlockSize, resortedRight, rdBlockSize){
            final /* synthetic */ int $rBlockInRow;
            final /* synthetic */ int $t;
            final /* synthetic */ int $n;
            final /* synthetic */ short[][] $resortedDest;
            final /* synthetic */ int $lBlockInRow;
            final /* synthetic */ short[][] $resortedLeft;
            final /* synthetic */ int $lBlockSize;
            final /* synthetic */ short[][] $resortedRight;
            final /* synthetic */ int $rdBlockSize;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Function1<? super Function0<Unit>, Unit> body) {
                Intrinsics.checkParameterIsNotNull(body, (String)"body");
                int n = 0;
                int n2 = this.$rBlockInRow;
                while (n < n2) {
                    void rdCol;
                    void rightIdx = rdCol * this.$t;
                    void destIdx = rdCol * this.$n;
                    body.invoke((Object)new Function0<Unit>(this, (int)destIdx, (int)rightIdx){
                        final /* synthetic */ dot.1 this$0;
                        final /* synthetic */ int $destIdx;
                        final /* synthetic */ int $rightIdx;

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            int n = 0;
                            int n2 = this.this$0.$n;
                            while (n < n2) {
                                void i;
                                short[] destBlock = this.this$0.$resortedDest[this.$destIdx + i];
                                int n3 = 0;
                                int n4 = this.this$0.$lBlockInRow;
                                while (n3 < n4) {
                                    void lCol;
                                    short[] leftBlock = this.this$0.$resortedLeft[i + lCol * this.this$0.$n];
                                    int rightIdxOffset = this.$rightIdx + this.this$0.$lBlockSize * lCol;
                                    int n5 = 0;
                                    int n6 = this.this$0.$lBlockSize;
                                    while (n5 < n6) {
                                        void k;
                                        short temp = leftBlock[k];
                                        short[] rightBlock = this.this$0.$resortedRight[rightIdxOffset + k];
                                        int n7 = 0;
                                        int n8 = this.this$0.$rdBlockSize;
                                        while (n7 < n8) {
                                            void j;
                                            destBlock[j] = (short)(destBlock[j] + temp * rightBlock[j]);
                                            ++j;
                                        }
                                        ++k;
                                    }
                                    ++lCol;
                                }
                                ++i;
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$destIdx = n;
                            this.$rightIdx = n2;
                            super(0);
                        }
                    });
                    ++rdCol;
                }
            }

            public static /* synthetic */ void invoke$default(dot.1 var0, Function1 function1, int n, Object object) {
                if ((n & 1) != 0) {
                    function1 = dot.1.INSTANCE;
                }
                var0.invoke((Function1<? super Function0<Unit>, Unit>)function1);
            }
            {
                this.$rBlockInRow = n;
                this.$t = n2;
                this.$n = n3;
                this.$resortedDest = sArray;
                this.$lBlockInRow = n4;
                this.$resortedLeft = sArray2;
                this.$lBlockSize = n5;
                this.$resortedRight = sArray3;
                this.$rdBlockSize = n6;
                super(1);
            }
        };
        if (rBlockInRow > 1) {
            BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($fun$wrapper$1, null){
                private CoroutineScope p$;
                int label;
                final /* synthetic */ dot.1 $wrapper$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$runBlocking = this.p$;
                            this.$wrapper$1.invoke((Function1<? super Function0<Unit>, Unit>)((Function1)new Function1<Function0<? extends Unit>, Unit>($this$runBlocking){
                                final /* synthetic */ CoroutineScope $this_runBlocking;

                                public final void invoke(@NotNull Function0<Unit> it) {
                                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                                    BuildersKt.launch$default((CoroutineScope)this.$this_runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null){
                                        private CoroutineScope p$;
                                        int label;
                                        final /* synthetic */ Function0 $it;

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object $result) {
                                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    CoroutineScope $this$launch = this.p$;
                                                    this.$it.invoke();
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }
                                        {
                                            this.$it = function0;
                                            super(2, continuation);
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                            Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                            CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                            return function2;
                                        }

                                        public final Object invoke(Object object, Object object2) {
                                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                }
                                {
                                    this.$this_runBlocking = coroutineScope;
                                    super(1);
                                }
                            }));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$wrapper$1 = var1_1;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else {
            dot.1.invoke$default($fun$wrapper$1, null, 1, null);
        }
        return destination;
    }

    @Override
    @NotNull
    public MutableNumberNDArray dotTransposedWithAlpha(double alpha, @NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        ShortNDArray cfr_ignored_0 = (ShortNDArray)other;
        MutableShortNDArray cfr_ignored_1 = (MutableShortNDArray)destination;
        short alpha2 = (short)alpha;
        int dRowsNum = destination.getShape()[0];
        int dBlocksInRow = ((MutableShortNDArray)destination).getBlocksInRow();
        int lrBlocksInRow = this.getBlocksInRow();
        int dBlockSize = ((MutableShortNDArray)destination).getArray().getBlockSize();
        int lrBlockSize = this.array.getBlockSize();
        short[][] dBlocks = ((MutableShortNDArray)destination).getArray().getBlocks();
        short[][] lBlocks = this.array.getBlocks();
        short[][] rBlocks = ((ShortNDArray)other).array.getBlocks();
        Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit> $fun$wrapper$1 = new Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit>(dRowsNum, dBlocksInRow, lrBlocksInRow, dBlocks, dBlockSize, lBlocks, rBlocks, lrBlockSize, alpha2){
            final /* synthetic */ int $dRowsNum;
            final /* synthetic */ int $dBlocksInRow;
            final /* synthetic */ int $lrBlocksInRow;
            final /* synthetic */ short[][] $dBlocks;
            final /* synthetic */ int $dBlockSize;
            final /* synthetic */ short[][] $lBlocks;
            final /* synthetic */ short[][] $rBlocks;
            final /* synthetic */ int $lrBlockSize;
            final /* synthetic */ short $alpha;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Function1<? super Function0<Unit>, Unit> body) {
                Intrinsics.checkParameterIsNotNull(body, (String)"body");
                int n = 0;
                int n2 = this.$dRowsNum;
                while (n < n2) {
                    void dRow;
                    int rRow = 0;
                    void dBlockOffset = dRow * this.$dBlocksInRow;
                    void lBlockOffset = dRow * this.$lrBlocksInRow;
                    int n3 = 0;
                    int n4 = this.$dBlocksInRow;
                    while (n3 < n4) {
                        void dBlockInRow;
                        short[] dBlock = this.$dBlocks[dBlockOffset + dBlockInRow];
                        int rRowOffset = rRow;
                        body.invoke((Object)new Function0<Unit>(this, rRowOffset, (int)lBlockOffset, dBlock){
                            final /* synthetic */ dotTransposedWithAlpha.1 this$0;
                            final /* synthetic */ int $rRowOffset;
                            final /* synthetic */ int $lBlockOffset;
                            final /* synthetic */ short[] $dBlock;

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke() {
                                int rBlockOffset = this.$rRowOffset * this.this$0.$lrBlocksInRow;
                                int n = 0;
                                int n2 = this.this$0.$dBlockSize;
                                while (n < n2) {
                                    void dIdx;
                                    int n3 = 0;
                                    int n4 = this.this$0.$lrBlocksInRow;
                                    while (n3 < n4) {
                                        void lrBlockInRow;
                                        short[] lBlock = this.this$0.$lBlocks[this.$lBlockOffset + lrBlockInRow];
                                        short[] rBlock = this.this$0.$rBlocks[rBlockOffset + lrBlockInRow];
                                        int n5 = 0;
                                        int n6 = this.this$0.$lrBlockSize;
                                        while (n5 < n6) {
                                            void lrIdx;
                                            this.$dBlock[dIdx] = (short)(this.$dBlock[dIdx] + this.this$0.$alpha * lBlock[lrIdx] * rBlock[lrIdx]);
                                            ++lrIdx;
                                        }
                                        ++lrBlockInRow;
                                    }
                                    rBlockOffset += this.this$0.$lrBlocksInRow;
                                    ++dIdx;
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$rRowOffset = n;
                                this.$lBlockOffset = n2;
                                this.$dBlock = sArray;
                                super(0);
                            }
                        });
                        rRow += this.$dBlockSize;
                        ++dBlockInRow;
                    }
                    ++dRow;
                }
            }

            public static /* synthetic */ void invoke$default(dotTransposedWithAlpha.1 var0, Function1 function1, int n, Object object) {
                if ((n & 1) != 0) {
                    function1 = dotTransposedWithAlpha.1.INSTANCE;
                }
                var0.invoke((Function1<? super Function0<Unit>, Unit>)function1);
            }
            {
                this.$dRowsNum = n;
                this.$dBlocksInRow = n2;
                this.$lrBlocksInRow = n3;
                this.$dBlocks = sArray;
                this.$dBlockSize = n4;
                this.$lBlocks = sArray2;
                this.$rBlocks = sArray3;
                this.$lrBlockSize = n5;
                this.$alpha = s;
                super(1);
            }
        };
        if (((MutableShortNDArray)destination).getBlocksInRow() > 1) {
            BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($fun$wrapper$1, null){
                private CoroutineScope p$;
                int label;
                final /* synthetic */ dotTransposedWithAlpha.1 $wrapper$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$runBlocking = this.p$;
                            this.$wrapper$1.invoke((Function1<? super Function0<Unit>, Unit>)((Function1)new Function1<Function0<? extends Unit>, Unit>($this$runBlocking){
                                final /* synthetic */ CoroutineScope $this_runBlocking;

                                public final void invoke(@NotNull Function0<Unit> it) {
                                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                                    BuildersKt.launch$default((CoroutineScope)this.$this_runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null){
                                        private CoroutineScope p$;
                                        int label;
                                        final /* synthetic */ Function0 $it;

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object $result) {
                                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    CoroutineScope $this$launch = this.p$;
                                                    this.$it.invoke();
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }
                                        {
                                            this.$it = function0;
                                            super(2, continuation);
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                            Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                            CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                            return function2;
                                        }

                                        public final Object invoke(Object object, Object object2) {
                                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                }
                                {
                                    this.$this_runBlocking = coroutineScope;
                                    super(1);
                                }
                            }));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$wrapper$1 = var1_1;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else {
            dotTransposedWithAlpha.1.invoke$default($fun$wrapper$1, null, 1, null);
        }
        return destination;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNDArray gemm(int m, int n, int k, double alpha, int lda, @NotNull NDArray b, int ldb, double beta, @NotNull MutableNDArray c, int ldc, int aOffset, int bOffset, int cOffset, boolean transposeA, boolean transposeB) {
        int $i$f$blockIncrement;
        int j;
        int n2;
        boolean $i$f$set;
        short value$iv22;
        boolean $i$f$get;
        int i;
        int t;
        int it;
        short s;
        short s2;
        int n3;
        int end$iv;
        int $i$f$map;
        int i2;
        int n4;
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        ShortNDArray cfr_ignored_0 = (ShortNDArray)b;
        MutableShortNDArray cfr_ignored_1 = (MutableShortNDArray)c;
        short betaPrimitive = (short)beta;
        int alphaPrimitive = (int)alpha;
        ShortPointer aPointer = ShortTiledArray.pointer$default(this.array, 0, 1, null);
        ShortPointer bPointer = ShortTiledArray.pointer$default(((ShortNDArray)b).array, 0, 1, null);
        ShortPointer cPointer = ShortTiledArray.pointer$default(((MutableShortNDArray)c).getArray(), 0, 1, null);
        if (beta != 1.0) {
            int n5 = 0;
            n4 = m;
            while (n5 < n4) {
                int offset$iv;
                short[] block$iv;
                cPointer.setLinearIndex(i2 * ldc + cOffset);
                ShortPointer $this$map$iv = cPointer;
                $i$f$map = 0;
                for (end$iv = n; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                    block$iv = $this$map$iv.getCurrentBlock();
                    offset$iv = $this$map$iv.getIndexInBlock();
                    ShortPointer this_$iv$iv22 = $this$map$iv;
                    int $i$f$blockIncrement2 = 0;
                    if (this_$iv$iv22.getBlockNum() < this_$iv$iv22.getArray().getBlocksNum() - 1) {
                        ShortPointer shortPointer = this_$iv$iv22;
                        n3 = shortPointer.getBlockNum();
                        shortPointer.setBlockNum(n3 + 1);
                        this_$iv$iv22.setIndexInBlock(0);
                        this_$iv$iv22.setCurrentBlock(this_$iv$iv22.getArray().getBlocks()[this_$iv$iv22.getBlockNum()]);
                    } else {
                        this_$iv$iv22.setIndexInBlock(this_$iv$iv22.getArray().getBlockSize());
                    }
                    int this_$iv$iv22 = offset$iv;
                    n3 = block$iv.length;
                    int n6 = offset$iv + end$iv;
                    boolean bl = false;
                    $i$f$blockIncrement2 = Math.min(n3, n6);
                    while (this_$iv$iv22 < $i$f$blockIncrement2) {
                        void index$iv;
                        short s3 = block$iv[index$iv];
                        s2 = index$iv++;
                        short[] sArray = block$iv;
                        boolean bl2 = false;
                        sArray[s2] = s = (short)(betaPrimitive * it);
                    }
                }
                ++i2;
            }
        }
        if (transposeA && transposeB) {
            i2 = 0;
            n4 = m;
            while (i2 < n4) {
                int $this$map$iv = 0;
                $i$f$map = n;
                while ($this$map$iv < $i$f$map) {
                    void j2;
                    cPointer.setLinearIndex(t * ldc + j2 + cOffset);
                    end$iv = 0;
                    int block$iv = k;
                    while (end$iv < block$iv) {
                        ShortPointer this_$iv;
                        aPointer.setLinearIndex(i * lda + t + aOffset);
                        bPointer.setLinearIndex((int)(j2 * ldb + i + bOffset));
                        ShortPointer offset$iv = cPointer;
                        ShortPointer index$iv = aPointer;
                        int n7 = alphaPrimitive;
                        $i$f$get = false;
                        s2 = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                        this_$iv = bPointer;
                        n7 *= s2;
                        $i$f$get = false;
                        s2 = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                        this_$iv = cPointer;
                        n7 *= s2;
                        $i$f$get = false;
                        s2 = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                        value$iv22 = (short)(n7 + s2);
                        $i$f$set = false;
                        this_$iv2.getCurrentBlock()[this_$iv2.getIndexInBlock()] = value$iv22;
                        ++i;
                    }
                    ++j2;
                }
                ++t;
            }
        } else if (transposeA) {
            n4 = m;
            for (t = 0; t < n4; ++t) {
                $i$f$map = n;
                for (int j2 = 0; j2 < $i$f$map; ++j2) {
                    cPointer.setLinearIndex(t * ldc + j2 + cOffset);
                    int block$iv = k;
                    for (i = 0; i < block$iv; ++i) {
                        ShortPointer this_$iv;
                        aPointer.setLinearIndex(i * lda + t + aOffset);
                        bPointer.setLinearIndex(i * ldb + j2 + bOffset);
                        ShortPointer this_$iv2 = cPointer;
                        ShortPointer value$iv22 = aPointer;
                        int n8 = alphaPrimitive;
                        $i$f$get = false;
                        s2 = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                        this_$iv = bPointer;
                        n8 *= s2;
                        $i$f$get = false;
                        s2 = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                        this_$iv = cPointer;
                        n8 *= s2;
                        $i$f$get = false;
                        s2 = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                        value$iv22 = (short)(n8 + s2);
                        $i$f$set = false;
                        this_$iv2.getCurrentBlock()[this_$iv2.getIndexInBlock()] = value$iv22;
                    }
                }
            }
        } else if (transposeB) {
            n4 = m;
            for (t = 0; t < n4; ++t) {
                int aIdx = t * lda + aOffset;
                cPointer.setLinearIndex(t * ldc + cOffset);
                $i$f$map = 0;
                n2 = n;
                while ($i$f$map < n2) {
                    int $i$f$getAndIncrement;
                    int n9;
                    short elementInB;
                    short elementInA;
                    int n10;
                    int end$iv2;
                    aPointer.setLinearIndex(aIdx);
                    bPointer.setLinearIndex(j * ldb + bOffset);
                    ShortPointer $this$combine$iv = aPointer;
                    boolean $i$f$combine = false;
                    ShortPointer $this$isCompatibleBySize$iv$iv22 = $this$combine$iv;
                    boolean $i$f$isCompatibleBySize = false;
                    boolean $this$isCompatibleBySize$iv$iv22 = $this$isCompatibleBySize$iv$iv22.getArray().getSize() - $this$isCompatibleBySize$iv$iv22.getLinearIndex() >= k && bPointer.getArray().getSize() - bPointer.getLinearIndex() >= k;
                    $i$f$isCompatibleBySize = false;
                    n3 = 0;
                    if (!$this$isCompatibleBySize$iv$iv22) {
                        boolean bl = false;
                        String string = "Pointers not compatible by available elements";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    ShortPointer $this$isCompatibleWith$iv$iv = $this$combine$iv;
                    boolean $i$f$isCompatibleWith = false;
                    if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == bPointer.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == bPointer.getArray().getBlockSize()) {
                        int fstOffset$iv;
                        short[] fstBlock$iv;
                        for (end$iv2 = k; end$iv2 > 0; end$iv2 -= fstBlock$iv.length - fstOffset$iv) {
                            int bl2;
                            fstBlock$iv = $this$combine$iv.getCurrentBlock();
                            fstOffset$iv = $this$combine$iv.getIndexInBlock();
                            ShortPointer this_$iv$iv = $this$combine$iv;
                            boolean $i$f$blockIncrement3 = false;
                            if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                ShortPointer shortPointer = this_$iv$iv;
                                it = shortPointer.getBlockNum();
                                shortPointer.setBlockNum(it + 1);
                                this_$iv$iv.setIndexInBlock(0);
                                this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                            } else {
                                this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                            }
                            short[] sndBlock$iv = bPointer.getCurrentBlock();
                            ShortPointer this_$iv$iv32 = bPointer;
                            $i$f$blockIncrement = 0;
                            if (this_$iv$iv32.getBlockNum() < this_$iv$iv32.getArray().getBlocksNum() - 1) {
                                ShortPointer shortPointer = this_$iv$iv32;
                                bl2 = shortPointer.getBlockNum();
                                shortPointer.setBlockNum(bl2 + 1);
                                this_$iv$iv32.setIndexInBlock(0);
                                this_$iv$iv32.setCurrentBlock(this_$iv$iv32.getArray().getBlocks()[this_$iv$iv32.getBlockNum()]);
                            } else {
                                this_$iv$iv32.setIndexInBlock(this_$iv$iv32.getArray().getBlockSize());
                            }
                            int this_$iv$iv32 = fstOffset$iv;
                            bl2 = fstBlock$iv.length;
                            int n11 = fstOffset$iv + end$iv2;
                            n10 = 0;
                            $i$f$blockIncrement = Math.min(bl2, n11);
                            while (this_$iv$iv32 < $i$f$blockIncrement) {
                                void this_$iv;
                                void index$iv;
                                short s4 = sndBlock$iv[index$iv];
                                elementInA = fstBlock$iv[index$iv];
                                boolean bl = false;
                                ShortPointer shortPointer = cPointer;
                                ShortPointer shortPointer2 = cPointer;
                                int n12 = alphaPrimitive * elementInA * elementInB;
                                boolean $i$f$get2 = false;
                                n9 = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                                short value$iv = (short)(n12 + n9);
                                boolean $i$f$set2 = false;
                                this_$iv3.getCurrentBlock()[this_$iv3.getIndexInBlock()] = value$iv;
                                ++index$iv;
                            }
                        }
                    } else {
                        while (end$iv2 > 0) {
                            void this_$iv;
                            void elementInB2;
                            boolean $i$f$blockIncrement4;
                            ShortPointer this_$iv$iv = $this$combine$iv;
                            $i$f$getAndIncrement = 0;
                            short value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                            ShortPointer this_$iv$iv$iv = this_$iv$iv;
                            boolean $i$f$increment = false;
                            if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                ShortPointer shortPointer = this_$iv$iv$iv;
                                int bl2 = shortPointer.getIndexInBlock();
                                shortPointer.setIndexInBlock(bl2 + 1);
                            } else {
                                ShortPointer this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                $i$f$blockIncrement4 = false;
                                if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    ShortPointer shortPointer = this_$iv$iv$iv$iv;
                                    n10 = shortPointer.getBlockNum();
                                    shortPointer.setBlockNum(n10 + 1);
                                    this_$iv$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            elementInA = value$iv$iv;
                            this_$iv$iv = bPointer;
                            $i$f$getAndIncrement = 0;
                            value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                            this_$iv$iv$iv = this_$iv$iv;
                            $i$f$increment = false;
                            if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                ShortPointer shortPointer = this_$iv$iv$iv;
                                int this_$iv$iv$iv$iv = shortPointer.getIndexInBlock();
                                shortPointer.setIndexInBlock(this_$iv$iv$iv$iv + 1);
                            } else {
                                ShortPointer this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                $i$f$blockIncrement4 = false;
                                if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    ShortPointer shortPointer = this_$iv$iv$iv$iv;
                                    n10 = shortPointer.getBlockNum();
                                    shortPointer.setBlockNum(n10 + 1);
                                    this_$iv$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            short this_$iv3 = elementInB = value$iv$iv;
                            short elementInA2 = elementInA;
                            boolean bl = false;
                            ShortPointer shortPointer = cPointer;
                            ShortPointer $i$f$set2 = cPointer;
                            n9 = alphaPrimitive * elementInA2 * elementInB2;
                            boolean $i$f$get3 = false;
                            short s5 = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                            short value$iv = (short)(n9 + s5);
                            boolean $i$f$set3 = false;
                            this_$iv4.getCurrentBlock()[this_$iv4.getIndexInBlock()] = value$iv;
                            --end$iv2;
                        }
                    }
                    ShortPointer this_$iv = cPointer;
                    boolean $i$f$increment = false;
                    if (this_$iv.getIndexInBlock() < this_$iv.getArray().getBlockSize() - 1) {
                        ShortPointer shortPointer = this_$iv;
                        end$iv2 = shortPointer.getIndexInBlock();
                        shortPointer.setIndexInBlock(end$iv2 + 1);
                    } else {
                        ShortPointer this_$iv$iv = this_$iv;
                        boolean $i$f$blockIncrement5 = false;
                        if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                            ShortPointer shortPointer = this_$iv$iv;
                            $i$f$getAndIncrement = shortPointer.getBlockNum();
                            shortPointer.setBlockNum($i$f$getAndIncrement + 1);
                            this_$iv$iv.setIndexInBlock(0);
                            this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                        }
                    }
                    ++j;
                }
            }
        } else {
            n4 = m;
            for (t = 0; t < n4; ++t) {
                int cIdx = t * ldc + cOffset;
                aPointer.setLinearIndex(t * lda + aOffset);
                j = 0;
                n2 = k;
                while (j < n2) {
                    int end$iv3;
                    Object dstBlock$iv;
                    void i3;
                    void this_$iv;
                    ShortPointer $i$f$increment = aPointer;
                    int n13 = alphaPrimitive;
                    boolean $i$f$getAndIncrement = false;
                    short value$iv = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                    void this_$iv$iv = this_$iv;
                    boolean $i$f$increment22 = false;
                    if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                        void v9 = this_$iv$iv;
                        int this_$iv$iv$iv = v9.getIndexInBlock();
                        v9.setIndexInBlock(this_$iv$iv$iv + 1);
                    } else {
                        void this_$iv$iv$iv = this_$iv$iv;
                        $i$f$blockIncrement = 0;
                        if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                            void v10 = this_$iv$iv$iv;
                            int this_$iv$iv$iv$iv = v10.getBlockNum();
                            v10.setBlockNum(this_$iv$iv$iv$iv + 1);
                            this_$iv$iv$iv.setIndexInBlock(0);
                            this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                        }
                    }
                    s2 = value$iv;
                    short temp = (short)(n13 * s2);
                    bPointer.setLinearIndex((int)(i3 * ldb + bOffset));
                    cPointer.setLinearIndex(cIdx);
                    ShortPointer $this$accept$iv = cPointer;
                    boolean $i$f$accept = false;
                    ShortPointer $this$isCompatibleBySize$iv$iv32 = $this$accept$iv;
                    boolean $i$f$isCompatibleBySize = false;
                    boolean $this$isCompatibleBySize$iv$iv32 = $this$isCompatibleBySize$iv$iv32.getArray().getSize() - $this$isCompatibleBySize$iv$iv32.getLinearIndex() >= n && bPointer.getArray().getSize() - bPointer.getLinearIndex() >= n;
                    $i$f$isCompatibleBySize = false;
                    $i$f$increment22 = false;
                    if (!$this$isCompatibleBySize$iv$iv32) {
                        boolean bl = false;
                        String $i$f$increment22 = "Pointers not compatible by available elements";
                        throw (Throwable)new IllegalArgumentException($i$f$increment22.toString());
                    }
                    ShortPointer $this$isCompatibleWith$iv$iv = $this$accept$iv;
                    boolean $i$f$isCompatibleWith = false;
                    if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == bPointer.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == bPointer.getArray().getBlockSize()) {
                        int dstOffset$iv;
                        for (end$iv3 = n; end$iv3 > 0; end$iv3 -= ((Object)dstBlock$iv).length - dstOffset$iv) {
                            int $i$f$blockIncrement6;
                            dstBlock$iv = $this$accept$iv.getCurrentBlock();
                            dstOffset$iv = $this$accept$iv.getIndexInBlock();
                            ShortPointer this_$iv$iv2 = $this$accept$iv;
                            $i$f$blockIncrement = 0;
                            if (this_$iv$iv2.getBlockNum() < this_$iv$iv2.getArray().getBlocksNum() - 1) {
                                ShortPointer shortPointer = this_$iv$iv2;
                                int this_$iv$iv$iv$iv = shortPointer.getBlockNum();
                                shortPointer.setBlockNum(this_$iv$iv$iv$iv + 1);
                                this_$iv$iv2.setIndexInBlock(0);
                                this_$iv$iv2.setCurrentBlock(this_$iv$iv2.getArray().getBlocks()[this_$iv$iv2.getBlockNum()]);
                            } else {
                                this_$iv$iv2.setIndexInBlock(this_$iv$iv2.getArray().getBlockSize());
                            }
                            short[] srcBlock$iv = bPointer.getCurrentBlock();
                            ShortPointer this_$iv$iv42 = bPointer;
                            int $i$f$blockIncrement7 = 0;
                            if (this_$iv$iv42.getBlockNum() < this_$iv$iv42.getArray().getBlocksNum() - 1) {
                                ShortPointer shortPointer = this_$iv$iv42;
                                $i$f$blockIncrement6 = shortPointer.getBlockNum();
                                shortPointer.setBlockNum($i$f$blockIncrement6 + 1);
                                this_$iv$iv42.setIndexInBlock(0);
                                this_$iv$iv42.setCurrentBlock(this_$iv$iv42.getArray().getBlocks()[this_$iv$iv42.getBlockNum()]);
                            } else {
                                this_$iv$iv42.setIndexInBlock(this_$iv$iv42.getArray().getBlockSize());
                            }
                            int this_$iv$iv42 = dstOffset$iv;
                            $i$f$blockIncrement6 = ((Object)dstBlock$iv).length;
                            int n14 = dstOffset$iv + end$iv3;
                            boolean elementInB = false;
                            $i$f$blockIncrement7 = Math.min($i$f$blockIncrement6, n14);
                            while (this_$iv$iv42 < $i$f$blockIncrement7) {
                                void elementInC;
                                void elementInB3;
                                void index$iv;
                                short elementInA = srcBlock$iv[index$iv];
                                Object elementInA2 = dstBlock$iv[index$iv];
                                s2 = index$iv++;
                                Object object = dstBlock$iv;
                                boolean bl = false;
                                s = (short)(temp * elementInB3 + elementInC);
                                object[s2] = s;
                            }
                        }
                    } else {
                        while (end$iv3 > 0) {
                            void elementInB;
                            short s6;
                            dstBlock$iv = $this$accept$iv;
                            ShortPointer this_$iv$iv3 = $this$accept$iv;
                            boolean $i$f$get4 = false;
                            short s7 = this_$iv$iv3.getCurrentBlock()[this_$iv$iv3.getIndexInBlock()];
                            this_$iv$iv3 = bPointer;
                            boolean $i$f$getAndIncrement2 = false;
                            short value$iv$iv = this_$iv$iv3.getCurrentBlock()[this_$iv$iv3.getIndexInBlock()];
                            ShortPointer this_$iv$iv$iv = this_$iv$iv3;
                            boolean $i$f$increment3 = false;
                            if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                ShortPointer shortPointer = this_$iv$iv$iv;
                                int n15 = shortPointer.getIndexInBlock();
                                shortPointer.setIndexInBlock(n15 + 1);
                            } else {
                                ShortPointer this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                boolean $i$f$blockIncrement8 = false;
                                if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    ShortPointer shortPointer = this_$iv$iv$iv$iv;
                                    int n16 = shortPointer.getBlockNum();
                                    shortPointer.setBlockNum(n16 + 1);
                                    this_$iv$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            short this_$iv4 = s6 = value$iv$iv;
                            short elementInC = s7;
                            boolean bl = false;
                            short value$iv$iv2 = (short)(temp * elementInB + elementInC);
                            int $i$f$set4 = 0;
                            this_$iv$iv4.getCurrentBlock()[this_$iv$iv4.getIndexInBlock()] = value$iv$iv2;
                            ShortPointer this_$iv$iv4 = $this$accept$iv;
                            $i$f$increment22 = false;
                            if (this_$iv$iv4.getIndexInBlock() < this_$iv$iv4.getArray().getBlockSize() - 1) {
                                ShortPointer shortPointer = this_$iv$iv4;
                                $i$f$set4 = shortPointer.getIndexInBlock();
                                shortPointer.setIndexInBlock($i$f$set4 + 1);
                            } else {
                                ShortPointer this_$iv$iv$iv2 = this_$iv$iv4;
                                $i$f$blockIncrement = 0;
                                if (this_$iv$iv$iv2.getBlockNum() < this_$iv$iv$iv2.getArray().getBlocksNum() - 1) {
                                    ShortPointer shortPointer = this_$iv$iv$iv2;
                                    int n17 = shortPointer.getBlockNum();
                                    shortPointer.setBlockNum(n17 + 1);
                                    this_$iv$iv$iv2.setIndexInBlock(0);
                                    this_$iv$iv$iv2.setCurrentBlock(this_$iv$iv$iv2.getArray().getBlocks()[this_$iv$iv$iv2.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv2.setIndexInBlock(this_$iv$iv$iv2.getArray().getBlockSize());
                                }
                            }
                            --end$iv3;
                        }
                    }
                    ++i3;
                }
            }
        }
        return c;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NDArray[] splitHorizontalByBlocks(int parts) {
        boolean bl = this.getRank() <= 2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.getBlocksInRow() % parts == 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int blocksInRow = this.getBlocksInRow();
        int partBlocksInRow = blocksInRow / parts;
        int blocksInPart = this.getRank() == 1 ? partBlocksInRow : partBlocksInRow * this.getShape()[0];
        int[] nArray = this.getShape();
        boolean bl6 = false;
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)nArray2, (String)"java.util.Arrays.copyOf(this, size)");
        int[] partShape = nArray2;
        int n = ArraysKt.getLastIndex((int[])partShape);
        partShape[n] = partShape[n] / parts;
        Strides partStrides = new Strides(partShape);
        NDArray[] nDArrayArray = new NDArray[parts];
        for (int i = 0; i < parts; ++i) {
            void part;
            int n2 = i;
            int n3 = i;
            NDArray[] nDArrayArray2 = nDArrayArray;
            boolean bl7 = false;
            int partOffset = partBlocksInRow * part;
            int n4 = blocksInPart;
            short[][] sArrayArray = new short[n4][];
            int n5 = 0;
            while (n5 < n4) {
                void block;
                int n6 = n5;
                int n7 = n5++;
                short[][] sArrayArray2 = sArrayArray;
                boolean bl8 = false;
                void rowNum = block / partBlocksInRow;
                void colNum = block % partBlocksInRow;
                short[] sArray = this.array.getBlocks()[rowNum * blocksInRow + partOffset + colNum];
                sArrayArray2[n7] = sArray;
            }
            short[][] partBlocks = sArrayArray;
            ShortNDArray shortNDArray = new ShortNDArray(new ShortTiledArray(partBlocks), partStrides);
            nDArrayArray2[n3] = shortNDArray;
        }
        return nDArrayArray;
    }

    @Override
    @NotNull
    public MutableNDArray copyIfNotMutable() {
        return new MutableShortNDArray(this.array.copyOf(), this.strides);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ShortNDArray)) {
            return false;
        }
        if (this.getType() != ((ShortNDArray)other).getType()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.strides, (Object)((ShortNDArray)other).strides) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.array, (Object)((ShortNDArray)other).array) ^ true);
    }

    public int hashCode() {
        int result = this.array.hashCode();
        result = 31 * result + this.strides.hashCode();
        result = 31 * result + this.getType().hashCode();
        return result;
    }

    public ShortNDArray(@NotNull ShortTiledArray array, @NotNull Strides strides) {
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        this.array = array;
        this.type = DataType.SHORT;
        this.strides = strides;
    }

    public ShortNDArray(@NotNull int[] shape, int divider) {
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        this(ShortTiledArray.Companion.invoke(shape, divider), new Strides(shape));
    }

    public /* synthetic */ ShortNDArray(int[] nArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(nArray, n);
    }

    public ShortNDArray(@NotNull int[] shape, int divider, @NotNull Function1<? super Integer, Short> init) {
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        this(ShortTiledArray.Companion.invoke(shape, divider, init), new Strides(shape));
    }

    public /* synthetic */ ShortNDArray(int[] nArray, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(nArray, n, (Function1<? super Integer, Short>)function1);
    }

    public ShortNDArray(@NotNull Strides strides, int divider) {
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        this(ShortTiledArray.Companion.invoke(strides, divider), strides);
    }

    public /* synthetic */ ShortNDArray(Strides strides, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(strides, n);
    }

    public ShortNDArray(@NotNull Strides strides, int divider, @NotNull Function1<? super Integer, Short> init) {
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        this(ShortTiledArray.Companion.invoke(strides, divider, init), strides);
    }

    public /* synthetic */ ShortNDArray(Strides strides, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(strides, n, (Function1<? super Integer, Short>)function1);
    }

    @Override
    public int getLinearSize() {
        return NumberNDArray.DefaultImpls.getLinearSize(this);
    }

    @Override
    @NotNull
    public int[] getShape() {
        return NumberNDArray.DefaultImpls.getShape(this);
    }

    @Override
    public int getRank() {
        return NumberNDArray.DefaultImpls.getRank(this);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/kinference/ndarray/arrays/ShortNDArray$Companion;", "", "()V", "scalar", "Lio/kinference/ndarray/arrays/ShortNDArray;", "value", "", "ndarray"})
    public static final class Companion {
        @NotNull
        public final ShortNDArray scalar(short value) {
            return new ShortNDArray(new ShortTiledArray(1, 1, (Function1<? super Integer, Short>)((Function1)new Function1<Integer, Short>(value){
                final /* synthetic */ short $value;

                public final short invoke(int it) {
                    return this.$value;
                }
                {
                    this.$value = s;
                    super(1);
                }
            })), Strides.Companion.getEMPTY());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

