/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays;

import io.kinference.ndarray.Strides;
import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.FloatNDArray;
import io.kinference.ndarray.arrays.IntNDArray;
import io.kinference.ndarray.arrays.MutableFloatNDArray;
import io.kinference.ndarray.arrays.MutableNDArray;
import io.kinference.ndarray.arrays.MutableNumberNDArray;
import io.kinference.ndarray.arrays.MutablePrimitiveNDArray;
import io.kinference.ndarray.arrays.NDArray;
import io.kinference.ndarray.arrays.NumberNDArray;
import io.kinference.ndarray.arrays.PrimitiveMap;
import io.kinference.ndarray.arrays.PrimitiveNDArray;
import io.kinference.ndarray.arrays.PrimitiveToPrimitiveFunction;
import io.kinference.ndarray.arrays.pointers.BytePointer;
import io.kinference.ndarray.arrays.pointers.IntPointer;
import io.kinference.ndarray.arrays.pointers.PrimitivePointer;
import io.kinference.ndarray.arrays.pointers.UBytePointer;
import io.kinference.ndarray.arrays.tiled.FloatTiledArray;
import io.kinference.ndarray.arrays.tiled.IntTiledArray;
import io.kinference.ndarray.arrays.tiled.PrimitiveTiledArray;
import io.kinference.ndarray.extensions.BroadcastingKt;
import io.kinference.ndarray.extensions.GatherKt;
import io.kinference.ndarray.extensions.NDArrayExtensionsKt;
import io.kinference.primitives.types.DataType;
import io.kinference.primitives.types.PrimitiveArray;
import io.kinference.primitives.types.PrimitiveType;
import io.kinference.primitives.types.PrimitiveTypeKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.UByteArray;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 s2\u00020\u0001:\u0001sB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rB-\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000eB\u0015\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010$\u001a\u00020%H\u0016J \u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016J)\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010,2\u0006\u0010.\u001a\u00020,2\b\u0010'\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010/J\u0011\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020\u0001H\u0096\u0002J\u0018\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J\u0018\u00103\u001a\u00020#2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J \u00104\u001a\u00020#2\u0006\u00105\u001a\u0002062\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J\u0013\u00107\u001a\u00020)2\b\u00101\u001a\u0004\u0018\u000108H\u0096\u0002J\u0010\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u000208H\u0016J\u0080\u0001\u0010;\u001a\u00020%2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\u00052\u0006\u00105\u001a\u0002062\u0006\u0010?\u001a\u00020\u00052\u0006\u0010@\u001a\u00020,2\u0006\u0010A\u001a\u00020\u00052\u0006\u0010B\u001a\u0002062\u0006\u0010C\u001a\u00020%2\u0006\u0010D\u001a\u00020\u00052\u0006\u0010E\u001a\u00020\u00052\u0006\u0010F\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020)2\u0006\u0010I\u001a\u00020)H\u0016J\b\u0010J\u001a\u00020\u0005H\u0016J\u0010\u0010K\u001a\u00020#2\u0006\u0010L\u001a\u00020MH\u0016J\b\u0010N\u001a\u00020\tH\u0016J\b\u0010O\u001a\u00020\tH\u0016J\u0011\u0010P\u001a\u00020#2\u0006\u00101\u001a\u00020\u0001H\u0096\u0002J\u0018\u0010P\u001a\u00020#2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J\u0011\u0010Q\u001a\u00020#2\u0006\u00101\u001a\u00020\u0001H\u0096\u0002J\u0018\u0010Q\u001a\u00020#2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J \u0010R\u001a\u00020S2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010T\u001a\u00020\t2\u0006\u00102\u001a\u00020\u0010H\u0002J\u0010\u0010U\u001a\u00020,2\u0006\u0010V\u001a\u00020\u0003H\u0016J1\u0010W\u001a\b\u0012\u0004\u0012\u00020Y0X2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020Y0X2\u0006\u0010[\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\\J\u0010\u0010]\u001a\u00020#2\u0006\u0010]\u001a\u00020\u0005H\u0016J\b\u0010^\u001a\u00020\tH\u0016JH\u0010_\u001a\u00020S2\u0006\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020a2\u0006\u0010c\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010d\u001a\u00020\u00032\u0006\u0010e\u001a\u00020\u00032\u0006\u0010f\u001a\u00020\u0003H\u0002J \u0010_\u001a\u00020#2\u0006\u0010d\u001a\u00020\u00032\u0006\u0010e\u001a\u00020\u00032\u0006\u0010f\u001a\u00020\u0003H\u0016J\u001b\u0010g\u001a\b\u0012\u0004\u0012\u00020,0X2\u0006\u0010h\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010iJ\b\u0010j\u001a\u00020\tH\u0016J\u0011\u0010k\u001a\u00020#2\u0006\u00101\u001a\u00020\u0001H\u0096\u0002J\u0018\u0010k\u001a\u00020#2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J \u0010l\u001a\u00020S2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010T\u001a\u00020\t2\u0006\u00102\u001a\u00020\u0010H\u0002J\u0010\u0010m\u001a\u00020#2\u0006\u0010n\u001a\u00020\fH\u0016J\u0014\u0010o\u001a\u00020\u00002\n\u0010p\u001a\u00020\u0003\"\u00020\u0005H\u0016J\u0010\u0010q\u001a\u00020r2\u0006\u0010-\u001a\u00020\u0001H\u0016R$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R$\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006t"}, d2={"Lio/kinference/ndarray/arrays/PrimitiveNDArray;", "Lio/kinference/ndarray/arrays/NumberNDArray;", "shape", "", "divider", "", "([II)V", "init", "Lkotlin/Function1;", "Lio/kinference/primitives/types/PrimitiveType;", "([IILkotlin/jvm/functions/Function1;)V", "strides", "Lio/kinference/ndarray/Strides;", "(Lio/kinference/ndarray/Strides;I)V", "(Lio/kinference/ndarray/Strides;ILkotlin/jvm/functions/Function1;)V", "array", "Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray;", "(Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray;Lio/kinference/ndarray/Strides;)V", "<set-?>", "getArray", "()Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray;", "setArray", "(Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray;)V", "blocksInRow", "getBlocksInRow", "()I", "getStrides", "()Lio/kinference/ndarray/Strides;", "setStrides", "(Lio/kinference/ndarray/Strides;)V", "type", "Lio/kinference/primitives/types/DataType;", "getType", "()Lio/kinference/primitives/types/DataType;", "allocateNDArray", "Lio/kinference/ndarray/arrays/MutableNumberNDArray;", "copyIfNotMutable", "Lio/kinference/ndarray/arrays/MutableNDArray;", "cumulativeSum", "axis", "exclusive", "", "reverse", "dequantize", "Lio/kinference/ndarray/arrays/NDArray;", "zeroPoint", "scale", "(Lio/kinference/ndarray/arrays/NDArray;Lio/kinference/ndarray/arrays/NDArray;Ljava/lang/Integer;)Lio/kinference/ndarray/arrays/NDArray;", "div", "other", "destination", "dot", "dotTransposedWithAlpha", "alpha", "", "equals", "", "erfFor", "value", "gemm", "m", "n", "k", "lda", "b", "ldb", "beta", "c", "ldc", "aOffset", "bOffset", "cOffset", "transposeA", "transposeB", "hashCode", "map", "function", "Lio/kinference/ndarray/arrays/PrimitiveToPrimitiveFunction;", "max", "min", "minus", "plus", "plusScalar", "", "scalar", "reshapeView", "newShape", "resortBlocks", "", "Lio/kinference/primitives/types/PrimitiveArray;", "blocks", "colSize", "([Lio/kinference/primitives/types/PrimitiveArray;II)[Lio/kinference/primitives/types/PrimitiveArray;", "row", "singleValue", "slice", "dst", "Lio/kinference/ndarray/arrays/pointers/PrimitivePointer;", "src", "offset", "starts", "ends", "steps", "splitHorizontalByBlocks", "parts", "(I)[Lio/kinference/ndarray/arrays/NDArray;", "sum", "times", "timesScalar", "toMutable", "newStrides", "view", "axes", "withZeroPoint", "Lio/kinference/ndarray/arrays/IntNDArray;", "Companion", "ndarray"})
public class PrimitiveNDArray
implements NumberNDArray {
    @NotNull
    private PrimitiveTiledArray array;
    @NotNull
    private final DataType type;
    @NotNull
    private Strides strides;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final PrimitiveTiledArray getArray() {
        return this.array;
    }

    protected final void setArray(@NotNull PrimitiveTiledArray primitiveTiledArray) {
        Intrinsics.checkParameterIsNotNull((Object)primitiveTiledArray, (String)"<set-?>");
        this.array = primitiveTiledArray;
    }

    protected final int getBlocksInRow() {
        int n;
        if (this.strides.getLinearSize() == 0) {
            n = 0;
        } else {
            int[] nArray = this.strides.getShape();
            boolean bl = false;
            n = nArray.length == 0 ? 1 : ArraysKt.last((int[])this.strides.getShape()) / this.array.getBlockSize();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PrimitiveNDArray view(int ... axes) {
        void $this$foldIndexed$iv;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)axes, (String)"axes");
        int[] nArray = axes;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            void i;
            int axis = nArray[n3];
            boolean bl = this.getShape()[i] > axis;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            n = 0;
            if (!bl) {
                boolean bl4 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ++i;
        }
        int[] axis = axes;
        int initial$iv22 = 0;
        int $i$f$foldIndexed = 0;
        int index$iv = 0;
        int accumulator$iv = initial$iv22;
        for (void element$iv : $this$foldIndexed$iv) {
            void i;
            void acc;
            int n4 = index$iv++;
            void var12_19 = element$iv;
            int n5 = accumulator$iv;
            int index = n4;
            boolean bl = false;
            accumulator$iv = acc + i * this.strides.getStrides()[index];
        }
        int offset = accumulator$iv;
        int[] initial$iv22 = this.getShape();
        $i$f$foldIndexed = axes.length;
        index$iv = this.getShape().length;
        accumulator$iv = 0;
        int[] newShape = ArraysKt.copyOfRange((int[])initial$iv22, (int)$i$f$foldIndexed, (int)index$iv);
        Strides newStrides = new Strides(newShape);
        if (this.array.getBlockSize() == 0) {
            return new PrimitiveNDArray(this.array, newStrides);
        }
        int offsetBlocks = offset / this.array.getBlockSize();
        int countBlocks = newStrides.getLinearSize() / this.array.getBlockSize();
        Object[] objectArray = this.array.getBlocks();
        n = offsetBlocks + countBlocks;
        int n6 = 0;
        PrimitiveArray[] copyBlocks = (PrimitiveArray[])ArraysKt.copyOfRange((Object[])objectArray, (int)offsetBlocks, (int)n);
        PrimitiveTiledArray newArray = new PrimitiveTiledArray(copyBlocks);
        return new PrimitiveNDArray(newArray, newStrides);
    }

    @Override
    @NotNull
    public DataType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public final Strides getStrides() {
        return this.strides;
    }

    protected final void setStrides(@NotNull Strides strides) {
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"<set-?>");
        this.strides = strides;
    }

    @NotNull
    public PrimitiveType singleValue() {
        boolean bl = NDArrayExtensionsKt.isScalar(this) || this.array.getSize() == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "NDArray contains more than 1 value";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.array.getBlocks()[0].get(0);
    }

    @Override
    @NotNull
    public MutableNumberNDArray allocateNDArray(@NotNull Strides strides) {
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        return new MutablePrimitiveNDArray(PrimitiveTiledArray.Companion.invoke$default(PrimitiveTiledArray.Companion, strides, 0, 2, null), strides);
    }

    @Override
    @NotNull
    public NDArray reshapeView(@NotNull int[] newShape) {
        Intrinsics.checkParameterIsNotNull((Object)newShape, (String)"newShape");
        Strides newStrides = new Strides(newShape);
        boolean bl = newStrides.getLinearSize() == this.getLinearSize();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new PrimitiveNDArray(this.array, newStrides);
    }

    @Override
    @NotNull
    public MutableNumberNDArray toMutable(@NotNull Strides newStrides) {
        Intrinsics.checkParameterIsNotNull((Object)newStrides, (String)"newStrides");
        return new MutablePrimitiveNDArray(this.array.copyOf(), newStrides);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNumberNDArray map(@NotNull PrimitiveToPrimitiveFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        PrimitiveMap cfr_ignored_0 = (PrimitiveMap)function;
        MutableNumberNDArray mutableNumberNDArray = this.allocateNDArray(this.strides);
        if (mutableNumberNDArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.MutablePrimitiveNDArray");
        }
        MutablePrimitiveNDArray destination = (MutablePrimitiveNDArray)mutableNumberNDArray;
        int n = 0;
        int n2 = this.array.getBlocksNum();
        while (n < n2) {
            int n3;
            void blockNum;
            PrimitiveArray thisBlock = this.array.getBlocks()[blockNum];
            PrimitiveArray destBlock = destination.getArray().getBlocks()[blockNum];
            IntRange intRange = thisBlock.getIndices();
            int n4 = intRange.getFirst();
            if (n4 <= (n3 = intRange.getLast())) {
                while (true) {
                    void idx;
                    destBlock.set((int)idx, ((PrimitiveMap)function).apply(thisBlock.get((int)idx)));
                    if (idx == n3) break;
                    ++idx;
                }
            }
            ++blockNum;
        }
        return destination;
    }

    @NotNull
    public PrimitiveType erfFor(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        PrimitiveType cfr_ignored_0 = (PrimitiveType)value;
        double d = UtilsKt.toDouble((PrimitiveType)value);
        boolean bl = false;
        double sign = Math.signum(d);
        double d2 = UtilsKt.toDouble((PrimitiveType)value);
        boolean bl2 = false;
        double doubleValue = Math.abs(d2);
        double t = 1.0 / (1.0 + 0.3275911 * doubleValue);
        double sum = t * (UtilsKt.getERF_COEF()[0] + t * (UtilsKt.getERF_COEF()[1] + t * (UtilsKt.getERF_COEF()[2] + t * (UtilsKt.getERF_COEF()[3] + t * UtilsKt.getERF_COEF()[4]))));
        double d3 = -doubleValue * doubleValue;
        double d4 = sum;
        double d5 = 1.0;
        double d6 = sign;
        boolean bl3 = false;
        double d7 = Math.exp(d3);
        return PrimitiveTypeKt.toPrimitive((Number)(d6 * (d5 - d4 * d7)));
    }

    @Override
    @NotNull
    public IntNDArray withZeroPoint(@NotNull NumberNDArray zeroPoint) {
        IntNDArray intNDArray;
        Intrinsics.checkParameterIsNotNull((Object)zeroPoint, (String)"zeroPoint");
        PrimitiveNDArray cfr_ignored_0 = (PrimitiveNDArray)zeroPoint;
        if (zeroPoint.getLinearSize() == 1) {
            int zero = UtilsKt.toInt(((PrimitiveNDArray)zeroPoint).array.getBlocks()[0].get(0));
            IntTiledArray arr2 = IntTiledArray.Companion.invoke$default(IntTiledArray.Companion, this.strides, 0, 2, null);
            IntPointer intPointer = IntTiledArray.pointer$default(arr2, 0, 1, null);
            PrimitivePointer primitivePointer = PrimitiveTiledArray.pointer$default(this.array, 0, 1, null);
            int count$iv = arr2.getSize();
            boolean $i$f$accept = false;
            intNDArray = new IntNDArray(arr2, this.strides);
        } else {
            IntTiledArray arr = IntTiledArray.Companion.invoke$default(IntTiledArray.Companion, this.strides, 0, 2, null);
            IntPointer arr2 = IntTiledArray.pointer$default(arr, 0, 1, null);
            PrimitivePointer $this$accept$iv = PrimitiveTiledArray.pointer$default(this.array, 0, 1, null);
            PrimitivePointer src$iv = PrimitiveTiledArray.pointer$default(((PrimitiveNDArray)zeroPoint).array, 0, 1, null);
            int count$iv = arr.getSize();
            boolean $i$f$acceptWithRecursive = false;
            intNDArray = new IntNDArray(arr, this.strides);
        }
        return intNDArray;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @NotNull
    public NDArray dequantize(@Nullable NDArray zeroPoint, @NotNull NDArray scale, @Nullable Integer axis) {
        block95: {
            block96: {
                block94: {
                    Intrinsics.checkParameterIsNotNull((Object)scale, (String)"scale");
                    (FloatNDArray)scale;
                    v0 = zeroPoint;
                    if (!(v0 instanceof PrimitiveNDArray)) {
                        v0 = null;
                    }
                    v1 = (PrimitiveNDArray)v0;
                    zeros = v1 != null ? v1.array : null;
                    output = new MutableFloatNDArray(new FloatTiledArray(this.array.getSize(), this.array.getBlockSize()), this.strides);
                    if (!NDArrayExtensionsKt.canDequantizePerTensor(zeroPoint, scale)) break block94;
                    zero = zeros == null ? 0.0f : UtilsKt.toFloat(zeros.getBlocks()[0].get(0));
                    sc = ((FloatNDArray)scale).getArray().getBlocks()[0][0];
                    if (this.getType() == DataType.BYTE) {
                        var8_12 = FloatTiledArray.pointer$default(output.getArray(), 0, 1, null);
                        v2 = PrimitiveTiledArray.pointer$default(this.array, 0, 1, null);
                        if (v2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.pointers.BytePointer");
                        }
                        var9_15 = (BytePointer)v2;
                        count$iv = output.getLinearSize();
                        $i$f$accept = false;
                        $this$isCompatibleBySize$iv$iv = $this$accept$iv;
                        $i$f$isCompatibleBySize = false;
                        $this$isCompatibleBySize$iv$iv = $this$isCompatibleBySize$iv$iv.getArray().getSize() - $this$isCompatibleBySize$iv$iv.getLinearIndex() >= count$iv && other$iv.getArray().getSize() - other$iv.getLinearIndex() >= count$iv;
                        $i$f$isCompatibleBySize = false;
                        var14_34 = false;
                        if (!$this$isCompatibleBySize$iv$iv) {
                            $i$a$-require-FloatPointerKt$accept$1$iv = false;
                            var14_35 = "Pointers not compatible by available elements";
                            throw (Throwable)new IllegalArgumentException(var14_35.toString());
                        }
                        $this$isCompatibleWith$iv$iv = $this$accept$iv;
                        $i$f$isCompatibleWith = false;
                        if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == other$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == other$iv.getArray().getBlockSize()) {
                            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                                this_$iv$iv = $this$accept$iv;
                                $i$f$blockIncrement = false;
                                if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                    v3 = this_$iv$iv;
                                    var17_60 = v3.getBlockNum();
                                    v3.setBlockNum(var17_60 + 1);
                                    this_$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                }
                                srcBlock$iv = other$iv.getCurrentBlock();
                                this_$iv$iv = other$iv;
                                $i$f$blockIncrement = 0;
                                if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                    v4 = this_$iv$iv;
                                    var18_68 = v4.getBlockNum();
                                    v4.setBlockNum(var18_68 + 1);
                                    this_$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                }
                                this_$iv$iv = dstOffset$iv;
                                var18_68 = dstBlock$iv.length;
                                var19_73 = dstOffset$iv + end$iv;
                                var20_81 = false;
                                $i$f$blockIncrement = Math.min(var18_68, var19_73);
                                while (this_$iv$iv < $i$f$blockIncrement) {
                                    var21_87 = srcBlock$iv[index$iv];
                                    var22_93 = dstBlock$iv[index$iv];
                                    var48_108 = index$iv++;
                                    var47_106 = dstBlock$iv;
                                    $i$a$-accept-PrimitiveNDArray$dequantize$1 = false;
                                    var47_106[var48_108] = var49_110 = ((float)src - zero) * sc;
                                }
                            }
                        } else {
                            while (end$iv > 0) {
                                dstBlock$iv = $this$accept$iv;
                                this_$iv$iv = $this$accept$iv;
                                $i$f$get = false;
                                $noName_0 = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                                this_$iv$iv = other$iv;
                                $i$f$getAndIncrement = false;
                                value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                                this_$iv$iv$iv = this_$iv$iv;
                                $i$f$increment = false;
                                if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                    v5 = this_$iv$iv$iv;
                                    var19_74 = v5.getIndexInBlock();
                                    v5.setIndexInBlock(var19_74 + 1);
                                } else {
                                    this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                    $i$f$blockIncrement = false;
                                    if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                        v6 = this_$iv$iv$iv$iv;
                                        var24_112 = v6.getBlockNum();
                                        v6.setBlockNum(var24_112 + 1);
                                        this_$iv$iv$iv$iv.setIndexInBlock(0);
                                        this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                    } else {
                                        this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                    }
                                }
                                var25_120 = src = value$iv$iv;
                                $noName_0 = $noName_0;
                                $i$a$-accept-PrimitiveNDArray$dequantize$1 = false;
                                value$iv$iv = ((float)src - zero) * sc;
                                $i$f$set = 0;
                                this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()] = value$iv$iv;
                                this_$iv$iv = $this$accept$iv;
                                $i$f$increment = false;
                                if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                                    v7 = this_$iv$iv;
                                    $i$f$set = v7.getIndexInBlock();
                                    v7.setIndexInBlock($i$f$set + 1);
                                } else {
                                    this_$iv$iv$iv = this_$iv$iv;
                                    $i$f$blockIncrement = false;
                                    if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                        v8 = this_$iv$iv$iv;
                                        this_$iv$iv$iv = v8.getBlockNum();
                                        v8.setBlockNum(this_$iv$iv$iv + 1);
                                        this_$iv$iv$iv.setIndexInBlock(0);
                                        this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                                    } else {
                                        this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                                    }
                                }
                                --end$iv;
                            }
                        }
                    } else {
                        $this$accept$iv = FloatTiledArray.pointer$default(output.getArray(), 0, 1, null);
                        v9 = PrimitiveTiledArray.pointer$default(this.array, 0, 1, null);
                        if (v9 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.pointers.UBytePointer");
                        }
                        other$iv = (UBytePointer)v9;
                        count$iv = output.getLinearSize();
                        $i$f$accept = false;
                        $this$isCompatibleBySize$iv$iv = $this$accept$iv;
                        $i$f$isCompatibleBySize = false;
                        $this$isCompatibleBySize$iv$iv = $this$isCompatibleBySize$iv$iv.getArray().getSize() - $this$isCompatibleBySize$iv$iv.getLinearIndex() >= count$iv && other$iv.getArray().getSize() - other$iv.getLinearIndex() >= count$iv;
                        $i$f$isCompatibleBySize = false;
                        $i$f$increment = false;
                        if (!$this$isCompatibleBySize$iv$iv) {
                            $i$a$-require-FloatPointerKt$accept$5$iv = false;
                            $i$f$increment = "Pointers not compatible by available elements";
                            throw (Throwable)new IllegalArgumentException($i$f$increment.toString());
                        }
                        $this$isCompatibleWith$iv$iv = $this$accept$iv;
                        $i$f$isCompatibleWith = false;
                        if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == other$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == other$iv.getArray().getBlockSize()) {
                            for (end$iv = count$iv; end$iv > 0; end$iv -= ((Object)dstBlock$iv).length - dstOffset$iv) {
                                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                                this_$iv$iv = $this$accept$iv;
                                $i$f$blockIncrement = false;
                                if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                    v10 = this_$iv$iv;
                                    this_$iv$iv$iv = v10.getBlockNum();
                                    v10.setBlockNum(this_$iv$iv$iv + 1);
                                    this_$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                }
                                srcBlock$iv = other$iv.getCurrentBlock();
                                this_$iv$iv = other$iv;
                                $i$f$blockIncrement = 0;
                                if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                    v11 = this_$iv$iv;
                                    $i$f$increment = v11.getBlockNum();
                                    v11.setBlockNum($i$f$increment + 1);
                                    this_$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv.setCurrentBlock-GBYM_sE(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()].unbox-impl());
                                } else {
                                    this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                }
                                this_$iv$iv = dstOffset$iv;
                                $i$f$increment = ((Object)dstBlock$iv).length;
                                this_$iv$iv$iv$iv = dstOffset$iv + end$iv;
                                $i$f$blockIncrement = false;
                                $i$f$blockIncrement = Math.min($i$f$increment, this_$iv$iv$iv$iv);
                                while (this_$iv$iv < $i$f$blockIncrement) {
                                    src = UByteArray.get-impl((byte[])srcBlock$iv, (int)index$iv);
                                    $noName_0 = dstBlock$iv[index$iv];
                                    var48_109 = index$iv++;
                                    var47_107 = dstBlock$iv;
                                    $i$a$-accept-PrimitiveNDArray$dequantize$2 = false;
                                    var24_113 = src;
                                    src = false;
                                    $i$a$-accept-PrimitiveNDArray$dequantize$1 = var24_113;
                                    var27_139 = false;
                                    var49_111 = ((float)($i$a$-accept-PrimitiveNDArray$dequantize$1 & 255) - zero) * sc;
                                    var47_107[var48_109] = var49_111;
                                }
                            }
                        } else {
                            while (end$iv > 0) {
                                dstBlock$iv = $this$accept$iv;
                                this_$iv$iv = $this$accept$iv;
                                $i$f$get = false;
                                $noName_0 = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                                this_$iv$iv = other$iv;
                                $i$f$getAndIncrement = false;
                                value$iv$iv = UByteArray.get-impl((byte[])this_$iv$iv.getCurrentBlock(), (int)this_$iv$iv.getIndexInBlock());
                                this_$iv$iv$iv = this_$iv$iv;
                                $i$f$increment = false;
                                if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                    v12 = this_$iv$iv$iv;
                                    this_$iv$iv$iv$iv = v12.getIndexInBlock();
                                    v12.setIndexInBlock(this_$iv$iv$iv$iv + 1);
                                } else {
                                    this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                    $i$f$blockIncrement = false;
                                    if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                        v13 = this_$iv$iv$iv$iv;
                                        var28_142 = v13.getBlockNum();
                                        v13.setBlockNum(var28_142 + 1);
                                        this_$iv$iv$iv$iv.setIndexInBlock(0);
                                        this_$iv$iv$iv$iv.setCurrentBlock-GBYM_sE(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()].unbox-impl());
                                    } else {
                                        this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                    }
                                }
                                var24_114 = src = value$iv$iv;
                                $noName_0 = $noName_0;
                                $i$a$-accept-PrimitiveNDArray$dequantize$2 = false;
                                $i$a$-accept-PrimitiveNDArray$dequantize$1 = src;
                                var27_140 = false;
                                var29_152 = $i$a$-accept-PrimitiveNDArray$dequantize$1;
                                var30_156 = false;
                                value$iv$iv = ((float)(var29_152 & 255) - zero) * sc;
                                $i$f$set = 0;
                                this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()] = value$iv$iv;
                                this_$iv$iv = $this$accept$iv;
                                $i$f$increment = false;
                                if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                                    v14 = this_$iv$iv;
                                    $i$f$set = v14.getIndexInBlock();
                                    v14.setIndexInBlock($i$f$set + 1);
                                } else {
                                    this_$iv$iv$iv = this_$iv$iv;
                                    $i$f$blockIncrement = false;
                                    if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                        v15 = this_$iv$iv$iv;
                                        this_$iv$iv$iv = v15.getBlockNum();
                                        v15.setBlockNum(this_$iv$iv$iv + 1);
                                        this_$iv$iv$iv.setIndexInBlock(0);
                                        this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                                    } else {
                                        this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                                    }
                                }
                                --end$iv;
                            }
                        }
                    }
                    break block95;
                }
                v16 = axis;
                if (v16 == null) {
                    Intrinsics.throwNpe();
                }
                if (!NDArrayExtensionsKt.canDequantizePerAxis(this, v16, zeroPoint, scale)) break block96;
                actualAxis = NDArrayExtensionsKt.indexAxis(this, axis);
                blockCount = GatherKt.computeBlockSize$default(this, 0, actualAxis, 1, null);
                blockSize = GatherKt.computeBlockSize$default(this, actualAxis + 1, 0, 2, null);
                outOffset = 0;
                var10_20 = false;
                var11_23 = 0;
                var12_28 = blockCount;
                for (var11_23 = 0; var11_23 < var12_28; ++var11_23) {
                    it = var11_23;
                    $i$a$-repeat-PrimitiveNDArray$dequantize$3 = false;
                    v17 = zeros;
                    zeroPointer = v17 != null ? PrimitiveTiledArray.pointer$default(v17, 0, 1, null) : null;
                    scalePointer = FloatTiledArray.pointer$default(((FloatNDArray)scale).getArray(), 0, 1, null);
                    this_$iv$iv$iv = 0;
                    var18_72 = this.getShape()[actualAxis];
                    while (this_$iv$iv$iv < var18_72) {
                        v18 = zeroPointer;
                        if (v18 == null) ** GOTO lbl-1000
                        this_$iv = v18;
                        $i$f$getAndIncrement = false;
                        value$iv = this_$iv.getCurrentBlock().get(this_$iv.getIndexInBlock());
                        this_$iv$iv = this_$iv;
                        $i$f$increment = false;
                        if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                            v19 = this_$iv$iv;
                            src = v19.getIndexInBlock();
                            v19.setIndexInBlock(src + 1);
                        } else {
                            this_$iv$iv$iv = this_$iv$iv;
                            $i$f$blockIncrement = false;
                            if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                v20 = this_$iv$iv$iv;
                                $i$a$-accept-PrimitiveNDArray$dequantize$1 = v20.getBlockNum();
                                v20.setBlockNum($i$a$-accept-PrimitiveNDArray$dequantize$1 + 1);
                                this_$iv$iv$iv.setIndexInBlock(0);
                                this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                            } else {
                                this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                            }
                        }
                        if ((v18 = value$iv) != null) {
                            v21 = UtilsKt.toFloat((PrimitiveType)v18);
                        } else lbl-1000:
                        // 2 sources

                        {
                            v21 = 0.0f;
                        }
                        zero = v21;
                        this_$iv = scalePointer;
                        $i$f$getAndIncrement = false;
                        value$iv = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                        this_$iv$iv = this_$iv;
                        $i$f$increment = false;
                        if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                            v22 = this_$iv$iv;
                            $i$f$blockIncrement = v22.getIndexInBlock();
                            v22.setIndexInBlock($i$f$blockIncrement + 1);
                        } else {
                            this_$iv$iv$iv = this_$iv$iv;
                            $i$f$blockIncrement = false;
                            if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                v23 = this_$iv$iv$iv;
                                var28_143 = v23.getBlockNum();
                                v23.setBlockNum(var28_143 + 1);
                                this_$iv$iv$iv.setIndexInBlock(0);
                                this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                            } else {
                                this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                            }
                        }
                        sc = value$iv;
                        if (this.getType() == DataType.BYTE) {
                            this_$iv = output.getArray().pointer(outOffset);
                            v24 = this.array.pointer(outOffset);
                            if (v24 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.pointers.BytePointer");
                            }
                            $i$f$getAndIncrement = (BytePointer)v24;
                            count$iv = blockSize;
                            $i$f$accept = false;
                            $this$isCompatibleBySize$iv$iv = $this$accept$iv;
                            $i$f$isCompatibleBySize = false;
                            $this$isCompatibleBySize$iv$iv = $this$isCompatibleBySize$iv$iv.getArray().getSize() - $this$isCompatibleBySize$iv$iv.getLinearIndex() >= count$iv && other$iv.getArray().getSize() - other$iv.getLinearIndex() >= count$iv;
                            $i$f$isCompatibleBySize = false;
                            $i$f$blockIncrement = false;
                            if (!$this$isCompatibleBySize$iv$iv) {
                                $i$a$-require-FloatPointerKt$accept$1$iv = false;
                                $i$f$blockIncrement = "Pointers not compatible by available elements";
                                throw (Throwable)new IllegalArgumentException($i$f$blockIncrement.toString());
                            }
                            $this$isCompatibleWith$iv$iv = $this$accept$iv;
                            $i$f$isCompatibleWith = false;
                            if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == other$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == other$iv.getArray().getBlockSize()) {
                                for (end$iv = count$iv; end$iv > 0; end$iv -= ((Object)dstBlock$iv).length - dstOffset$iv) {
                                    dstBlock$iv = $this$accept$iv.getCurrentBlock();
                                    dstOffset$iv = $this$accept$iv.getIndexInBlock();
                                    this_$iv$iv = $this$accept$iv;
                                    $i$f$blockIncrement = false;
                                    if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                        v25 = this_$iv$iv;
                                        var30_157 = v25.getBlockNum();
                                        v25.setBlockNum(var30_157 + 1);
                                        this_$iv$iv.setIndexInBlock(0);
                                        this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                                    } else {
                                        this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                    }
                                    srcBlock$iv = other$iv.getCurrentBlock();
                                    this_$iv$iv = other$iv;
                                    $i$f$blockIncrement = 0;
                                    if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                        v26 = this_$iv$iv;
                                        var31_163 = v26.getBlockNum();
                                        v26.setBlockNum(var31_163 + 1);
                                        this_$iv$iv.setIndexInBlock(0);
                                        this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                                    } else {
                                        this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                    }
                                    this_$iv$iv = dstOffset$iv;
                                    var31_163 = ((Object)dstBlock$iv).length;
                                    var32_164 = dstOffset$iv + end$iv;
                                    var33_169 = false;
                                    $i$f$blockIncrement = Math.min(var31_163, var32_164);
                                    while (this_$iv$iv < $i$f$blockIncrement) {
                                        var34_170 = srcBlock$iv[index$iv];
                                        var35_171 /* !! */  = (float)dstBlock$iv[index$iv];
                                        var36_172 = index$iv++;
                                        var37_173 = dstBlock$iv;
                                        $i$a$-accept-PrimitiveNDArray$dequantize$3$1 = false;
                                        var39_177 = ((float)src - zero) * sc;
                                        var37_173[var36_172] = var39_177;
                                    }
                                }
                            } else {
                                while (end$iv > 0) {
                                    dstBlock$iv = $this$accept$iv;
                                    this_$iv$iv = $this$accept$iv;
                                    $i$f$get = false;
                                    $noName_0 /* !! */  = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                                    this_$iv$iv = other$iv;
                                    $i$f$getAndIncrement = false;
                                    value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                                    this_$iv$iv$iv = this_$iv$iv;
                                    $i$f$increment = 0;
                                    if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                        v27 = this_$iv$iv$iv;
                                        var32_165 = v27.getIndexInBlock();
                                        v27.setIndexInBlock(var32_165 + 1);
                                    } else {
                                        this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                        $i$f$blockIncrement = false;
                                        if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                            v28 = this_$iv$iv$iv$iv;
                                            var40_178 = v28.getBlockNum();
                                            v28.setBlockNum(var40_178 + 1);
                                            this_$iv$iv$iv$iv.setIndexInBlock(0);
                                            this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                        } else {
                                            this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                        }
                                    }
                                    var41_179 = src = value$iv$iv;
                                    $noName_0 = $noName_0 /* !! */ ;
                                    $i$a$-accept-PrimitiveNDArray$dequantize$3$1 = false;
                                    value$iv$iv = ((float)src - zero) * sc;
                                    $i$f$set = 0;
                                    this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()] = value$iv$iv;
                                    this_$iv$iv = $this$accept$iv;
                                    $i$f$increment = false;
                                    if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                                        v29 = this_$iv$iv;
                                        $i$f$set = v29.getIndexInBlock();
                                        v29.setIndexInBlock($i$f$set + 1);
                                    } else {
                                        this_$iv$iv$iv = this_$iv$iv;
                                        $i$f$blockIncrement = false;
                                        if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                            v30 = this_$iv$iv$iv;
                                            this_$iv$iv$iv = v30.getBlockNum();
                                            v30.setBlockNum(this_$iv$iv$iv + 1);
                                            this_$iv$iv$iv.setIndexInBlock(0);
                                            this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                                        } else {
                                            this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                                        }
                                    }
                                    --end$iv;
                                }
                            }
                        } else {
                            $this$accept$iv = output.getArray().pointer(outOffset);
                            v31 = this.array.pointer(outOffset);
                            if (v31 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.pointers.UBytePointer");
                            }
                            other$iv = (UBytePointer)v31;
                            count$iv = blockSize;
                            $i$f$accept = false;
                            $this$isCompatibleBySize$iv$iv = $this$accept$iv;
                            $i$f$isCompatibleBySize = false;
                            $this$isCompatibleBySize$iv$iv = $this$isCompatibleBySize$iv$iv.getArray().getSize() - $this$isCompatibleBySize$iv$iv.getLinearIndex() >= count$iv && other$iv.getArray().getSize() - other$iv.getLinearIndex() >= count$iv;
                            $i$f$isCompatibleBySize = false;
                            $i$f$increment = false;
                            if (!$this$isCompatibleBySize$iv$iv) {
                                $i$a$-require-FloatPointerKt$accept$5$iv = false;
                                $i$f$increment = "Pointers not compatible by available elements";
                                throw (Throwable)new IllegalArgumentException($i$f$increment.toString());
                            }
                            $this$isCompatibleWith$iv$iv = $this$accept$iv;
                            $i$f$isCompatibleWith = false;
                            if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == other$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == other$iv.getArray().getBlockSize()) {
                                for (end$iv = count$iv; end$iv > 0; end$iv -= ((Object)dstBlock$iv).length - dstOffset$iv) {
                                    dstBlock$iv = $this$accept$iv.getCurrentBlock();
                                    dstOffset$iv = $this$accept$iv.getIndexInBlock();
                                    this_$iv$iv = $this$accept$iv;
                                    $i$f$blockIncrement = false;
                                    if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                        v32 = this_$iv$iv;
                                        this_$iv$iv$iv = v32.getBlockNum();
                                        v32.setBlockNum(this_$iv$iv$iv + 1);
                                        this_$iv$iv.setIndexInBlock(0);
                                        this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                                    } else {
                                        this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                    }
                                    srcBlock$iv = other$iv.getCurrentBlock();
                                    this_$iv$iv = other$iv;
                                    $i$f$blockIncrement = 0;
                                    if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                        v33 = this_$iv$iv;
                                        $i$f$increment = v33.getBlockNum();
                                        v33.setBlockNum($i$f$increment + 1);
                                        this_$iv$iv.setIndexInBlock(0);
                                        this_$iv$iv.setCurrentBlock-GBYM_sE(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()].unbox-impl());
                                    } else {
                                        this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                    }
                                    this_$iv$iv = dstOffset$iv;
                                    $i$f$increment = ((Object)dstBlock$iv).length;
                                    this_$iv$iv$iv$iv = dstOffset$iv + end$iv;
                                    $i$f$blockIncrement = false;
                                    $i$f$blockIncrement = Math.min($i$f$increment, this_$iv$iv$iv$iv);
                                    while (this_$iv$iv < $i$f$blockIncrement) {
                                        src = UByteArray.get-impl((byte[])srcBlock$iv, (int)index$iv);
                                        $noName_0 /* !! */  = (float)dstBlock$iv[index$iv];
                                        var36_172 = index$iv++;
                                        var37_173 = dstBlock$iv;
                                        $i$a$-accept-PrimitiveNDArray$dequantize$3$2 = false;
                                        var40_178 = src;
                                        src = false;
                                        var42_180 = var40_178;
                                        var43_181 = false;
                                        var39_177 = ((float)(var42_180 & 255) - zero) * sc;
                                        var37_173[var36_172] = var39_177;
                                    }
                                }
                            } else {
                                while (end$iv > 0) {
                                    dstBlock$iv = $this$accept$iv;
                                    this_$iv$iv = $this$accept$iv;
                                    $i$f$get = false;
                                    var35_171 /* !! */  = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                                    this_$iv$iv = other$iv;
                                    $i$f$getAndIncrement = false;
                                    value$iv$iv = UByteArray.get-impl((byte[])this_$iv$iv.getCurrentBlock(), (int)this_$iv$iv.getIndexInBlock());
                                    this_$iv$iv$iv = this_$iv$iv;
                                    $i$f$increment = 0;
                                    if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                        v34 = this_$iv$iv$iv;
                                        this_$iv$iv$iv$iv = v34.getIndexInBlock();
                                        v34.setIndexInBlock(this_$iv$iv$iv$iv + 1);
                                    } else {
                                        this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                        $i$f$blockIncrement = false;
                                        if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                            v35 = this_$iv$iv$iv$iv;
                                            var44_182 = v35.getBlockNum();
                                            v35.setBlockNum(var44_182 + 1);
                                            this_$iv$iv$iv$iv.setIndexInBlock(0);
                                            this_$iv$iv$iv$iv.setCurrentBlock-GBYM_sE(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()].unbox-impl());
                                        } else {
                                            this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                        }
                                    }
                                    var40_178 = var34_170 = value$iv$iv;
                                    $noName_0 = var35_171 /* !! */ ;
                                    $i$a$-accept-PrimitiveNDArray$dequantize$3$2 = false;
                                    var42_180 = src;
                                    var43_181 = false;
                                    var45_183 = var42_180;
                                    var46_184 = false;
                                    value$iv$iv = ((float)(var45_183 & 255) - zero) * sc;
                                    $i$f$set = 0;
                                    this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()] = value$iv$iv;
                                    this_$iv$iv = $this$accept$iv;
                                    $i$f$increment = false;
                                    if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                                        v36 = this_$iv$iv;
                                        $i$f$set = v36.getIndexInBlock();
                                        v36.setIndexInBlock($i$f$set + 1);
                                    } else {
                                        this_$iv$iv$iv = this_$iv$iv;
                                        $i$f$blockIncrement = false;
                                        if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                            v37 = this_$iv$iv$iv;
                                            var30_162 = v37.getBlockNum();
                                            v37.setBlockNum(var30_162 + 1);
                                            this_$iv$iv$iv.setIndexInBlock(0);
                                            this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                                        } else {
                                            this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                                        }
                                    }
                                    --end$iv;
                                }
                            }
                        }
                        outOffset += blockSize;
                        ++i;
                    }
                }
                break block95;
            }
            var6_8 = "Cannot perform dequantization. Scale and zero point tensors should be either scalars or 1D tensors containing " + this.getShape()[axis] + " elements";
            var7_11 = false;
            throw (Throwable)new IllegalStateException(var6_8.toString());
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNumberNDArray row(int row2) {
        int end$iv;
        PrimitiveArray dstBlock$iv;
        void other$iv;
        void $this$accept$iv;
        int rowLength = this.getLinearSize() / this.getShape()[0];
        int start = row2 * rowLength;
        int[] nArray = this.getShape();
        int n = 1;
        int n2 = this.getRank();
        boolean bl = false;
        int[] dims = ArraysKt.copyOfRange((int[])nArray, (int)n, (int)n2);
        PrimitiveTiledArray result = PrimitiveTiledArray.Companion.invoke$default(PrimitiveTiledArray.Companion, new Strides(dims), 0, 2, null);
        PrimitivePointer primitivePointer = PrimitiveTiledArray.pointer$default(result, 0, 1, null);
        PrimitivePointer primitivePointer2 = this.array.pointer(start);
        int count$iv = result.getSize();
        boolean $i$f$accept = false;
        void $this$isCompatibleBySize$iv$iv22 = $this$accept$iv;
        boolean $i$f$isCompatibleBySize = false;
        boolean $this$isCompatibleBySize$iv$iv22 = $this$isCompatibleBySize$iv$iv22.getArray().getSize() - $this$isCompatibleBySize$iv$iv22.getLinearIndex() >= count$iv && other$iv.getArray().getSize() - other$iv.getLinearIndex() >= count$iv;
        $i$f$isCompatibleBySize = false;
        boolean bl2 = false;
        if (!$this$isCompatibleBySize$iv$iv22) {
            boolean bl3 = false;
            String string = "Pointers not compatible by available elements";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        void $this$isCompatibleWith$iv$iv = $this$accept$iv;
        boolean $i$f$isCompatibleWith = false;
        if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == other$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == other$iv.getArray().getBlockSize()) {
            int dstOffset$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.getSize() - dstOffset$iv) {
                int n3;
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                void this_$iv$iv = $this$accept$iv;
                boolean $i$f$blockIncrement = false;
                if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                    void v0 = this_$iv$iv;
                    int n4 = v0.getBlockNum();
                    v0.setBlockNum(n4 + 1);
                    this_$iv$iv.setIndexInBlock(0);
                    this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                } else {
                    this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                }
                PrimitiveArray srcBlock$iv = other$iv.getCurrentBlock();
                void this_$iv$iv22 = other$iv;
                int $i$f$blockIncrement2 = 0;
                if (this_$iv$iv22.getBlockNum() < this_$iv$iv22.getArray().getBlocksNum() - 1) {
                    void v1 = this_$iv$iv22;
                    n3 = v1.getBlockNum();
                    v1.setBlockNum(n3 + 1);
                    this_$iv$iv22.setIndexInBlock(0);
                    this_$iv$iv22.setCurrentBlock(this_$iv$iv22.getArray().getBlocks()[this_$iv$iv22.getBlockNum()]);
                } else {
                    this_$iv$iv22.setIndexInBlock(this_$iv$iv22.getArray().getBlockSize());
                }
                int this_$iv$iv22 = dstOffset$iv;
                n3 = dstBlock$iv.getSize();
                int n5 = dstOffset$iv + end$iv;
                boolean bl4 = false;
                $i$f$blockIncrement2 = Math.min(n3, n5);
                while (this_$iv$iv22 < $i$f$blockIncrement2) {
                    void src;
                    void index$iv;
                    PrimitiveType primitiveType = srcBlock$iv.get((int)index$iv);
                    PrimitiveType primitiveType2 = dstBlock$iv.get((int)index$iv);
                    void var27_46 = index$iv++;
                    PrimitiveArray primitiveArray = dstBlock$iv;
                    boolean bl5 = false;
                    void var28_47 = src;
                    primitiveArray.set((int)var27_46, (PrimitiveType)var28_47);
                }
            }
        } else {
            while (end$iv > 0) {
                void this_$iv$iv;
                void src;
                PrimitiveType primitiveType;
                dstBlock$iv = $this$accept$iv;
                void this_$iv$iv2 = $this$accept$iv;
                boolean $i$f$get = false;
                PrimitiveType primitiveType3 = this_$iv$iv2.getCurrentBlock().get(this_$iv$iv2.getIndexInBlock());
                this_$iv$iv2 = other$iv;
                boolean $i$f$getAndIncrement = false;
                PrimitiveType value$iv$iv = this_$iv$iv2.getCurrentBlock().get(this_$iv$iv2.getIndexInBlock());
                void this_$iv$iv$iv = this_$iv$iv2;
                boolean $i$f$increment = false;
                if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                    void v2 = this_$iv$iv$iv;
                    int n6 = v2.getIndexInBlock();
                    v2.setIndexInBlock(n6 + 1);
                } else {
                    void this_$iv$iv$iv$iv = this_$iv$iv$iv;
                    boolean $i$f$blockIncrement = false;
                    if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                        void v3 = this_$iv$iv$iv$iv;
                        int n7 = v3.getBlockNum();
                        v3.setBlockNum(n7 + 1);
                        this_$iv$iv$iv$iv.setIndexInBlock(0);
                        this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                    } else {
                        this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                    }
                }
                PrimitiveType primitiveType4 = primitiveType = value$iv$iv;
                PrimitiveType $noName_0 = primitiveType3;
                boolean bl6 = false;
                void value$iv$iv2 = src;
                int $i$f$set = 0;
                this_$iv$iv.getCurrentBlock().set(this_$iv$iv.getIndexInBlock(), (PrimitiveType)value$iv$iv2);
                this_$iv$iv = $this$accept$iv;
                boolean $i$f$increment2 = false;
                if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                    void v4 = this_$iv$iv;
                    $i$f$set = v4.getIndexInBlock();
                    v4.setIndexInBlock($i$f$set + 1);
                } else {
                    void this_$iv$iv$iv2 = this_$iv$iv;
                    boolean $i$f$blockIncrement = false;
                    if (this_$iv$iv$iv2.getBlockNum() < this_$iv$iv$iv2.getArray().getBlocksNum() - 1) {
                        void v5 = this_$iv$iv$iv2;
                        int n8 = v5.getBlockNum();
                        v5.setBlockNum(n8 + 1);
                        this_$iv$iv$iv2.setIndexInBlock(0);
                        this_$iv$iv$iv2.setCurrentBlock(this_$iv$iv$iv2.getArray().getBlocks()[this_$iv$iv$iv2.getBlockNum()]);
                    } else {
                        this_$iv$iv$iv2.setIndexInBlock(this_$iv$iv$iv2.getArray().getBlockSize());
                    }
                }
                --end$iv;
            }
        }
        return new MutablePrimitiveNDArray(result, new Strides(dims));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNumberNDArray slice(@NotNull int[] starts, @NotNull int[] ends, @NotNull int[] steps) {
        Intrinsics.checkParameterIsNotNull((Object)starts, (String)"starts");
        Intrinsics.checkParameterIsNotNull((Object)ends, (String)"ends");
        Intrinsics.checkParameterIsNotNull((Object)steps, (String)"steps");
        int n = this.getShape().length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            void it;
            int n3 = i;
            int n4 = i;
            int[] nArray2 = nArray;
            boolean bl = false;
            int n5 = ends[it] - starts[it];
            int n6 = 0;
            int length = Math.abs(n5);
            n6 = steps[it];
            int n7 = length;
            boolean bl2 = false;
            int n8 = Math.abs(n6);
            int rest = n7 % n8;
            n6 = steps[it];
            n7 = length;
            bl2 = false;
            n8 = Math.abs(n6);
            nArray2[n4] = n2 = n7 / n8 + (rest != 0 ? 1 : 0);
        }
        int[] newShape = nArray;
        Strides newStrides = new Strides(newShape);
        PrimitiveTiledArray newArray = PrimitiveTiledArray.Companion.invoke$default(PrimitiveTiledArray.Companion, newStrides, 0, 2, null);
        if (newArray.getSize() > 0) {
            this.slice(PrimitiveTiledArray.pointer$default(newArray, 0, 1, null), PrimitiveTiledArray.pointer$default(this.array, 0, 1, null), 0, 0, this.getShape(), starts, ends, steps);
        }
        return new MutablePrimitiveNDArray(newArray, newStrides);
    }

    /*
     * WARNING - void declaration
     */
    private final void slice(PrimitivePointer dst, PrimitivePointer src, int offset, int axis, int[] shape, int[] starts, int[] ends, int[] steps) {
        IntProgression range;
        int start = starts[axis];
        int end = ends[axis];
        int step = steps[axis];
        IntProgression intProgression = range = step > 0 ? RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)start, (int)end)), (int)step) : RangesKt.step((IntProgression)RangesKt.downTo((int)start, (int)(end + 1)), (int)(-step));
        if (axis == shape.length - 1) {
            IntProgression intProgression2 = range;
            int n = intProgression2.getFirst();
            int n2 = intProgression2.getLast();
            int n3 = intProgression2.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    PrimitivePointer this_$iv;
                    void index;
                    src.setLinearIndex(offset + index);
                    PrimitivePointer primitivePointer = dst;
                    PrimitivePointer this_$iv2 = src;
                    boolean $i$f$get = false;
                    PrimitiveType value$iv = this_$iv2.getCurrentBlock().get(this_$iv2.getIndexInBlock());
                    int $i$f$set = 0;
                    this_$iv.getCurrentBlock().set(this_$iv.getIndexInBlock(), value$iv);
                    this_$iv = dst;
                    boolean $i$f$increment = false;
                    if (this_$iv.getIndexInBlock() < this_$iv.getArray().getBlockSize() - 1) {
                        PrimitivePointer primitivePointer2 = this_$iv;
                        $i$f$set = primitivePointer2.getIndexInBlock();
                        primitivePointer2.setIndexInBlock($i$f$set + 1);
                    } else {
                        PrimitivePointer this_$iv$iv = this_$iv;
                        boolean $i$f$blockIncrement = false;
                        if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                            PrimitivePointer primitivePointer3 = this_$iv$iv;
                            int n6 = primitivePointer3.getBlockNum();
                            primitivePointer3.setBlockNum(n6 + 1);
                            this_$iv$iv.setIndexInBlock(0);
                            this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                        }
                    }
                    if (index != n2) {
                        index += n3;
                        continue;
                    }
                    break;
                }
            }
        } else {
            int ind;
            int dim = 1;
            int n = axis + 1;
            int n7 = shape.length;
            while (n < n7) {
                dim *= shape[ind];
                ++ind;
            }
            IntProgression intProgression3 = range;
            ind = intProgression3.getFirst();
            n7 = intProgression3.getLast();
            int n8 = intProgression3.getStep();
            int n9 = ind;
            int n10 = n7;
            if (n8 >= 0 ? n9 <= n10 : n9 >= n10) {
                while (true) {
                    void index;
                    this.slice(dst, src, offset + index * dim, axis + 1, shape, starts, ends, steps);
                    if (index == n7) break;
                    index += n8;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PrimitiveType min() {
        PrimitiveType min = PrimitiveType.Companion.getMAX_VALUE();
        block0: for (PrimitiveArray block : this.array.getBlocks()) {
            int n;
            IntRange intRange = block.getIndices();
            int n2 = intRange.getFirst();
            if (n2 > (n = intRange.getLast())) continue;
            while (true) {
                void idx;
                PrimitiveType tmp;
                if ((tmp = block.get((int)idx)).compareTo(min) < 0) {
                    min = tmp;
                }
                if (idx == n) continue block0;
                ++idx;
            }
        }
        return min;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PrimitiveType max() {
        PrimitiveType max = PrimitiveType.Companion.getMIN_VALUE();
        block0: for (PrimitiveArray block : this.array.getBlocks()) {
            int n;
            IntRange intRange = block.getIndices();
            int n2 = intRange.getFirst();
            if (n2 > (n = intRange.getLast())) continue;
            while (true) {
                void idx;
                PrimitiveType tmp;
                if ((tmp = block.get((int)idx)).compareTo(max) > 0) {
                    max = tmp;
                }
                if (idx == n) continue block0;
                ++idx;
            }
        }
        return max;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PrimitiveType sum() {
        PrimitiveType sum = PrimitiveTypeKt.toPrimitive((Number)0);
        block0: for (PrimitiveArray block : this.array.getBlocks()) {
            int n;
            IntRange intRange = block.getIndices();
            int n2 = intRange.getFirst();
            if (n2 > (n = intRange.getLast())) continue;
            while (true) {
                void idx;
                sum = sum.plus(block.get((int)idx)).toPrimitive();
                if (idx == n) continue block0;
                ++idx;
            }
        }
        return sum;
    }

    @Override
    @NotNull
    public MutableNumberNDArray cumulativeSum(int axis, boolean exclusive, boolean reverse) {
        MutablePrimitiveNDArray output = new MutablePrimitiveNDArray(PrimitiveTiledArray.Companion.invoke$default(PrimitiveTiledArray.Companion, this.strides, 0, 2, null), this.strides);
        int actualAxis = NDArrayExtensionsKt.indexAxis(this, axis);
        int blockSize = GatherKt.computeBlockSize$default(this, actualAxis + 1, 0, 2, null);
        int batchSize = GatherKt.computeBlockSize$default(this, actualAxis, 0, 2, null);
        int numBatches = GatherKt.computeBlockSize$default(this, 0, actualAxis, 1, null);
        int numBlocks = batchSize / blockSize;
        boolean bl = false;
        int n = 0;
        int n2 = numBatches;
        for (n = 0; n < n2; ++n) {
            int thisOff;
            int currentOff;
            int j;
            int i;
            int n3;
            int n4;
            int dstOff;
            int batchIdx = n;
            boolean bl2 = false;
            int n5 = dstOff = !reverse ? batchIdx * batchSize : (numBatches - batchIdx) * batchSize - 1;
            if (!exclusive) {
                if (!reverse) {
                    output.copyFrom(dstOff, this, dstOff, dstOff + blockSize);
                } else {
                    output.copyFrom(dstOff - blockSize + 1, this, dstOff - blockSize + 1, dstOff + 1);
                }
            }
            if (!reverse) {
                int n6 = 1;
                n4 = numBlocks;
                while (n6 < n4) {
                    int n7 = 0;
                    n3 = blockSize;
                    while (n7 < n3) {
                        currentOff = dstOff + i * blockSize + j;
                        thisOff = !exclusive ? currentOff : currentOff - blockSize;
                        output.getArray().set(currentOff, output.getArray().get(currentOff - blockSize).plus(this.array.get(thisOff)).toPrimitive());
                        ++j;
                    }
                    ++i;
                }
                continue;
            }
            n4 = numBlocks;
            for (i = 1; i < n4; ++i) {
                n3 = 0;
                for (j = blockSize - 1; j >= 0; --j) {
                    currentOff = dstOff - i * blockSize - j;
                    thisOff = !exclusive ? currentOff : currentOff + blockSize;
                    output.getArray().set(currentOff, output.getArray().get(currentOff + blockSize).plus(this.array.get(thisOff)).toPrimitive());
                }
            }
        }
        return output;
    }

    @Override
    @NotNull
    public MutableNumberNDArray plus(@NotNull NumberNDArray other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.plus(other, new MutablePrimitiveNDArray(PrimitiveTiledArray.Companion.invoke$default(PrimitiveTiledArray.Companion, this.strides, 0, 2, null), this.strides));
    }

    /*
     * WARNING - void declaration
     */
    private final void plusScalar(PrimitiveTiledArray array, PrimitiveType scalar2, PrimitiveTiledArray destination) {
        int n = array.getBlocksNum() == destination.getBlocksNum() && array.getBlockSize() == destination.getBlockSize() ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = 0;
        n2 = array.getBlocksNum();
        while (n < n2) {
            int n3;
            void blockNum;
            PrimitiveArray arrayBlock = array.getBlocks()[blockNum];
            PrimitiveArray destBlock = destination.getBlocks()[blockNum];
            IntRange intRange = arrayBlock.getIndices();
            int n4 = intRange.getFirst();
            if (n4 <= (n3 = intRange.getLast())) {
                while (true) {
                    void idx;
                    destBlock.set((int)idx, arrayBlock.get((int)idx).plus(scalar2).toPrimitive());
                    if (idx == n3) break;
                    ++idx;
                }
            }
            ++blockNum;
        }
    }

    @Override
    @NotNull
    public MutableNumberNDArray plus(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        boolean bl = other instanceof PrimitiveNDArray && destination instanceof MutablePrimitiveNDArray;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Operands must have the same types";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (NDArrayExtensionsKt.isScalar(this) && NDArrayExtensionsKt.isScalar(other)) {
            ((MutablePrimitiveNDArray)destination).getArray().getBlocks()[0].set(0, this.array.getBlocks()[0].get(0).plus(((PrimitiveNDArray)other).array.getBlocks()[0].get(0)).toPrimitive());
        } else if (NDArrayExtensionsKt.isScalar(this)) {
            this.plusScalar(((PrimitiveNDArray)other).array, this.array.getBlocks()[0].get(0), ((MutablePrimitiveNDArray)destination).getArray());
        } else if (NDArrayExtensionsKt.isScalar(other)) {
            this.plusScalar(this.array, ((PrimitiveNDArray)other).array.getBlocks()[0].get(0), ((MutablePrimitiveNDArray)destination).getArray());
        } else {
            BroadcastingKt.applyWithBroadcast((NDArray)this, (NDArray)other, destination, false, (Function3<? super NDArray, ? super NDArray, ? super MutableNDArray, Unit>)((Function3)plus.2.INSTANCE));
        }
        return destination;
    }

    @Override
    @NotNull
    public MutableNumberNDArray minus(@NotNull NumberNDArray other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.minus(other, new MutablePrimitiveNDArray(PrimitiveTiledArray.Companion.invoke$default(PrimitiveTiledArray.Companion, this.strides, 0, 2, null), this.strides));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNumberNDArray minus(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        boolean bl = other instanceof PrimitiveNDArray && destination instanceof MutablePrimitiveNDArray;
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            boolean bl32 = false;
            String string = "Operands must have the same types";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (NDArrayExtensionsKt.isScalar(this) && NDArrayExtensionsKt.isScalar(other)) {
            ((MutablePrimitiveNDArray)destination).getArray().getBlocks()[0].set(0, this.array.getBlocks()[0].get(0).minus(((PrimitiveNDArray)other).array.getBlocks()[0].get(0)).toPrimitive());
        } else if (NDArrayExtensionsKt.isScalar(other)) {
            int[] nArray = this.getShape();
            int[] nArray2 = destination.getShape();
            n = 0;
            boolean bl4 = Arrays.equals(nArray, nArray2);
            int n2 = 0;
            n = 0;
            n = 0;
            boolean bl32 = false;
            if (!bl4) {
                boolean bl5 = false;
                String bl32 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(bl32.toString());
            }
            PrimitiveType scalar2 = ((PrimitiveNDArray)other).array.getBlocks()[0].get(0);
            n2 = 0;
            n = this.array.getBlocksNum();
            while (n2 < n) {
                int n3;
                void blockNum;
                PrimitiveArray leftBlock = this.array.getBlocks()[blockNum];
                PrimitiveArray destBlock = ((MutablePrimitiveNDArray)destination).getArray().getBlocks()[blockNum];
                IntRange intRange = leftBlock.getIndices();
                int n4 = intRange.getFirst();
                if (n4 <= (n3 = intRange.getLast())) {
                    while (true) {
                        void idx;
                        destBlock.set((int)idx, leftBlock.get((int)idx).minus(scalar2).toPrimitive());
                        if (idx == n3) break;
                        ++idx;
                    }
                }
                ++blockNum;
            }
        } else {
            if (NDArrayExtensionsKt.isScalar(this)) {
                String string = "Subtraction of a matrix from a scalar is prohibited";
                bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            BroadcastingKt.applyWithBroadcast((NDArray)this, (NDArray)other, destination, true, (Function3<? super NDArray, ? super NDArray, ? super MutableNDArray, Unit>)((Function3)minus.2.INSTANCE));
        }
        return destination;
    }

    @Override
    @NotNull
    public MutableNumberNDArray times(@NotNull NumberNDArray other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.times(other, new MutablePrimitiveNDArray(PrimitiveTiledArray.Companion.invoke$default(PrimitiveTiledArray.Companion, this.strides, 0, 2, null), this.strides));
    }

    /*
     * WARNING - void declaration
     */
    private final void timesScalar(PrimitiveTiledArray array, PrimitiveType scalar2, PrimitiveTiledArray destination) {
        int n = array.getBlocksNum() == destination.getBlocksNum() && array.getBlockSize() == destination.getBlockSize() ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = 0;
        n2 = array.getBlocksNum();
        while (n < n2) {
            int n3;
            void blockNum;
            PrimitiveArray arrayBlock = array.getBlocks()[blockNum];
            PrimitiveArray destBlock = destination.getBlocks()[blockNum];
            IntRange intRange = arrayBlock.getIndices();
            int n4 = intRange.getFirst();
            if (n4 <= (n3 = intRange.getLast())) {
                while (true) {
                    void idx;
                    destBlock.set((int)idx, arrayBlock.get((int)idx).times(scalar2).toPrimitive());
                    if (idx == n3) break;
                    ++idx;
                }
            }
            ++blockNum;
        }
    }

    @Override
    @NotNull
    public MutableNumberNDArray times(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        boolean bl = other instanceof PrimitiveNDArray && destination instanceof MutablePrimitiveNDArray;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Operands must have the same types";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (NDArrayExtensionsKt.isScalar(this) && NDArrayExtensionsKt.isScalar(other)) {
            ((MutablePrimitiveNDArray)destination).getArray().getBlocks()[0].set(0, this.array.getBlocks()[0].get(0).times(((PrimitiveNDArray)other).array.getBlocks()[0].get(0)).toPrimitive());
        } else if (NDArrayExtensionsKt.isScalar(this)) {
            this.timesScalar(((PrimitiveNDArray)other).array, this.array.getBlocks()[0].get(0), ((MutablePrimitiveNDArray)destination).getArray());
        } else if (NDArrayExtensionsKt.isScalar(other)) {
            this.timesScalar(this.array, ((PrimitiveNDArray)other).array.getBlocks()[0].get(0), ((MutablePrimitiveNDArray)destination).getArray());
        } else {
            BroadcastingKt.applyWithBroadcast((NDArray)this, (NDArray)other, destination, false, (Function3<? super NDArray, ? super NDArray, ? super MutableNDArray, Unit>)((Function3)times.2.INSTANCE));
        }
        return destination;
    }

    @Override
    @NotNull
    public MutableNumberNDArray div(@NotNull NumberNDArray other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.div(other, new MutablePrimitiveNDArray(PrimitiveTiledArray.Companion.invoke$default(PrimitiveTiledArray.Companion, this.strides, 0, 2, null), this.strides));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNumberNDArray div(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        boolean bl = other instanceof PrimitiveNDArray && destination instanceof MutablePrimitiveNDArray;
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            boolean bl32 = false;
            String string = "Operands must have the same types";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (NDArrayExtensionsKt.isScalar(this) && NDArrayExtensionsKt.isScalar(other)) {
            ((MutablePrimitiveNDArray)destination).getArray().getBlocks()[0].set(0, this.array.getBlocks()[0].get(0).div(((PrimitiveNDArray)other).array.getBlocks()[0].get(0)).toPrimitive());
        } else if (NDArrayExtensionsKt.isScalar(other)) {
            int[] nArray = this.getShape();
            int[] nArray2 = destination.getShape();
            n = 0;
            boolean bl4 = Arrays.equals(nArray, nArray2);
            int n2 = 0;
            n = 0;
            n = 0;
            boolean bl32 = false;
            if (!bl4) {
                boolean bl5 = false;
                String bl32 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(bl32.toString());
            }
            PrimitiveType scalar2 = ((PrimitiveNDArray)other).array.getBlocks()[0].get(0);
            n2 = 0;
            n = this.array.getBlocksNum();
            while (n2 < n) {
                int n3;
                void blockNum;
                PrimitiveArray leftBlock = this.array.getBlocks()[blockNum];
                PrimitiveArray destBlock = ((MutablePrimitiveNDArray)destination).getArray().getBlocks()[blockNum];
                IntRange intRange = leftBlock.getIndices();
                int n4 = intRange.getFirst();
                if (n4 <= (n3 = intRange.getLast())) {
                    while (true) {
                        void idx;
                        destBlock.set((int)idx, leftBlock.get((int)idx).div(scalar2).toPrimitive());
                        if (idx == n3) break;
                        ++idx;
                    }
                }
                ++blockNum;
            }
        } else {
            if (NDArrayExtensionsKt.isScalar(this)) {
                String string = "Division of a scalar into a matrix is prohibited";
                bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            BroadcastingKt.applyWithBroadcast((NDArray)this, (NDArray)other, destination, true, (Function3<? super NDArray, ? super NDArray, ? super MutableNDArray, Unit>)((Function3)div.2.INSTANCE));
        }
        return destination;
    }

    /*
     * WARNING - void declaration
     */
    private final PrimitiveArray[] resortBlocks(PrimitiveArray[] blocks, int colSize, int blocksInRow) {
        PrimitiveArray[] primitiveArrayArray = blocks;
        int n = 0;
        PrimitiveArray[] primitiveArrayArray2 = Arrays.copyOf(primitiveArrayArray, primitiveArrayArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)primitiveArrayArray2, (String)"java.util.Arrays.copyOf(this, size)");
        PrimitiveArray[] result = primitiveArrayArray2;
        int n2 = 0;
        n = blocksInRow;
        while (n2 < n) {
            void i;
            int n3 = 0;
            int n4 = colSize;
            while (n3 < n4) {
                void j;
                result[i * colSize + j] = blocks[j * blocksInRow + i];
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    @NotNull
    public MutableNumberNDArray dot(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        PrimitiveNDArray cfr_ignored_0 = (PrimitiveNDArray)other;
        MutablePrimitiveNDArray cfr_ignored_1 = (MutablePrimitiveNDArray)destination;
        boolean bl = this.getShape().length == 2 && other.getShape().length == 2;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.getShape()[1] == other.getShape()[0];
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int n = this.getShape()[0];
        int t = this.getShape()[1];
        PrimitiveArray[] resortedLeft = this.resortBlocks(this.array.getBlocks(), this.getShape()[0], this.getBlocksInRow());
        PrimitiveArray[] resortedRight = this.resortBlocks(((PrimitiveNDArray)other).array.getBlocks(), other.getShape()[0], ((PrimitiveNDArray)other).getBlocksInRow());
        PrimitiveArray[] resortedDest = this.resortBlocks(((MutablePrimitiveNDArray)destination).getArray().getBlocks(), destination.getShape()[0], ((MutablePrimitiveNDArray)destination).getBlocksInRow());
        int lBlockSize = this.array.getBlockSize();
        int rdBlockSize = ((MutablePrimitiveNDArray)destination).getArray().getBlockSize();
        int lBlockInRow = this.getBlocksInRow();
        int rBlockInRow = ((PrimitiveNDArray)other).getBlocksInRow();
        Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit> $fun$wrapper$1 = new Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit>(rBlockInRow, t, n, resortedDest, lBlockInRow, resortedLeft, lBlockSize, resortedRight, rdBlockSize){
            final /* synthetic */ int $rBlockInRow;
            final /* synthetic */ int $t;
            final /* synthetic */ int $n;
            final /* synthetic */ PrimitiveArray[] $resortedDest;
            final /* synthetic */ int $lBlockInRow;
            final /* synthetic */ PrimitiveArray[] $resortedLeft;
            final /* synthetic */ int $lBlockSize;
            final /* synthetic */ PrimitiveArray[] $resortedRight;
            final /* synthetic */ int $rdBlockSize;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Function1<? super Function0<Unit>, Unit> body) {
                Intrinsics.checkParameterIsNotNull(body, (String)"body");
                int n = 0;
                int n2 = this.$rBlockInRow;
                while (n < n2) {
                    void rdCol;
                    void rightIdx = rdCol * this.$t;
                    void destIdx = rdCol * this.$n;
                    body.invoke((Object)new Function0<Unit>(this, (int)destIdx, (int)rightIdx){
                        final /* synthetic */ dot.1 this$0;
                        final /* synthetic */ int $destIdx;
                        final /* synthetic */ int $rightIdx;

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            int n = 0;
                            int n2 = this.this$0.$n;
                            while (n < n2) {
                                void i;
                                PrimitiveArray destBlock = this.this$0.$resortedDest[this.$destIdx + i];
                                int n3 = 0;
                                int n4 = this.this$0.$lBlockInRow;
                                while (n3 < n4) {
                                    void lCol;
                                    PrimitiveArray leftBlock = this.this$0.$resortedLeft[i + lCol * this.this$0.$n];
                                    int rightIdxOffset = this.$rightIdx + this.this$0.$lBlockSize * lCol;
                                    int n5 = 0;
                                    int n6 = this.this$0.$lBlockSize;
                                    while (n5 < n6) {
                                        void k;
                                        PrimitiveType temp = leftBlock.get((int)k);
                                        PrimitiveArray rightBlock = this.this$0.$resortedRight[rightIdxOffset + k];
                                        int n7 = 0;
                                        int n8 = this.this$0.$rdBlockSize;
                                        while (n7 < n8) {
                                            void j;
                                            destBlock.set((int)j, destBlock.get((int)j).plus(temp.times(rightBlock.get((int)j))).toPrimitive());
                                            ++j;
                                        }
                                        ++k;
                                    }
                                    ++lCol;
                                }
                                ++i;
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$destIdx = n;
                            this.$rightIdx = n2;
                            super(0);
                        }
                    });
                    ++rdCol;
                }
            }

            public static /* synthetic */ void invoke$default(dot.1 var0, Function1 function1, int n, Object object) {
                if ((n & 1) != 0) {
                    function1 = dot.1.INSTANCE;
                }
                var0.invoke((Function1<? super Function0<Unit>, Unit>)function1);
            }
            {
                this.$rBlockInRow = n;
                this.$t = n2;
                this.$n = n3;
                this.$resortedDest = primitiveArrayArray;
                this.$lBlockInRow = n4;
                this.$resortedLeft = primitiveArrayArray2;
                this.$lBlockSize = n5;
                this.$resortedRight = primitiveArrayArray3;
                this.$rdBlockSize = n6;
                super(1);
            }
        };
        if (rBlockInRow > 1) {
            BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($fun$wrapper$1, null){
                private CoroutineScope p$;
                int label;
                final /* synthetic */ dot.1 $wrapper$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$runBlocking = this.p$;
                            this.$wrapper$1.invoke((Function1<? super Function0<Unit>, Unit>)((Function1)new Function1<Function0<? extends Unit>, Unit>($this$runBlocking){
                                final /* synthetic */ CoroutineScope $this_runBlocking;

                                public final void invoke(@NotNull Function0<Unit> it) {
                                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                                    BuildersKt.launch$default((CoroutineScope)this.$this_runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null){
                                        private CoroutineScope p$;
                                        int label;
                                        final /* synthetic */ Function0 $it;

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object $result) {
                                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    CoroutineScope $this$launch = this.p$;
                                                    this.$it.invoke();
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }
                                        {
                                            this.$it = function0;
                                            super(2, continuation);
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                            Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                            CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                            return function2;
                                        }

                                        public final Object invoke(Object object, Object object2) {
                                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                }
                                {
                                    this.$this_runBlocking = coroutineScope;
                                    super(1);
                                }
                            }));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$wrapper$1 = var1_1;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else {
            dot.1.invoke$default($fun$wrapper$1, null, 1, null);
        }
        return destination;
    }

    @Override
    @NotNull
    public MutableNumberNDArray dotTransposedWithAlpha(double alpha, @NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        PrimitiveNDArray cfr_ignored_0 = (PrimitiveNDArray)other;
        MutablePrimitiveNDArray cfr_ignored_1 = (MutablePrimitiveNDArray)destination;
        PrimitiveType alpha2 = PrimitiveTypeKt.toPrimitive((Number)alpha);
        int dRowsNum = destination.getShape()[0];
        int dBlocksInRow = ((MutablePrimitiveNDArray)destination).getBlocksInRow();
        int lrBlocksInRow = this.getBlocksInRow();
        int dBlockSize = ((MutablePrimitiveNDArray)destination).getArray().getBlockSize();
        int lrBlockSize = this.array.getBlockSize();
        PrimitiveArray[] dBlocks = ((MutablePrimitiveNDArray)destination).getArray().getBlocks();
        PrimitiveArray[] lBlocks = this.array.getBlocks();
        PrimitiveArray[] rBlocks = ((PrimitiveNDArray)other).array.getBlocks();
        Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit> $fun$wrapper$1 = new Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit>(dRowsNum, dBlocksInRow, lrBlocksInRow, dBlocks, dBlockSize, lBlocks, rBlocks, lrBlockSize, alpha2){
            final /* synthetic */ int $dRowsNum;
            final /* synthetic */ int $dBlocksInRow;
            final /* synthetic */ int $lrBlocksInRow;
            final /* synthetic */ PrimitiveArray[] $dBlocks;
            final /* synthetic */ int $dBlockSize;
            final /* synthetic */ PrimitiveArray[] $lBlocks;
            final /* synthetic */ PrimitiveArray[] $rBlocks;
            final /* synthetic */ int $lrBlockSize;
            final /* synthetic */ PrimitiveType $alpha;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Function1<? super Function0<Unit>, Unit> body) {
                Intrinsics.checkParameterIsNotNull(body, (String)"body");
                int n = 0;
                int n2 = this.$dRowsNum;
                while (n < n2) {
                    void dRow;
                    int rRow = 0;
                    void dBlockOffset = dRow * this.$dBlocksInRow;
                    void lBlockOffset = dRow * this.$lrBlocksInRow;
                    int n3 = 0;
                    int n4 = this.$dBlocksInRow;
                    while (n3 < n4) {
                        void dBlockInRow;
                        PrimitiveArray dBlock = this.$dBlocks[dBlockOffset + dBlockInRow];
                        int rRowOffset = rRow;
                        body.invoke((Object)new Function0<Unit>(this, rRowOffset, (int)lBlockOffset, dBlock){
                            final /* synthetic */ dotTransposedWithAlpha.1 this$0;
                            final /* synthetic */ int $rRowOffset;
                            final /* synthetic */ int $lBlockOffset;
                            final /* synthetic */ PrimitiveArray $dBlock;

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke() {
                                int rBlockOffset = this.$rRowOffset * this.this$0.$lrBlocksInRow;
                                int n = 0;
                                int n2 = this.this$0.$dBlockSize;
                                while (n < n2) {
                                    void dIdx;
                                    int n3 = 0;
                                    int n4 = this.this$0.$lrBlocksInRow;
                                    while (n3 < n4) {
                                        void lrBlockInRow;
                                        PrimitiveArray lBlock = this.this$0.$lBlocks[this.$lBlockOffset + lrBlockInRow];
                                        PrimitiveArray rBlock = this.this$0.$rBlocks[rBlockOffset + lrBlockInRow];
                                        int n5 = 0;
                                        int n6 = this.this$0.$lrBlockSize;
                                        while (n5 < n6) {
                                            void lrIdx;
                                            this.$dBlock.set((int)dIdx, this.$dBlock.get((int)dIdx).plus(this.this$0.$alpha.times(lBlock.get((int)lrIdx)).times(rBlock.get((int)lrIdx))).toPrimitive());
                                            ++lrIdx;
                                        }
                                        ++lrBlockInRow;
                                    }
                                    rBlockOffset += this.this$0.$lrBlocksInRow;
                                    ++dIdx;
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$rRowOffset = n;
                                this.$lBlockOffset = n2;
                                this.$dBlock = primitiveArray;
                                super(0);
                            }
                        });
                        rRow += this.$dBlockSize;
                        ++dBlockInRow;
                    }
                    ++dRow;
                }
            }

            public static /* synthetic */ void invoke$default(dotTransposedWithAlpha.1 var0, Function1 function1, int n, Object object) {
                if ((n & 1) != 0) {
                    function1 = dotTransposedWithAlpha.1.INSTANCE;
                }
                var0.invoke((Function1<? super Function0<Unit>, Unit>)function1);
            }
            {
                this.$dRowsNum = n;
                this.$dBlocksInRow = n2;
                this.$lrBlocksInRow = n3;
                this.$dBlocks = primitiveArrayArray;
                this.$dBlockSize = n4;
                this.$lBlocks = primitiveArrayArray2;
                this.$rBlocks = primitiveArrayArray3;
                this.$lrBlockSize = n5;
                this.$alpha = primitiveType;
                super(1);
            }
        };
        if (((MutablePrimitiveNDArray)destination).getBlocksInRow() > 1) {
            BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($fun$wrapper$1, null){
                private CoroutineScope p$;
                int label;
                final /* synthetic */ dotTransposedWithAlpha.1 $wrapper$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$runBlocking = this.p$;
                            this.$wrapper$1.invoke((Function1<? super Function0<Unit>, Unit>)((Function1)new Function1<Function0<? extends Unit>, Unit>($this$runBlocking){
                                final /* synthetic */ CoroutineScope $this_runBlocking;

                                public final void invoke(@NotNull Function0<Unit> it) {
                                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                                    BuildersKt.launch$default((CoroutineScope)this.$this_runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null){
                                        private CoroutineScope p$;
                                        int label;
                                        final /* synthetic */ Function0 $it;

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object $result) {
                                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    CoroutineScope $this$launch = this.p$;
                                                    this.$it.invoke();
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }
                                        {
                                            this.$it = function0;
                                            super(2, continuation);
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                            Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                            CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                            return function2;
                                        }

                                        public final Object invoke(Object object, Object object2) {
                                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                }
                                {
                                    this.$this_runBlocking = coroutineScope;
                                    super(1);
                                }
                            }));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$wrapper$1 = var1_1;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else {
            dotTransposedWithAlpha.1.invoke$default($fun$wrapper$1, null, 1, null);
        }
        return destination;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNDArray gemm(int m, int n, int k, double alpha, int lda, @NotNull NDArray b, int ldb, double beta, @NotNull MutableNDArray c, int ldc, int aOffset, int bOffset, int cOffset, boolean transposeA, boolean transposeB) {
        int j;
        int n2;
        boolean $i$f$set;
        boolean $i$f$get;
        int i;
        int t;
        PrimitiveType primitiveType;
        Object object;
        int n3;
        int end$iv;
        int $i$f$map;
        int i2;
        int n4;
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        PrimitiveNDArray cfr_ignored_0 = (PrimitiveNDArray)b;
        MutablePrimitiveNDArray cfr_ignored_1 = (MutablePrimitiveNDArray)c;
        PrimitiveType betaPrimitive = PrimitiveTypeKt.toPrimitive((Number)beta);
        PrimitiveType alphaPrimitive = PrimitiveTypeKt.toPrimitive((Number)alpha);
        PrimitivePointer aPointer = PrimitiveTiledArray.pointer$default(this.array, 0, 1, null);
        PrimitivePointer bPointer = PrimitiveTiledArray.pointer$default(((PrimitiveNDArray)b).array, 0, 1, null);
        PrimitivePointer cPointer = PrimitiveTiledArray.pointer$default(((MutablePrimitiveNDArray)c).getArray(), 0, 1, null);
        if (beta != 1.0) {
            int n5 = 0;
            n4 = m;
            while (n5 < n4) {
                int offset$iv;
                PrimitiveArray block$iv;
                cPointer.setLinearIndex(i2 * ldc + cOffset);
                PrimitivePointer $this$map$iv = cPointer;
                $i$f$map = 0;
                for (end$iv = n; end$iv > 0; end$iv -= block$iv.getSize() - offset$iv) {
                    block$iv = $this$map$iv.getCurrentBlock();
                    offset$iv = $this$map$iv.getIndexInBlock();
                    PrimitivePointer this_$iv$iv22 = $this$map$iv;
                    int $i$f$blockIncrement = 0;
                    if (this_$iv$iv22.getBlockNum() < this_$iv$iv22.getArray().getBlocksNum() - 1) {
                        PrimitivePointer primitivePointer = this_$iv$iv22;
                        n3 = primitivePointer.getBlockNum();
                        primitivePointer.setBlockNum(n3 + 1);
                        this_$iv$iv22.setIndexInBlock(0);
                        this_$iv$iv22.setCurrentBlock(this_$iv$iv22.getArray().getBlocks()[this_$iv$iv22.getBlockNum()]);
                    } else {
                        this_$iv$iv22.setIndexInBlock(this_$iv$iv22.getArray().getBlockSize());
                    }
                    int this_$iv$iv22 = offset$iv;
                    n3 = block$iv.getSize();
                    int n6 = offset$iv + end$iv;
                    boolean bl = false;
                    $i$f$blockIncrement = Math.min(n3, n6);
                    while (this_$iv$iv22 < $i$f$blockIncrement) {
                        void it;
                        void index$iv;
                        PrimitiveType primitiveType2 = block$iv.get((int)index$iv);
                        void var50_91 = index$iv++;
                        object = block$iv;
                        boolean bl2 = false;
                        primitiveType = betaPrimitive.times((PrimitiveType)it).toPrimitive();
                        object.set((int)var50_91, primitiveType);
                    }
                }
                ++i2;
            }
        }
        if (transposeA && transposeB) {
            i2 = 0;
            n4 = m;
            while (i2 < n4) {
                int $this$map$iv = 0;
                $i$f$map = n;
                while ($this$map$iv < $i$f$map) {
                    void j2;
                    cPointer.setLinearIndex(t * ldc + j2 + cOffset);
                    end$iv = 0;
                    int block$iv = k;
                    while (end$iv < block$iv) {
                        void this_$iv3;
                        PrimitivePointer this_$iv2;
                        aPointer.setLinearIndex(i * lda + t + aOffset);
                        bPointer.setLinearIndex((int)(j2 * ldb + i + bOffset));
                        PrimitivePointer offset$iv = cPointer;
                        PrimitivePointer index$iv = aPointer;
                        object = alphaPrimitive;
                        $i$f$get = false;
                        PrimitiveType primitiveType3 = this_$iv2.getCurrentBlock().get(this_$iv2.getIndexInBlock());
                        this_$iv2 = bPointer;
                        object = object.times(primitiveType3);
                        $i$f$get = false;
                        primitiveType3 = this_$iv2.getCurrentBlock().get(this_$iv2.getIndexInBlock());
                        this_$iv2 = cPointer;
                        object = object.times(primitiveType3);
                        $i$f$get = false;
                        primitiveType3 = this_$iv2.getCurrentBlock().get(this_$iv2.getIndexInBlock());
                        PrimitiveType value$iv = object.plus(primitiveType3).toPrimitive();
                        $i$f$set = false;
                        this_$iv3.getCurrentBlock().set(this_$iv3.getIndexInBlock(), value$iv);
                        ++i;
                    }
                    ++j2;
                }
                ++t;
            }
        } else if (transposeA) {
            n4 = m;
            for (t = 0; t < n4; ++t) {
                $i$f$map = n;
                for (int j2 = 0; j2 < $i$f$map; ++j2) {
                    cPointer.setLinearIndex(t * ldc + j2 + cOffset);
                    int block$iv = k;
                    for (i = 0; i < block$iv; ++i) {
                        PrimitivePointer this_$iv;
                        aPointer.setLinearIndex(i * lda + t + aOffset);
                        bPointer.setLinearIndex(i * ldb + j2 + bOffset);
                        PrimitivePointer this_$iv3 = cPointer;
                        PrimitivePointer value$iv = aPointer;
                        object = alphaPrimitive;
                        $i$f$get = false;
                        PrimitiveType primitiveType4 = this_$iv.getCurrentBlock().get(this_$iv.getIndexInBlock());
                        this_$iv = bPointer;
                        object = object.times(primitiveType4);
                        $i$f$get = false;
                        primitiveType4 = this_$iv.getCurrentBlock().get(this_$iv.getIndexInBlock());
                        this_$iv = cPointer;
                        object = object.times(primitiveType4);
                        $i$f$get = false;
                        primitiveType4 = this_$iv.getCurrentBlock().get(this_$iv.getIndexInBlock());
                        value$iv = object.plus(primitiveType4).toPrimitive();
                        $i$f$set = false;
                        this_$iv3.getCurrentBlock().set(this_$iv3.getIndexInBlock(), (PrimitiveType)value$iv);
                    }
                }
            }
        } else if (transposeB) {
            n4 = m;
            for (t = 0; t < n4; ++t) {
                int aIdx = t * lda + aOffset;
                cPointer.setLinearIndex(t * ldc + cOffset);
                $i$f$map = 0;
                n2 = n;
                while ($i$f$map < n2) {
                    int $i$f$getAndIncrement;
                    PrimitiveType this_$iv;
                    PrimitiveType primitiveType5;
                    PrimitivePointer primitivePointer;
                    PrimitiveType elementInB;
                    PrimitiveType elementInA;
                    int n7;
                    int end$iv2;
                    aPointer.setLinearIndex(aIdx);
                    bPointer.setLinearIndex(j * ldb + bOffset);
                    PrimitivePointer $this$combine$iv = aPointer;
                    boolean $i$f$combine = false;
                    PrimitivePointer $this$isCompatibleBySize$iv$iv22 = $this$combine$iv;
                    boolean $i$f$isCompatibleBySize = false;
                    boolean $this$isCompatibleBySize$iv$iv22 = $this$isCompatibleBySize$iv$iv22.getArray().getSize() - $this$isCompatibleBySize$iv$iv22.getLinearIndex() >= k && bPointer.getArray().getSize() - bPointer.getLinearIndex() >= k;
                    $i$f$isCompatibleBySize = false;
                    n3 = 0;
                    if (!$this$isCompatibleBySize$iv$iv22) {
                        boolean bl = false;
                        String string = "Pointers not compatible by available elements";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    PrimitivePointer $this$isCompatibleWith$iv$iv = $this$combine$iv;
                    boolean $i$f$isCompatibleWith = false;
                    if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == bPointer.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == bPointer.getArray().getBlockSize()) {
                        int fstOffset$iv;
                        PrimitiveArray fstBlock$iv;
                        for (end$iv2 = k; end$iv2 > 0; end$iv2 -= fstBlock$iv.getSize() - fstOffset$iv) {
                            int bl2;
                            fstBlock$iv = $this$combine$iv.getCurrentBlock();
                            fstOffset$iv = $this$combine$iv.getIndexInBlock();
                            PrimitivePointer this_$iv$iv = $this$combine$iv;
                            boolean $i$f$blockIncrement = false;
                            if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                PrimitivePointer primitivePointer2 = this_$iv$iv;
                                int it = primitivePointer2.getBlockNum();
                                primitivePointer2.setBlockNum(it + 1);
                                this_$iv$iv.setIndexInBlock(0);
                                this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                            } else {
                                this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                            }
                            PrimitiveArray sndBlock$iv = bPointer.getCurrentBlock();
                            PrimitivePointer this_$iv$iv32 = bPointer;
                            int $i$f$blockIncrement2 = 0;
                            if (this_$iv$iv32.getBlockNum() < this_$iv$iv32.getArray().getBlocksNum() - 1) {
                                PrimitivePointer primitivePointer3 = this_$iv$iv32;
                                bl2 = primitivePointer3.getBlockNum();
                                primitivePointer3.setBlockNum(bl2 + 1);
                                this_$iv$iv32.setIndexInBlock(0);
                                this_$iv$iv32.setCurrentBlock(this_$iv$iv32.getArray().getBlocks()[this_$iv$iv32.getBlockNum()]);
                            } else {
                                this_$iv$iv32.setIndexInBlock(this_$iv$iv32.getArray().getBlockSize());
                            }
                            int this_$iv$iv32 = fstOffset$iv;
                            bl2 = fstBlock$iv.getSize();
                            int n8 = fstOffset$iv + end$iv2;
                            n7 = 0;
                            $i$f$blockIncrement2 = Math.min(bl2, n8);
                            while (this_$iv$iv32 < $i$f$blockIncrement2) {
                                void this_$iv4;
                                void index$iv;
                                PrimitiveType primitiveType6 = sndBlock$iv.get((int)index$iv);
                                elementInA = fstBlock$iv.get((int)index$iv);
                                boolean bl = false;
                                PrimitivePointer primitivePointer4 = cPointer;
                                PrimitivePointer primitivePointer5 = cPointer;
                                primitivePointer = alphaPrimitive.times(elementInA).times(elementInB);
                                boolean $i$f$get2 = false;
                                primitiveType5 = this_$iv4.getCurrentBlock().get(this_$iv4.getIndexInBlock());
                                PrimitiveType value$iv = primitivePointer.plus(primitiveType5).toPrimitive();
                                boolean $i$f$set2 = false;
                                this_$iv.getCurrentBlock().set(this_$iv.getIndexInBlock(), value$iv);
                                ++index$iv;
                            }
                        }
                    } else {
                        while (end$iv2 > 0) {
                            void this_$iv5;
                            void this_$iv6;
                            void elementInB2;
                            boolean $i$f$blockIncrement;
                            PrimitivePointer this_$iv$iv = $this$combine$iv;
                            $i$f$getAndIncrement = 0;
                            PrimitiveType value$iv$iv = this_$iv$iv.getCurrentBlock().get(this_$iv$iv.getIndexInBlock());
                            PrimitivePointer this_$iv$iv$iv = this_$iv$iv;
                            boolean $i$f$increment = false;
                            if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                PrimitivePointer primitivePointer6 = this_$iv$iv$iv;
                                int bl2 = primitivePointer6.getIndexInBlock();
                                primitivePointer6.setIndexInBlock(bl2 + 1);
                            } else {
                                PrimitivePointer this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                $i$f$blockIncrement = false;
                                if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    PrimitivePointer primitivePointer7 = this_$iv$iv$iv$iv;
                                    n7 = primitivePointer7.getBlockNum();
                                    primitivePointer7.setBlockNum(n7 + 1);
                                    this_$iv$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            elementInA = value$iv$iv;
                            this_$iv$iv = bPointer;
                            $i$f$getAndIncrement = 0;
                            value$iv$iv = this_$iv$iv.getCurrentBlock().get(this_$iv$iv.getIndexInBlock());
                            this_$iv$iv$iv = this_$iv$iv;
                            $i$f$increment = false;
                            if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                PrimitivePointer primitivePointer8 = this_$iv$iv$iv;
                                int this_$iv$iv$iv$iv = primitivePointer8.getIndexInBlock();
                                primitivePointer8.setIndexInBlock(this_$iv$iv$iv$iv + 1);
                            } else {
                                PrimitivePointer this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                $i$f$blockIncrement = false;
                                if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    PrimitivePointer primitivePointer9 = this_$iv$iv$iv$iv;
                                    n7 = primitivePointer9.getBlockNum();
                                    primitivePointer9.setBlockNum(n7 + 1);
                                    this_$iv$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            this_$iv = elementInB = value$iv$iv;
                            PrimitiveType elementInA2 = elementInA;
                            boolean bl = false;
                            primitivePointer = cPointer;
                            PrimitivePointer $i$f$set2 = cPointer;
                            primitiveType5 = alphaPrimitive.times(elementInA2).times((PrimitiveType)elementInB2);
                            boolean $i$f$get3 = false;
                            PrimitiveType primitiveType7 = this_$iv6.getCurrentBlock().get(this_$iv6.getIndexInBlock());
                            PrimitiveType value$iv = primitiveType5.plus(primitiveType7).toPrimitive();
                            boolean $i$f$set3 = false;
                            this_$iv5.getCurrentBlock().set(this_$iv5.getIndexInBlock(), value$iv);
                            --end$iv2;
                        }
                    }
                    PrimitivePointer this_$iv7 = cPointer;
                    boolean $i$f$increment = false;
                    if (this_$iv7.getIndexInBlock() < this_$iv7.getArray().getBlockSize() - 1) {
                        PrimitivePointer primitivePointer10 = this_$iv7;
                        end$iv2 = primitivePointer10.getIndexInBlock();
                        primitivePointer10.setIndexInBlock(end$iv2 + 1);
                    } else {
                        PrimitivePointer this_$iv$iv = this_$iv7;
                        boolean $i$f$blockIncrement = false;
                        if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                            PrimitivePointer primitivePointer11 = this_$iv$iv;
                            $i$f$getAndIncrement = primitivePointer11.getBlockNum();
                            primitivePointer11.setBlockNum($i$f$getAndIncrement + 1);
                            this_$iv$iv.setIndexInBlock(0);
                            this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                        }
                    }
                    ++j;
                }
            }
        } else {
            n4 = m;
            for (t = 0; t < n4; ++t) {
                int cIdx = t * ldc + cOffset;
                aPointer.setLinearIndex(t * lda + aOffset);
                j = 0;
                n2 = k;
                while (j < n2) {
                    int end$iv3;
                    PrimitivePointer dstBlock$iv;
                    void i3;
                    void this_$iv;
                    PrimitivePointer $i$f$increment = aPointer;
                    object = alphaPrimitive;
                    boolean $i$f$getAndIncrement = false;
                    PrimitiveType value$iv = this_$iv.getCurrentBlock().get(this_$iv.getIndexInBlock());
                    void this_$iv$iv = this_$iv;
                    boolean $i$f$increment22 = false;
                    if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                        void v9 = this_$iv$iv;
                        int this_$iv$iv$iv = v9.getIndexInBlock();
                        v9.setIndexInBlock(this_$iv$iv$iv + 1);
                    } else {
                        void this_$iv$iv$iv = this_$iv$iv;
                        boolean $i$f$blockIncrement = false;
                        if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                            void v10 = this_$iv$iv$iv;
                            int this_$iv$iv$iv$iv = v10.getBlockNum();
                            v10.setBlockNum(this_$iv$iv$iv$iv + 1);
                            this_$iv$iv$iv.setIndexInBlock(0);
                            this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                        }
                    }
                    PrimitiveType primitiveType8 = value$iv;
                    PrimitiveType temp = object.times(primitiveType8).toPrimitive();
                    bPointer.setLinearIndex((int)(i3 * ldb + bOffset));
                    cPointer.setLinearIndex(cIdx);
                    PrimitivePointer $this$accept$iv = cPointer;
                    boolean $i$f$accept = false;
                    PrimitivePointer $this$isCompatibleBySize$iv$iv32 = $this$accept$iv;
                    boolean $i$f$isCompatibleBySize = false;
                    boolean $this$isCompatibleBySize$iv$iv32 = $this$isCompatibleBySize$iv$iv32.getArray().getSize() - $this$isCompatibleBySize$iv$iv32.getLinearIndex() >= n && bPointer.getArray().getSize() - bPointer.getLinearIndex() >= n;
                    $i$f$isCompatibleBySize = false;
                    $i$f$increment22 = false;
                    if (!$this$isCompatibleBySize$iv$iv32) {
                        boolean bl = false;
                        String $i$f$increment22 = "Pointers not compatible by available elements";
                        throw (Throwable)new IllegalArgumentException($i$f$increment22.toString());
                    }
                    PrimitivePointer $this$isCompatibleWith$iv$iv = $this$accept$iv;
                    boolean $i$f$isCompatibleWith = false;
                    if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == bPointer.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == bPointer.getArray().getBlockSize()) {
                        int dstOffset$iv;
                        for (end$iv3 = n; end$iv3 > 0; end$iv3 -= dstBlock$iv.getSize() - dstOffset$iv) {
                            int $i$f$blockIncrement;
                            dstBlock$iv = $this$accept$iv.getCurrentBlock();
                            dstOffset$iv = $this$accept$iv.getIndexInBlock();
                            PrimitivePointer this_$iv$iv2 = $this$accept$iv;
                            boolean $i$f$blockIncrement3 = false;
                            if (this_$iv$iv2.getBlockNum() < this_$iv$iv2.getArray().getBlocksNum() - 1) {
                                PrimitivePointer primitivePointer = this_$iv$iv2;
                                int this_$iv$iv$iv$iv = primitivePointer.getBlockNum();
                                primitivePointer.setBlockNum(this_$iv$iv$iv$iv + 1);
                                this_$iv$iv2.setIndexInBlock(0);
                                this_$iv$iv2.setCurrentBlock(this_$iv$iv2.getArray().getBlocks()[this_$iv$iv2.getBlockNum()]);
                            } else {
                                this_$iv$iv2.setIndexInBlock(this_$iv$iv2.getArray().getBlockSize());
                            }
                            PrimitiveArray srcBlock$iv = bPointer.getCurrentBlock();
                            PrimitivePointer this_$iv$iv42 = bPointer;
                            int $i$f$blockIncrement4 = 0;
                            if (this_$iv$iv42.getBlockNum() < this_$iv$iv42.getArray().getBlocksNum() - 1) {
                                PrimitivePointer primitivePointer = this_$iv$iv42;
                                $i$f$blockIncrement = primitivePointer.getBlockNum();
                                primitivePointer.setBlockNum($i$f$blockIncrement + 1);
                                this_$iv$iv42.setIndexInBlock(0);
                                this_$iv$iv42.setCurrentBlock(this_$iv$iv42.getArray().getBlocks()[this_$iv$iv42.getBlockNum()]);
                            } else {
                                this_$iv$iv42.setIndexInBlock(this_$iv$iv42.getArray().getBlockSize());
                            }
                            int this_$iv$iv42 = dstOffset$iv;
                            $i$f$blockIncrement = dstBlock$iv.getSize();
                            int n9 = dstOffset$iv + end$iv3;
                            boolean elementInB = false;
                            $i$f$blockIncrement4 = Math.min($i$f$blockIncrement, n9);
                            while (this_$iv$iv42 < $i$f$blockIncrement4) {
                                void elementInC;
                                void elementInB3;
                                void index$iv;
                                PrimitiveType elementInA = srcBlock$iv.get((int)index$iv);
                                PrimitiveType elementInA2 = dstBlock$iv.get((int)index$iv);
                                void var50_95 = index$iv++;
                                object = dstBlock$iv;
                                boolean bl = false;
                                primitiveType = temp.times((PrimitiveType)elementInB3).plus((PrimitiveType)elementInC).toPrimitive();
                                object.set((int)var50_95, primitiveType);
                            }
                        }
                    } else {
                        while (end$iv3 > 0) {
                            void elementInB;
                            PrimitiveType primitiveType9;
                            dstBlock$iv = $this$accept$iv;
                            PrimitivePointer this_$iv$iv3 = $this$accept$iv;
                            boolean $i$f$get4 = false;
                            PrimitiveType primitiveType10 = this_$iv$iv3.getCurrentBlock().get(this_$iv$iv3.getIndexInBlock());
                            this_$iv$iv3 = bPointer;
                            boolean $i$f$getAndIncrement2 = false;
                            PrimitiveType value$iv$iv = this_$iv$iv3.getCurrentBlock().get(this_$iv$iv3.getIndexInBlock());
                            PrimitivePointer this_$iv$iv$iv = this_$iv$iv3;
                            boolean $i$f$increment3 = false;
                            if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                PrimitivePointer primitivePointer = this_$iv$iv$iv;
                                int n10 = primitivePointer.getIndexInBlock();
                                primitivePointer.setIndexInBlock(n10 + 1);
                            } else {
                                PrimitivePointer this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                boolean $i$f$blockIncrement = false;
                                if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    PrimitivePointer primitivePointer = this_$iv$iv$iv$iv;
                                    int n11 = primitivePointer.getBlockNum();
                                    primitivePointer.setBlockNum(n11 + 1);
                                    this_$iv$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            PrimitiveType this_$iv5 = primitiveType9 = value$iv$iv;
                            PrimitiveType elementInC = primitiveType10;
                            boolean bl = false;
                            PrimitiveType value$iv$iv2 = temp.times((PrimitiveType)elementInB).plus(elementInC).toPrimitive();
                            int $i$f$set4 = 0;
                            this_$iv$iv4.getCurrentBlock().set(this_$iv$iv4.getIndexInBlock(), value$iv$iv2);
                            PrimitivePointer this_$iv$iv4 = $this$accept$iv;
                            $i$f$increment22 = false;
                            if (this_$iv$iv4.getIndexInBlock() < this_$iv$iv4.getArray().getBlockSize() - 1) {
                                PrimitivePointer primitivePointer = this_$iv$iv4;
                                $i$f$set4 = primitivePointer.getIndexInBlock();
                                primitivePointer.setIndexInBlock($i$f$set4 + 1);
                            } else {
                                PrimitivePointer this_$iv$iv$iv2 = this_$iv$iv4;
                                boolean $i$f$blockIncrement = false;
                                if (this_$iv$iv$iv2.getBlockNum() < this_$iv$iv$iv2.getArray().getBlocksNum() - 1) {
                                    PrimitivePointer primitivePointer = this_$iv$iv$iv2;
                                    int n12 = primitivePointer.getBlockNum();
                                    primitivePointer.setBlockNum(n12 + 1);
                                    this_$iv$iv$iv2.setIndexInBlock(0);
                                    this_$iv$iv$iv2.setCurrentBlock(this_$iv$iv$iv2.getArray().getBlocks()[this_$iv$iv$iv2.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv2.setIndexInBlock(this_$iv$iv$iv2.getArray().getBlockSize());
                                }
                            }
                            --end$iv3;
                        }
                    }
                    ++i3;
                }
            }
        }
        return c;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NDArray[] splitHorizontalByBlocks(int parts) {
        boolean bl = this.getRank() <= 2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.getBlocksInRow() % parts == 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int blocksInRow = this.getBlocksInRow();
        int partBlocksInRow = blocksInRow / parts;
        int blocksInPart = this.getRank() == 1 ? partBlocksInRow : partBlocksInRow * this.getShape()[0];
        int[] nArray = this.getShape();
        boolean bl6 = false;
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)nArray2, (String)"java.util.Arrays.copyOf(this, size)");
        int[] partShape = nArray2;
        int n = ArraysKt.getLastIndex((int[])partShape);
        partShape[n] = partShape[n] / parts;
        Strides partStrides = new Strides(partShape);
        NDArray[] nDArrayArray = new NDArray[parts];
        for (int i = 0; i < parts; ++i) {
            void part;
            int n2 = i;
            int n3 = i;
            NDArray[] nDArrayArray2 = nDArrayArray;
            boolean bl7 = false;
            int partOffset = partBlocksInRow * part;
            int n4 = blocksInPart;
            PrimitiveArray[] primitiveArrayArray = new PrimitiveArray[n4];
            int n5 = 0;
            while (n5 < n4) {
                PrimitiveArray primitiveArray;
                void block;
                int n6 = n5;
                int n7 = n5++;
                PrimitiveArray[] primitiveArrayArray2 = primitiveArrayArray;
                boolean bl8 = false;
                void rowNum = block / partBlocksInRow;
                void colNum = block % partBlocksInRow;
                primitiveArrayArray2[n7] = primitiveArray = this.array.getBlocks()[rowNum * blocksInRow + partOffset + colNum];
            }
            PrimitiveArray[] partBlocks = primitiveArrayArray;
            PrimitiveNDArray primitiveNDArray = new PrimitiveNDArray(new PrimitiveTiledArray(partBlocks), partStrides);
            nDArrayArray2[n3] = primitiveNDArray;
        }
        return nDArrayArray;
    }

    @Override
    @NotNull
    public MutableNDArray copyIfNotMutable() {
        return new MutablePrimitiveNDArray(this.array.copyOf(), this.strides);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PrimitiveNDArray)) {
            return false;
        }
        if (this.getType() != ((PrimitiveNDArray)other).getType()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.strides, (Object)((PrimitiveNDArray)other).strides) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.array, (Object)((PrimitiveNDArray)other).array) ^ true);
    }

    public int hashCode() {
        int result = this.array.hashCode();
        result = 31 * result + this.strides.hashCode();
        result = 31 * result + this.getType().hashCode();
        return result;
    }

    public PrimitiveNDArray(@NotNull PrimitiveTiledArray array, @NotNull Strides strides) {
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        this.array = array;
        this.type = DataType.UNKNOWN;
        this.strides = strides;
    }

    public PrimitiveNDArray(@NotNull int[] shape, int divider) {
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        this(PrimitiveTiledArray.Companion.invoke(shape, divider), new Strides(shape));
    }

    public /* synthetic */ PrimitiveNDArray(int[] nArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(nArray, n);
    }

    public PrimitiveNDArray(@NotNull int[] shape, int divider, @NotNull Function1<? super Integer, PrimitiveType> init) {
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        this(PrimitiveTiledArray.Companion.invoke(shape, divider, init), new Strides(shape));
    }

    public /* synthetic */ PrimitiveNDArray(int[] nArray, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(nArray, n, (Function1<? super Integer, PrimitiveType>)function1);
    }

    public PrimitiveNDArray(@NotNull Strides strides, int divider) {
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        this(PrimitiveTiledArray.Companion.invoke(strides, divider), strides);
    }

    public /* synthetic */ PrimitiveNDArray(Strides strides, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(strides, n);
    }

    public PrimitiveNDArray(@NotNull Strides strides, int divider, @NotNull Function1<? super Integer, PrimitiveType> init) {
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        this(PrimitiveTiledArray.Companion.invoke(strides, divider, init), strides);
    }

    public /* synthetic */ PrimitiveNDArray(Strides strides, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(strides, n, (Function1<? super Integer, PrimitiveType>)function1);
    }

    @Override
    public int getLinearSize() {
        return NumberNDArray.DefaultImpls.getLinearSize(this);
    }

    @Override
    @NotNull
    public int[] getShape() {
        return NumberNDArray.DefaultImpls.getShape(this);
    }

    @Override
    public int getRank() {
        return NumberNDArray.DefaultImpls.getRank(this);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/kinference/ndarray/arrays/PrimitiveNDArray$Companion;", "", "()V", "scalar", "Lio/kinference/ndarray/arrays/PrimitiveNDArray;", "value", "Lio/kinference/primitives/types/PrimitiveType;", "ndarray"})
    public static final class Companion {
        @NotNull
        public final PrimitiveNDArray scalar(@NotNull PrimitiveType value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return new PrimitiveNDArray(new PrimitiveTiledArray(1, 1, (Function1<? super Integer, PrimitiveType>)((Function1)new Function1<Integer, PrimitiveType>(value){
                final /* synthetic */ PrimitiveType $value;

                @NotNull
                public final PrimitiveType invoke(int it) {
                    return this.$value;
                }
                {
                    this.$value = primitiveType;
                    super(1);
                }
            })), Strides.Companion.getEMPTY());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

