/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays;

import io.kinference.ndarray.Strides;
import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.FloatNDArray;
import io.kinference.ndarray.arrays.IntNDArray;
import io.kinference.ndarray.arrays.LongMap;
import io.kinference.ndarray.arrays.LongNDArray;
import io.kinference.ndarray.arrays.MutableFloatNDArray;
import io.kinference.ndarray.arrays.MutableLongNDArray;
import io.kinference.ndarray.arrays.MutableNDArray;
import io.kinference.ndarray.arrays.MutableNumberNDArray;
import io.kinference.ndarray.arrays.NDArray;
import io.kinference.ndarray.arrays.NumberNDArray;
import io.kinference.ndarray.arrays.PrimitiveToPrimitiveFunction;
import io.kinference.ndarray.arrays.pointers.BytePointer;
import io.kinference.ndarray.arrays.pointers.FloatPointer;
import io.kinference.ndarray.arrays.pointers.IntPointer;
import io.kinference.ndarray.arrays.pointers.LongPointer;
import io.kinference.ndarray.arrays.pointers.UBytePointer;
import io.kinference.ndarray.arrays.tiled.FloatTiledArray;
import io.kinference.ndarray.arrays.tiled.IntTiledArray;
import io.kinference.ndarray.arrays.tiled.LongTiledArray;
import io.kinference.ndarray.extensions.BroadcastingKt;
import io.kinference.ndarray.extensions.GatherKt;
import io.kinference.ndarray.extensions.NDArrayExtensionsKt;
import io.kinference.primitives.types.DataType;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.UByteArray;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0016\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 u2\u00020\u0001:\u0001uB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rB-\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000eB\u0015\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010$\u001a\u00020%H\u0016J \u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016J)\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010,2\u0006\u0010.\u001a\u00020,2\b\u0010'\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010/J\u0011\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020\u0001H\u0096\u0002J\u0018\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J\u0018\u00103\u001a\u00020#2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J \u00104\u001a\u00020#2\u0006\u00105\u001a\u0002062\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J\u0013\u00107\u001a\u00020)2\b\u00101\u001a\u0004\u0018\u000108H\u0096\u0002J\u0015\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u000208H\u0016\u00a2\u0006\u0002\u0010;J\u0080\u0001\u0010<\u001a\u00020%2\u0006\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\u00052\u0006\u0010?\u001a\u00020\u00052\u0006\u00105\u001a\u0002062\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020,2\u0006\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u0002062\u0006\u0010D\u001a\u00020%2\u0006\u0010E\u001a\u00020\u00052\u0006\u0010F\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u00020)2\u0006\u0010J\u001a\u00020)H\u0016J\b\u0010K\u001a\u00020\u0005H\u0016J\u0010\u0010L\u001a\u00020#2\u0006\u0010M\u001a\u00020NH\u0016J\r\u0010O\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010PJ\r\u0010Q\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010PJ\u0011\u0010R\u001a\u00020#2\u0006\u00101\u001a\u00020\u0001H\u0096\u0002J\u0018\u0010R\u001a\u00020#2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J\u0011\u0010S\u001a\u00020#2\u0006\u00101\u001a\u00020\u0001H\u0096\u0002J\u0018\u0010S\u001a\u00020#2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J \u0010T\u001a\u00020U2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010V\u001a\u00020\t2\u0006\u00102\u001a\u00020\u0010H\u0002J\u0010\u0010W\u001a\u00020,2\u0006\u0010X\u001a\u00020\u0003H\u0016J1\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0Z2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020[0Z2\u0006\u0010]\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010^J\u0010\u0010_\u001a\u00020#2\u0006\u0010_\u001a\u00020\u0005H\u0016J\r\u0010`\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010PJH\u0010a\u001a\u00020U2\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020c2\u0006\u0010e\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010f\u001a\u00020\u00032\u0006\u0010g\u001a\u00020\u00032\u0006\u0010h\u001a\u00020\u0003H\u0002J \u0010a\u001a\u00020#2\u0006\u0010f\u001a\u00020\u00032\u0006\u0010g\u001a\u00020\u00032\u0006\u0010h\u001a\u00020\u0003H\u0016J\u001b\u0010i\u001a\b\u0012\u0004\u0012\u00020,0Z2\u0006\u0010j\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010kJ\r\u0010l\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010PJ\u0011\u0010m\u001a\u00020#2\u0006\u00101\u001a\u00020\u0001H\u0096\u0002J\u0018\u0010m\u001a\u00020#2\u0006\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020#H\u0016J \u0010n\u001a\u00020U2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010V\u001a\u00020\t2\u0006\u00102\u001a\u00020\u0010H\u0002J\u0010\u0010o\u001a\u00020#2\u0006\u0010p\u001a\u00020\fH\u0016J\u0014\u0010q\u001a\u00020\u00002\n\u0010r\u001a\u00020\u0003\"\u00020\u0005H\u0016J\u0010\u0010s\u001a\u00020t2\u0006\u0010-\u001a\u00020\u0001H\u0016R$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R$\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006v"}, d2={"Lio/kinference/ndarray/arrays/LongNDArray;", "Lio/kinference/ndarray/arrays/NumberNDArray;", "shape", "", "divider", "", "([II)V", "init", "Lkotlin/Function1;", "", "([IILkotlin/jvm/functions/Function1;)V", "strides", "Lio/kinference/ndarray/Strides;", "(Lio/kinference/ndarray/Strides;I)V", "(Lio/kinference/ndarray/Strides;ILkotlin/jvm/functions/Function1;)V", "array", "Lio/kinference/ndarray/arrays/tiled/LongTiledArray;", "(Lio/kinference/ndarray/arrays/tiled/LongTiledArray;Lio/kinference/ndarray/Strides;)V", "<set-?>", "getArray", "()Lio/kinference/ndarray/arrays/tiled/LongTiledArray;", "setArray", "(Lio/kinference/ndarray/arrays/tiled/LongTiledArray;)V", "blocksInRow", "getBlocksInRow", "()I", "getStrides", "()Lio/kinference/ndarray/Strides;", "setStrides", "(Lio/kinference/ndarray/Strides;)V", "type", "Lio/kinference/primitives/types/DataType;", "getType", "()Lio/kinference/primitives/types/DataType;", "allocateNDArray", "Lio/kinference/ndarray/arrays/MutableNumberNDArray;", "copyIfNotMutable", "Lio/kinference/ndarray/arrays/MutableNDArray;", "cumulativeSum", "axis", "exclusive", "", "reverse", "dequantize", "Lio/kinference/ndarray/arrays/NDArray;", "zeroPoint", "scale", "(Lio/kinference/ndarray/arrays/NDArray;Lio/kinference/ndarray/arrays/NDArray;Ljava/lang/Integer;)Lio/kinference/ndarray/arrays/NDArray;", "div", "other", "destination", "dot", "dotTransposedWithAlpha", "alpha", "", "equals", "", "erfFor", "value", "(Ljava/lang/Object;)Ljava/lang/Long;", "gemm", "m", "n", "k", "lda", "b", "ldb", "beta", "c", "ldc", "aOffset", "bOffset", "cOffset", "transposeA", "transposeB", "hashCode", "map", "function", "Lio/kinference/ndarray/arrays/PrimitiveToPrimitiveFunction;", "max", "()Ljava/lang/Long;", "min", "minus", "plus", "plusScalar", "", "scalar", "reshapeView", "newShape", "resortBlocks", "", "", "blocks", "colSize", "([[JII)[[J", "row", "singleValue", "slice", "dst", "Lio/kinference/ndarray/arrays/pointers/LongPointer;", "src", "offset", "starts", "ends", "steps", "splitHorizontalByBlocks", "parts", "(I)[Lio/kinference/ndarray/arrays/NDArray;", "sum", "times", "timesScalar", "toMutable", "newStrides", "view", "axes", "withZeroPoint", "Lio/kinference/ndarray/arrays/IntNDArray;", "Companion", "ndarray"})
public class LongNDArray
implements NumberNDArray {
    @NotNull
    private LongTiledArray array;
    @NotNull
    private final DataType type;
    @NotNull
    private Strides strides;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final LongTiledArray getArray() {
        return this.array;
    }

    protected final void setArray(@NotNull LongTiledArray longTiledArray) {
        Intrinsics.checkParameterIsNotNull((Object)longTiledArray, (String)"<set-?>");
        this.array = longTiledArray;
    }

    protected final int getBlocksInRow() {
        int n;
        if (this.strides.getLinearSize() == 0) {
            n = 0;
        } else {
            int[] nArray = this.strides.getShape();
            boolean bl = false;
            n = nArray.length == 0 ? 1 : ArraysKt.last((int[])this.strides.getShape()) / this.array.getBlockSize();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LongNDArray view(int ... axes) {
        void $this$foldIndexed$iv;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)axes, (String)"axes");
        int[] nArray = axes;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            void i;
            int axis = nArray[n3];
            boolean bl = this.getShape()[i] > axis;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            n = 0;
            if (!bl) {
                boolean bl4 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ++i;
        }
        int[] axis = axes;
        int initial$iv22 = 0;
        int $i$f$foldIndexed = 0;
        int index$iv = 0;
        int accumulator$iv = initial$iv22;
        for (void element$iv : $this$foldIndexed$iv) {
            void i;
            void acc;
            int n4 = index$iv++;
            void var12_19 = element$iv;
            int n5 = accumulator$iv;
            int index = n4;
            boolean bl = false;
            accumulator$iv = acc + i * this.strides.getStrides()[index];
        }
        int offset = accumulator$iv;
        int[] initial$iv22 = this.getShape();
        $i$f$foldIndexed = axes.length;
        index$iv = this.getShape().length;
        accumulator$iv = 0;
        int[] newShape = ArraysKt.copyOfRange((int[])initial$iv22, (int)$i$f$foldIndexed, (int)index$iv);
        Strides newStrides = new Strides(newShape);
        if (this.array.getBlockSize() == 0) {
            return new LongNDArray(this.array, newStrides);
        }
        int offsetBlocks = offset / this.array.getBlockSize();
        int countBlocks = newStrides.getLinearSize() / this.array.getBlockSize();
        Object[] objectArray = (Object[])this.array.getBlocks();
        n = offsetBlocks + countBlocks;
        int n6 = 0;
        long[][] copyBlocks = (long[][])ArraysKt.copyOfRange((Object[])objectArray, (int)offsetBlocks, (int)n);
        LongTiledArray newArray = new LongTiledArray(copyBlocks);
        return new LongNDArray(newArray, newStrides);
    }

    @Override
    @NotNull
    public DataType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public final Strides getStrides() {
        return this.strides;
    }

    protected final void setStrides(@NotNull Strides strides) {
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"<set-?>");
        this.strides = strides;
    }

    @Override
    @NotNull
    public Long singleValue() {
        boolean bl = NDArrayExtensionsKt.isScalar(this) || this.array.getSize() == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "NDArray contains more than 1 value";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.array.getBlocks()[0][0];
    }

    @Override
    @NotNull
    public MutableNumberNDArray allocateNDArray(@NotNull Strides strides) {
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        return new MutableLongNDArray(LongTiledArray.Companion.invoke$default(LongTiledArray.Companion, strides, 0, 2, null), strides);
    }

    @Override
    @NotNull
    public NDArray reshapeView(@NotNull int[] newShape) {
        Intrinsics.checkParameterIsNotNull((Object)newShape, (String)"newShape");
        Strides newStrides = new Strides(newShape);
        boolean bl = newStrides.getLinearSize() == this.getLinearSize();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new LongNDArray(this.array, newStrides);
    }

    @Override
    @NotNull
    public MutableNumberNDArray toMutable(@NotNull Strides newStrides) {
        Intrinsics.checkParameterIsNotNull((Object)newStrides, (String)"newStrides");
        return new MutableLongNDArray(this.array.copyOf(), newStrides);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNumberNDArray map(@NotNull PrimitiveToPrimitiveFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        LongMap cfr_ignored_0 = (LongMap)function;
        MutableNumberNDArray mutableNumberNDArray = this.allocateNDArray(this.strides);
        if (mutableNumberNDArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.MutableLongNDArray");
        }
        MutableLongNDArray destination = (MutableLongNDArray)mutableNumberNDArray;
        int n = 0;
        int n2 = this.array.getBlocksNum();
        while (n < n2) {
            void blockNum;
            long[] thisBlock = this.array.getBlocks()[blockNum];
            long[] destBlock = destination.getArray().getBlocks()[blockNum];
            int n3 = 0;
            int n4 = thisBlock.length;
            while (n3 < n4) {
                void idx;
                destBlock[idx] = ((LongMap)function).apply(thisBlock[idx]);
                ++idx;
            }
            ++blockNum;
        }
        return destination;
    }

    @Override
    @NotNull
    public Long erfFor(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Long cfr_ignored_0 = (Long)value;
        double d = ((Number)value).longValue();
        boolean bl = false;
        double sign = Math.signum(d);
        double d2 = ((Number)value).longValue();
        boolean bl2 = false;
        double doubleValue = Math.abs(d2);
        double t = 1.0 / (1.0 + 0.3275911 * doubleValue);
        double sum = t * (UtilsKt.getERF_COEF()[0] + t * (UtilsKt.getERF_COEF()[1] + t * (UtilsKt.getERF_COEF()[2] + t * (UtilsKt.getERF_COEF()[3] + t * UtilsKt.getERF_COEF()[4]))));
        double d3 = -doubleValue * doubleValue;
        double d4 = sum;
        double d5 = 1.0;
        double d6 = sign;
        boolean bl3 = false;
        double d7 = Math.exp(d3);
        return (long)(d6 * (d5 - d4 * d7));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public IntNDArray withZeroPoint(@NotNull NumberNDArray zeroPoint) {
        IntNDArray intNDArray;
        IntTiledArray arr;
        block46: {
            int end$iv;
            int[] dstBlock$iv;
            int buf$iv;
            void rec$iv;
            void src$iv;
            void $this$acceptWithRecursive$iv;
            block43: {
                int dstOffset$iv;
                block44: {
                    IntTiledArray arr22;
                    block45: {
                        int end$iv2;
                        int[] dstBlock$iv2;
                        void other$iv2;
                        void $this$accept$iv2;
                        int zero;
                        block41: {
                            int dstOffset$iv2;
                            block42: {
                                block40: {
                                    Intrinsics.checkParameterIsNotNull((Object)zeroPoint, (String)"zeroPoint");
                                    LongNDArray cfr_ignored_0 = (LongNDArray)zeroPoint;
                                    if (zeroPoint.getLinearSize() != 1) break block40;
                                    zero = (int)((LongNDArray)zeroPoint).array.getBlocks()[0][0];
                                    arr22 = IntTiledArray.Companion.invoke$default(IntTiledArray.Companion, this.strides, 0, 2, null);
                                    IntPointer intPointer = IntTiledArray.pointer$default(arr22, 0, 1, null);
                                    LongPointer longPointer = LongTiledArray.pointer$default(this.array, 0, 1, null);
                                    int count$iv = arr22.getSize();
                                    boolean $i$f$accept = false;
                                    void $this$isCompatibleBySize$iv$iv22 = $this$accept$iv2;
                                    boolean $i$f$isCompatibleBySize = false;
                                    boolean $this$isCompatibleBySize$iv$iv22 = $this$isCompatibleBySize$iv$iv22.getArray().getSize() - $this$isCompatibleBySize$iv$iv22.getLinearIndex() >= count$iv && other$iv2.getArray().getSize() - other$iv2.getLinearIndex() >= count$iv;
                                    $i$f$isCompatibleBySize = false;
                                    boolean bl = false;
                                    if (!$this$isCompatibleBySize$iv$iv22) {
                                        boolean bl2 = false;
                                        String string = "Pointers not compatible by available elements";
                                        throw (Throwable)new IllegalArgumentException(string.toString());
                                    }
                                    void $this$isCompatibleWith$iv$iv = $this$accept$iv2;
                                    boolean $i$f$isCompatibleWith = false;
                                    if (!($this$isCompatibleWith$iv$iv.getIndexInBlock() == other$iv2.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == other$iv2.getArray().getBlockSize())) break block41;
                                    break block42;
                                }
                                arr = IntTiledArray.Companion.invoke$default(IntTiledArray.Companion, this.strides, 0, 2, null);
                                IntPointer arr22 = IntTiledArray.pointer$default(arr, 0, 1, null);
                                LongPointer $this$accept$iv2 = LongTiledArray.pointer$default(this.array, 0, 1, null);
                                LongPointer other$iv2 = LongTiledArray.pointer$default(((LongNDArray)zeroPoint).array, 0, 1, null);
                                int count$iv = arr.getSize();
                                boolean $i$f$acceptWithRecursive = false;
                                void $this$isCompatibleBySize$iv$iv32 = $this$acceptWithRecursive$iv;
                                boolean $i$f$isCompatibleBySize = false;
                                boolean $this$isCompatibleBySize$iv$iv32 = $this$isCompatibleBySize$iv$iv32.getArray().getSize() - $this$isCompatibleBySize$iv$iv32.getLinearIndex() >= count$iv && src$iv.getArray().getSize() - src$iv.getLinearIndex() >= count$iv;
                                $i$f$isCompatibleBySize = false;
                                boolean $i$f$increment2 = false;
                                if (!$this$isCompatibleBySize$iv$iv32) {
                                    boolean bl = false;
                                    String $i$f$increment2 = "Pointers not compatible by available elements";
                                    throw (Throwable)new IllegalArgumentException($i$f$increment2.toString());
                                }
                                buf$iv = rec$iv.getLinearIndex();
                                void $this$isCompatibleWith$iv$iv = $this$acceptWithRecursive$iv;
                                boolean $i$f$isCompatibleWith = false;
                                if (!($this$isCompatibleWith$iv$iv.getIndexInBlock() == src$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == src$iv.getArray().getBlockSize())) break block43;
                                $this$isCompatibleWith$iv$iv = $this$acceptWithRecursive$iv;
                                $i$f$isCompatibleWith = false;
                                if (!($this$isCompatibleWith$iv$iv.getIndexInBlock() == rec$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == rec$iv.getArray().getBlockSize())) break block43;
                                break block44;
                            }
                            for (end$iv2 = count$iv; end$iv2 > 0; end$iv2 -= dstBlock$iv2.length - dstOffset$iv2) {
                                int n;
                                dstBlock$iv2 = $this$accept$iv2.getCurrentBlock();
                                dstOffset$iv2 = $this$accept$iv2.getIndexInBlock();
                                void this_$iv$iv = $this$accept$iv2;
                                boolean $i$f$blockIncrement = false;
                                if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                    void v0 = this_$iv$iv;
                                    int n2 = v0.getBlockNum();
                                    v0.setBlockNum(n2 + 1);
                                    this_$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                                }
                                long[] srcBlock$iv = other$iv2.getCurrentBlock();
                                void this_$iv$iv22 = other$iv2;
                                int $i$f$blockIncrement2 = 0;
                                if (this_$iv$iv22.getBlockNum() < this_$iv$iv22.getArray().getBlocksNum() - 1) {
                                    void v1 = this_$iv$iv22;
                                    n = v1.getBlockNum();
                                    v1.setBlockNum(n + 1);
                                    this_$iv$iv22.setIndexInBlock(0);
                                    this_$iv$iv22.setCurrentBlock(this_$iv$iv22.getArray().getBlocks()[this_$iv$iv22.getBlockNum()]);
                                } else {
                                    this_$iv$iv22.setIndexInBlock(this_$iv$iv22.getArray().getBlockSize());
                                }
                                int this_$iv$iv22 = dstOffset$iv2;
                                n = dstBlock$iv2.length;
                                int n3 = dstOffset$iv2 + end$iv2;
                                boolean bl = false;
                                $i$f$blockIncrement2 = Math.min(n, n3);
                                while (this_$iv$iv22 < $i$f$blockIncrement2) {
                                    void src3;
                                    int n4;
                                    void index$iv;
                                    long l = srcBlock$iv[index$iv];
                                    int n5 = dstBlock$iv2[index$iv];
                                    void var39_37 = index$iv++;
                                    int[] nArray = dstBlock$iv2;
                                    boolean bl3 = false;
                                    nArray[var39_37] = n4 = (int)src3 - zero;
                                }
                            }
                            break block45;
                        }
                        while (end$iv2 > 0) {
                            void src;
                            long l;
                            dstBlock$iv2 = $this$accept$iv2;
                            void this_$iv$iv = $this$accept$iv2;
                            boolean $i$f$get = false;
                            int n = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                            this_$iv$iv = other$iv2;
                            boolean $i$f$getAndIncrement = false;
                            long value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                            void this_$iv$iv$iv = this_$iv$iv;
                            boolean $i$f$increment = false;
                            if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                void v2 = this_$iv$iv$iv;
                                int n6 = v2.getIndexInBlock();
                                v2.setIndexInBlock(n6 + 1);
                            } else {
                                void this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                boolean $i$f$blockIncrement = false;
                                if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    void v3 = this_$iv$iv$iv$iv;
                                    int n7 = v3.getBlockNum();
                                    v3.setBlockNum(n7 + 1);
                                    this_$iv$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            long l2 = l = value$iv$iv;
                            int $noName_0 = n;
                            boolean bl = false;
                            int value$iv$iv2 = (int)src - zero;
                            int $i$f$set = 0;
                            this_$iv$iv2.getCurrentBlock()[this_$iv$iv2.getIndexInBlock()] = value$iv$iv2;
                            void this_$iv$iv2 = $this$accept$iv2;
                            boolean $i$f$increment2 = false;
                            if (this_$iv$iv2.getIndexInBlock() < this_$iv$iv2.getArray().getBlockSize() - 1) {
                                void v4 = this_$iv$iv2;
                                $i$f$set = v4.getIndexInBlock();
                                v4.setIndexInBlock($i$f$set + 1);
                            } else {
                                void this_$iv$iv$iv2 = this_$iv$iv2;
                                boolean $i$f$blockIncrement = false;
                                if (this_$iv$iv$iv2.getBlockNum() < this_$iv$iv$iv2.getArray().getBlocksNum() - 1) {
                                    void v5 = this_$iv$iv$iv2;
                                    int $i$f$blockIncrement2 = v5.getBlockNum();
                                    v5.setBlockNum($i$f$blockIncrement2 + 1);
                                    this_$iv$iv$iv2.setIndexInBlock(0);
                                    this_$iv$iv$iv2.setCurrentBlock(this_$iv$iv$iv2.getArray().getBlocks()[this_$iv$iv$iv2.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv2.setIndexInBlock(this_$iv$iv$iv2.getArray().getBlockSize());
                                }
                            }
                            --end$iv2;
                        }
                    }
                    intNDArray = new IntNDArray(arr22, this.strides);
                    return intNDArray;
                }
                for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                    int this_$iv$iv$iv$iv;
                    if (!rec$iv.isValid()) {
                        rec$iv.setLinearIndex(buf$iv);
                    }
                    dstBlock$iv = $this$acceptWithRecursive$iv.getCurrentBlock();
                    dstOffset$iv = $this$acceptWithRecursive$iv.getIndexInBlock();
                    void this_$iv$iv = $this$acceptWithRecursive$iv;
                    boolean $i$f$blockIncrement = false;
                    if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                        void v7 = this_$iv$iv;
                        int this_$iv$iv$iv = v7.getBlockNum();
                        v7.setBlockNum(this_$iv$iv$iv + 1);
                        this_$iv$iv.setIndexInBlock(0);
                        this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                    } else {
                        this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                    }
                    long[] srcBlock$iv = src$iv.getCurrentBlock();
                    void this_$iv$iv3 = src$iv;
                    boolean $i$f$blockIncrement3 = false;
                    if (this_$iv$iv3.getBlockNum() < this_$iv$iv3.getArray().getBlocksNum() - 1) {
                        void v8 = this_$iv$iv3;
                        int $i$f$increment = v8.getBlockNum();
                        v8.setBlockNum($i$f$increment + 1);
                        this_$iv$iv3.setIndexInBlock(0);
                        this_$iv$iv3.setCurrentBlock(this_$iv$iv3.getArray().getBlocks()[this_$iv$iv3.getBlockNum()]);
                    } else {
                        this_$iv$iv3.setIndexInBlock(this_$iv$iv3.getArray().getBlockSize());
                    }
                    long[] recBlock$iv = rec$iv.getCurrentBlock();
                    void this_$iv$iv322 = rec$iv;
                    int $i$f$blockIncrement4 = 0;
                    if (this_$iv$iv322.getBlockNum() < this_$iv$iv322.getArray().getBlocksNum() - 1) {
                        void v9 = this_$iv$iv322;
                        this_$iv$iv$iv$iv = v9.getBlockNum();
                        v9.setBlockNum(this_$iv$iv$iv$iv + 1);
                        this_$iv$iv322.setIndexInBlock(0);
                        this_$iv$iv322.setCurrentBlock(this_$iv$iv322.getArray().getBlocks()[this_$iv$iv322.getBlockNum()]);
                    } else {
                        this_$iv$iv322.setIndexInBlock(this_$iv$iv322.getArray().getBlockSize());
                    }
                    int this_$iv$iv322 = dstOffset$iv;
                    this_$iv$iv$iv$iv = dstBlock$iv.length;
                    int src3 = dstOffset$iv + end$iv;
                    boolean bl = false;
                    $i$f$blockIncrement4 = Math.min(this_$iv$iv$iv$iv, src3);
                    while (this_$iv$iv322 < $i$f$blockIncrement4) {
                        void zero;
                        void src2;
                        int n;
                        void index$iv;
                        long $noName_0 = recBlock$iv[index$iv];
                        long l = srcBlock$iv[index$iv];
                        int n8 = dstBlock$iv[index$iv];
                        void var39_38 = index$iv++;
                        int[] nArray = dstBlock$iv;
                        boolean bl4 = false;
                        nArray[var39_38] = n = (int)src2 - (int)zero;
                    }
                }
                break block46;
            }
            while (end$iv > 0) {
                void zero;
                void src;
                long l;
                int n;
                boolean $i$f$blockIncrement;
                if (!rec$iv.isValid()) {
                    rec$iv.setLinearIndex(buf$iv);
                }
                dstBlock$iv = $this$acceptWithRecursive$iv;
                void this_$iv$iv = $this$acceptWithRecursive$iv;
                boolean $i$f$get = false;
                int n9 = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                this_$iv$iv = src$iv;
                boolean $i$f$getAndIncrement = false;
                long value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$increment = false;
                if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                    void v10 = this_$iv$iv$iv;
                    int src3 = v10.getIndexInBlock();
                    v10.setIndexInBlock(src3 + 1);
                } else {
                    void this_$iv$iv$iv$iv = this_$iv$iv$iv;
                    $i$f$blockIncrement = false;
                    if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                        void v11 = this_$iv$iv$iv$iv;
                        n = v11.getBlockNum();
                        v11.setBlockNum(n + 1);
                        this_$iv$iv$iv$iv.setIndexInBlock(0);
                        this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                    } else {
                        this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                    }
                }
                long l3 = value$iv$iv;
                this_$iv$iv = rec$iv;
                long l4 = l3;
                $i$f$getAndIncrement = false;
                value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                this_$iv$iv$iv = this_$iv$iv;
                $i$f$increment = false;
                if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                    void v12 = this_$iv$iv$iv;
                    int this_$iv$iv$iv$iv = v12.getIndexInBlock();
                    v12.setIndexInBlock(this_$iv$iv$iv$iv + 1);
                } else {
                    void this_$iv$iv$iv$iv = this_$iv$iv$iv;
                    $i$f$blockIncrement = false;
                    if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                        void v13 = this_$iv$iv$iv$iv;
                        n = v13.getBlockNum();
                        v13.setBlockNum(n + 1);
                        this_$iv$iv$iv$iv.setIndexInBlock(0);
                        this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                    } else {
                        this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                    }
                }
                long bl = l = value$iv$iv;
                long l5 = l4;
                int $noName_0 = n9;
                boolean bl5 = false;
                int value$iv$iv3 = (int)src - (int)zero;
                int $i$f$set = 0;
                this_$iv$iv4.getCurrentBlock()[this_$iv$iv4.getIndexInBlock()] = value$iv$iv3;
                void this_$iv$iv4 = $this$acceptWithRecursive$iv;
                boolean $i$f$increment3 = false;
                if (this_$iv$iv4.getIndexInBlock() < this_$iv$iv4.getArray().getBlockSize() - 1) {
                    void v14 = this_$iv$iv4;
                    $i$f$set = v14.getIndexInBlock();
                    v14.setIndexInBlock($i$f$set + 1);
                } else {
                    void this_$iv$iv$iv3 = this_$iv$iv4;
                    boolean $i$f$blockIncrement5 = false;
                    if (this_$iv$iv$iv3.getBlockNum() < this_$iv$iv$iv3.getArray().getBlocksNum() - 1) {
                        void v15 = this_$iv$iv$iv3;
                        int n10 = v15.getBlockNum();
                        v15.setBlockNum(n10 + 1);
                        this_$iv$iv$iv3.setIndexInBlock(0);
                        this_$iv$iv$iv3.setCurrentBlock(this_$iv$iv$iv3.getArray().getBlocks()[this_$iv$iv$iv3.getBlockNum()]);
                    } else {
                        this_$iv$iv$iv3.setIndexInBlock(this_$iv$iv$iv3.getArray().getBlockSize());
                    }
                }
                --end$iv;
            }
        }
        intNDArray = new IntNDArray(arr, this.strides);
        return intNDArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NDArray dequantize(@Nullable NDArray zeroPoint, @NotNull NDArray scale, @Nullable Integer axis) {
        Intrinsics.checkParameterIsNotNull((Object)scale, (String)"scale");
        FloatNDArray cfr_ignored_0 = (FloatNDArray)scale;
        NDArray nDArray = zeroPoint;
        if (!(nDArray instanceof LongNDArray)) {
            nDArray = null;
        }
        LongNDArray longNDArray = (LongNDArray)nDArray;
        LongTiledArray zeros = longNDArray != null ? longNDArray.array : null;
        MutableFloatNDArray output = new MutableFloatNDArray(new FloatTiledArray(this.array.getSize(), this.array.getBlockSize()), this.strides);
        if (NDArrayExtensionsKt.canDequantizePerTensor(zeroPoint, scale)) {
            float zero = zeros == null ? 0.0f : (float)zeros.getBlocks()[0][0];
            float sc = ((FloatNDArray)scale).getArray().getBlocks()[0][0];
            if (this.getType() == DataType.BYTE) {
                int end$iv;
                float[] dstBlock$iv;
                void other$iv;
                void $this$accept$iv;
                FloatPointer floatPointer = FloatTiledArray.pointer$default(output.getArray(), 0, 1, null);
                LongPointer longPointer = LongTiledArray.pointer$default(this.array, 0, 1, null);
                if (longPointer == null) {
                    throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.pointers.BytePointer");
                }
                BytePointer bytePointer = (BytePointer)((Object)longPointer);
                int count$iv = output.getLinearSize();
                boolean $i$f$accept = false;
                void $this$isCompatibleBySize$iv$iv22 = $this$accept$iv;
                boolean $i$f$isCompatibleBySize = false;
                boolean $this$isCompatibleBySize$iv$iv22 = $this$isCompatibleBySize$iv$iv22.getArray().getSize() - $this$isCompatibleBySize$iv$iv22.getLinearIndex() >= count$iv && other$iv.getArray().getSize() - other$iv.getLinearIndex() >= count$iv;
                $i$f$isCompatibleBySize = false;
                boolean bl = false;
                if (!$this$isCompatibleBySize$iv$iv22) {
                    boolean bl2 = false;
                    String string = "Pointers not compatible by available elements";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                void $this$isCompatibleWith$iv$iv = $this$accept$iv;
                boolean $i$f$isCompatibleWith = false;
                if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == other$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == other$iv.getArray().getBlockSize()) {
                    int dstOffset$iv;
                    for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                        int n;
                        dstBlock$iv = $this$accept$iv.getCurrentBlock();
                        dstOffset$iv = $this$accept$iv.getIndexInBlock();
                        void this_$iv$iv = $this$accept$iv;
                        boolean $i$f$blockIncrement = false;
                        if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                            void v3 = this_$iv$iv;
                            int n2 = v3.getBlockNum();
                            v3.setBlockNum(n2 + 1);
                            this_$iv$iv.setIndexInBlock(0);
                            this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                        }
                        byte[] srcBlock$iv = other$iv.getCurrentBlock();
                        void this_$iv$iv22 = other$iv;
                        int $i$f$blockIncrement2 = 0;
                        if (this_$iv$iv22.getBlockNum() < this_$iv$iv22.getArray().getBlocksNum() - 1) {
                            void v4 = this_$iv$iv22;
                            n = v4.getBlockNum();
                            v4.setBlockNum(n + 1);
                            this_$iv$iv22.setIndexInBlock(0);
                            this_$iv$iv22.setCurrentBlock(this_$iv$iv22.getArray().getBlocks()[this_$iv$iv22.getBlockNum()]);
                        } else {
                            this_$iv$iv22.setIndexInBlock(this_$iv$iv22.getArray().getBlockSize());
                        }
                        int this_$iv$iv22 = dstOffset$iv;
                        n = dstBlock$iv.length;
                        int n3 = dstOffset$iv + end$iv;
                        boolean bl3 = false;
                        $i$f$blockIncrement2 = Math.min(n, n3);
                        while (this_$iv$iv22 < $i$f$blockIncrement2) {
                            void src2;
                            float f;
                            void index$iv;
                            byte by = srcBlock$iv[index$iv];
                            float f2 = dstBlock$iv[index$iv];
                            void var50_105 = index$iv++;
                            float[] fArray = dstBlock$iv;
                            boolean bl4 = false;
                            fArray[var50_105] = f = ((float)src2 - zero) * sc;
                        }
                    }
                } else {
                    while (end$iv > 0) {
                        void src;
                        byte src2;
                        dstBlock$iv = $this$accept$iv;
                        void this_$iv$iv = $this$accept$iv;
                        boolean $i$f$get = false;
                        float $noName_0 = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                        this_$iv$iv = other$iv;
                        boolean $i$f$getAndIncrement = false;
                        byte value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                        void this_$iv$iv$iv3 = this_$iv$iv;
                        boolean $i$f$increment = false;
                        if (this_$iv$iv$iv3.getIndexInBlock() < this_$iv$iv$iv3.getArray().getBlockSize() - 1) {
                            void v5 = this_$iv$iv$iv3;
                            int n = v5.getIndexInBlock();
                            v5.setIndexInBlock(n + 1);
                        } else {
                            void this_$iv$iv$iv$iv = this_$iv$iv$iv3;
                            boolean $i$f$blockIncrement4 = false;
                            if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                void v6 = this_$iv$iv$iv$iv;
                                int n = v6.getBlockNum();
                                v6.setBlockNum(n + 1);
                                this_$iv$iv$iv$iv.setIndexInBlock(0);
                                this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                            } else {
                                this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                            }
                        }
                        byte by = src2 = value$iv$iv;
                        float $noName_02 = $noName_0;
                        boolean bl5 = false;
                        float value$iv$iv2 = ((float)src - zero) * sc;
                        int $i$f$set = 0;
                        this_$iv$iv2.getCurrentBlock()[this_$iv$iv2.getIndexInBlock()] = value$iv$iv2;
                        void this_$iv$iv2 = $this$accept$iv;
                        boolean $i$f$increment22 = false;
                        if (this_$iv$iv2.getIndexInBlock() < this_$iv$iv2.getArray().getBlockSize() - 1) {
                            void v7 = this_$iv$iv2;
                            $i$f$set = v7.getIndexInBlock();
                            v7.setIndexInBlock($i$f$set + 1);
                        } else {
                            void this_$iv$iv$iv2 = this_$iv$iv2;
                            boolean $i$f$blockIncrement = false;
                            if (this_$iv$iv$iv2.getBlockNum() < this_$iv$iv$iv2.getArray().getBlocksNum() - 1) {
                                void v8 = this_$iv$iv$iv2;
                                int this_$iv$iv$iv3 = v8.getBlockNum();
                                v8.setBlockNum(this_$iv$iv$iv3 + 1);
                                this_$iv$iv$iv2.setIndexInBlock(0);
                                this_$iv$iv$iv2.setCurrentBlock(this_$iv$iv$iv2.getArray().getBlocks()[this_$iv$iv$iv2.getBlockNum()]);
                            } else {
                                this_$iv$iv$iv2.setIndexInBlock(this_$iv$iv$iv2.getArray().getBlockSize());
                            }
                        }
                        --end$iv;
                    }
                }
            } else {
                int end$iv;
                Object dstBlock$iv;
                FloatPointer $this$accept$iv = FloatTiledArray.pointer$default(output.getArray(), 0, 1, null);
                LongPointer longPointer = LongTiledArray.pointer$default(this.array, 0, 1, null);
                if (longPointer == null) {
                    throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.pointers.UBytePointer");
                }
                UBytePointer other$iv = (UBytePointer)((Object)longPointer);
                int count$iv = output.getLinearSize();
                boolean $i$f$accept = false;
                FloatPointer $this$isCompatibleBySize$iv$iv32 = $this$accept$iv;
                boolean $i$f$isCompatibleBySize = false;
                boolean $this$isCompatibleBySize$iv$iv32 = $this$isCompatibleBySize$iv$iv32.getArray().getSize() - $this$isCompatibleBySize$iv$iv32.getLinearIndex() >= count$iv && other$iv.getArray().getSize() - other$iv.getLinearIndex() >= count$iv;
                $i$f$isCompatibleBySize = false;
                boolean $i$f$increment22 = false;
                if (!$this$isCompatibleBySize$iv$iv32) {
                    boolean bl = false;
                    String $i$f$increment22 = "Pointers not compatible by available elements";
                    throw (Throwable)new IllegalArgumentException($i$f$increment22.toString());
                }
                FloatPointer $this$isCompatibleWith$iv$iv = $this$accept$iv;
                boolean $i$f$isCompatibleWith = false;
                if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == other$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == other$iv.getArray().getBlockSize()) {
                    int dstOffset$iv;
                    for (end$iv = count$iv; end$iv > 0; end$iv -= ((Object)dstBlock$iv).length - dstOffset$iv) {
                        int $i$f$increment;
                        dstBlock$iv = $this$accept$iv.getCurrentBlock();
                        dstOffset$iv = $this$accept$iv.getIndexInBlock();
                        FloatPointer this_$iv$iv = $this$accept$iv;
                        boolean $i$f$blockIncrement = false;
                        if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                            FloatPointer floatPointer = this_$iv$iv;
                            int this_$iv$iv$iv3 = floatPointer.getBlockNum();
                            floatPointer.setBlockNum(this_$iv$iv$iv3 + 1);
                            this_$iv$iv.setIndexInBlock(0);
                            this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                        }
                        byte[] srcBlock$iv = other$iv.getCurrentBlock();
                        UBytePointer this_$iv$iv32 = other$iv;
                        int $i$f$blockIncrement3 = 0;
                        if (this_$iv$iv32.getBlockNum() < this_$iv$iv32.getArray().getBlocksNum() - 1) {
                            UBytePointer uBytePointer = this_$iv$iv32;
                            $i$f$increment = uBytePointer.getBlockNum();
                            uBytePointer.setBlockNum($i$f$increment + 1);
                            this_$iv$iv32.setIndexInBlock(0);
                            this_$iv$iv32.setCurrentBlock-GBYM_sE(this_$iv$iv32.getArray().getBlocks()[this_$iv$iv32.getBlockNum()].unbox-impl());
                        } else {
                            this_$iv$iv32.setIndexInBlock(this_$iv$iv32.getArray().getBlockSize());
                        }
                        int this_$iv$iv32 = dstOffset$iv;
                        $i$f$increment = ((Object)dstBlock$iv).length;
                        int this_$iv$iv$iv$iv = dstOffset$iv + end$iv;
                        boolean $i$f$blockIncrement4 = false;
                        $i$f$blockIncrement3 = Math.min($i$f$increment, this_$iv$iv$iv$iv);
                        while (this_$iv$iv32 < $i$f$blockIncrement3) {
                            void index$iv;
                            byte src2 = UByteArray.get-impl((byte[])srcBlock$iv, (int)index$iv);
                            Object $noName_0 = dstBlock$iv[index$iv];
                            void var50_106 = index$iv++;
                            Object object = dstBlock$iv;
                            boolean bl = false;
                            byte by = src2;
                            boolean src = false;
                            byte bl5 = by;
                            boolean bl6 = false;
                            float f = ((float)(bl5 & 0xFF) - zero) * sc;
                            object[var50_106] = f;
                        }
                    }
                } else {
                    while (end$iv > 0) {
                        void src;
                        byte src3;
                        dstBlock$iv = $this$accept$iv;
                        Object this_$iv$iv = $this$accept$iv;
                        boolean $i$f$get = false;
                        float f = ((FloatPointer)this_$iv$iv).getCurrentBlock()[((FloatPointer)this_$iv$iv).getIndexInBlock()];
                        this_$iv$iv = other$iv;
                        boolean $i$f$getAndIncrement = false;
                        byte value$iv$iv = UByteArray.get-impl((byte[])((UBytePointer)this_$iv$iv).getCurrentBlock(), (int)((UBytePointer)this_$iv$iv).getIndexInBlock());
                        Object this_$iv$iv$iv5 = this_$iv$iv;
                        boolean $i$f$increment = false;
                        if (((UBytePointer)this_$iv$iv$iv5).getIndexInBlock() < ((UBytePointer)this_$iv$iv$iv5).getArray().getBlockSize() - 1) {
                            Object object = this_$iv$iv$iv5;
                            int this_$iv$iv$iv$iv = ((UBytePointer)object).getIndexInBlock();
                            ((UBytePointer)object).setIndexInBlock(this_$iv$iv$iv$iv + 1);
                        } else {
                            Object this_$iv$iv$iv$iv = this_$iv$iv$iv5;
                            boolean $i$f$blockIncrement = false;
                            if (((UBytePointer)this_$iv$iv$iv$iv).getBlockNum() < ((UBytePointer)this_$iv$iv$iv$iv).getArray().getBlocksNum() - 1) {
                                Object object = this_$iv$iv$iv$iv;
                                int n = ((UBytePointer)object).getBlockNum();
                                ((UBytePointer)object).setBlockNum(n + 1);
                                ((UBytePointer)this_$iv$iv$iv$iv).setIndexInBlock(0);
                                ((UBytePointer)this_$iv$iv$iv$iv).setCurrentBlock-GBYM_sE(((UBytePointer)this_$iv$iv$iv$iv).getArray().getBlocks()[((UBytePointer)this_$iv$iv$iv$iv).getBlockNum()].unbox-impl());
                            } else {
                                ((UBytePointer)this_$iv$iv$iv$iv).setIndexInBlock(((UBytePointer)this_$iv$iv$iv$iv).getArray().getBlockSize());
                            }
                        }
                        byte by = src3 = value$iv$iv;
                        float $noName_0 = f;
                        boolean bl10 = false;
                        void bl5 = src;
                        boolean bl7 = false;
                        void var29_147 = bl5;
                        boolean bl8 = false;
                        float value$iv$iv3 = ((float)(var29_147 & 0xFF) - zero) * sc;
                        int $i$f$set = 0;
                        this_$iv$iv3.getCurrentBlock()[this_$iv$iv3.getIndexInBlock()] = value$iv$iv3;
                        FloatPointer this_$iv$iv3 = $this$accept$iv;
                        $i$f$increment22 = false;
                        if (this_$iv$iv3.getIndexInBlock() < this_$iv$iv3.getArray().getBlockSize() - 1) {
                            FloatPointer floatPointer = this_$iv$iv3;
                            $i$f$set = floatPointer.getIndexInBlock();
                            floatPointer.setIndexInBlock($i$f$set + 1);
                        } else {
                            FloatPointer this_$iv$iv$iv4 = this_$iv$iv3;
                            boolean $i$f$blockIncrement = false;
                            if (this_$iv$iv$iv4.getBlockNum() < this_$iv$iv$iv4.getArray().getBlocksNum() - 1) {
                                FloatPointer floatPointer = this_$iv$iv$iv4;
                                int this_$iv$iv$iv5 = floatPointer.getBlockNum();
                                floatPointer.setBlockNum(this_$iv$iv$iv5 + 1);
                                this_$iv$iv$iv4.setIndexInBlock(0);
                                this_$iv$iv$iv4.setCurrentBlock(this_$iv$iv$iv4.getArray().getBlocks()[this_$iv$iv$iv4.getBlockNum()]);
                            } else {
                                this_$iv$iv$iv4.setIndexInBlock(this_$iv$iv$iv4.getArray().getBlockSize());
                            }
                        }
                        --end$iv;
                    }
                }
            }
        } else {
            Integer n = axis;
            if (n == null) {
                Intrinsics.throwNpe();
            }
            if (NDArrayExtensionsKt.canDequantizePerAxis(this, n, zeroPoint, scale)) {
                int actualAxis = NDArrayExtensionsKt.indexAxis(this, axis);
                int blockCount = GatherKt.computeBlockSize$default(this, 0, actualAxis, 1, null);
                int blockSize = GatherKt.computeBlockSize$default(this, actualAxis + 1, 0, 2, null);
                int outOffset = 0;
                boolean bl = false;
                int n4 = 0;
                int n5 = blockCount;
                for (n4 = 0; n4 < n5; ++n4) {
                    int it = n4;
                    boolean bl9 = false;
                    LongTiledArray longTiledArray = zeros;
                    LongPointer zeroPointer = longTiledArray != null ? LongTiledArray.pointer$default(longTiledArray, 0, 1, null) : null;
                    FloatPointer scalePointer = FloatTiledArray.pointer$default(((FloatNDArray)scale).getArray(), 0, 1, null);
                    int this_$iv$iv$iv5 = 0;
                    int n6 = this.getShape()[actualAxis];
                    while (this_$iv$iv$iv5 < n6) {
                        void i;
                        boolean $i$f$increment5;
                        FloatPointer this_$iv$iv;
                        boolean src;
                        float $noName_0;
                        int n7;
                        boolean $i$f$blockIncrement;
                        int $i$f$increment3;
                        int value$iv$iv;
                        Object $noName_03;
                        float f;
                        int src4;
                        Object object;
                        void var38_171;
                        Object object2;
                        int n8;
                        void index$iv;
                        int this_$iv$iv42;
                        boolean $i$f$blockIncrement5;
                        int end$iv;
                        int dstOffset$iv;
                        Object dstBlock$iv;
                        boolean $i$f$isCompatibleWith;
                        FloatPointer $this$isCompatibleWith$iv$iv;
                        boolean $this$isCompatibleBySize$iv$iv42;
                        UBytePointer other$iv;
                        FloatPointer $this$accept$iv;
                        boolean $i$f$accept;
                        int count$iv;
                        float f3;
                        int n9;
                        boolean $i$f$blockIncrement6;
                        boolean $i$f$increment4;
                        if (zeroPointer != null) {
                            LongPointer this_$iv;
                            boolean $i$f$getAndIncrement = false;
                            long value$iv = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                            LongPointer this_$iv$iv5 = this_$iv;
                            $i$f$increment4 = false;
                            if (this_$iv$iv5.getIndexInBlock() < this_$iv$iv5.getArray().getBlockSize() - 1) {
                                LongPointer longPointer = this_$iv$iv5;
                                int bl10 = longPointer.getIndexInBlock();
                                longPointer.setIndexInBlock(bl10 + 1);
                            } else {
                                LongPointer this_$iv$iv$iv = this_$iv$iv5;
                                $i$f$blockIncrement6 = false;
                                if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    LongPointer longPointer = this_$iv$iv$iv;
                                    n9 = longPointer.getBlockNum();
                                    longPointer.setBlockNum(n9 + 1);
                                    this_$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            f3 = value$iv;
                        } else {
                            f3 = 0.0f;
                        }
                        float zero = f3;
                        FloatPointer this_$iv = scalePointer;
                        boolean $i$f$getAndIncrement2 = false;
                        float value$iv = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                        FloatPointer this_$iv$iv6 = this_$iv;
                        $i$f$increment4 = false;
                        if (this_$iv$iv6.getIndexInBlock() < this_$iv$iv6.getArray().getBlockSize() - 1) {
                            FloatPointer floatPointer = this_$iv$iv6;
                            int this_$iv$iv$iv = floatPointer.getIndexInBlock();
                            floatPointer.setIndexInBlock(this_$iv$iv$iv + 1);
                        } else {
                            FloatPointer this_$iv$iv$iv = this_$iv$iv6;
                            $i$f$blockIncrement6 = false;
                            if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                FloatPointer floatPointer = this_$iv$iv$iv;
                                n9 = floatPointer.getBlockNum();
                                floatPointer.setBlockNum(n9 + 1);
                                this_$iv$iv$iv.setIndexInBlock(0);
                                this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                            } else {
                                this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                            }
                        }
                        float sc = value$iv;
                        if (this.getType() == DataType.BYTE) {
                            this_$iv = output.getArray().pointer(outOffset);
                            LongPointer longPointer = this.array.pointer(outOffset);
                            if (longPointer == null) {
                                throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.pointers.BytePointer");
                            }
                            BytePointer $i$f$getAndIncrement2 = (BytePointer)((Object)longPointer);
                            count$iv = blockSize;
                            $i$f$accept = false;
                            FloatPointer $this$isCompatibleBySize$iv$iv42 = $this$accept$iv;
                            boolean $i$f$isCompatibleBySize = false;
                            $this$isCompatibleBySize$iv$iv42 = $this$isCompatibleBySize$iv$iv42.getArray().getSize() - $this$isCompatibleBySize$iv$iv42.getLinearIndex() >= count$iv && ((BytePointer)((Object)other$iv)).getArray().getSize() - ((BytePointer)((Object)other$iv)).getLinearIndex() >= count$iv;
                            $i$f$isCompatibleBySize = false;
                            $i$f$blockIncrement6 = false;
                            if (!$this$isCompatibleBySize$iv$iv42) {
                                boolean bl11 = false;
                                String $i$f$blockIncrement7 = "Pointers not compatible by available elements";
                                throw (Throwable)new IllegalArgumentException($i$f$blockIncrement7.toString());
                            }
                            $this$isCompatibleWith$iv$iv = $this$accept$iv;
                            $i$f$isCompatibleWith = false;
                            if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == ((BytePointer)((Object)other$iv)).getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == ((BytePointer)((Object)other$iv)).getArray().getBlockSize()) {
                                for (end$iv = count$iv; end$iv > 0; end$iv -= ((Object)dstBlock$iv).length - dstOffset$iv) {
                                    int n10;
                                    dstBlock$iv = $this$accept$iv.getCurrentBlock();
                                    dstOffset$iv = $this$accept$iv.getIndexInBlock();
                                    FloatPointer this_$iv$iv7 = $this$accept$iv;
                                    $i$f$blockIncrement5 = false;
                                    if (this_$iv$iv7.getBlockNum() < this_$iv$iv7.getArray().getBlocksNum() - 1) {
                                        FloatPointer floatPointer = this_$iv$iv7;
                                        int n11 = floatPointer.getBlockNum();
                                        floatPointer.setBlockNum(n11 + 1);
                                        this_$iv$iv7.setIndexInBlock(0);
                                        this_$iv$iv7.setCurrentBlock(this_$iv$iv7.getArray().getBlocks()[this_$iv$iv7.getBlockNum()]);
                                    } else {
                                        this_$iv$iv7.setIndexInBlock(this_$iv$iv7.getArray().getBlockSize());
                                    }
                                    byte[] srcBlock$iv = ((BytePointer)((Object)other$iv)).getCurrentBlock();
                                    UBytePointer this_$iv$iv42 = other$iv;
                                    int $i$f$blockIncrement8 = 0;
                                    if (((BytePointer)((Object)this_$iv$iv42)).getBlockNum() < ((BytePointer)((Object)this_$iv$iv42)).getArray().getBlocksNum() - 1) {
                                        UBytePointer uBytePointer = this_$iv$iv42;
                                        n10 = ((BytePointer)((Object)uBytePointer)).getBlockNum();
                                        ((BytePointer)((Object)uBytePointer)).setBlockNum(n10 + 1);
                                        ((BytePointer)((Object)this_$iv$iv42)).setIndexInBlock(0);
                                        ((BytePointer)((Object)this_$iv$iv42)).setCurrentBlock(((BytePointer)((Object)this_$iv$iv42)).getArray().getBlocks()[((BytePointer)((Object)this_$iv$iv42)).getBlockNum()]);
                                    } else {
                                        ((BytePointer)((Object)this_$iv$iv42)).setIndexInBlock(((BytePointer)((Object)this_$iv$iv42)).getArray().getBlockSize());
                                    }
                                    this_$iv$iv42 = dstOffset$iv;
                                    n10 = ((Object)dstBlock$iv).length;
                                    int n12 = dstOffset$iv + end$iv;
                                    boolean bl12 = false;
                                    $i$f$blockIncrement8 = Math.min(n10, n12);
                                    while (this_$iv$iv42 < $i$f$blockIncrement8) {
                                        n8 = srcBlock$iv[index$iv];
                                        object2 = dstBlock$iv[index$iv];
                                        var38_171 = index$iv++;
                                        object = dstBlock$iv;
                                        boolean bl13 = false;
                                        f = ((float)src4 - zero) * sc;
                                        object[var38_171] = f;
                                    }
                                }
                            } else {
                                while (end$iv > 0) {
                                    dstBlock$iv = $this$accept$iv;
                                    Object this_$iv$iv8 = $this$accept$iv;
                                    boolean $i$f$get = false;
                                    $noName_03 = ((FloatPointer)this_$iv$iv8).getCurrentBlock()[((FloatPointer)this_$iv$iv8).getIndexInBlock()];
                                    this_$iv$iv8 = other$iv;
                                    boolean $i$f$getAndIncrement3 = false;
                                    value$iv$iv = ((BytePointer)this_$iv$iv8).getCurrentBlock()[((BytePointer)this_$iv$iv8).getIndexInBlock()];
                                    Object this_$iv$iv$iv7 = this_$iv$iv8;
                                    $i$f$increment3 = 0;
                                    if (((BytePointer)this_$iv$iv$iv7).getIndexInBlock() < ((BytePointer)this_$iv$iv$iv7).getArray().getBlockSize() - 1) {
                                        Object object3 = this_$iv$iv$iv7;
                                        int n13 = ((BytePointer)object3).getIndexInBlock();
                                        ((BytePointer)object3).setIndexInBlock(n13 + 1);
                                    } else {
                                        Object this_$iv$iv$iv$iv = this_$iv$iv$iv7;
                                        $i$f$blockIncrement = false;
                                        if (((BytePointer)this_$iv$iv$iv$iv).getBlockNum() < ((BytePointer)this_$iv$iv$iv$iv).getArray().getBlocksNum() - 1) {
                                            Object object4 = this_$iv$iv$iv$iv;
                                            n7 = ((BytePointer)object4).getBlockNum();
                                            ((BytePointer)object4).setBlockNum(n7 + 1);
                                            ((BytePointer)this_$iv$iv$iv$iv).setIndexInBlock(0);
                                            ((BytePointer)this_$iv$iv$iv$iv).setCurrentBlock(((BytePointer)this_$iv$iv$iv$iv).getArray().getBlocks()[((BytePointer)this_$iv$iv$iv$iv).getBlockNum()]);
                                        } else {
                                            ((BytePointer)this_$iv$iv$iv$iv).setIndexInBlock(((BytePointer)this_$iv$iv$iv$iv).getArray().getBlockSize());
                                        }
                                    }
                                    int n14 = src4 = value$iv$iv;
                                    $noName_0 = $noName_03;
                                    boolean bl14 = false;
                                    float value$iv$iv4 = ((float)src - zero) * sc;
                                    int $i$f$set = 0;
                                    this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()] = value$iv$iv4;
                                    this_$iv$iv = $this$accept$iv;
                                    $i$f$increment5 = false;
                                    if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                                        FloatPointer floatPointer = this_$iv$iv;
                                        $i$f$set = floatPointer.getIndexInBlock();
                                        floatPointer.setIndexInBlock($i$f$set + 1);
                                    } else {
                                        FloatPointer this_$iv$iv$iv6 = this_$iv$iv;
                                        $i$f$blockIncrement5 = false;
                                        if (this_$iv$iv$iv6.getBlockNum() < this_$iv$iv$iv6.getArray().getBlocksNum() - 1) {
                                            FloatPointer floatPointer = this_$iv$iv$iv6;
                                            int this_$iv$iv$iv7 = floatPointer.getBlockNum();
                                            floatPointer.setBlockNum(this_$iv$iv$iv7 + 1);
                                            this_$iv$iv$iv6.setIndexInBlock(0);
                                            this_$iv$iv$iv6.setCurrentBlock(this_$iv$iv$iv6.getArray().getBlocks()[this_$iv$iv$iv6.getBlockNum()]);
                                        } else {
                                            this_$iv$iv$iv6.setIndexInBlock(this_$iv$iv$iv6.getArray().getBlockSize());
                                        }
                                    }
                                    --end$iv;
                                }
                            }
                        } else {
                            boolean bl15;
                            int n15;
                            $this$accept$iv = output.getArray().pointer(outOffset);
                            LongPointer longPointer = this.array.pointer(outOffset);
                            if (longPointer == null) {
                                throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.pointers.UBytePointer");
                            }
                            other$iv = (UBytePointer)((Object)longPointer);
                            count$iv = blockSize;
                            $i$f$accept = false;
                            FloatPointer $this$isCompatibleBySize$iv$iv = $this$accept$iv;
                            boolean $i$f$isCompatibleBySize = false;
                            $this$isCompatibleBySize$iv$iv42 = $this$isCompatibleBySize$iv$iv.getArray().getSize() - $this$isCompatibleBySize$iv$iv.getLinearIndex() >= count$iv && other$iv.getArray().getSize() - other$iv.getLinearIndex() >= count$iv;
                            $i$f$isCompatibleBySize = false;
                            $i$f$increment5 = false;
                            if (!$this$isCompatibleBySize$iv$iv42) {
                                boolean bl16 = false;
                                String $i$f$increment5 = "Pointers not compatible by available elements";
                                throw (Throwable)new IllegalArgumentException($i$f$increment5.toString());
                            }
                            $this$isCompatibleWith$iv$iv = $this$accept$iv;
                            $i$f$isCompatibleWith = false;
                            if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == other$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == other$iv.getArray().getBlockSize()) {
                                for (end$iv = count$iv; end$iv > 0; end$iv -= ((Object)dstBlock$iv).length - dstOffset$iv) {
                                    dstBlock$iv = $this$accept$iv.getCurrentBlock();
                                    dstOffset$iv = $this$accept$iv.getIndexInBlock();
                                    FloatPointer this_$iv$iv9 = $this$accept$iv;
                                    $i$f$blockIncrement5 = false;
                                    if (this_$iv$iv9.getBlockNum() < this_$iv$iv9.getArray().getBlocksNum() - 1) {
                                        FloatPointer floatPointer = this_$iv$iv9;
                                        int this_$iv$iv$iv7 = floatPointer.getBlockNum();
                                        floatPointer.setBlockNum(this_$iv$iv$iv7 + 1);
                                        this_$iv$iv9.setIndexInBlock(0);
                                        this_$iv$iv9.setCurrentBlock(this_$iv$iv9.getArray().getBlocks()[this_$iv$iv9.getBlockNum()]);
                                    } else {
                                        this_$iv$iv9.setIndexInBlock(this_$iv$iv9.getArray().getBlockSize());
                                    }
                                    byte[] srcBlock$iv = other$iv.getCurrentBlock();
                                    UBytePointer this_$iv$iv10 = other$iv;
                                    int $i$f$blockIncrement9 = 0;
                                    if (this_$iv$iv10.getBlockNum() < this_$iv$iv10.getArray().getBlocksNum() - 1) {
                                        UBytePointer uBytePointer = this_$iv$iv10;
                                        $i$f$increment3 = uBytePointer.getBlockNum();
                                        uBytePointer.setBlockNum($i$f$increment3 + 1);
                                        this_$iv$iv10.setIndexInBlock(0);
                                        this_$iv$iv10.setCurrentBlock-GBYM_sE(this_$iv$iv10.getArray().getBlocks()[this_$iv$iv10.getBlockNum()].unbox-impl());
                                    } else {
                                        this_$iv$iv10.setIndexInBlock(this_$iv$iv10.getArray().getBlockSize());
                                    }
                                    this_$iv$iv42 = dstOffset$iv;
                                    $i$f$increment3 = ((Object)dstBlock$iv).length;
                                    int this_$iv$iv$iv$iv = dstOffset$iv + end$iv;
                                    $i$f$blockIncrement = false;
                                    $i$f$blockIncrement9 = Math.min($i$f$increment3, this_$iv$iv$iv$iv);
                                    while (this_$iv$iv42 < $i$f$blockIncrement9) {
                                        src4 = UByteArray.get-impl((byte[])srcBlock$iv, (int)index$iv);
                                        $noName_03 = dstBlock$iv[index$iv];
                                        var38_171 = index$iv++;
                                        object = dstBlock$iv;
                                        boolean bl17 = false;
                                        n7 = src4;
                                        src = false;
                                        n15 = n7;
                                        bl15 = false;
                                        f = ((float)(n15 & 0xFF) - zero) * sc;
                                        object[var38_171] = f;
                                    }
                                }
                            } else {
                                while (end$iv > 0) {
                                    void src5;
                                    dstBlock$iv = $this$accept$iv;
                                    Object this_$iv$iv11 = $this$accept$iv;
                                    boolean $i$f$get = false;
                                    object2 = ((FloatPointer)this_$iv$iv11).getCurrentBlock()[((FloatPointer)this_$iv$iv11).getIndexInBlock()];
                                    this_$iv$iv11 = other$iv;
                                    boolean $i$f$getAndIncrement4 = false;
                                    value$iv$iv = UByteArray.get-impl((byte[])((UBytePointer)this_$iv$iv11).getCurrentBlock(), (int)((UBytePointer)this_$iv$iv11).getIndexInBlock());
                                    Object this_$iv$iv$iv = this_$iv$iv11;
                                    $i$f$increment3 = 0;
                                    if (((UBytePointer)this_$iv$iv$iv).getIndexInBlock() < ((UBytePointer)this_$iv$iv$iv).getArray().getBlockSize() - 1) {
                                        Object object5 = this_$iv$iv$iv;
                                        int this_$iv$iv$iv$iv = ((UBytePointer)object5).getIndexInBlock();
                                        ((UBytePointer)object5).setIndexInBlock(this_$iv$iv$iv$iv + 1);
                                    } else {
                                        Object this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                        $i$f$blockIncrement = false;
                                        if (((UBytePointer)this_$iv$iv$iv$iv).getBlockNum() < ((UBytePointer)this_$iv$iv$iv$iv).getArray().getBlocksNum() - 1) {
                                            Object object6 = this_$iv$iv$iv$iv;
                                            int n16 = ((UBytePointer)object6).getBlockNum();
                                            ((UBytePointer)object6).setBlockNum(n16 + 1);
                                            ((UBytePointer)this_$iv$iv$iv$iv).setIndexInBlock(0);
                                            ((UBytePointer)this_$iv$iv$iv$iv).setCurrentBlock-GBYM_sE(((UBytePointer)this_$iv$iv$iv$iv).getArray().getBlocks()[((UBytePointer)this_$iv$iv$iv$iv).getBlockNum()].unbox-impl());
                                        } else {
                                            ((UBytePointer)this_$iv$iv$iv$iv).setIndexInBlock(((UBytePointer)this_$iv$iv$iv$iv).getArray().getBlockSize());
                                        }
                                    }
                                    n7 = n8 = value$iv$iv;
                                    $noName_0 = object2;
                                    boolean bl18 = false;
                                    n15 = src5;
                                    bl15 = false;
                                    void var47_182 = n15;
                                    boolean bl19 = false;
                                    float value$iv$iv5 = ((float)(var47_182 & 0xFF) - zero) * sc;
                                    int $i$f$set = 0;
                                    this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()] = value$iv$iv5;
                                    this_$iv$iv = $this$accept$iv;
                                    $i$f$increment5 = false;
                                    if (this_$iv$iv.getIndexInBlock() < this_$iv$iv.getArray().getBlockSize() - 1) {
                                        FloatPointer floatPointer = this_$iv$iv;
                                        $i$f$set = floatPointer.getIndexInBlock();
                                        floatPointer.setIndexInBlock($i$f$set + 1);
                                    } else {
                                        FloatPointer this_$iv$iv$iv8 = this_$iv$iv;
                                        $i$f$blockIncrement5 = false;
                                        if (this_$iv$iv$iv8.getBlockNum() < this_$iv$iv$iv8.getArray().getBlocksNum() - 1) {
                                            FloatPointer floatPointer = this_$iv$iv$iv8;
                                            int n17 = floatPointer.getBlockNum();
                                            floatPointer.setBlockNum(n17 + 1);
                                            this_$iv$iv$iv8.setIndexInBlock(0);
                                            this_$iv$iv$iv8.setCurrentBlock(this_$iv$iv$iv8.getArray().getBlocks()[this_$iv$iv$iv8.getBlockNum()]);
                                        } else {
                                            this_$iv$iv$iv8.setIndexInBlock(this_$iv$iv$iv8.getArray().getBlockSize());
                                        }
                                    }
                                    --end$iv;
                                }
                            }
                        }
                        outOffset += blockSize;
                        ++i;
                    }
                }
            } else {
                String string = "Cannot perform dequantization. Scale and zero point tensors should be either scalars or 1D tensors containing " + this.getShape()[axis] + " elements";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNumberNDArray row(int row2) {
        int end$iv;
        long[] dstBlock$iv;
        void other$iv;
        void $this$accept$iv;
        int rowLength = this.getLinearSize() / this.getShape()[0];
        int start = row2 * rowLength;
        int[] nArray = this.getShape();
        int n = 1;
        int n2 = this.getRank();
        boolean bl = false;
        int[] dims = ArraysKt.copyOfRange((int[])nArray, (int)n, (int)n2);
        LongTiledArray result = LongTiledArray.Companion.invoke$default(LongTiledArray.Companion, new Strides(dims), 0, 2, null);
        LongPointer longPointer = LongTiledArray.pointer$default(result, 0, 1, null);
        LongPointer longPointer2 = this.array.pointer(start);
        int count$iv = result.getSize();
        boolean $i$f$accept = false;
        void $this$isCompatibleBySize$iv$iv22 = $this$accept$iv;
        boolean $i$f$isCompatibleBySize = false;
        boolean $this$isCompatibleBySize$iv$iv22 = $this$isCompatibleBySize$iv$iv22.getArray().getSize() - $this$isCompatibleBySize$iv$iv22.getLinearIndex() >= count$iv && other$iv.getArray().getSize() - other$iv.getLinearIndex() >= count$iv;
        $i$f$isCompatibleBySize = false;
        boolean bl2 = false;
        if (!$this$isCompatibleBySize$iv$iv22) {
            boolean bl3 = false;
            String string = "Pointers not compatible by available elements";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        void $this$isCompatibleWith$iv$iv = $this$accept$iv;
        boolean $i$f$isCompatibleWith = false;
        if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == other$iv.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == other$iv.getArray().getBlockSize()) {
            int dstOffset$iv;
            for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.length - dstOffset$iv) {
                int n3;
                int n4;
                dstBlock$iv = $this$accept$iv.getCurrentBlock();
                dstOffset$iv = $this$accept$iv.getIndexInBlock();
                void this_$iv$iv = $this$accept$iv;
                boolean $i$f$blockIncrement = false;
                if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                    void v0 = this_$iv$iv;
                    n4 = v0.getBlockNum();
                    v0.setBlockNum(n4 + 1);
                    this_$iv$iv.setIndexInBlock(0);
                    this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                } else {
                    this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                }
                long[] srcBlock$iv = other$iv.getCurrentBlock();
                void this_$iv$iv22 = other$iv;
                boolean $i$f$blockIncrement2 = false;
                if (this_$iv$iv22.getBlockNum() < this_$iv$iv22.getArray().getBlocksNum() - 1) {
                    void v1 = this_$iv$iv22;
                    n3 = v1.getBlockNum();
                    v1.setBlockNum(n3 + 1);
                    this_$iv$iv22.setIndexInBlock(0);
                    this_$iv$iv22.setCurrentBlock(this_$iv$iv22.getArray().getBlocks()[this_$iv$iv22.getBlockNum()]);
                } else {
                    this_$iv$iv22.setIndexInBlock(this_$iv$iv22.getArray().getBlockSize());
                }
                int this_$iv$iv22 = dstOffset$iv;
                n3 = dstBlock$iv.length;
                int n5 = dstOffset$iv + end$iv;
                boolean bl4 = false;
                n4 = Math.min(n3, n5);
                while (this_$iv$iv22 < n4) {
                    void src;
                    void index$iv;
                    long l = srcBlock$iv[index$iv];
                    long l2 = dstBlock$iv[index$iv];
                    void var40_41 = index$iv++;
                    long[] lArray = dstBlock$iv;
                    boolean bl5 = false;
                    void var41_42 = src;
                    lArray[var40_41] = var41_42;
                }
            }
        } else {
            while (end$iv > 0) {
                void src;
                long l;
                dstBlock$iv = $this$accept$iv;
                void this_$iv$iv = $this$accept$iv;
                boolean $i$f$get = false;
                long l3 = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                this_$iv$iv = other$iv;
                long l4 = l3;
                int $i$f$getAndIncrement = 0;
                long value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                void this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$increment = false;
                if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                    void v2 = this_$iv$iv$iv;
                    int n6 = v2.getIndexInBlock();
                    v2.setIndexInBlock(n6 + 1);
                } else {
                    void this_$iv$iv$iv$iv = this_$iv$iv$iv;
                    boolean $i$f$blockIncrement = false;
                    if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                        void v3 = this_$iv$iv$iv$iv;
                        int n7 = v3.getBlockNum();
                        v3.setBlockNum(n7 + 1);
                        this_$iv$iv$iv$iv.setIndexInBlock(0);
                        this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                    } else {
                        this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                    }
                }
                long l5 = l = value$iv$iv;
                long $noName_0 = l4;
                boolean bl6 = false;
                void value$iv$iv2 = src;
                boolean $i$f$set = false;
                this_$iv$iv2.getCurrentBlock()[this_$iv$iv2.getIndexInBlock()] = value$iv$iv2;
                void this_$iv$iv2 = $this$accept$iv;
                boolean $i$f$increment2 = false;
                if (this_$iv$iv2.getIndexInBlock() < this_$iv$iv2.getArray().getBlockSize() - 1) {
                    void v4 = this_$iv$iv2;
                    $i$f$getAndIncrement = v4.getIndexInBlock();
                    v4.setIndexInBlock($i$f$getAndIncrement + 1);
                } else {
                    void this_$iv$iv$iv2 = this_$iv$iv2;
                    boolean $i$f$blockIncrement = false;
                    if (this_$iv$iv$iv2.getBlockNum() < this_$iv$iv$iv2.getArray().getBlocksNum() - 1) {
                        void v5 = this_$iv$iv$iv2;
                        int n8 = v5.getBlockNum();
                        v5.setBlockNum(n8 + 1);
                        this_$iv$iv$iv2.setIndexInBlock(0);
                        this_$iv$iv$iv2.setCurrentBlock(this_$iv$iv$iv2.getArray().getBlocks()[this_$iv$iv$iv2.getBlockNum()]);
                    } else {
                        this_$iv$iv$iv2.setIndexInBlock(this_$iv$iv$iv2.getArray().getBlockSize());
                    }
                }
                --end$iv;
            }
        }
        return new MutableLongNDArray(result, new Strides(dims));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNumberNDArray slice(@NotNull int[] starts, @NotNull int[] ends, @NotNull int[] steps) {
        Intrinsics.checkParameterIsNotNull((Object)starts, (String)"starts");
        Intrinsics.checkParameterIsNotNull((Object)ends, (String)"ends");
        Intrinsics.checkParameterIsNotNull((Object)steps, (String)"steps");
        int n = this.getShape().length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            void it;
            int n3 = i;
            int n4 = i;
            int[] nArray2 = nArray;
            boolean bl = false;
            int n5 = ends[it] - starts[it];
            int n6 = 0;
            int length = Math.abs(n5);
            n6 = steps[it];
            int n7 = length;
            boolean bl2 = false;
            int n8 = Math.abs(n6);
            int rest = n7 % n8;
            n6 = steps[it];
            n7 = length;
            bl2 = false;
            n8 = Math.abs(n6);
            nArray2[n4] = n2 = n7 / n8 + (rest != 0 ? 1 : 0);
        }
        int[] newShape = nArray;
        Strides newStrides = new Strides(newShape);
        LongTiledArray newArray = LongTiledArray.Companion.invoke$default(LongTiledArray.Companion, newStrides, 0, 2, null);
        if (newArray.getSize() > 0) {
            this.slice(LongTiledArray.pointer$default(newArray, 0, 1, null), LongTiledArray.pointer$default(this.array, 0, 1, null), 0, 0, this.getShape(), starts, ends, steps);
        }
        return new MutableLongNDArray(newArray, newStrides);
    }

    /*
     * WARNING - void declaration
     */
    private final void slice(LongPointer dst, LongPointer src, int offset, int axis, int[] shape, int[] starts, int[] ends, int[] steps) {
        IntProgression range;
        int start = starts[axis];
        int end = ends[axis];
        int step = steps[axis];
        IntProgression intProgression = range = step > 0 ? RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)start, (int)end)), (int)step) : RangesKt.step((IntProgression)RangesKt.downTo((int)start, (int)(end + 1)), (int)(-step));
        if (axis == shape.length - 1) {
            IntProgression intProgression2 = range;
            int n = intProgression2.getFirst();
            int n2 = intProgression2.getLast();
            int n3 = intProgression2.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void index;
                    src.setLinearIndex(offset + index);
                    LongPointer longPointer = dst;
                    LongPointer this_$iv = src;
                    int $i$f$get = 0;
                    long value$iv = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                    boolean $i$f$set = false;
                    this_$iv2.getCurrentBlock()[this_$iv2.getIndexInBlock()] = value$iv;
                    LongPointer this_$iv2 = dst;
                    boolean $i$f$increment = false;
                    if (this_$iv2.getIndexInBlock() < this_$iv2.getArray().getBlockSize() - 1) {
                        LongPointer longPointer2 = this_$iv2;
                        $i$f$get = longPointer2.getIndexInBlock();
                        longPointer2.setIndexInBlock($i$f$get + 1);
                    } else {
                        LongPointer this_$iv$iv = this_$iv2;
                        boolean $i$f$blockIncrement = false;
                        if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                            LongPointer longPointer3 = this_$iv$iv;
                            int n6 = longPointer3.getBlockNum();
                            longPointer3.setBlockNum(n6 + 1);
                            this_$iv$iv.setIndexInBlock(0);
                            this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                        }
                    }
                    if (index != n2) {
                        index += n3;
                        continue;
                    }
                    break;
                }
            }
        } else {
            int ind;
            int dim = 1;
            int n = axis + 1;
            int n7 = shape.length;
            while (n < n7) {
                dim *= shape[ind];
                ++ind;
            }
            IntProgression intProgression3 = range;
            ind = intProgression3.getFirst();
            n7 = intProgression3.getLast();
            int n8 = intProgression3.getStep();
            int n9 = ind;
            int n10 = n7;
            if (n8 >= 0 ? n9 <= n10 : n9 >= n10) {
                while (true) {
                    void index;
                    this.slice(dst, src, offset + index * dim, axis + 1, shape, starts, ends, steps);
                    if (index == n7) break;
                    index += n8;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Long min() {
        long min = Long.MAX_VALUE;
        for (long[] block : this.array.getBlocks()) {
            int n = 0;
            int n2 = block.length;
            while (n < n2) {
                void idx;
                long tmp = block[idx];
                if (tmp < min) {
                    min = tmp;
                }
                ++idx;
            }
        }
        return min;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Long max() {
        long max = Long.MIN_VALUE;
        for (long[] block : this.array.getBlocks()) {
            int n = 0;
            int n2 = block.length;
            while (n < n2) {
                void idx;
                long tmp = block[idx];
                if (tmp > max) {
                    max = tmp;
                }
                ++idx;
            }
        }
        return max;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Long sum() {
        long sum = 0L;
        for (long[] block : this.array.getBlocks()) {
            int n = 0;
            int n2 = block.length;
            while (n < n2) {
                void idx;
                sum += block[idx];
                ++idx;
            }
        }
        return sum;
    }

    @Override
    @NotNull
    public MutableNumberNDArray cumulativeSum(int axis, boolean exclusive, boolean reverse) {
        MutableLongNDArray output = new MutableLongNDArray(LongTiledArray.Companion.invoke$default(LongTiledArray.Companion, this.strides, 0, 2, null), this.strides);
        int actualAxis = NDArrayExtensionsKt.indexAxis(this, axis);
        int blockSize = GatherKt.computeBlockSize$default(this, actualAxis + 1, 0, 2, null);
        int batchSize = GatherKt.computeBlockSize$default(this, actualAxis, 0, 2, null);
        int numBatches = GatherKt.computeBlockSize$default(this, 0, actualAxis, 1, null);
        int numBlocks = batchSize / blockSize;
        boolean bl = false;
        int n = 0;
        int n2 = numBatches;
        for (n = 0; n < n2; ++n) {
            int thisOff;
            int currentOff;
            int j;
            int i;
            int n3;
            int n4;
            int dstOff;
            int batchIdx = n;
            boolean bl2 = false;
            int n5 = dstOff = !reverse ? batchIdx * batchSize : (numBatches - batchIdx) * batchSize - 1;
            if (!exclusive) {
                if (!reverse) {
                    output.copyFrom(dstOff, this, dstOff, dstOff + blockSize);
                } else {
                    output.copyFrom(dstOff - blockSize + 1, this, dstOff - blockSize + 1, dstOff + 1);
                }
            }
            if (!reverse) {
                int n6 = 1;
                n4 = numBlocks;
                while (n6 < n4) {
                    int n7 = 0;
                    n3 = blockSize;
                    while (n7 < n3) {
                        currentOff = dstOff + i * blockSize + j;
                        thisOff = !exclusive ? currentOff : currentOff - blockSize;
                        output.getArray().set(currentOff, output.getArray().get(currentOff - blockSize) + this.array.get(thisOff));
                        ++j;
                    }
                    ++i;
                }
                continue;
            }
            n4 = numBlocks;
            for (i = 1; i < n4; ++i) {
                n3 = 0;
                for (j = blockSize - 1; j >= 0; --j) {
                    currentOff = dstOff - i * blockSize - j;
                    thisOff = !exclusive ? currentOff : currentOff + blockSize;
                    output.getArray().set(currentOff, output.getArray().get(currentOff + blockSize) + this.array.get(thisOff));
                }
            }
        }
        return output;
    }

    @Override
    @NotNull
    public MutableNumberNDArray plus(@NotNull NumberNDArray other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.plus(other, new MutableLongNDArray(LongTiledArray.Companion.invoke$default(LongTiledArray.Companion, this.strides, 0, 2, null), this.strides));
    }

    /*
     * WARNING - void declaration
     */
    private final void plusScalar(LongTiledArray array, long scalar2, LongTiledArray destination) {
        int n = array.getBlocksNum() == destination.getBlocksNum() && array.getBlockSize() == destination.getBlockSize() ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = 0;
        n2 = array.getBlocksNum();
        while (n < n2) {
            void blockNum;
            long[] arrayBlock = array.getBlocks()[blockNum];
            long[] destBlock = destination.getBlocks()[blockNum];
            int n3 = 0;
            int n4 = arrayBlock.length;
            while (n3 < n4) {
                void idx;
                destBlock[idx] = arrayBlock[idx] + scalar2;
                ++idx;
            }
            ++blockNum;
        }
    }

    @Override
    @NotNull
    public MutableNumberNDArray plus(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        boolean bl = other instanceof LongNDArray && destination instanceof MutableLongNDArray;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Operands must have the same types";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (NDArrayExtensionsKt.isScalar(this) && NDArrayExtensionsKt.isScalar(other)) {
            ((MutableLongNDArray)destination).getArray().getBlocks()[0][0] = this.array.getBlocks()[0][0] + ((LongNDArray)other).array.getBlocks()[0][0];
        } else if (NDArrayExtensionsKt.isScalar(this)) {
            this.plusScalar(((LongNDArray)other).array, this.array.getBlocks()[0][0], ((MutableLongNDArray)destination).getArray());
        } else if (NDArrayExtensionsKt.isScalar(other)) {
            this.plusScalar(this.array, ((LongNDArray)other).array.getBlocks()[0][0], ((MutableLongNDArray)destination).getArray());
        } else {
            BroadcastingKt.applyWithBroadcast((NDArray)this, (NDArray)other, destination, false, (Function3<? super NDArray, ? super NDArray, ? super MutableNDArray, Unit>)((Function3)plus.2.INSTANCE));
        }
        return destination;
    }

    @Override
    @NotNull
    public MutableNumberNDArray minus(@NotNull NumberNDArray other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.minus(other, new MutableLongNDArray(LongTiledArray.Companion.invoke$default(LongTiledArray.Companion, this.strides, 0, 2, null), this.strides));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNumberNDArray minus(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        boolean bl = other instanceof LongNDArray && destination instanceof MutableLongNDArray;
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "Operands must have the same types";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (NDArrayExtensionsKt.isScalar(this) && NDArrayExtensionsKt.isScalar(other)) {
            ((MutableLongNDArray)destination).getArray().getBlocks()[0][0] = this.array.getBlocks()[0][0] - ((LongNDArray)other).array.getBlocks()[0][0];
        } else if (NDArrayExtensionsKt.isScalar(other)) {
            int[] nArray = this.getShape();
            int[] nArray2 = destination.getShape();
            n = 0;
            boolean bl4 = Arrays.equals(nArray, nArray2);
            boolean bl5 = false;
            n = 0;
            n = 0;
            int n2 = 0;
            if (!bl4) {
                boolean bl6 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            long scalar2 = ((LongNDArray)other).array.getBlocks()[0][0];
            n = 0;
            n2 = this.array.getBlocksNum();
            while (n < n2) {
                void blockNum;
                long[] leftBlock = this.array.getBlocks()[blockNum];
                long[] destBlock = ((MutableLongNDArray)destination).getArray().getBlocks()[blockNum];
                int n3 = 0;
                int n4 = leftBlock.length;
                while (n3 < n4) {
                    void idx;
                    destBlock[idx] = leftBlock[idx] - scalar2;
                    ++idx;
                }
                ++blockNum;
            }
        } else {
            if (NDArrayExtensionsKt.isScalar(this)) {
                String string = "Subtraction of a matrix from a scalar is prohibited";
                bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            BroadcastingKt.applyWithBroadcast((NDArray)this, (NDArray)other, destination, true, (Function3<? super NDArray, ? super NDArray, ? super MutableNDArray, Unit>)((Function3)minus.2.INSTANCE));
        }
        return destination;
    }

    @Override
    @NotNull
    public MutableNumberNDArray times(@NotNull NumberNDArray other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.times(other, new MutableLongNDArray(LongTiledArray.Companion.invoke$default(LongTiledArray.Companion, this.strides, 0, 2, null), this.strides));
    }

    /*
     * WARNING - void declaration
     */
    private final void timesScalar(LongTiledArray array, long scalar2, LongTiledArray destination) {
        int n = array.getBlocksNum() == destination.getBlocksNum() && array.getBlockSize() == destination.getBlockSize() ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = 0;
        n2 = array.getBlocksNum();
        while (n < n2) {
            void blockNum;
            long[] arrayBlock = array.getBlocks()[blockNum];
            long[] destBlock = destination.getBlocks()[blockNum];
            int n3 = 0;
            int n4 = arrayBlock.length;
            while (n3 < n4) {
                void idx;
                destBlock[idx] = arrayBlock[idx] * scalar2;
                ++idx;
            }
            ++blockNum;
        }
    }

    @Override
    @NotNull
    public MutableNumberNDArray times(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        boolean bl = other instanceof LongNDArray && destination instanceof MutableLongNDArray;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Operands must have the same types";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (NDArrayExtensionsKt.isScalar(this) && NDArrayExtensionsKt.isScalar(other)) {
            ((MutableLongNDArray)destination).getArray().getBlocks()[0][0] = this.array.getBlocks()[0][0] * ((LongNDArray)other).array.getBlocks()[0][0];
        } else if (NDArrayExtensionsKt.isScalar(this)) {
            this.timesScalar(((LongNDArray)other).array, this.array.getBlocks()[0][0], ((MutableLongNDArray)destination).getArray());
        } else if (NDArrayExtensionsKt.isScalar(other)) {
            this.timesScalar(this.array, ((LongNDArray)other).array.getBlocks()[0][0], ((MutableLongNDArray)destination).getArray());
        } else {
            BroadcastingKt.applyWithBroadcast((NDArray)this, (NDArray)other, destination, false, (Function3<? super NDArray, ? super NDArray, ? super MutableNDArray, Unit>)((Function3)times.2.INSTANCE));
        }
        return destination;
    }

    @Override
    @NotNull
    public MutableNumberNDArray div(@NotNull NumberNDArray other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.div(other, new MutableLongNDArray(LongTiledArray.Companion.invoke$default(LongTiledArray.Companion, this.strides, 0, 2, null), this.strides));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNumberNDArray div(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        boolean bl = other instanceof LongNDArray && destination instanceof MutableLongNDArray;
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "Operands must have the same types";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (NDArrayExtensionsKt.isScalar(this) && NDArrayExtensionsKt.isScalar(other)) {
            ((MutableLongNDArray)destination).getArray().getBlocks()[0][0] = this.array.getBlocks()[0][0] / ((LongNDArray)other).array.getBlocks()[0][0];
        } else if (NDArrayExtensionsKt.isScalar(other)) {
            int[] nArray = this.getShape();
            int[] nArray2 = destination.getShape();
            n = 0;
            boolean bl4 = Arrays.equals(nArray, nArray2);
            boolean bl5 = false;
            n = 0;
            n = 0;
            int n2 = 0;
            if (!bl4) {
                boolean bl6 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            long scalar2 = ((LongNDArray)other).array.getBlocks()[0][0];
            n = 0;
            n2 = this.array.getBlocksNum();
            while (n < n2) {
                void blockNum;
                long[] leftBlock = this.array.getBlocks()[blockNum];
                long[] destBlock = ((MutableLongNDArray)destination).getArray().getBlocks()[blockNum];
                int n3 = 0;
                int n4 = leftBlock.length;
                while (n3 < n4) {
                    void idx;
                    destBlock[idx] = leftBlock[idx] / scalar2;
                    ++idx;
                }
                ++blockNum;
            }
        } else {
            if (NDArrayExtensionsKt.isScalar(this)) {
                String string = "Division of a scalar into a matrix is prohibited";
                bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            BroadcastingKt.applyWithBroadcast((NDArray)this, (NDArray)other, destination, true, (Function3<? super NDArray, ? super NDArray, ? super MutableNDArray, Unit>)((Function3)div.2.INSTANCE));
        }
        return destination;
    }

    /*
     * WARNING - void declaration
     */
    private final long[][] resortBlocks(long[][] blocks, int colSize, int blocksInRow) {
        Object[] objectArray = (Object[])blocks;
        int n = 0;
        Object[] objectArray2 = Arrays.copyOf(objectArray, objectArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"java.util.Arrays.copyOf(this, size)");
        long[][] result = (long[][])objectArray2;
        int n2 = 0;
        n = blocksInRow;
        while (n2 < n) {
            void i;
            int n3 = 0;
            int n4 = colSize;
            while (n3 < n4) {
                void j;
                result[i * colSize + j] = blocks[j * blocksInRow + i];
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    @NotNull
    public MutableNumberNDArray dot(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        LongNDArray cfr_ignored_0 = (LongNDArray)other;
        MutableLongNDArray cfr_ignored_1 = (MutableLongNDArray)destination;
        boolean bl = this.getShape().length == 2 && other.getShape().length == 2;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.getShape()[1] == other.getShape()[0];
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int n = this.getShape()[0];
        int t = this.getShape()[1];
        long[][] resortedLeft = this.resortBlocks(this.array.getBlocks(), this.getShape()[0], this.getBlocksInRow());
        long[][] resortedRight = this.resortBlocks(((LongNDArray)other).array.getBlocks(), other.getShape()[0], ((LongNDArray)other).getBlocksInRow());
        long[][] resortedDest = this.resortBlocks(((MutableLongNDArray)destination).getArray().getBlocks(), destination.getShape()[0], ((MutableLongNDArray)destination).getBlocksInRow());
        int lBlockSize = this.array.getBlockSize();
        int rdBlockSize = ((MutableLongNDArray)destination).getArray().getBlockSize();
        int lBlockInRow = this.getBlocksInRow();
        int rBlockInRow = ((LongNDArray)other).getBlocksInRow();
        Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit> $fun$wrapper$1 = new Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit>(rBlockInRow, t, n, resortedDest, lBlockInRow, resortedLeft, lBlockSize, resortedRight, rdBlockSize){
            final /* synthetic */ int $rBlockInRow;
            final /* synthetic */ int $t;
            final /* synthetic */ int $n;
            final /* synthetic */ long[][] $resortedDest;
            final /* synthetic */ int $lBlockInRow;
            final /* synthetic */ long[][] $resortedLeft;
            final /* synthetic */ int $lBlockSize;
            final /* synthetic */ long[][] $resortedRight;
            final /* synthetic */ int $rdBlockSize;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Function1<? super Function0<Unit>, Unit> body) {
                Intrinsics.checkParameterIsNotNull(body, (String)"body");
                int n = 0;
                int n2 = this.$rBlockInRow;
                while (n < n2) {
                    void rdCol;
                    void rightIdx = rdCol * this.$t;
                    void destIdx = rdCol * this.$n;
                    body.invoke((Object)new Function0<Unit>(this, (int)destIdx, (int)rightIdx){
                        final /* synthetic */ dot.1 this$0;
                        final /* synthetic */ int $destIdx;
                        final /* synthetic */ int $rightIdx;

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            int n = 0;
                            int n2 = this.this$0.$n;
                            while (n < n2) {
                                void i;
                                long[] destBlock = this.this$0.$resortedDest[this.$destIdx + i];
                                int n3 = 0;
                                int n4 = this.this$0.$lBlockInRow;
                                while (n3 < n4) {
                                    void lCol;
                                    long[] leftBlock = this.this$0.$resortedLeft[i + lCol * this.this$0.$n];
                                    int rightIdxOffset = this.$rightIdx + this.this$0.$lBlockSize * lCol;
                                    int n5 = 0;
                                    int n6 = this.this$0.$lBlockSize;
                                    while (n5 < n6) {
                                        void k;
                                        long temp = leftBlock[k];
                                        long[] rightBlock = this.this$0.$resortedRight[rightIdxOffset + k];
                                        int n7 = 0;
                                        int n8 = this.this$0.$rdBlockSize;
                                        while (n7 < n8) {
                                            void j;
                                            destBlock[j] = destBlock[j] + temp * rightBlock[j];
                                            ++j;
                                        }
                                        ++k;
                                    }
                                    ++lCol;
                                }
                                ++i;
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$destIdx = n;
                            this.$rightIdx = n2;
                            super(0);
                        }
                    });
                    ++rdCol;
                }
            }

            public static /* synthetic */ void invoke$default(dot.1 var0, Function1 function1, int n, Object object) {
                if ((n & 1) != 0) {
                    function1 = dot.1.INSTANCE;
                }
                var0.invoke((Function1<? super Function0<Unit>, Unit>)function1);
            }
            {
                this.$rBlockInRow = n;
                this.$t = n2;
                this.$n = n3;
                this.$resortedDest = lArray;
                this.$lBlockInRow = n4;
                this.$resortedLeft = lArray2;
                this.$lBlockSize = n5;
                this.$resortedRight = lArray3;
                this.$rdBlockSize = n6;
                super(1);
            }
        };
        if (rBlockInRow > 1) {
            BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($fun$wrapper$1, null){
                private CoroutineScope p$;
                int label;
                final /* synthetic */ dot.1 $wrapper$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$runBlocking = this.p$;
                            this.$wrapper$1.invoke((Function1<? super Function0<Unit>, Unit>)((Function1)new Function1<Function0<? extends Unit>, Unit>($this$runBlocking){
                                final /* synthetic */ CoroutineScope $this_runBlocking;

                                public final void invoke(@NotNull Function0<Unit> it) {
                                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                                    BuildersKt.launch$default((CoroutineScope)this.$this_runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null){
                                        private CoroutineScope p$;
                                        int label;
                                        final /* synthetic */ Function0 $it;

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object $result) {
                                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    CoroutineScope $this$launch = this.p$;
                                                    this.$it.invoke();
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }
                                        {
                                            this.$it = function0;
                                            super(2, continuation);
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                            Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                            CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                            return function2;
                                        }

                                        public final Object invoke(Object object, Object object2) {
                                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                }
                                {
                                    this.$this_runBlocking = coroutineScope;
                                    super(1);
                                }
                            }));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$wrapper$1 = var1_1;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else {
            dot.1.invoke$default($fun$wrapper$1, null, 1, null);
        }
        return destination;
    }

    @Override
    @NotNull
    public MutableNumberNDArray dotTransposedWithAlpha(double alpha, @NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        LongNDArray cfr_ignored_0 = (LongNDArray)other;
        MutableLongNDArray cfr_ignored_1 = (MutableLongNDArray)destination;
        long alpha2 = (long)alpha;
        int dRowsNum = destination.getShape()[0];
        int dBlocksInRow = ((MutableLongNDArray)destination).getBlocksInRow();
        int lrBlocksInRow = this.getBlocksInRow();
        int dBlockSize = ((MutableLongNDArray)destination).getArray().getBlockSize();
        int lrBlockSize = this.array.getBlockSize();
        long[][] dBlocks = ((MutableLongNDArray)destination).getArray().getBlocks();
        long[][] lBlocks = this.array.getBlocks();
        long[][] rBlocks = ((LongNDArray)other).array.getBlocks();
        Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit> $fun$wrapper$1 = new Function1<Function1<? super Function0<? extends Unit>, ? extends Unit>, Unit>(dRowsNum, dBlocksInRow, lrBlocksInRow, dBlocks, dBlockSize, lBlocks, rBlocks, lrBlockSize, alpha2){
            final /* synthetic */ int $dRowsNum;
            final /* synthetic */ int $dBlocksInRow;
            final /* synthetic */ int $lrBlocksInRow;
            final /* synthetic */ long[][] $dBlocks;
            final /* synthetic */ int $dBlockSize;
            final /* synthetic */ long[][] $lBlocks;
            final /* synthetic */ long[][] $rBlocks;
            final /* synthetic */ int $lrBlockSize;
            final /* synthetic */ long $alpha;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Function1<? super Function0<Unit>, Unit> body) {
                Intrinsics.checkParameterIsNotNull(body, (String)"body");
                int n = 0;
                int n2 = this.$dRowsNum;
                while (n < n2) {
                    void dRow;
                    int rRow = 0;
                    void dBlockOffset = dRow * this.$dBlocksInRow;
                    void lBlockOffset = dRow * this.$lrBlocksInRow;
                    int n3 = 0;
                    int n4 = this.$dBlocksInRow;
                    while (n3 < n4) {
                        void dBlockInRow;
                        long[] dBlock = this.$dBlocks[dBlockOffset + dBlockInRow];
                        int rRowOffset = rRow;
                        body.invoke((Object)new Function0<Unit>(this, rRowOffset, (int)lBlockOffset, dBlock){
                            final /* synthetic */ dotTransposedWithAlpha.1 this$0;
                            final /* synthetic */ int $rRowOffset;
                            final /* synthetic */ int $lBlockOffset;
                            final /* synthetic */ long[] $dBlock;

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke() {
                                int rBlockOffset = this.$rRowOffset * this.this$0.$lrBlocksInRow;
                                int n = 0;
                                int n2 = this.this$0.$dBlockSize;
                                while (n < n2) {
                                    void dIdx;
                                    int n3 = 0;
                                    int n4 = this.this$0.$lrBlocksInRow;
                                    while (n3 < n4) {
                                        void lrBlockInRow;
                                        long[] lBlock = this.this$0.$lBlocks[this.$lBlockOffset + lrBlockInRow];
                                        long[] rBlock = this.this$0.$rBlocks[rBlockOffset + lrBlockInRow];
                                        int n5 = 0;
                                        int n6 = this.this$0.$lrBlockSize;
                                        while (n5 < n6) {
                                            void lrIdx;
                                            this.$dBlock[dIdx] = this.$dBlock[dIdx] + this.this$0.$alpha * lBlock[lrIdx] * rBlock[lrIdx];
                                            ++lrIdx;
                                        }
                                        ++lrBlockInRow;
                                    }
                                    rBlockOffset += this.this$0.$lrBlocksInRow;
                                    ++dIdx;
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$rRowOffset = n;
                                this.$lBlockOffset = n2;
                                this.$dBlock = lArray;
                                super(0);
                            }
                        });
                        rRow += this.$dBlockSize;
                        ++dBlockInRow;
                    }
                    ++dRow;
                }
            }

            public static /* synthetic */ void invoke$default(dotTransposedWithAlpha.1 var0, Function1 function1, int n, Object object) {
                if ((n & 1) != 0) {
                    function1 = dotTransposedWithAlpha.1.INSTANCE;
                }
                var0.invoke((Function1<? super Function0<Unit>, Unit>)function1);
            }
            {
                this.$dRowsNum = n;
                this.$dBlocksInRow = n2;
                this.$lrBlocksInRow = n3;
                this.$dBlocks = lArray;
                this.$dBlockSize = n4;
                this.$lBlocks = lArray2;
                this.$rBlocks = lArray3;
                this.$lrBlockSize = n5;
                this.$alpha = l;
                super(1);
            }
        };
        if (((MutableLongNDArray)destination).getBlocksInRow() > 1) {
            BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($fun$wrapper$1, null){
                private CoroutineScope p$;
                int label;
                final /* synthetic */ dotTransposedWithAlpha.1 $wrapper$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$runBlocking = this.p$;
                            this.$wrapper$1.invoke((Function1<? super Function0<Unit>, Unit>)((Function1)new Function1<Function0<? extends Unit>, Unit>($this$runBlocking){
                                final /* synthetic */ CoroutineScope $this_runBlocking;

                                public final void invoke(@NotNull Function0<Unit> it) {
                                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                                    BuildersKt.launch$default((CoroutineScope)this.$this_runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null){
                                        private CoroutineScope p$;
                                        int label;
                                        final /* synthetic */ Function0 $it;

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object $result) {
                                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    CoroutineScope $this$launch = this.p$;
                                                    this.$it.invoke();
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }
                                        {
                                            this.$it = function0;
                                            super(2, continuation);
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                            Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                            CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                            return function2;
                                        }

                                        public final Object invoke(Object object, Object object2) {
                                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                }
                                {
                                    this.$this_runBlocking = coroutineScope;
                                    super(1);
                                }
                            }));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$wrapper$1 = var1_1;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else {
            dotTransposedWithAlpha.1.invoke$default($fun$wrapper$1, null, 1, null);
        }
        return destination;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNDArray gemm(int m, int n, int k, double alpha, int lda, @NotNull NDArray b, int ldb, double beta, @NotNull MutableNDArray c, int ldc, int aOffset, int bOffset, int cOffset, boolean transposeA, boolean transposeB) {
        int this_$iv$iv422;
        int j;
        int n2;
        boolean $i$f$set2;
        boolean $i$f$get;
        int i;
        int t;
        long l;
        void var75_28;
        int end$iv;
        int $i$f$map;
        int i2;
        int n3;
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        LongNDArray cfr_ignored_0 = (LongNDArray)b;
        MutableLongNDArray cfr_ignored_1 = (MutableLongNDArray)c;
        long betaPrimitive = (long)beta;
        long alphaPrimitive = (long)alpha;
        LongPointer aPointer = LongTiledArray.pointer$default(this.array, 0, 1, null);
        LongPointer bPointer = LongTiledArray.pointer$default(((LongNDArray)b).array, 0, 1, null);
        LongPointer cPointer = LongTiledArray.pointer$default(((MutableLongNDArray)c).getArray(), 0, 1, null);
        if (beta != 1.0) {
            int n4 = 0;
            n3 = m;
            while (n4 < n3) {
                int offset$iv;
                long[] block$iv;
                cPointer.setLinearIndex(i2 * ldc + cOffset);
                LongPointer $this$map$iv = cPointer;
                $i$f$map = 0;
                for (end$iv = n; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                    int n5;
                    block$iv = $this$map$iv.getCurrentBlock();
                    offset$iv = $this$map$iv.getIndexInBlock();
                    LongPointer this_$iv$iv22 = $this$map$iv;
                    int $i$f$blockIncrement = 0;
                    if (this_$iv$iv22.getBlockNum() < this_$iv$iv22.getArray().getBlocksNum() - 1) {
                        LongPointer longPointer = this_$iv$iv22;
                        n5 = longPointer.getBlockNum();
                        longPointer.setBlockNum(n5 + 1);
                        this_$iv$iv22.setIndexInBlock(0);
                        this_$iv$iv22.setCurrentBlock(this_$iv$iv22.getArray().getBlocks()[this_$iv$iv22.getBlockNum()]);
                    } else {
                        this_$iv$iv22.setIndexInBlock(this_$iv$iv22.getArray().getBlockSize());
                    }
                    int this_$iv$iv22 = offset$iv;
                    n5 = block$iv.length;
                    int n6 = offset$iv + end$iv;
                    boolean bl = false;
                    $i$f$blockIncrement = Math.min(n5, n6);
                    while (this_$iv$iv22 < $i$f$blockIncrement) {
                        void it;
                        void index$iv;
                        long l2 = block$iv[index$iv];
                        var75_28 = index$iv++;
                        long[] lArray = block$iv;
                        boolean bl2 = false;
                        lArray[var75_28] = l = betaPrimitive * it;
                    }
                }
                ++i2;
            }
        }
        if (transposeA && transposeB) {
            i2 = 0;
            n3 = m;
            while (i2 < n3) {
                int $this$map$iv = 0;
                $i$f$map = n;
                while ($this$map$iv < $i$f$map) {
                    void j2;
                    cPointer.setLinearIndex(t * ldc + j2 + cOffset);
                    end$iv = 0;
                    int block$iv = k;
                    while (end$iv < block$iv) {
                        LongPointer this_$iv;
                        aPointer.setLinearIndex(i * lda + t + aOffset);
                        bPointer.setLinearIndex((int)(j2 * ldb + i + bOffset));
                        LongPointer offset$iv = cPointer;
                        LongPointer index$iv = aPointer;
                        long l3 = alphaPrimitive;
                        $i$f$get = false;
                        l = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                        this_$iv = bPointer;
                        l3 *= l;
                        $i$f$get = false;
                        l = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                        this_$iv = cPointer;
                        l3 *= l;
                        $i$f$get = false;
                        l = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                        long value$iv = l3 + l;
                        $i$f$set2 = false;
                        this_$iv2.getCurrentBlock()[this_$iv2.getIndexInBlock()] = value$iv;
                        ++i;
                    }
                    ++j2;
                }
                ++t;
            }
        } else if (transposeA) {
            n3 = m;
            for (t = 0; t < n3; ++t) {
                $i$f$map = n;
                for (int j2 = 0; j2 < $i$f$map; ++j2) {
                    cPointer.setLinearIndex(t * ldc + j2 + cOffset);
                    int block$iv = k;
                    for (i = 0; i < block$iv; ++i) {
                        LongPointer this_$iv;
                        aPointer.setLinearIndex(i * lda + t + aOffset);
                        bPointer.setLinearIndex(i * ldb + j2 + bOffset);
                        LongPointer this_$iv2 = cPointer;
                        LongPointer value$iv = aPointer;
                        long l4 = alphaPrimitive;
                        $i$f$get = false;
                        l = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                        this_$iv = bPointer;
                        l4 *= l;
                        $i$f$get = false;
                        l = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                        this_$iv = cPointer;
                        l4 *= l;
                        $i$f$get = false;
                        l = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                        long value$iv2 = l4 + l;
                        $i$f$set2 = false;
                        this_$iv2.getCurrentBlock()[this_$iv2.getIndexInBlock()] = value$iv2;
                    }
                }
            }
        } else if (transposeB) {
            n3 = m;
            for (t = 0; t < n3; ++t) {
                int aIdx = t * lda + aOffset;
                cPointer.setLinearIndex(t * ldc + cOffset);
                $i$f$map = 0;
                n2 = n;
                while ($i$f$map < n2) {
                    int $i$f$getAndIncrement;
                    long elementInA;
                    int end$iv2;
                    aPointer.setLinearIndex(aIdx);
                    bPointer.setLinearIndex(j * ldb + bOffset);
                    LongPointer $this$combine$iv = aPointer;
                    boolean $i$f$combine = false;
                    LongPointer $this$isCompatibleBySize$iv$iv22 = $this$combine$iv;
                    boolean $i$f$isCompatibleBySize = false;
                    boolean $this$isCompatibleBySize$iv$iv22 = $this$isCompatibleBySize$iv$iv22.getArray().getSize() - $this$isCompatibleBySize$iv$iv22.getLinearIndex() >= k && bPointer.getArray().getSize() - bPointer.getLinearIndex() >= k;
                    $i$f$isCompatibleBySize = false;
                    $i$f$set2 = false;
                    if (!$this$isCompatibleBySize$iv$iv22) {
                        boolean bl = false;
                        String $i$f$set2 = "Pointers not compatible by available elements";
                        throw (Throwable)new IllegalArgumentException($i$f$set2.toString());
                    }
                    LongPointer $this$isCompatibleWith$iv$iv = $this$combine$iv;
                    boolean $i$f$isCompatibleWith = false;
                    if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == bPointer.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == bPointer.getArray().getBlockSize()) {
                        int fstOffset$iv;
                        long[] fstBlock$iv;
                        for (end$iv2 = k; end$iv2 > 0; end$iv2 -= fstBlock$iv.length - fstOffset$iv) {
                            int n7;
                            fstBlock$iv = $this$combine$iv.getCurrentBlock();
                            fstOffset$iv = $this$combine$iv.getIndexInBlock();
                            LongPointer this_$iv$iv = $this$combine$iv;
                            boolean $i$f$blockIncrement = false;
                            if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                                LongPointer longPointer = this_$iv$iv;
                                int it = longPointer.getBlockNum();
                                longPointer.setBlockNum(it + 1);
                                this_$iv$iv.setIndexInBlock(0);
                                this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                            } else {
                                this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                            }
                            long[] sndBlock$iv = bPointer.getCurrentBlock();
                            LongPointer this_$iv$iv2 = bPointer;
                            int $i$f$blockIncrement2 = 0;
                            if (this_$iv$iv2.getBlockNum() < this_$iv$iv2.getArray().getBlocksNum() - 1) {
                                LongPointer longPointer = this_$iv$iv2;
                                n7 = longPointer.getBlockNum();
                                longPointer.setBlockNum(n7 + 1);
                                this_$iv$iv2.setIndexInBlock(0);
                                this_$iv$iv2.setCurrentBlock(this_$iv$iv2.getArray().getBlocks()[this_$iv$iv2.getBlockNum()]);
                            } else {
                                this_$iv$iv2.setIndexInBlock(this_$iv$iv2.getArray().getBlockSize());
                            }
                            this_$iv$iv422 = fstOffset$iv;
                            n7 = fstBlock$iv.length;
                            int bl2 = fstOffset$iv + end$iv2;
                            boolean bl = false;
                            $i$f$blockIncrement2 = Math.min(n7, bl2);
                            while (this_$iv$iv422 < $i$f$blockIncrement2) {
                                void this_$iv;
                                void elementInB;
                                void index$iv;
                                long l5 = sndBlock$iv[index$iv];
                                elementInA = fstBlock$iv[index$iv];
                                boolean bl3 = false;
                                LongPointer longPointer = cPointer;
                                LongPointer longPointer2 = cPointer;
                                long l6 = alphaPrimitive * elementInA * elementInB;
                                boolean $i$f$get2 = false;
                                long l7 = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                                long value$iv = l6 + l7;
                                boolean $i$f$set3 = false;
                                this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()] = value$iv;
                                ++index$iv;
                            }
                        }
                    } else {
                        while (end$iv2 > 0) {
                            void this_$iv;
                            void elementInB;
                            int n8;
                            boolean $i$f$blockIncrement;
                            LongPointer this_$iv$iv = $this$combine$iv;
                            $i$f$getAndIncrement = 0;
                            long value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                            LongPointer this_$iv$iv$iv = this_$iv$iv;
                            boolean $i$f$increment = false;
                            if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                LongPointer longPointer = this_$iv$iv$iv;
                                int bl2 = longPointer.getIndexInBlock();
                                longPointer.setIndexInBlock(bl2 + 1);
                            } else {
                                LongPointer this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                $i$f$blockIncrement = false;
                                if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    LongPointer longPointer = this_$iv$iv$iv$iv;
                                    n8 = longPointer.getBlockNum();
                                    longPointer.setBlockNum(n8 + 1);
                                    this_$iv$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            long l8 = value$iv$iv;
                            this_$iv$iv = bPointer;
                            long l9 = l8;
                            $i$f$getAndIncrement = 0;
                            value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                            this_$iv$iv$iv = this_$iv$iv;
                            $i$f$increment = false;
                            if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                LongPointer longPointer = this_$iv$iv$iv;
                                int this_$iv$iv$iv$iv = longPointer.getIndexInBlock();
                                longPointer.setIndexInBlock(this_$iv$iv$iv$iv + 1);
                            } else {
                                LongPointer this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                $i$f$blockIncrement = false;
                                if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    LongPointer longPointer = this_$iv$iv$iv$iv;
                                    n8 = longPointer.getBlockNum();
                                    longPointer.setBlockNum(n8 + 1);
                                    this_$iv$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            long l10 = elementInA = value$iv$iv;
                            long elementInA2 = l9;
                            boolean bl = false;
                            LongPointer longPointer = cPointer;
                            LongPointer longPointer3 = cPointer;
                            long l11 = alphaPrimitive * elementInA2 * elementInB;
                            boolean $i$f$get3 = false;
                            long l12 = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                            long value$iv = l11 + l12;
                            boolean $i$f$set4 = false;
                            this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()] = value$iv;
                            --end$iv2;
                        }
                    }
                    LongPointer this_$iv = cPointer;
                    boolean $i$f$increment = false;
                    if (this_$iv.getIndexInBlock() < this_$iv.getArray().getBlockSize() - 1) {
                        LongPointer longPointer = this_$iv;
                        end$iv2 = longPointer.getIndexInBlock();
                        longPointer.setIndexInBlock(end$iv2 + 1);
                    } else {
                        LongPointer this_$iv$iv = this_$iv;
                        boolean $i$f$blockIncrement = false;
                        if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                            LongPointer longPointer = this_$iv$iv;
                            $i$f$getAndIncrement = longPointer.getBlockNum();
                            longPointer.setBlockNum($i$f$getAndIncrement + 1);
                            this_$iv$iv.setIndexInBlock(0);
                            this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv.setIndexInBlock(this_$iv$iv.getArray().getBlockSize());
                        }
                    }
                    ++j;
                }
            }
        } else {
            n3 = m;
            for (t = 0; t < n3; ++t) {
                int cIdx = t * ldc + cOffset;
                aPointer.setLinearIndex(t * lda + aOffset);
                j = 0;
                n2 = k;
                while (j < n2) {
                    int n9;
                    int end$iv3;
                    Object dstBlock$iv;
                    void i3;
                    int $i$f$blockIncrement;
                    void this_$iv;
                    LongPointer this_$iv$iv = aPointer;
                    long l13 = alphaPrimitive;
                    boolean $i$f$getAndIncrement = false;
                    long value$iv = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                    void this_$iv$iv422 = this_$iv;
                    boolean $i$f$increment = false;
                    if (this_$iv$iv422.getIndexInBlock() < this_$iv$iv422.getArray().getBlockSize() - 1) {
                        void v9 = this_$iv$iv422;
                        int $i$f$increment2 = v9.getIndexInBlock();
                        v9.setIndexInBlock($i$f$increment2 + 1);
                    } else {
                        void this_$iv$iv$iv = this_$iv$iv422;
                        $i$f$blockIncrement = 0;
                        if (this_$iv$iv$iv.getBlockNum() < this_$iv$iv$iv.getArray().getBlocksNum() - 1) {
                            void v10 = this_$iv$iv$iv;
                            int $i$f$blockIncrement3 = v10.getBlockNum();
                            v10.setBlockNum($i$f$blockIncrement3 + 1);
                            this_$iv$iv$iv.setIndexInBlock(0);
                            this_$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv.getBlockNum()]);
                        } else {
                            this_$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv.getArray().getBlockSize());
                        }
                    }
                    l = value$iv;
                    long temp = l13 * l;
                    bPointer.setLinearIndex((int)(i3 * ldb + bOffset));
                    cPointer.setLinearIndex(cIdx);
                    LongPointer $this$accept$iv = cPointer;
                    boolean $i$f$accept = false;
                    LongPointer $this$isCompatibleBySize$iv$iv32 = $this$accept$iv;
                    boolean $i$f$isCompatibleBySize = false;
                    boolean $this$isCompatibleBySize$iv$iv32 = $this$isCompatibleBySize$iv$iv32.getArray().getSize() - $this$isCompatibleBySize$iv$iv32.getLinearIndex() >= n && bPointer.getArray().getSize() - bPointer.getLinearIndex() >= n;
                    $i$f$isCompatibleBySize = false;
                    this_$iv$iv422 = 0;
                    if (!$this$isCompatibleBySize$iv$iv32) {
                        boolean bl = false;
                        String this_$iv$iv422 = "Pointers not compatible by available elements";
                        throw (Throwable)new IllegalArgumentException(this_$iv$iv422.toString());
                    }
                    LongPointer $this$isCompatibleWith$iv$iv = $this$accept$iv;
                    boolean $i$f$isCompatibleWith = false;
                    if ($this$isCompatibleWith$iv$iv.getIndexInBlock() == bPointer.getIndexInBlock() && $this$isCompatibleWith$iv$iv.getArray().getBlockSize() == bPointer.getArray().getBlockSize()) {
                        int dstOffset$iv;
                        for (end$iv3 = n; end$iv3 > 0; end$iv3 -= ((Object)dstBlock$iv).length - dstOffset$iv) {
                            int $i$f$blockIncrement3;
                            dstBlock$iv = $this$accept$iv.getCurrentBlock();
                            dstOffset$iv = $this$accept$iv.getIndexInBlock();
                            LongPointer this_$iv$iv3 = $this$accept$iv;
                            boolean $i$f$blockIncrement4 = false;
                            if (this_$iv$iv3.getBlockNum() < this_$iv$iv3.getArray().getBlocksNum() - 1) {
                                LongPointer longPointer = this_$iv$iv3;
                                $i$f$blockIncrement = longPointer.getBlockNum();
                                longPointer.setBlockNum($i$f$blockIncrement + 1);
                                this_$iv$iv3.setIndexInBlock(0);
                                this_$iv$iv3.setCurrentBlock(this_$iv$iv3.getArray().getBlocks()[this_$iv$iv3.getBlockNum()]);
                            } else {
                                this_$iv$iv3.setIndexInBlock(this_$iv$iv3.getArray().getBlockSize());
                            }
                            long[] srcBlock$iv = bPointer.getCurrentBlock();
                            LongPointer this_$iv$iv322 = bPointer;
                            $i$f$blockIncrement = 0;
                            if (this_$iv$iv322.getBlockNum() < this_$iv$iv322.getArray().getBlocksNum() - 1) {
                                LongPointer longPointer = this_$iv$iv322;
                                $i$f$blockIncrement3 = longPointer.getBlockNum();
                                longPointer.setBlockNum($i$f$blockIncrement3 + 1);
                                this_$iv$iv322.setIndexInBlock(0);
                                this_$iv$iv322.setCurrentBlock(this_$iv$iv322.getArray().getBlocks()[this_$iv$iv322.getBlockNum()]);
                            } else {
                                this_$iv$iv322.setIndexInBlock(this_$iv$iv322.getArray().getBlockSize());
                            }
                            int this_$iv$iv322 = dstOffset$iv;
                            $i$f$blockIncrement3 = ((Object)dstBlock$iv).length;
                            int elementInA2 = dstOffset$iv + end$iv3;
                            boolean bl = false;
                            n9 = Math.min($i$f$blockIncrement3, elementInA2);
                            while (this_$iv$iv322 < n9) {
                                void elementInC;
                                void elementInB;
                                void index$iv;
                                long elementInA = srcBlock$iv[index$iv];
                                Object bl3 = dstBlock$iv[index$iv];
                                var75_28 = index$iv++;
                                Object object = dstBlock$iv;
                                boolean bl4 = false;
                                l = temp * elementInB + elementInC;
                                object[var75_28] = l;
                            }
                        }
                    } else {
                        while (end$iv3 > 0) {
                            void elementInB;
                            long l14;
                            dstBlock$iv = $this$accept$iv;
                            this_$iv$iv = $this$accept$iv;
                            boolean $i$f$get4 = false;
                            long l15 = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                            this_$iv$iv = bPointer;
                            long l16 = l15;
                            int $i$f$getAndIncrement2 = 0;
                            long value$iv$iv = this_$iv$iv.getCurrentBlock()[this_$iv$iv.getIndexInBlock()];
                            LongPointer this_$iv$iv$iv = this_$iv$iv;
                            boolean $i$f$increment3 = false;
                            if (this_$iv$iv$iv.getIndexInBlock() < this_$iv$iv$iv.getArray().getBlockSize() - 1) {
                                LongPointer longPointer = this_$iv$iv$iv;
                                int n10 = longPointer.getIndexInBlock();
                                longPointer.setIndexInBlock(n10 + 1);
                            } else {
                                LongPointer this_$iv$iv$iv$iv = this_$iv$iv$iv;
                                boolean $i$f$blockIncrement5 = false;
                                if (this_$iv$iv$iv$iv.getBlockNum() < this_$iv$iv$iv$iv.getArray().getBlocksNum() - 1) {
                                    LongPointer longPointer = this_$iv$iv$iv$iv;
                                    int n11 = longPointer.getBlockNum();
                                    longPointer.setBlockNum(n11 + 1);
                                    this_$iv$iv$iv$iv.setIndexInBlock(0);
                                    this_$iv$iv$iv$iv.setCurrentBlock(this_$iv$iv$iv$iv.getArray().getBlocks()[this_$iv$iv$iv$iv.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv$iv.setIndexInBlock(this_$iv$iv$iv$iv.getArray().getBlockSize());
                                }
                            }
                            long $i$f$set3 = l14 = value$iv$iv;
                            long elementInC = l16;
                            boolean bl = false;
                            long value$iv$iv2 = temp * elementInB + elementInC;
                            boolean $i$f$set5 = false;
                            this_$iv$iv5.getCurrentBlock()[this_$iv$iv5.getIndexInBlock()] = value$iv$iv2;
                            LongPointer this_$iv$iv5 = $this$accept$iv;
                            boolean $i$f$increment4 = false;
                            if (this_$iv$iv5.getIndexInBlock() < this_$iv$iv5.getArray().getBlockSize() - 1) {
                                LongPointer longPointer = this_$iv$iv5;
                                $i$f$getAndIncrement2 = longPointer.getIndexInBlock();
                                longPointer.setIndexInBlock($i$f$getAndIncrement2 + 1);
                            } else {
                                LongPointer this_$iv$iv$iv2 = this_$iv$iv5;
                                boolean $i$f$blockIncrement6 = false;
                                if (this_$iv$iv$iv2.getBlockNum() < this_$iv$iv$iv2.getArray().getBlocksNum() - 1) {
                                    LongPointer longPointer = this_$iv$iv$iv2;
                                    n9 = longPointer.getBlockNum();
                                    longPointer.setBlockNum(n9 + 1);
                                    this_$iv$iv$iv2.setIndexInBlock(0);
                                    this_$iv$iv$iv2.setCurrentBlock(this_$iv$iv$iv2.getArray().getBlocks()[this_$iv$iv$iv2.getBlockNum()]);
                                } else {
                                    this_$iv$iv$iv2.setIndexInBlock(this_$iv$iv$iv2.getArray().getBlockSize());
                                }
                            }
                            --end$iv3;
                        }
                    }
                    ++i3;
                }
            }
        }
        return c;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NDArray[] splitHorizontalByBlocks(int parts) {
        boolean bl = this.getRank() <= 2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.getBlocksInRow() % parts == 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int blocksInRow = this.getBlocksInRow();
        int partBlocksInRow = blocksInRow / parts;
        int blocksInPart = this.getRank() == 1 ? partBlocksInRow : partBlocksInRow * this.getShape()[0];
        int[] nArray = this.getShape();
        boolean bl6 = false;
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)nArray2, (String)"java.util.Arrays.copyOf(this, size)");
        int[] partShape = nArray2;
        int n = ArraysKt.getLastIndex((int[])partShape);
        partShape[n] = partShape[n] / parts;
        Strides partStrides = new Strides(partShape);
        NDArray[] nDArrayArray = new NDArray[parts];
        for (int i = 0; i < parts; ++i) {
            void part;
            int n2 = i;
            int n3 = i;
            NDArray[] nDArrayArray2 = nDArrayArray;
            boolean bl7 = false;
            int partOffset = partBlocksInRow * part;
            int n4 = blocksInPart;
            long[][] lArrayArray = new long[n4][];
            int n5 = 0;
            while (n5 < n4) {
                void block;
                int n6 = n5;
                int n7 = n5++;
                long[][] lArrayArray2 = lArrayArray;
                boolean bl8 = false;
                void rowNum = block / partBlocksInRow;
                void colNum = block % partBlocksInRow;
                long[] lArray = this.array.getBlocks()[rowNum * blocksInRow + partOffset + colNum];
                lArrayArray2[n7] = lArray;
            }
            long[][] partBlocks = lArrayArray;
            LongNDArray longNDArray = new LongNDArray(new LongTiledArray(partBlocks), partStrides);
            nDArrayArray2[n3] = longNDArray;
        }
        return nDArrayArray;
    }

    @Override
    @NotNull
    public MutableNDArray copyIfNotMutable() {
        return new MutableLongNDArray(this.array.copyOf(), this.strides);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LongNDArray)) {
            return false;
        }
        if (this.getType() != ((LongNDArray)other).getType()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.strides, (Object)((LongNDArray)other).strides) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.array, (Object)((LongNDArray)other).array) ^ true);
    }

    public int hashCode() {
        int result = this.array.hashCode();
        result = 31 * result + this.strides.hashCode();
        result = 31 * result + this.getType().hashCode();
        return result;
    }

    public LongNDArray(@NotNull LongTiledArray array, @NotNull Strides strides) {
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        this.array = array;
        this.type = DataType.LONG;
        this.strides = strides;
    }

    public LongNDArray(@NotNull int[] shape, int divider) {
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        this(LongTiledArray.Companion.invoke(shape, divider), new Strides(shape));
    }

    public /* synthetic */ LongNDArray(int[] nArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(nArray, n);
    }

    public LongNDArray(@NotNull int[] shape, int divider, @NotNull Function1<? super Integer, Long> init) {
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        this(LongTiledArray.Companion.invoke(shape, divider, init), new Strides(shape));
    }

    public /* synthetic */ LongNDArray(int[] nArray, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(nArray, n, (Function1<? super Integer, Long>)function1);
    }

    public LongNDArray(@NotNull Strides strides, int divider) {
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        this(LongTiledArray.Companion.invoke(strides, divider), strides);
    }

    public /* synthetic */ LongNDArray(Strides strides, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(strides, n);
    }

    public LongNDArray(@NotNull Strides strides, int divider, @NotNull Function1<? super Integer, Long> init) {
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        this(LongTiledArray.Companion.invoke(strides, divider, init), strides);
    }

    public /* synthetic */ LongNDArray(Strides strides, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(strides, n, (Function1<? super Integer, Long>)function1);
    }

    @Override
    public int getLinearSize() {
        return NumberNDArray.DefaultImpls.getLinearSize(this);
    }

    @Override
    @NotNull
    public int[] getShape() {
        return NumberNDArray.DefaultImpls.getShape(this);
    }

    @Override
    public int getRank() {
        return NumberNDArray.DefaultImpls.getRank(this);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/kinference/ndarray/arrays/LongNDArray$Companion;", "", "()V", "scalar", "Lio/kinference/ndarray/arrays/LongNDArray;", "value", "", "ndarray"})
    public static final class Companion {
        @NotNull
        public final LongNDArray scalar(long value) {
            return new LongNDArray(new LongTiledArray(1, 1, (Function1<? super Integer, Long>)((Function1)new Function1<Integer, Long>(value){
                final /* synthetic */ long $value;

                public final long invoke(int it) {
                    return this.$value;
                }
                {
                    this.$value = l;
                    super(1);
                }
            })), Strides.Companion.getEMPTY());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

