/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays;

import io.kinference.ndarray.Strides;
import io.kinference.ndarray.arrays.BooleanMap;
import io.kinference.ndarray.arrays.MutableBooleanNDArray;
import io.kinference.ndarray.arrays.MutableNDArray;
import io.kinference.ndarray.arrays.NDArray;
import io.kinference.ndarray.arrays.PrimitiveToPrimitiveFunction;
import io.kinference.ndarray.arrays.pointers.BooleanPointer;
import io.kinference.ndarray.arrays.tiled.BooleanTiledArray;
import io.kinference.ndarray.extensions.NDArrayExtensionsKt;
import io.kinference.primitives.types.DataType;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\b\b\u0016\u0018\u0000 B2\u00020\u0001:\u0001BB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rB-\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000eB\u0015\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010$\u001a\u00020#H\u0016J\u0013\u0010%\u001a\u00020\t2\b\u0010&\u001a\u0004\u0018\u00010'H\u0096\u0002J\u0010\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u0003H\u0016J\u0010\u0010-\u001a\u00020#2\u0006\u0010-\u001a\u00020\u0005H\u0016J\r\u0010.\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010/JH\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0003H\u0002J \u00100\u001a\u00020#2\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0003H\u0016J\u001b\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00010;2\u0006\u0010<\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010=J\u0010\u0010>\u001a\u00020#2\u0006\u0010?\u001a\u00020\fH\u0016J\u0014\u0010@\u001a\u00020\u00012\n\u0010A\u001a\u00020\u0003\"\u00020\u0005H\u0016R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006C"}, d2={"Lio/kinference/ndarray/arrays/BooleanNDArray;", "Lio/kinference/ndarray/arrays/NDArray;", "shape", "", "divider", "", "([II)V", "init", "Lkotlin/Function1;", "", "([IILkotlin/jvm/functions/Function1;)V", "strides", "Lio/kinference/ndarray/Strides;", "(Lio/kinference/ndarray/Strides;I)V", "(Lio/kinference/ndarray/Strides;ILkotlin/jvm/functions/Function1;)V", "array", "Lio/kinference/ndarray/arrays/tiled/BooleanTiledArray;", "(Lio/kinference/ndarray/arrays/tiled/BooleanTiledArray;Lio/kinference/ndarray/Strides;)V", "getArray", "()Lio/kinference/ndarray/arrays/tiled/BooleanTiledArray;", "setArray", "(Lio/kinference/ndarray/arrays/tiled/BooleanTiledArray;)V", "blocksInRow", "getBlocksInRow", "()I", "<set-?>", "getStrides", "()Lio/kinference/ndarray/Strides;", "setStrides", "(Lio/kinference/ndarray/Strides;)V", "type", "Lio/kinference/primitives/types/DataType;", "getType", "()Lio/kinference/primitives/types/DataType;", "allocateNDArray", "Lio/kinference/ndarray/arrays/MutableNDArray;", "copyIfNotMutable", "equals", "other", "", "map", "function", "Lio/kinference/ndarray/arrays/PrimitiveToPrimitiveFunction;", "reshapeView", "newShape", "row", "singleValue", "()Ljava/lang/Boolean;", "slice", "", "dst", "Lio/kinference/ndarray/arrays/pointers/BooleanPointer;", "src", "offset", "axis", "starts", "ends", "steps", "splitHorizontalByBlocks", "", "parts", "(I)[Lio/kinference/ndarray/arrays/NDArray;", "toMutable", "newStrides", "view", "axes", "Companion", "ndarray"})
public class BooleanNDArray
implements NDArray {
    @NotNull
    private final DataType type;
    @NotNull
    private Strides strides;
    @NotNull
    private BooleanTiledArray array;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public DataType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public final Strides getStrides() {
        return this.strides;
    }

    protected final void setStrides(@NotNull Strides strides) {
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"<set-?>");
        this.strides = strides;
    }

    protected final int getBlocksInRow() {
        int n;
        if (this.strides.getLinearSize() == 0) {
            n = 0;
        } else {
            int[] nArray = this.strides.getShape();
            boolean bl = false;
            n = nArray.length == 0 ? 1 : ArraysKt.last((int[])this.strides.getShape()) / this.array.getBlockSize();
        }
        return n;
    }

    @Override
    @NotNull
    public NDArray view(int ... axes) {
        Intrinsics.checkParameterIsNotNull((Object)axes, (String)"axes");
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public Boolean singleValue() {
        boolean bl = NDArrayExtensionsKt.isScalar(this) || this.array.getSize() == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "NDArray contains more than 1 value";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.array.getBlocks()[0][0];
    }

    @Override
    @NotNull
    public MutableNDArray allocateNDArray(@NotNull Strides strides) {
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        return new MutableBooleanNDArray(BooleanTiledArray.Companion.invoke$default(BooleanTiledArray.Companion, strides, 0, 2, null), strides);
    }

    @Override
    @NotNull
    public NDArray reshapeView(@NotNull int[] newShape) {
        Intrinsics.checkParameterIsNotNull((Object)newShape, (String)"newShape");
        return new BooleanNDArray(this.array, new Strides(newShape));
    }

    @Override
    @NotNull
    public MutableNDArray toMutable(@NotNull Strides newStrides) {
        Intrinsics.checkParameterIsNotNull((Object)newStrides, (String)"newStrides");
        return new MutableBooleanNDArray(this.array.copyOf(), this.strides);
    }

    @Override
    @NotNull
    public MutableNDArray copyIfNotMutable() {
        return new MutableBooleanNDArray(this.array, this.strides);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNDArray map(@NotNull PrimitiveToPrimitiveFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        BooleanMap cfr_ignored_0 = (BooleanMap)function;
        MutableNDArray mutableNDArray = this.allocateNDArray(this.strides);
        if (mutableNDArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.kinference.ndarray.arrays.MutableBooleanNDArray");
        }
        MutableBooleanNDArray destination = (MutableBooleanNDArray)mutableNDArray;
        int n = 0;
        int n2 = destination.getLinearSize();
        while (n < n2) {
            void index;
            destination.getArray().set((int)index, ((BooleanMap)function).apply(this.array.get((int)index)));
            ++index;
        }
        return destination;
    }

    @Override
    @NotNull
    public MutableNDArray row(int row2) {
        int rowLength = this.getLinearSize() / this.getShape()[0];
        int start = row2 * rowLength;
        int[] nArray = this.getShape();
        int n = 1;
        int n2 = this.getRank();
        boolean bl = false;
        int[] dims = ArraysKt.copyOfRange((int[])nArray, (int)n, (int)n2);
        return new MutableBooleanNDArray(BooleanTiledArray.Companion.invoke$default(BooleanTiledArray.Companion, new Strides(dims), 0, (Function1)new Function1<Integer, Boolean>(this, start){
            final /* synthetic */ BooleanNDArray this$0;
            final /* synthetic */ int $start;

            public final boolean invoke(int it) {
                return this.this$0.getArray().get(this.$start + it);
            }
            {
                this.this$0 = booleanNDArray;
                this.$start = n;
                super(1);
            }
        }, 2, null), new Strides(dims));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MutableNDArray slice(@NotNull int[] starts, @NotNull int[] ends, @NotNull int[] steps) {
        Intrinsics.checkParameterIsNotNull((Object)starts, (String)"starts");
        Intrinsics.checkParameterIsNotNull((Object)ends, (String)"ends");
        Intrinsics.checkParameterIsNotNull((Object)steps, (String)"steps");
        int n = this.getShape().length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            void it;
            int n3 = i;
            int n4 = i;
            int[] nArray2 = nArray;
            boolean bl = false;
            int n5 = ends[it] - starts[it];
            int n6 = 0;
            int length = Math.abs(n5);
            n6 = steps[it];
            int n7 = length;
            boolean bl2 = false;
            int n8 = Math.abs(n6);
            int rest = n7 % n8;
            n6 = steps[it];
            n7 = length;
            bl2 = false;
            n8 = Math.abs(n6);
            nArray2[n4] = n2 = n7 / n8 + (rest != 0 ? 1 : 0);
        }
        int[] newShape = nArray;
        Strides newStrides = new Strides(newShape);
        BooleanTiledArray newArray = BooleanTiledArray.Companion.invoke$default(BooleanTiledArray.Companion, newStrides, 0, 2, null);
        if (newArray.getSize() > 0) {
            this.slice(BooleanTiledArray.pointer$default(newArray, 0, 1, null), BooleanTiledArray.pointer$default(this.array, 0, 1, null), 0, 0, this.getShape(), starts, ends, steps);
        }
        return new MutableBooleanNDArray(newArray, newStrides);
    }

    /*
     * WARNING - void declaration
     */
    private final void slice(BooleanPointer dst, BooleanPointer src, int offset, int axis, int[] shape, int[] starts, int[] ends, int[] steps) {
        IntProgression range;
        int start = starts[axis];
        int end = ends[axis];
        int step = steps[axis];
        IntProgression intProgression = range = step > 0 ? RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)start, (int)end)), (int)step) : RangesKt.step((IntProgression)RangesKt.downTo((int)start, (int)(end + 1)), (int)(-step));
        if (axis == shape.length - 1) {
            IntProgression intProgression2 = range;
            int n = intProgression2.getFirst();
            int n2 = intProgression2.getLast();
            int n3 = intProgression2.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void index;
                    src.setLinearIndex(offset + index);
                    BooleanPointer booleanPointer = dst;
                    BooleanPointer this_$iv = src;
                    boolean $i$f$get = false;
                    boolean value$iv = this_$iv.getCurrentBlock()[this_$iv.getIndexInBlock()];
                    int $i$f$set = 0;
                    this_$iv2.getCurrentBlock()[this_$iv2.getIndexInBlock()] = value$iv;
                    BooleanPointer this_$iv2 = dst;
                    boolean $i$f$increment = false;
                    if (this_$iv2.getIndexInBlock() < this_$iv2.getArray().getBlockSize() - 1) {
                        BooleanPointer booleanPointer2 = this_$iv2;
                        $i$f$set = booleanPointer2.getIndexInBlock();
                        booleanPointer2.setIndexInBlock($i$f$set + 1);
                    } else {
                        int n6;
                        BooleanPointer this_$iv$iv = this_$iv2;
                        boolean $i$f$blockIncrement = false;
                        if (this_$iv$iv.getBlockNum() < this_$iv$iv.getArray().getBlocksNum() - 1) {
                            BooleanPointer booleanPointer3 = this_$iv$iv;
                            n6 = booleanPointer3.getBlockNum();
                            booleanPointer3.setBlockNum(n6 + 1);
                            this_$iv$iv.setIndexInBlock(0);
                            this_$iv$iv.setCurrentBlock(this_$iv$iv.getArray().getBlocks()[this_$iv$iv.getBlockNum()]);
                        } else {
                            BooleanPointer booleanPointer4 = this_$iv$iv;
                            n6 = booleanPointer4.getIndexInBlock();
                            booleanPointer4.setIndexInBlock(n6 + 1);
                        }
                    }
                    if (index != n2) {
                        index += n3;
                        continue;
                    }
                    break;
                }
            }
        } else {
            int ind;
            int dim = 1;
            int n = axis + 1;
            int n7 = shape.length;
            while (n < n7) {
                dim *= shape[ind];
                ++ind;
            }
            IntProgression intProgression3 = range;
            ind = intProgression3.getFirst();
            n7 = intProgression3.getLast();
            int n8 = intProgression3.getStep();
            int n9 = ind;
            int n10 = n7;
            if (n8 >= 0 ? n9 <= n10 : n9 >= n10) {
                while (true) {
                    void index;
                    this.slice(dst, src, offset + index * dim, axis + 1, shape, starts, ends, steps);
                    if (index == n7) break;
                    index += n8;
                }
            }
        }
    }

    @Override
    @NotNull
    public NDArray[] splitHorizontalByBlocks(int parts) {
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BooleanNDArray)) {
            return false;
        }
        if (this.getType() != ((BooleanNDArray)other).getType()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.strides, (Object)((BooleanNDArray)other).strides) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.array, (Object)((BooleanNDArray)other).array) ^ true);
    }

    @NotNull
    public final BooleanTiledArray getArray() {
        return this.array;
    }

    public final void setArray(@NotNull BooleanTiledArray booleanTiledArray) {
        Intrinsics.checkParameterIsNotNull((Object)booleanTiledArray, (String)"<set-?>");
        this.array = booleanTiledArray;
    }

    public BooleanNDArray(@NotNull BooleanTiledArray array, @NotNull Strides strides) {
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        this.array = array;
        this.type = DataType.BOOLEAN;
        this.strides = strides;
    }

    public BooleanNDArray(@NotNull int[] shape, int divider) {
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        this(BooleanTiledArray.Companion.invoke$default(BooleanTiledArray.Companion, shape, 0, 2, null), new Strides(shape));
    }

    public /* synthetic */ BooleanNDArray(int[] nArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(nArray, n);
    }

    public BooleanNDArray(@NotNull int[] shape, int divider, @NotNull Function1<? super Integer, Boolean> init) {
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        this(BooleanTiledArray.Companion.invoke(shape, divider, init), new Strides(shape));
    }

    public /* synthetic */ BooleanNDArray(int[] nArray, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(nArray, n, (Function1<? super Integer, Boolean>)function1);
    }

    public BooleanNDArray(@NotNull Strides strides, int divider) {
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        this(BooleanTiledArray.Companion.invoke(strides, divider), strides);
    }

    public /* synthetic */ BooleanNDArray(Strides strides, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(strides, n);
    }

    public BooleanNDArray(@NotNull Strides strides, int divider, @NotNull Function1<? super Integer, Boolean> init) {
        Intrinsics.checkParameterIsNotNull((Object)strides, (String)"strides");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        this(BooleanTiledArray.Companion.invoke(strides, divider, init), strides);
    }

    public /* synthetic */ BooleanNDArray(Strides strides, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(strides, n, (Function1<? super Integer, Boolean>)function1);
    }

    @Override
    public int getLinearSize() {
        return NDArray.DefaultImpls.getLinearSize(this);
    }

    @Override
    @NotNull
    public int[] getShape() {
        return NDArray.DefaultImpls.getShape(this);
    }

    @Override
    public int getRank() {
        return NDArray.DefaultImpls.getRank(this);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/kinference/ndarray/arrays/BooleanNDArray$Companion;", "", "()V", "scalar", "Lio/kinference/ndarray/arrays/BooleanNDArray;", "value", "", "ndarray"})
    public static final class Companion {
        @NotNull
        public final BooleanNDArray scalar(boolean value) {
            return new BooleanNDArray(new BooleanTiledArray(1, 1, (Function1<? super Integer, Boolean>)((Function1)new Function1<Integer, Boolean>(value){
                final /* synthetic */ boolean $value;

                public final boolean invoke(int it) {
                    return this.$value;
                }
                {
                    this.$value = bl;
                    super(1);
                }
            })), Strides.Companion.getEMPTY());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

