/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0016"}, d2={"Lio/kinference/ndarray/Strides;", "", "shape", "", "([I)V", "linearSize", "", "getLinearSize", "()I", "getShape", "()[I", "strides", "getStrides", "equals", "", "other", "hashCode", "index", "offset", "transpose", "permutations", "Companion", "ndarray"})
public final class Strides {
    @NotNull
    private final int[] strides;
    private final int linearSize;
    @NotNull
    private final int[] shape;
    @NotNull
    private static final Strides EMPTY;
    public static final Companion Companion;

    @NotNull
    public final int[] getStrides() {
        return this.strides;
    }

    /*
     * WARNING - void declaration
     */
    public final int offset(@NotNull int[] index) {
        void $this$foldIndexed$iv;
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        int[] nArray = index;
        int initial$iv = 0;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        int accumulator$iv = initial$iv;
        for (void element$iv : $this$foldIndexed$iv) {
            void i;
            void acc;
            int n = index$iv++;
            void var11_11 = element$iv;
            int n2 = accumulator$iv;
            int ind = n;
            boolean bl = false;
            accumulator$iv = acc + i * this.strides[ind];
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final int[] index(int offset) {
        int n = offset;
        n = 0 <= n && this.linearSize > n ? 1 : 0;
        boolean bl = false;
        int n2 = 0;
        if (n == 0) {
            boolean bl2 = false;
            String string = "Offset " + offset + " out of buffer bounds: (0, " + (this.linearSize - 1) + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int[] res = new int[this.shape.length];
        int current = offset;
        int[] nArray = this.strides;
        int n3 = nArray.length;
        n2 = 0;
        while (n2 < n3) {
            void index;
            int stride = nArray[n2];
            res[index] = current / stride;
            current %= stride;
            ++index;
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Strides transpose(@NotNull int[] permutations) {
        Intrinsics.checkParameterIsNotNull((Object)permutations, (String)"permutations");
        int[] newShape = new int[this.shape.length];
        int[] nArray = permutations;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            void i;
            int axis = nArray[n2];
            newShape[i] = this.shape[axis];
            ++i;
        }
        return new Strides(newShape);
    }

    public final int getLinearSize() {
        return this.linearSize;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Strides)) {
            return false;
        }
        int[] nArray = this.shape;
        int[] nArray2 = ((Strides)other).shape;
        boolean bl = false;
        return Arrays.equals(nArray, nArray2);
    }

    public int hashCode() {
        int[] nArray = this.shape;
        boolean bl = false;
        return Arrays.hashCode(nArray);
    }

    @NotNull
    public final int[] getShape() {
        return this.shape;
    }

    /*
     * WARNING - void declaration
     */
    public Strides(@NotNull int[] shape) {
        void $this$foldRightIndexed$iv;
        Intrinsics.checkParameterIsNotNull((Object)shape, (String)"shape");
        this.shape = shape;
        this.strides = new int[this.shape.length];
        int[] nArray = this.shape;
        boolean initial$iv = true;
        boolean $i$f$foldRightIndexed = false;
        int index$iv = ArraysKt.getLastIndex((int[])$this$foldRightIndexed$iv);
        boolean accumulator$iv = initial$iv;
        while (index$iv >= 0) {
            void i;
            void acc;
            boolean bl = accumulator$iv;
            void var8_8 = $this$foldRightIndexed$iv[index$iv];
            int index = index$iv--;
            boolean bl2 = false;
            this.strides[index] = acc;
            accumulator$iv = acc * i;
        }
        nArray = this.shape;
        Strides strides = this;
        boolean bl = false;
        boolean bl3 = nArray.length == 0;
        strides.linearSize = bl3 ? 1 : this.strides[0] * this.shape[0];
    }

    static {
        Companion = new Companion(null);
        EMPTY = new Strides(new int[0]);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/kinference/ndarray/Strides$Companion;", "", "()V", "EMPTY", "Lio/kinference/ndarray/Strides;", "getEMPTY", "()Lio/kinference/ndarray/Strides;", "ndarray"})
    public static final class Companion {
        @NotNull
        public final Strides getEMPTY() {
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

