/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.view.toolwindow;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.websocket.WebSocketProjectComponent;
import com.intellij.websocket.jam.WebSocketEndpoint;
import com.intellij.websocket.jam.WebSocketJamModel;
import com.intellij.websocket.view.toolwindow.WebSocketViewFrameworkProvider;
import com.intellij.websocket.view.toolwindow.WebSocketViewSettings;
import com.intellij.websocket.view.toolwindow.actions.CheckWebsocketTypeAction;
import com.intellij.websocket.view.toolwindow.actions.ShowResourcesAction;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebsocketFinderRecursivePanel
extends FinderRecursivePanel<WebSocketEndpoint> {
    private final Module myModule;
    private final DefaultActionGroup myActions;
    private ShowResourcesAction myShowResourcesAction;
    private CheckWebsocketTypeAction.Server myShowServerAction;
    private CheckWebsocketTypeAction.Client myShowClientAction;

    public WebsocketFinderRecursivePanel(@NotNull FinderRecursivePanel parent, @Nullable Module module, DefaultActionGroup actions) {
        if (parent == null) {
            WebsocketFinderRecursivePanel.$$$reportNull$$$0(0);
        }
        super(parent);
        this.myModule = module;
        this.myActions = actions;
        this.initAdditionalActions(actions);
    }

    private void initAdditionalActions(DefaultActionGroup actions) {
        this.myShowResourcesAction = new ShowResourcesAction(this);
        this.myShowServerAction = new CheckWebsocketTypeAction.Server(this);
        this.myShowClientAction = new CheckWebsocketTypeAction.Client(this);
        actions.add((AnAction)this.myShowResourcesAction);
        actions.add((AnAction)this.myShowServerAction);
        actions.add((AnAction)this.myShowClientAction);
    }

    @Nullable
    protected JComponent createRightComponent(@NotNull WebSocketEndpoint endpoint) {
        if (endpoint == null) {
            WebsocketFinderRecursivePanel.$$$reportNull$$$0(1);
        }
        if (this.hasChildren(endpoint)) {
            // empty if block
        }
        return DocumentationComponent.createAndFetch((Project)this.getProject(), (PsiElement)WebsocketFinderRecursivePanel.getPsiElement(endpoint), (Disposable)this);
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            WebsocketFinderRecursivePanel.$$$reportNull$$$0(2);
        }
        WebSocketEndpoint jamElement = (WebSocketEndpoint)this.getSelectedValue();
        PsiElement element = WebsocketFinderRecursivePanel.getPsiElement(jamElement);
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && element != null) {
            return element;
        }
        return super.getData(dataId);
    }

    @Nullable
    private static PsiElement getPsiElement(WebSocketEndpoint jamElement) {
        if (jamElement == null) {
            return null;
        }
        return jamElement.getPsiElement();
    }

    @NotNull
    protected String getItemText(@NotNull WebSocketEndpoint endpoint) {
        if (endpoint == null) {
            WebsocketFinderRecursivePanel.$$$reportNull$$$0(3);
        }
        String string = endpoint.getPath();
        if (string == null) {
            WebsocketFinderRecursivePanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected void doCustomizeCellRenderer(@NotNull SimpleColoredComponent comp, @NotNull JList list, @NotNull WebSocketEndpoint value, int index, boolean selected, boolean hasFocus) {
        String annoName;
        if (comp == null) {
            WebsocketFinderRecursivePanel.$$$reportNull$$$0(5);
        }
        if (list == null) {
            WebsocketFinderRecursivePanel.$$$reportNull$$$0(6);
        }
        if (value == null) {
            WebsocketFinderRecursivePanel.$$$reportNull$$$0(7);
        }
        comp.clear();
        comp.setIcon(this.getItemIcon(value));
        String endpointValue = value.getPath();
        String className = StringUtil.getShortName((String)value.getPsiElement().getQualifiedName());
        if (this.isShowResourcesView()) {
            if (!StringUtil.isEmptyOrSpaces((String)endpointValue)) {
                comp.append("\"" + endpointValue + "\"");
                comp.append(" (" + className + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            } else {
                comp.append(className);
            }
        } else {
            comp.append(className);
            if (!StringUtil.isEmptyOrSpaces((String)endpointValue)) {
                comp.append(" (\"" + endpointValue + "\")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)value.getAnnotationRef().getPsiElement();
        String string = annoName = psiAnnotation == null || psiAnnotation.getQualifiedName() == null ? "" : StringUtil.getShortName((String)psiAnnotation.getQualifiedName());
        if (StringUtil.isNotEmpty((String)annoName)) {
            comp.append(" @" + annoName + " ", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    @Nullable
    protected Icon getItemIcon(@NotNull WebSocketEndpoint path) {
        if (path == null) {
            WebsocketFinderRecursivePanel.$$$reportNull$$$0(8);
        }
        return AllIcons.Nodes.Plugin;
    }

    public void dispose() {
        super.dispose();
        this.myActions.remove((AnAction)this.myShowClientAction);
        this.myActions.remove((AnAction)this.myShowResourcesAction);
        this.myActions.remove((AnAction)this.myShowServerAction);
    }

    @NotNull
    protected List<WebSocketEndpoint> getListItems() {
        WebSocketJamModel model = WebSocketJamModel.getModel(this.getProject());
        List<WebSocketEndpoint> allEndpoints = this.myModule != null ? model.getEndpoints(this.myModule) : model.getEndpoints(this.getProject());
        List<WebSocketEndpoint> filteredEndpoints = WebSocketViewFrameworkProvider.getFilteredEndpoints(allEndpoints, this.getProject());
        filteredEndpoints.sort((o1, o2) -> {
            String value1 = o1.getPath();
            String value2 = o2.getPath();
            return value1.compareTo(value2);
        });
        List<WebSocketEndpoint> list = filteredEndpoints;
        if (list == null) {
            WebsocketFinderRecursivePanel.$$$reportNull$$$0(9);
        }
        return list;
    }

    protected boolean hasChildren(@NotNull WebSocketEndpoint endpoint) {
        if (endpoint == null) {
            WebsocketFinderRecursivePanel.$$$reportNull$$$0(10);
        }
        return false;
    }

    public Module getModule() {
        return this.myModule;
    }

    public boolean isShowResourcesView() {
        WebSocketViewSettings viewSettings = WebSocketProjectComponent.getInstance(this.getProject()).getState();
        return viewSettings == null || viewSettings.showResources;
    }

    public boolean isShowServerEndpoints() {
        WebSocketViewSettings viewSettings = WebSocketProjectComponent.getInstance(this.getProject()).getState();
        return viewSettings == null || viewSettings.server;
    }

    public boolean isShowClientEndpoints() {
        WebSocketViewSettings viewSettings = WebSocketProjectComponent.getInstance(this.getProject()).getState();
        return viewSettings == null || viewSettings.client;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/websocket/view/toolwindow/WebsocketFinderRecursivePanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/websocket/view/toolwindow/WebsocketFinderRecursivePanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createRightComponent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getItemText";
                break;
            }
            case 4: 
            case 9: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCustomizeCellRenderer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

