/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.view.endpoints;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.uast.url.UastUrlAttributeUtils;
import com.intellij.microservices.utils.EndpointsViewUtils;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.uast.UastModificationTracker;
import com.intellij.websocket.jam.WebSocketEndpoint;
import com.intellij.websocket.utils.WebSocketCommonUtils;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class WebSocketFramework<T extends WebSocketEndpoint>
implements EndpointsProvider<T, T> {
    WebSocketFramework() {
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        if (project == null) {
            WebSocketFramework.$$$reportNull$$$0(0);
        }
        if (WebSocketCommonUtils.hasWebSocketLibrary(project)) {
            EndpointsProvider.Status status = EndpointsProvider.Status.HAS_ENDPOINTS;
            if (status == null) {
                WebSocketFramework.$$$reportNull$$$0(1);
            }
            return status;
        }
        EndpointsProvider.Status status = EndpointsProvider.Status.UNAVAILABLE;
        if (status == null) {
            WebSocketFramework.$$$reportNull$$$0(2);
        }
        return status;
    }

    @NotNull
    public Iterable<T> getEndpoints(@NotNull T group) {
        if (group == null) {
            WebSocketFramework.$$$reportNull$$$0(3);
        }
        Set<T> set = Collections.singleton(group);
        if (set == null) {
            WebSocketFramework.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull T group, @NotNull T endpoint) {
        String qualifiedName;
        String endpointValue;
        if (group == null) {
            WebSocketFramework.$$$reportNull$$$0(5);
        }
        if (endpoint == null) {
            WebSocketFramework.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmptyOrSpaces((String)(endpointValue = ((WebSocketEndpoint)group).getPath()))) {
            endpointValue = "/";
        }
        String className = StringUtil.isNotEmpty((String)(qualifiedName = ((WebSocketEndpoint)group).getPsiElement().getQualifiedName())) ? StringUtil.getShortName((String)qualifiedName) : "";
        return new PresentationData(endpointValue, className, AllIcons.Webreferences.WebSocket, (TextAttributesKey)(UastUrlAttributeUtils.isUastDeclarationDeprecated((PsiElement)((WebSocketEndpoint)endpoint).getPsiElement()) ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null));
    }

    @Nullable
    public Object getEndpointData(@NotNull T group, @NotNull T endpoint, @NotNull String dataId) {
        if (group == null) {
            WebSocketFramework.$$$reportNull$$$0(7);
        }
        if (endpoint == null) {
            WebSocketFramework.$$$reportNull$$$0(8);
        }
        if (dataId == null) {
            WebSocketFramework.$$$reportNull$$$0(9);
        }
        return EndpointsViewUtils.getCommonEndpointValue((PsiElement)((WebSocketEndpoint)endpoint).getPsiElement(), (String)dataId);
    }

    public boolean isValidEndpoint(@NotNull T group, @NotNull T endpoint) {
        if (group == null) {
            WebSocketFramework.$$$reportNull$$$0(10);
        }
        if (endpoint == null) {
            WebSocketFramework.$$$reportNull$$$0(11);
        }
        return ((WebSocketEndpoint)endpoint).isPsiValid();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        if (project == null) {
            WebSocketFramework.$$$reportNull$$$0(12);
        }
        UastModificationTracker uastModificationTracker = UastModificationTracker.getInstance((Project)project);
        if (uastModificationTracker == null) {
            WebSocketFramework.$$$reportNull$$$0(13);
        }
        return uastModificationTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/websocket/view/endpoints/WebSocketFramework";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/websocket/view/endpoints/WebSocketFramework";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpoints";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEndpoints";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointPresentation";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointData";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isValidEndpoint";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModificationTracker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

