/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.references;

import com.intellij.javaee.util.UriTemplateParser;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import com.intellij.websocket.constants.WebSocketAnnoConstants;
import com.intellij.websocket.references.WebSocketPathReference;
import com.intellij.websocket.references.WebSocketReferenceProvider;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebSocketPathReferenceProvider
extends WebSocketReferenceProvider {
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiLiteralExpression literal;
        Object value;
        if (element == null) {
            WebSocketPathReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            WebSocketPathReferenceProvider.$$$reportNull$$$0(1);
        }
        ArrayList<WebSocketPathReference> refs = new ArrayList<WebSocketPathReference>();
        if (element instanceof PsiLiteralExpression && (value = (literal = (PsiLiteralExpression)element).getValue()) instanceof String) {
            String path = (String)value;
            if (path.length() > 0) {
                List names;
                try {
                    UriTemplateParser parser = new UriTemplateParser(path);
                    names = parser.getNames();
                }
                catch (Exception e) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        WebSocketPathReferenceProvider.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                for (String name : names) {
                    int index = path.indexOf("{" + name + "}");
                    TextRange range = TextRange.from((int)(index + 2), (int)name.length());
                    refs.add(new WebSocketPathReference(literal, range, name));
                }
            }
            PsiReference[] psiReferenceArray = refs.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                WebSocketPathReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            WebSocketPathReferenceProvider.$$$reportNull$$$0(4);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Override
    public ElementPattern<? extends PsiElement> getPattern() {
        return PsiJavaPatterns.literalExpression().annotationParam(WebSocketAnnoConstants.SERVER_ENDPOINT.javax());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/websocket/references/WebSocketPathReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/websocket/references/WebSocketPathReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

