/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.util.UriTemplateParser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.websocket.jam.WebSocketEndpoint;
import com.intellij.websocket.references.WebSocketPathReference;
import com.intellij.websocket.utils.WebSocketCommonUtils;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebSocketPathParamReference
extends PsiReferenceBase<PsiLiteralExpression> {
    private PsiLiteralExpression myParam;
    private final String myStringValue;
    private final Pattern GOOD_PATH_NAME = Pattern.compile("[a-zA-Z0-9_-]*");

    public WebSocketPathParamReference(PsiLiteralExpression pathParamLiteral) {
        super((PsiElement)pathParamLiteral, false);
        this.myParam = pathParamLiteral;
        Object value = this.myParam.getValue();
        this.myStringValue = value instanceof String ? (String)value : null;
    }

    public PsiElement resolve() {
        PsiElement element;
        PsiAnnotationMemberValue attributeValue;
        if (this.myStringValue == null) {
            return null;
        }
        PsiAnnotation annotation = WebSocketPathParamReference.findEndpointAnnotation(this.myElement);
        if (annotation != null && (attributeValue = annotation.findAttributeValue("value")) != null && (element = attributeValue.getOriginalElement()) instanceof PsiLiteralExpression) {
            for (PsiReference reference : element.getReferences()) {
                WebSocketPathReference pathReference;
                if (!(reference instanceof WebSocketPathReference) || !this.myStringValue.equals((pathReference = (WebSocketPathReference)reference).getName())) continue;
                return pathReference.resolve();
            }
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findEndpointAnnotation(@NotNull PsiElement element) {
        WebSocketEndpoint endpoint;
        PsiClass endpointClass;
        if (element == null) {
            WebSocketPathParamReference.$$$reportNull$$$0(0);
        }
        if ((endpointClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) != null && (endpoint = WebSocketCommonUtils.getWebsocketEndpoint(endpointClass)) != null) {
            return (PsiAnnotation)endpoint.getAnnotationRef().getPsiElement();
        }
        return null;
    }

    @Nullable
    private static WebSocketEndpoint findEndpoint(@NotNull PsiElement element) {
        PsiClass endpointClass;
        if (element == null) {
            WebSocketPathParamReference.$$$reportNull$$$0(1);
        }
        if ((endpointClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) != null) {
            return WebSocketCommonUtils.getWebsocketEndpoint(endpointClass);
        }
        return null;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            WebSocketPathParamReference.$$$reportNull$$$0(2);
        }
        if (this.GOOD_PATH_NAME.matcher(newElementName).matches()) {
            PsiExpression newLiteral = JavaPsiFacade.getElementFactory((Project)((PsiLiteralExpression)this.getElement()).getProject()).createExpressionFromText("\"" + newElementName + "\"", this.myParam.getContext());
            this.myParam = (PsiLiteralExpression)this.myParam.replace((PsiElement)newLiteral);
        }
        return this.myParam;
    }

    @NotNull
    public String getValue() {
        String string = this.myStringValue == null ? "" : this.myStringValue;
        if (string == null) {
            WebSocketPathParamReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    public Object @NotNull [] getVariants() {
        String path;
        HashSet<LookupElementBuilder> variants = new HashSet<LookupElementBuilder>();
        WebSocketEndpoint endpoint = WebSocketPathParamReference.findEndpoint(this.myElement);
        if (endpoint != null && !StringUtil.isEmptyOrSpaces((String)(path = endpoint.getPath()))) {
            for (String name : new UriTemplateParser(path).getNames()) {
                variants.add(LookupElementBuilder.create((String)name).withIcon(PlatformIcons.VARIABLE_ICON));
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray(variants);
        if (objectArray == null) {
            WebSocketPathParamReference.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/websocket/references/WebSocketPathParamReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/websocket/references/WebSocketPathParamReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findEndpointAnnotation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findEndpoint";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

