/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.util.PlatformIcons;
import com.intellij.websocket.resources.WebSocketBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class WebSocketPathParamPsiElement
extends RenameableFakePsiElement {
    private final PsiElement myPathLiteral;
    private final String myName;
    private final TextRange myRange;

    protected WebSocketPathParamPsiElement(PsiElement pathLiteral, String name, TextRange range) {
        super(pathLiteral);
        this.myPathLiteral = pathLiteral;
        this.myName = name;
        this.myRange = range;
    }

    public String getName() {
        return this.myName;
    }

    public PsiElement getParent() {
        return this.myPathLiteral;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        WebSocketPathParamPsiElement webSocketPathParamPsiElement = this;
        if (webSocketPathParamPsiElement == null) {
            WebSocketPathParamPsiElement.$$$reportNull$$$0(0);
        }
        return webSocketPathParamPsiElement;
    }

    public int getTextOffset() {
        return this.myPathLiteral.getTextRange().getStartOffset() + this.myRange.getStartOffset();
    }

    public int getTextLength() {
        return this.myName.length();
    }

    public String getTypeName() {
        return WebSocketBundle.message("websocket.path.parameter", new Object[0]);
    }

    public Icon getIcon() {
        return PlatformIcons.VARIABLE_ICON;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        WebSocketPathParamPsiElement element = (WebSocketPathParamPsiElement)((Object)o);
        if (!this.myPathLiteral.equals(element.myPathLiteral)) {
            return false;
        }
        return this.myRange.equals((Object)element.myRange);
    }

    public int hashCode() {
        int result = this.myPathLiteral.hashCode();
        result = 31 * result + this.myRange.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/references/WebSocketPathParamPsiElement", "getNavigationElement"));
    }
}

