/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.providers;

import com.intellij.icons.AllIcons;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.FindClassUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.model.gotosymbol.GoToSymbolProvider;
import com.intellij.websocket.constants.WebSocketAnnoConstants;
import com.intellij.websocket.jam.WebSocketJamModel;
import com.intellij.websocket.jam.WebSocketServerEndpoint;
import com.intellij.websocket.utils.WebSocketCommonUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class WebSocketGotoSymbolProvider
extends GoToSymbolProvider {
    protected void addNames(@NotNull Module module, Set<String> result) {
        if (module == null) {
            WebSocketGotoSymbolProvider.$$$reportNull$$$0(0);
        }
        List<WebSocketServerEndpoint> endpoints = WebSocketJamModel.getModel(module.getProject()).getServerEndpoints(module);
        result.addAll(ContainerUtil.mapNotNull(endpoints, endpoint -> endpoint.getPath()));
    }

    protected void addItems(@NotNull Module module, String name, List<NavigationItem> result) {
        if (module == null) {
            WebSocketGotoSymbolProvider.$$$reportNull$$$0(1);
        }
        for (WebSocketServerEndpoint endpoint : WebSocketJamModel.getModel(module.getProject()).getServerEndpoints(module)) {
            NavigationItem navigationItem;
            PsiNamedElement element = endpoint.getIdentifyingPsiElement();
            String elementName = element.getName();
            if (elementName == null || !elementName.trim().startsWith(name) || result.contains(navigationItem = WebSocketGotoSymbolProvider.createNavigationItem((PsiElement)element, (String)elementName, (Icon)AllIcons.Nodes.Plugin))) continue;
            result.add(navigationItem);
        }
    }

    @NotNull
    protected Collection<Module> calcAcceptableModules(@NotNull Project project) {
        if (project == null) {
            WebSocketGotoSymbolProvider.$$$reportNull$$$0(2);
        }
        HashSet<Module> modules = new HashSet<Module>();
        modules.addAll(FindClassUtil.findModulesWithClass((Project)project, (String)WebSocketAnnoConstants.SERVER_ENDPOINT.javax()));
        modules.addAll(FindClassUtil.findModulesWithClass((Project)project, (String)WebSocketAnnoConstants.SERVER_ENDPOINT.jakarta()));
        HashSet<Module> hashSet = modules;
        if (hashSet == null) {
            WebSocketGotoSymbolProvider.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    protected boolean acceptModule(Module module) {
        return WebSocketCommonUtils.isWebSocketInstalled(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/websocket/providers/WebSocketGotoSymbolProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/websocket/providers/WebSocketGotoSymbolProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAcceptableModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addNames";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addItems";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcAcceptableModules";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

