/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.providers;

import com.intellij.ide.presentation.Presentation;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.FrameworkUrlPathSpecification;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.DefaultFrameworkUrlPathSpecification;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.websocket.jam.WebSocketJamModel;
import com.intellij.websocket.jam.WebSocketServerEndpoint;
import com.intellij.websocket.providers.WebSocketTargetInfo;
import com.intellij.websocket.utils.WebSocketCommonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="WebSocket", icon="AllIcons.Webreferences.WebSocket")
public final class JavaeeWebSocketUrlResolver
implements UrlResolver {
    private final Project myProject;

    public JavaeeWebSocketUrlResolver(Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<Authority.Exact> getAuthorityHints() {
        List<Authority.Exact> list = Collections.emptyList();
        if (list == null) {
            JavaeeWebSocketUrlResolver.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<String> getSupportedSchemes() {
        List list = UrlConstants.WS_SCHEMES;
        if (list == null) {
            JavaeeWebSocketUrlResolver.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        List<WebSocketServerEndpoint> endpoints;
        if (request == null) {
            JavaeeWebSocketUrlResolver.$$$reportNull$$$0(2);
        }
        if ((endpoints = this.getAllEndpoints()).isEmpty()) {
            Set<UrlTargetInfo> set = Collections.emptySet();
            if (set == null) {
                JavaeeWebSocketUrlResolver.$$$reportNull$$$0(3);
            }
            return set;
        }
        Iterator combinations = UrlPath.combinations((UrlPath)request.getPath()).iterator();
        ArrayList<UrlTargetInfo> resolved = new ArrayList<UrlTargetInfo>();
        while (combinations.hasNext()) {
            resolved.addAll(JavaeeWebSocketUrlResolver.resolveInner((UrlPath)combinations.next(), endpoints));
        }
        if (resolved.isEmpty()) {
            List<UrlTargetInfo> list = Collections.emptyList();
            if (list == null) {
                JavaeeWebSocketUrlResolver.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (resolved.size() == 1) {
            ArrayList<UrlTargetInfo> arrayList = resolved;
            if (arrayList == null) {
                JavaeeWebSocketUrlResolver.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        return new HashSet<UrlTargetInfo>(resolved);
    }

    private static Collection<? extends UrlTargetInfo> resolveInner(@NotNull UrlPath resolveUrl, @NotNull List<WebSocketServerEndpoint> endpoints) {
        if (resolveUrl == null) {
            JavaeeWebSocketUrlResolver.$$$reportNull$$$0(6);
        }
        if (endpoints == null) {
            JavaeeWebSocketUrlResolver.$$$reportNull$$$0(7);
        }
        ArrayList<WebSocketTargetInfo> resolved = new ArrayList<WebSocketTargetInfo>();
        DefaultFrameworkUrlPathSpecification specification = JavaeeWebSocketUrlResolver.getUrlPathSpecification();
        for (WebSocketServerEndpoint endpoint : endpoints) {
            UrlPath urlPath = specification.parsePath(endpoint.getPath());
            if (!urlPath.isCompatibleWith(resolveUrl)) continue;
            resolved.add(new WebSocketTargetInfo(urlPath, endpoint.getPsiElement().getNavigationElement()));
        }
        return resolved;
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        DefaultFrameworkUrlPathSpecification specification = JavaeeWebSocketUrlResolver.getUrlPathSpecification();
        Iterable iterable = this.getAllEndpoints().stream().map(arg_0 -> JavaeeWebSocketUrlResolver.lambda$getVariants$0((FrameworkUrlPathSpecification)specification, arg_0)).collect(Collectors.toSet());
        if (iterable == null) {
            JavaeeWebSocketUrlResolver.$$$reportNull$$$0(8);
        }
        return iterable;
    }

    @NotNull
    private List<WebSocketServerEndpoint> getAllEndpoints() {
        List<WebSocketServerEndpoint> list = WebSocketJamModel.getModel(this.myProject).getServerEndpoints(GlobalSearchScope.allScope((Project)this.myProject), JavaeeType.JAVAX, JavaeeType.JAKARTA);
        if (list == null) {
            JavaeeWebSocketUrlResolver.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private static DefaultFrameworkUrlPathSpecification getUrlPathSpecification() {
        DefaultFrameworkUrlPathSpecification defaultFrameworkUrlPathSpecification = DefaultFrameworkUrlPathSpecification.INSTANCE;
        if (defaultFrameworkUrlPathSpecification == null) {
            JavaeeWebSocketUrlResolver.$$$reportNull$$$0(10);
        }
        return defaultFrameworkUrlPathSpecification;
    }

    private static /* synthetic */ WebSocketTargetInfo lambda$getVariants$0(FrameworkUrlPathSpecification specification, WebSocketServerEndpoint ep) {
        return new WebSocketTargetInfo(specification.parsePath(ep.getPath()), ep.getPsiElement().getNavigationElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/websocket/providers/JavaeeWebSocketUrlResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveUrl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorityHints";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedSchemes";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/websocket/providers/JavaeeWebSocketUrlResolver";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEndpoints";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlPathSpecification";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class WebSocketPathResolverFactory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            if (project == null) {
                WebSocketPathResolverFactory.$$$reportNull$$$0(0);
            }
            return WebSocketCommonUtils.hasWebSocketLibrary(project) ? new JavaeeWebSocketUrlResolver(project) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/websocket/providers/JavaeeWebSocketUrlResolver$WebSocketPathResolverFactory", "forProject"));
        }
    }
}

