/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ee.websocket.highlighting;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ee.websocket.highlighting.WebSocketBaseInspection;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.websocket.constants.WebSocketAnnoConstants;
import com.intellij.websocket.constants.WebSocketClassesConstants;
import com.intellij.websocket.jam.WebSocketEndpoint;
import com.intellij.websocket.resources.WebSocketInspectionBundle;
import com.intellij.websocket.utils.WebSocketCommonUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class IncorrectOnMessageMethodsInspection
extends WebSocketBaseInspection {
    IncorrectOnMessageMethodsInspection() {
    }

    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(0);
        }
        WebSocketEndpoint endpoint = WebSocketCommonUtils.getWebsocketEndpoint(aClass);
        JavaeeType javaeeType = JavaeeType.discover((Module)module, (JavaeeClass)WebSocketAnnoConstants.SERVER_ENDPOINT);
        if (endpoint == null && !InheritanceUtil.isInheritor((PsiClass)aClass, (String)WebSocketClassesConstants.ENDPOINT.fqn(javaeeType))) {
            return;
        }
        for (PsiMethod method : aClass.getMethods()) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, Collections.singleton(WebSocketAnnoConstants.ON_MESSAGE.fqn(javaeeType)));
            if (annotation == null) continue;
            IncorrectOnMessageMethodsInspection.checkParameters(method, javaeeType, holder, endpoint != null ? endpoint.getDecoders() : Collections.emptySet());
            IncorrectOnMessageMethodsInspection.checkReturnType(method, javaeeType, holder, endpoint != null ? endpoint.getEncoders() : Collections.emptySet());
        }
    }

    private static void checkParameters(@NotNull PsiMethod method, @NotNull JavaeeType javaeeType, ProblemsHolder holder, Set<PsiClass> decoders) {
        PsiIdentifier identifier;
        PsiParameter[] parameters;
        if (method == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(1);
        }
        if (javaeeType == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(2);
        }
        if ((parameters = method.getParameterList().getParameters()).length == 0 && (identifier = method.getNameIdentifier()) != null) {
            holder.registerProblem((PsiElement)identifier, WebSocketInspectionBundle.message("IncorrectOnMessageMethodsInspection.incorrect.on.message.no.parameter", new Object[0]), new LocalQuickFix[0]);
        }
        HashSet<PsiParameter> textMessageParameters = new HashSet<PsiParameter>();
        HashSet<PsiParameter> binaryMessageParameters = new HashSet<PsiParameter>();
        HashSet<PsiParameter> pongMessageParameters = new HashSet<PsiParameter>();
        HashSet<PsiParameter> sessionMessageParameters = new HashSet<PsiParameter>();
        HashSet<PsiParameter> unknownTypeParameters = new HashSet<PsiParameter>();
        for (PsiParameter parameter : parameters) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)WebSocketAnnoConstants.PATH_PARAM.fqn(javaeeType), (int)0)) {
                IncorrectOnMessageMethodsInspection.checkPathParamParameter(parameter, holder);
                continue;
            }
            PsiType type = parameter.getType();
            if (WebSocketCommonUtils.isTextMessageParameterType(type, javaeeType, parameter.getProject(), decoders)) {
                textMessageParameters.add(parameter);
                continue;
            }
            if (WebSocketCommonUtils.isBinaryMessageParameterType(type, javaeeType, parameter.getProject(), decoders)) {
                binaryMessageParameters.add(parameter);
                continue;
            }
            if (WebSocketCommonUtils.isPongMessageParameterType(type, javaeeType)) {
                pongMessageParameters.add(parameter);
                continue;
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)WebSocketClassesConstants.SESSION.fqn(javaeeType))) {
                sessionMessageParameters.add(parameter);
                continue;
            }
            unknownTypeParameters.add(parameter);
        }
        if (!IncorrectOnMessageMethodsInspection.isStringBooleanPair(textMessageParameters.toArray(PsiParameter.EMPTY_ARRAY))) {
            IncorrectOnMessageMethodsInspection.checkMultipleParameters(holder, textMessageParameters, "text");
        }
        IncorrectOnMessageMethodsInspection.checkMultipleParameters(holder, binaryMessageParameters, "binary");
        IncorrectOnMessageMethodsInspection.checkMultipleParameters(holder, pongMessageParameters, "pong");
        IncorrectOnMessageMethodsInspection.checkMultipleParameters(holder, sessionMessageParameters, "Session");
        for (PsiParameter unknownTypeParameter : unknownTypeParameters) {
            PsiTypeElement typeElement = unknownTypeParameter.getTypeElement();
            if (typeElement == null) continue;
            holder.registerProblem((PsiElement)typeElement, WebSocketInspectionBundle.message("IncorrectOnMessageMethodsInspection.incorrect.on.message.parameter.type", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static boolean isStringBooleanPair(PsiParameter @NotNull [] parameters) {
        if (parameters == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(3);
        }
        if (parameters.length == 2) {
            if (TypeConversionUtil.isBooleanType((PsiType)parameters[0].getType())) {
                return !TypeConversionUtil.isBooleanType((PsiType)parameters[1].getType());
            }
            if (TypeConversionUtil.isBooleanType((PsiType)parameters[1].getType())) {
                return !TypeConversionUtil.isBooleanType((PsiType)parameters[0].getType());
            }
        }
        return false;
    }

    private static void checkMultipleParameters(@NotNull ProblemsHolder holder, @NotNull Set<PsiParameter> textMessageParameters, @NotNull String type) {
        if (holder == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(4);
        }
        if (textMessageParameters == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(5);
        }
        if (type == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(6);
        }
        if (textMessageParameters.size() > 1) {
            for (PsiParameter parameter : textMessageParameters) {
                PsiTypeElement typeElement = parameter.getTypeElement();
                if (typeElement == null) continue;
                holder.registerProblem((PsiElement)typeElement, WebSocketInspectionBundle.message("IncorrectOnMessageMethodsInspection.incorrect.on.message.multiple.parameter.type", type), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkPathParamParameter(PsiParameter parameter, ProblemsHolder holder) {
        PsiType type = parameter.getType();
        if (type instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)type) != null) {
            return;
        }
        if ("java.lang.String".equals(type.getCanonicalText())) {
            return;
        }
        holder.registerProblem((PsiElement)parameter, WebSocketInspectionBundle.message("IncorrectOnMessageMethodsInspection.incorrect.on.message.path.parameter.type", new Object[0]), new LocalQuickFix[0]);
    }

    private static void checkReturnType(@NotNull PsiMethod method, @NotNull JavaeeType javaeeType, @NotNull ProblemsHolder holder, Set<PsiClass> encoders) {
        PsiType type;
        if (method == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(7);
        }
        if (javaeeType == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            IncorrectOnMessageMethodsInspection.$$$reportNull$$$0(9);
        }
        if ((type = method.getReturnType()) == null) {
            return;
        }
        if (type instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)type) != null) {
            return;
        }
        if ("java.lang.String".equals(type.getCanonicalText())) {
            return;
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.nio.ByteBuffer")) {
            return;
        }
        if (type instanceof PsiArrayType && ((PsiArrayType)type).getComponentType().equals(PsiType.BYTE)) {
            return;
        }
        if (WebSocketCommonUtils.hasEncoderForType(type, encoders, javaeeType, method.getProject())) {
            return;
        }
        PsiTypeElement typeElement = method.getReturnTypeElement();
        if (typeElement != null) {
            holder.registerProblem((PsiElement)typeElement, WebSocketInspectionBundle.message("IncorrectOnMessageMethodsInspection.incorrect.on.message.return.type", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textMessageParameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ee/websocket/highlighting/IncorrectOnMessageMethodsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkParameters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isStringBooleanPair";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMultipleParameters";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReturnType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

