/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.integrations.maven.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchDialog;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.plugins.gradle.integrations.maven.codeInsight.actions.AddGradleDslDependencyAction;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;

class AddGradleDslDependencyActionHandler
implements CodeInsightActionHandler {
    AddGradleDslDependencyActionHandler() {
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            AddGradleDslDependencyActionHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            AddGradleDslDependencyActionHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            AddGradleDslDependencyActionHandler.$$$reportNull$$$0(2);
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor) || !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{file})) {
            return;
        }
        List ids = ApplicationManager.getApplication().isUnitTestMode() ? AddGradleDslDependencyAction.TEST_THREAD_LOCAL.get() : MavenArtifactSearchDialog.searchForArtifact((Project)project, Collections.emptyList());
        if (ids.isEmpty()) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).withName(GradleBundle.message((String)"gradle.codeInsight.action.add_maven_dependency.text", (Object[])new Object[0])).run(() -> {
            GradleVersion gradleVersion = GradleUtil.getGradleVersion((Project)project, (PsiFile)file);
            String scope = GradleUtil.isSupportedImplementationScope((GradleVersion)gradleVersion) ? "implementation" : "compile";
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
            List closableBlocks = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)file, GrMethodCall.class);
            GrCall dependenciesBlock = (GrCall)ContainerUtil.find((Iterable)closableBlocks, call -> {
                GrExpression expression = call.getInvokedExpression();
                return "dependencies".equals(expression.getText());
            });
            if (dependenciesBlock == null) {
                StringBuilder buf = new StringBuilder();
                for (MavenId mavenId : ids) {
                    buf.append(String.format("%s '%s'\n", scope, AddGradleDslDependencyActionHandler.getMavenArtifactKey(mavenId)));
                }
                dependenciesBlock = (GrCall)factory.createStatementFromText((CharSequence)("dependencies{\n" + buf + "}"));
                file.add((PsiElement)dependenciesBlock);
            } else {
                GrClosableBlock closableBlock = (GrClosableBlock)ArrayUtil.getFirstElement((Object[])dependenciesBlock.getClosureArguments());
                if (closableBlock != null) {
                    for (MavenId mavenId : ids) {
                        closableBlock.addStatementBefore(factory.createStatementFromText((CharSequence)String.format("%s '%s'\n", scope, AddGradleDslDependencyActionHandler.getMavenArtifactKey(mavenId))), null);
                    }
                }
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    private static String getMavenArtifactKey(MavenId mavenId) {
        StringBuilder builder = new StringBuilder();
        AddGradleDslDependencyActionHandler.append(builder, mavenId.getGroupId());
        AddGradleDslDependencyActionHandler.append(builder, mavenId.getArtifactId());
        AddGradleDslDependencyActionHandler.append(builder, mavenId.getVersion());
        String string = builder.toString();
        if (string == null) {
            AddGradleDslDependencyActionHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void append(StringBuilder builder, String part) {
        if (builder.length() != 0) {
            builder.append(':');
        }
        builder.append(part == null ? "" : part);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/integrations/maven/codeInsight/actions/AddGradleDslDependencyActionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/integrations/maven/codeInsight/actions/AddGradleDslDependencyActionHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenArtifactKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

