/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinJavaModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinJsModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeDetectionUtil;
import org.jetbrains.kotlin.idea.framework.KotlinLibraryUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001c\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f\u00a8\u0006\u0010"}, d2={"replaceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "updatedFile", "Ljava/nio/file/Path;", "jarFileToReplace", "updateJar", "", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "libraryJarDescriptor", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "updateLibraries", "libraries", "", "kotlin.jvm"})
public final class KotlinJVMRuntimeLibraryUtilKt {
    public static final void updateLibraries(@NotNull Project project, @NotNull Collection<? extends Library> libraries) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
            Iterable $this$any$iv = ProjectStructureUtilKt.allModules((Project)project);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Module module = (Module)element$iv;
                    boolean bl2 = false;
                    Module module2 = module;
                    Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
                    if (!(Intrinsics.areEqual((Object)BuildSystemTypeKt.getBuildSystemType((Module)module2), (Object)BuildSystemType.JPS.INSTANCE) ^ true)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            Messages.showMessageDialog((Project)project, (String)KotlinJvmBundle.message("automatic.library.version.update.for.maven.and.gradle.projects.is.currently.unsupported.please.update.your.build.scripts.manually", new Object[0]), (String)KotlinJvmBundle.message("update.kotlin.runtime.library", new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        KotlinJavaModuleConfigurator kotlinJavaModuleConfigurator = (KotlinJavaModuleConfigurator)ConfigureKotlinInProjectUtilsKt.getConfiguratorByName("java");
        if (kotlinJavaModuleConfigurator == null) {
            String $i$f$any = "Configurator with given name doesn't exists: java";
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException($i$f$any.toString());
        }
        KotlinJavaModuleConfigurator kJvmConfigurator = kotlinJavaModuleConfigurator;
        KotlinJsModuleConfigurator kotlinJsModuleConfigurator = (KotlinJsModuleConfigurator)ConfigureKotlinInProjectUtilsKt.getConfiguratorByName("js");
        if (kotlinJsModuleConfigurator == null) {
            String string = "Configurator with given name doesn't exists: js";
            boolean element$iv = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KotlinJsModuleConfigurator kJsConfigurator = kotlinJsModuleConfigurator;
        NotificationMessageCollector collector = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project);
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        Sdk sdk = projectRootManager.getProjectSdk();
        for (Library library2 : libraries) {
            List<LibraryJarDescriptor> libraryJarDescriptors = JavaRuntimeDetectionUtil.getJavaRuntimeVersion((Library)library2) != null ? kJvmConfigurator.getLibraryJarDescriptors(sdk) : kJsConfigurator.getLibraryJarDescriptors(sdk);
            for (LibraryJarDescriptor libraryJarDescriptor : libraryJarDescriptors) {
                KotlinJVMRuntimeLibraryUtilKt.updateJar(project, library2, libraryJarDescriptor);
            }
        }
        collector.showNotification();
    }

    /*
     * WARNING - void declaration
     */
    private static final void updateJar(Project project, Library library2, LibraryJarDescriptor libraryJarDescriptor) {
        VirtualFile $i$f$mapTo2;
        Path jarPath;
        VirtualFile fileToReplace = libraryJarDescriptor.findExistingJar(library2);
        if (fileToReplace == null) {
            if (libraryJarDescriptor.getShouldExist()) {
                Collection<BuildSystemType> collection;
                void $this$mapTo$iv$iv;
                String $this$map$iv;
                Iterable iterable = ProjectStructureUtilKt.allModules((Project)project);
                StringBuilder stringBuilder = new StringBuilder().append("Update for library was requested, but file for replacement isn't present: \n").append("name = ").append(library2.getName()).append('\n').append("isExternal = `").append(KotlinLibraryUtilKt.isExternalLibrary((Library)library2)).append("`\n").append("entries = ").append(library2.getUrls(libraryJarDescriptor.getOrderRootType())).append('\n').append("buildSystems = ");
                boolean $i$f$map = false;
                void var6_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void module;
                    Module module2 = (Module)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    void v0 = module;
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"module");
                    BuildSystemType buildSystemType = BuildSystemTypeKt.getBuildSystemType((Module)v0);
                    collection.add(buildSystemType);
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = stringBuilder.append(CollectionsKt.distinct((Iterable)collection)).toString();
                $i$f$map = false;
                throw (Throwable)new IllegalStateException($this$map$iv.toString());
            }
            return;
        }
        String string = fileToReplace.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileToReplace.url");
        String oldUrl = string;
        Path $this$mapTo$iv$iv = jarPath = libraryJarDescriptor.getPathInPlugin();
        LinkOption[] destination$iv$iv = new LinkOption[]{};
        boolean $i$f$mapTo2 = false;
        if (Files.notExists($this$mapTo$iv$iv, Arrays.copyOf(destination$iv$iv, destination$iv$iv.length))) {
            KotlinRuntimeLibraryUtilKt.showRuntimeJarNotFoundDialog((Project)project, (String)libraryJarDescriptor.getJarName());
            return;
        }
        VirtualFile virtualFile = VfsUtil.getLocalFile((VirtualFile)fileToReplace);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"VfsUtil.getLocalFile(fileToReplace)");
        VirtualFile jarFileToReplace = virtualFile;
        try {
            $i$f$mapTo2 = KotlinJVMRuntimeLibraryUtilKt.replaceFile(jarPath, jarFileToReplace);
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)project, (String)KotlinJvmBundle.message("failed.to.update.0.1", jarPath, String.valueOf(e.getMessage())), (String)KotlinJvmBundle.message("library.update.failed", new Object[0]));
            return;
        }
        VirtualFile newVFile = $i$f$mapTo2;
        if (newVFile != null) {
            Library.ModifiableModel modifiableModel = library2.getModifiableModel();
            Intrinsics.checkNotNullExpressionValue((Object)modifiableModel, (String)"library.modifiableModel");
            Library.ModifiableModel model = modifiableModel;
            ApplicationUtilsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(model, oldUrl, libraryJarDescriptor, newVFile, project){
                final /* synthetic */ Library.ModifiableModel $model;
                final /* synthetic */ String $oldUrl;
                final /* synthetic */ LibraryJarDescriptor $libraryJarDescriptor;
                final /* synthetic */ VirtualFile $newVFile;
                final /* synthetic */ Project $project;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    try {
                        this.$model.removeRoot(this.$oldUrl, this.$libraryJarDescriptor.getOrderRootType());
                        VirtualFile virtualFile = JarFileSystem.getInstance().getJarRootForLocalFile(this.$newVFile);
                        if (virtualFile == null) {
                            boolean bl = false;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            Messages.showErrorDialog((Project)this.$project, (String)KotlinJvmBundle.message("failed.to.find.root.for.file.0", String.valueOf(this.$newVFile.getCanonicalPath())), (String)KotlinJvmBundle.message("library.update.failed1", new Object[0]));
                            return;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"JarFileSystem.getInstanc\u2026eAction\n                }");
                        VirtualFile newRoot = virtualFile;
                        this.$model.addRoot(newRoot, this.$libraryJarDescriptor.getOrderRootType());
                    }
                    finally {
                        this.$model.commit();
                    }
                }
                {
                    this.$model = modifiableModel;
                    this.$oldUrl = string;
                    this.$libraryJarDescriptor = libraryJarDescriptor;
                    this.$newVFile = virtualFile;
                    this.$project = project;
                    super(0);
                }
            }));
        }
    }

    @Nullable
    public static final VirtualFile replaceFile(@NotNull Path updatedFile, @NotNull VirtualFile jarFileToReplace) {
        Intrinsics.checkNotNullParameter((Object)updatedFile, (String)"updatedFile");
        Intrinsics.checkNotNullParameter((Object)jarFileToReplace, (String)"jarFileToReplace");
        Path path = VfsUtil.getLocalFile((VirtualFile)jarFileToReplace).toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"VfsUtil.getLocalFile(jarFileToReplace).toNioPath()");
        Path jarNioFileToReplace = path;
        if (Intrinsics.areEqual((Object)updatedFile, (Object)jarNioFileToReplace)) {
            return null;
        }
        Path path2 = updatedFile;
        boolean bl = true;
        boolean bl2 = false;
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, jarNioFileToReplace, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
        if (Intrinsics.areEqual((Object)PathsKt.getName((Path)jarNioFileToReplace), (Object)PathsKt.getName((Path)updatedFile)) ^ true) {
            Path newFile;
            Path path3 = newFile = jarNioFileToReplace.resolveSibling(PathsKt.getName((Path)updatedFile));
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"newFile");
            Path path4 = path3;
            Object object = new LinkOption[]{};
            boolean bl3 = false;
            if (Files.notExists(path4, Arrays.copyOf(object, ((LinkOption[])object).length))) {
                try {
                    path4 = jarNioFileToReplace;
                    object = newFile;
                    bl3 = true;
                    boolean bl4 = false;
                    CopyOption[] copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.move(path4, (Path)object, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"Files.move(this, target, *options)");
                }
                catch (Throwable e) {
                    if (e instanceof ControlFlowException) {
                        throw e;
                    }
                    object = jarNioFileToReplace;
                    bl3 = false;
                    StringBuilder stringBuilder = new StringBuilder().append("Failed to rename ").append(object.toString()).append(" to ");
                    object = newFile;
                    bl3 = false;
                    KotlinRuntimeLibraryUtilKt.getLOG().info(stringBuilder.append(object.toString()).toString());
                    return null;
                }
                VirtualFile newVFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(newFile);
                if (newVFile == null) {
                    object = newFile;
                    bl3 = false;
                    KotlinRuntimeLibraryUtilKt.getLOG().info("Failed to find " + object.toString() + " in VFS");
                    return null;
                }
                newVFile.refresh(false, true);
                return newVFile;
            }
        }
        jarFileToReplace.refresh(false, true);
        return null;
    }
}

