/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.compile;

import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetProgressIndicatorAdapter;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.PathsList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.core.KotlinCompilerIde;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.compile.KtCompilingExecutor;
import org.jetbrains.kotlin.idea.scratch.compile.KtScratchExecutionSession;
import org.jetbrains.kotlin.idea.scratch.compile.KtScratchSourceFileProcessor;
import org.jetbrains.kotlin.idea.util.JavaParametersBuilder;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J6\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0014\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dJL\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dH\u0002J\u0006\u0010%\u001a\u00020\u001bR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession;", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "executor", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;)V", "backgroundProcessIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "compileFileToTempDir", "Ljava/io/File;", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "expressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "createCommandLine", "Lkotlin/Pair;", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "Lcom/intellij/execution/target/TargetedCommandLine;", "originalFile", "module", "Lcom/intellij/openapi/module/Module;", "mainClassName", "", "tempOutDir", "execute", "", "callback", "Lkotlin/Function0;", "runCommandLine", "project", "Lcom/intellij/openapi/project/Project;", "modifiedScratchSourceFile", "result", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result$OK;", "indicator", "stop", "Companion", "kotlin.jvm"})
public final class KtScratchExecutionSession {
    private volatile ProgressIndicator backgroundProcessIndicator;
    private final ScratchFile file;
    private final KtCompilingExecutor executor;
    private static final int TIMEOUT_MS = 30000;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void execute(@NotNull Function0<Unit> callback) {
        block3: {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            KtFile ktFile = this.file.getKtScratchFile();
            if (ktFile == null) {
                ScratchExecutor.errorOccurs$default(this.executor, KotlinJvmBundle.message("couldn.t.find.ktfile.for.current.editor", new Object[0]), null, true, 2, null);
                return;
            }
            KtFile psiFile2 = ktFile;
            List<ScratchExpression> expressions = this.file.getExpressions();
            if (!this.executor.checkForErrors(psiFile2, expressions)) {
                return;
            }
            Project project = this.file.getProject();
            KtScratchSourceFileProcessor.Result result2 = (KtScratchSourceFileProcessor.Result)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<KtScratchSourceFileProcessor.Result>(expressions){
                final /* synthetic */ List $expressions;

                @NotNull
                public final KtScratchSourceFileProcessor.Result invoke() {
                    return new KtScratchSourceFileProcessor().process(this.$expressions);
                }
                {
                    this.$expressions = list;
                    super(0);
                }
            }));
            if (result2 instanceof KtScratchSourceFileProcessor.Result.Error) {
                ScratchExecutor.errorOccurs$default(this.executor, ((KtScratchSourceFileProcessor.Result.Error)result2).getMessage(), null, true, 2, null);
                return;
            }
            if (!(result2 instanceof KtScratchSourceFileProcessor.Result.OK)) break block3;
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "After processing by KtScratchSourceFileProcessor:\n " + ((KtScratchSourceFileProcessor.Result.OK)result2).getCode());
            new Task.Backgroundable(this, psiFile2, result2, project, expressions, callback, psiFile2.getProject(), KotlinJvmBundle.message("running.kotlin.scratch", new Object[0]), true){
                final /* synthetic */ KtScratchExecutionSession this$0;
                final /* synthetic */ KtFile $psiFile;
                final /* synthetic */ KtScratchSourceFileProcessor.Result $result;
                final /* synthetic */ Project $project;
                final /* synthetic */ List $expressions;
                final /* synthetic */ Function0 $callback;

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    KtScratchExecutionSession.access$setBackgroundProcessIndicator$p(this.this$0, indicator);
                    ReadAction.nonBlocking((Runnable)new Runnable(this, indicator){
                        final /* synthetic */ execute.1 this$0;
                        final /* synthetic */ ProgressIndicator $indicator;

                        public final void run() {
                            Project project = this.this$0.$psiFile.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiFile.project");
                            KtFile modifiedScratchSourceFile = new KtPsiFactory(project, false, 2, null).createFileWithLightClassSupport("tmp.kt", ((KtScratchSourceFileProcessor.Result.OK)this.this$0.$result).getCode(), (PsiElement)this.this$0.$psiFile);
                            try {
                                KtScratchExecutionSession.access$runCommandLine(this.this$0.this$0, this.this$0.$project, modifiedScratchSourceFile, this.this$0.$expressions, this.this$0.$psiFile, (KtScratchSourceFileProcessor.Result.OK)this.this$0.$result, this.$indicator, this.this$0.$callback);
                            }
                            catch (Throwable e) {
                                if (e instanceof ControlFlowException) {
                                    throw e;
                                }
                                ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), ((KtScratchSourceFileProcessor.Result.OK)this.this$0.$result).getCode());
                                KtCompilingExecutor ktCompilingExecutor = KtScratchExecutionSession.access$getExecutor$p(this.this$0.this$0);
                                String string = e.getMessage();
                                if (string == null) {
                                    Object[] objectArray = new Object[1];
                                    String string2 = this.this$0.$psiFile.getName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"psiFile.name");
                                    objectArray[0] = string2;
                                    string = KotlinJvmBundle.message("couldn.t.compile.0", objectArray);
                                }
                                ktCompilingExecutor.errorOccurs(string, e, true);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$indicator = progressIndicator;
                        }
                    }).inSmartMode(this.$project).wrapProgress(indicator).withDocumentsCommitted(this.$project).executeSynchronously();
                }
                {
                    this.this$0 = this$0;
                    this.$psiFile = $captured_local_variable$1;
                    this.$result = $captured_local_variable$2;
                    this.$project = $captured_local_variable$3;
                    this.$expressions = $captured_local_variable$4;
                    this.$callback = $captured_local_variable$5;
                    super($super_call_param$6, $super_call_param$7, $super_call_param$8);
                }
            }.queue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void runCommandLine(Project project, KtFile modifiedScratchSourceFile, List<ScratchExpression> expressions, KtFile psiFile2, KtScratchSourceFileProcessor.Result.OK result2, ProgressIndicator indicator, Function0<Unit> callback) {
        File file = (File)DumbService.getInstance((Project)project).runReadActionInSmartMode(new Computable(this, modifiedScratchSourceFile, expressions){
            final /* synthetic */ KtScratchExecutionSession this$0;
            final /* synthetic */ KtFile $modifiedScratchSourceFile;
            final /* synthetic */ List $expressions;

            @Nullable
            public final File compute() {
                return KtScratchExecutionSession.access$compileFileToTempDir(this.this$0, this.$modifiedScratchSourceFile, this.$expressions);
            }
            {
                this.this$0 = ktScratchExecutionSession;
                this.$modifiedScratchSourceFile = ktFile;
                this.$expressions = list;
            }
        });
        if (file == null) {
            return;
        }
        File tempDir2 = file;
        try {
            void environmentRequest;
            Module module = this.file.getModule();
            String string = result2.getMainClassName();
            String string2 = tempDir2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tempDir.path");
            Pair<TargetEnvironmentRequest, TargetedCommandLine> pair = this.createCommandLine(psiFile2, module, string, string2);
            TargetEnvironmentRequest targetEnvironmentRequest = (TargetEnvironmentRequest)pair.component1();
            TargetedCommandLine commandLine = (TargetedCommandLine)pair.component2();
            TargetEnvironment environment = environmentRequest.prepareEnvironment((TargetProgressIndicator)new TargetProgressIndicatorAdapter(indicator));
            String commandLinePresentation = commandLine.getCommandPresentation(environment);
            Logger logger = ScratchUtilsKt.getLOG();
            String string3 = commandLinePresentation;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"commandLinePresentation");
            ScratchUtilsKt.printDebugMessage(logger, string3);
            CapturingProcessHandler processHandler = new CapturingProcessHandler(environment.createProcess(commandLine, indicator), null, commandLinePresentation);
            ProcessOutput processOutput = processHandler.runProcessWithProgressIndicator(indicator, 30000);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"processHandler.runProces\u2026or(indicator, TIMEOUT_MS)");
            ProcessOutput executionResult = processOutput;
            if (executionResult.isTimeout()) {
                ScratchExecutor.errorOccurs$default(this.executor, KotlinJvmBundle.message("couldn.t.get.scratch.execution.result.stopped.by.timeout.0.ms", 30000), null, false, 6, null);
            } else if (executionResult.isCancelled()) {
            } else {
                this.executor.parseOutput(executionResult, expressions);
            }
        }
        finally {
            tempDir2.delete();
            callback.invoke();
        }
    }

    public final void stop() {
        block0: {
            ProgressIndicator progressIndicator = this.backgroundProcessIndicator;
            if (progressIndicator == null) break block0;
            progressIndicator.cancel();
        }
    }

    private final File compileFileToTempDir(KtFile psiFile2, List<ScratchExpression> expressions) {
        if (!this.executor.checkForErrors(psiFile2, expressions)) {
            return null;
        }
        File file = FileUtil.createTempDirectory((String)"compile", (String)"scratch");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtil.createTempDirectory(\"compile\", \"scratch\")");
        File tmpDir = file;
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Temp output dir: " + tmpDir.getPath());
        new KotlinCompilerIde(psiFile2, null, null, null, false, 30, null).compileToDirectory(tmpDir);
        return tmpDir;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<TargetEnvironmentRequest, TargetedCommandLine> createCommandLine(KtFile originalFile, Module module, String mainClassName, String tempOutDir) {
        WslTargetEnvironmentConfiguration wslTargetEnvironmentConfiguration;
        JavaParameters javaParameters;
        block7: {
            block6: {
                WslTargetEnvironmentConfiguration wslConfiguration;
                Project project = originalFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"originalFile.project");
                javaParameters = new JavaParametersBuilder(project).withSdkFrom(module, true).withMainClassName(mainClassName).build();
                javaParameters.getClassPath().add(tempOutDir);
                if (module != null) {
                    javaParameters.getClassPath().addAll(JavaParametersBuilder.Companion.getModuleDependencies(module));
                }
                Project project2 = originalFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"originalFile.project");
                ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper = ScriptConfigurationManager.Companion.getInstance(project2).getConfiguration(originalFile);
                if (scriptCompilationConfigurationWrapper != null) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper2 = scriptCompilationConfigurationWrapper;
                    boolean bl = false;
                    boolean bl2 = false;
                    ScriptCompilationConfigurationWrapper it = scriptCompilationConfigurationWrapper2;
                    boolean bl3 = false;
                    Iterable iterable = it.getDependenciesClassPath();
                    PathsList pathsList = javaParameters.getClassPath();
                    boolean $i$f$map = false;
                    void var14_15 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void f;
                        File file = (File)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        String string = f.getAbsolutePath();
                        collection.add(string);
                    }
                    collection = (List)destination$iv$iv;
                    pathsList.addAll((List)collection);
                }
                if ((wslTargetEnvironmentConfiguration = (wslConfiguration = JavaCommandLineState.checkCreateWslConfiguration((Sdk)javaParameters.getJdk()))) == null) break block6;
                Project project3 = originalFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"originalFile.project");
                if ((wslTargetEnvironmentConfiguration = wslTargetEnvironmentConfiguration.createEnvironmentRequest(project3)) != null) break block7;
            }
            wslTargetEnvironmentConfiguration = (TargetEnvironmentRequest)new LocalTargetEnvironmentRequest();
        }
        WslTargetEnvironmentConfiguration request = wslTargetEnvironmentConfiguration;
        TargetedCommandLine targetedCommandLine = javaParameters.toCommandLine((TargetEnvironmentRequest)request).build();
        Intrinsics.checkNotNullExpressionValue((Object)targetedCommandLine, (String)"javaParameters.toCommandLine(request).build()");
        return TuplesKt.to((Object)request, (Object)targetedCommandLine);
    }

    public KtScratchExecutionSession(@NotNull ScratchFile file, @NotNull KtCompilingExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.file = file;
        this.executor = executor;
    }

    public static final /* synthetic */ ProgressIndicator access$getBackgroundProcessIndicator$p(KtScratchExecutionSession $this) {
        return $this.backgroundProcessIndicator;
    }

    public static final /* synthetic */ void access$setBackgroundProcessIndicator$p(KtScratchExecutionSession $this, ProgressIndicator progressIndicator) {
        $this.backgroundProcessIndicator = progressIndicator;
    }

    public static final /* synthetic */ void access$runCommandLine(KtScratchExecutionSession $this, Project project, KtFile modifiedScratchSourceFile, List expressions, KtFile psiFile2, KtScratchSourceFileProcessor.Result.OK result2, ProgressIndicator indicator, Function0 callback) {
        $this.runCommandLine(project, modifiedScratchSourceFile, expressions, psiFile2, result2, indicator, (Function0<Unit>)callback);
    }

    public static final /* synthetic */ KtCompilingExecutor access$getExecutor$p(KtScratchExecutionSession $this) {
        return $this.executor;
    }

    public static final /* synthetic */ File access$compileFileToTempDir(KtScratchExecutionSession $this, KtFile psiFile2, List expressions) {
        return $this.compileFileToTempDir(psiFile2, expressions);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession$Companion;", "", "()V", "TIMEOUT_MS", "", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

