/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ui.KtScratchFileEditorProviderKt;
import org.jetbrains.kotlin.idea.scratch.ui.KtScratchFileEditorWithPreview;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0007\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\u0010*\u00020\u0014\u001a\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0019"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "isKotlinScratch", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "isKotlinWorksheet", "getScratchEditorForSelectedFile", "Lorg/jetbrains/kotlin/idea/scratch/ui/KtScratchFileEditorWithPreview;", "fileManager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "virtualFile", "getScratchFileFromSelectedEditor", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "project", "Lcom/intellij/openapi/project/Project;", "getScratchFile", "Lcom/intellij/openapi/fileEditor/TextEditor;", "printDebugMessage", "", "str", "", "kotlin.jvm"})
public final class ScratchUtilsKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    public static final void printDebugMessage(@NotNull Logger $this$printDebugMessage, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)$this$printDebugMessage, (String)"$this$printDebugMessage");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if ($this$printDebugMessage.isDebugEnabled()) {
            $this$printDebugMessage.debug("SCRATCH: " + str);
        }
    }

    public static final boolean isKotlinWorksheet(@NotNull VirtualFile $this$isKotlinWorksheet) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinWorksheet, (String)"$this$isKotlinWorksheet");
        String string = $this$isKotlinWorksheet.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return StringsKt.endsWith$default((String)string, (String)".ws.kts", (boolean)false, (int)2, null);
    }

    public static final boolean isKotlinScratch(@NotNull VirtualFile $this$isKotlinScratch) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinScratch, (String)"$this$isKotlinScratch");
        return Intrinsics.areEqual((Object)KotlinParserDefinition.STD_SCRIPT_SUFFIX, (Object)$this$isKotlinScratch.getExtension()) && ScratchFileService.getInstance().getRootType($this$isKotlinScratch) instanceof ScratchRootType;
    }

    @TestOnly
    @Nullable
    public static final KtScratchFileEditorWithPreview getScratchEditorForSelectedFile(@NotNull FileEditorManager fileManager, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)fileManager, (String)"fileManager");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        FileEditor fileEditor = fileManager.getSelectedEditor(virtualFile);
        if (!(fileEditor instanceof TextEditor)) {
            fileEditor = null;
        }
        TextEditor textEditor = (TextEditor)fileEditor;
        if (textEditor == null) {
            return null;
        }
        TextEditor editor = textEditor;
        return KtScratchFileEditorProviderKt.findScratchFileEditorWithPreview(editor);
    }

    @Nullable
    public static final ScratchFile getScratchFileFromSelectedEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
        Editor editor = fileEditorManager.getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"FileEditorManager.getIns\u2026TextEditor ?: return null");
        Editor editor2 = editor;
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor2);
        Intrinsics.checkNotNullExpressionValue((Object)textEditor, (String)"TextEditorProvider.getIn\u2026e().getTextEditor(editor)");
        return ScratchUtilsKt.getScratchFile(textEditor);
    }

    @Nullable
    public static final ScratchFile getScratchFile(@NotNull TextEditor $this$getScratchFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getScratchFile, (String)"$this$getScratchFile");
        KtScratchFileEditorWithPreview ktScratchFileEditorWithPreview = KtScratchFileEditorProviderKt.findScratchFileEditorWithPreview($this$getScratchFile);
        return ktScratchFileEditorWithPreview != null ? ktScratchFileEditorWithPreview.getScratchFile() : null;
    }

    static {
        Logger logger = Logger.getInstance((String)"#org.jetbrains.kotlin.idea.scratch");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#org\u2026ins.kotlin.idea.scratch\")");
        LOG = logger;
    }
}

