/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.ProjectUtilKt;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchFileListener;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchCompilationSupport;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandlerAdapter;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H$J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\nH$J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H$J\u0018\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\nJ\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFileLanguageProvider;", "", "()V", "createCompilingExecutor", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor;", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "createFile", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "createReplExecutor", "Lorg/jetbrains/kotlin/idea/scratch/SequentialScratchExecutor;", "newScratchFile", "addOutputHandlers", "", "Companion", "kotlin.jvm"})
public abstract class ScratchFileLanguageProvider {
    private static final LanguageExtension<ScratchFileLanguageProvider> EXTENSION;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final ScratchFile newScratchFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ScratchFile scratchFile = this.createFile(project, file);
        if (scratchFile == null) {
            return null;
        }
        ScratchFile scratchFile2 = scratchFile;
        scratchFile2.setReplScratchExecutor(this.createReplExecutor(scratchFile2));
        scratchFile2.setCompilingScratchExecutor(this.createCompilingExecutor(scratchFile2));
        SequentialScratchExecutor sequentialScratchExecutor = scratchFile2.getReplScratchExecutor();
        if (sequentialScratchExecutor != null) {
            this.addOutputHandlers(sequentialScratchExecutor);
        }
        ScratchExecutor scratchExecutor = scratchFile2.getCompilingScratchExecutor();
        if (scratchExecutor != null) {
            this.addOutputHandlers(scratchExecutor);
        }
        ((ScratchFileListener)ProjectUtilKt.syncPublisherWithDisposeCheck((Project)scratchFile2.getProject(), ScratchFileListener.Companion.getTOPIC())).fileCreated(scratchFile2);
        return scratchFile2;
    }

    private final void addOutputHandlers(ScratchExecutor $this$addOutputHandlers) {
        $this$addOutputHandlers.addOutputHandler(new ScratchOutputHandlerAdapter($this$addOutputHandlers){
            final /* synthetic */ ScratchExecutor $this_addOutputHandlers;

            public void onStart(@NotNull ScratchFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ScratchCompilationSupport.INSTANCE.start(file, this.$this_addOutputHandlers);
            }

            public void onFinish(@NotNull ScratchFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ScratchCompilationSupport.INSTANCE.stop();
            }
            {
                this.$this_addOutputHandlers = $receiver;
            }
        });
    }

    @Nullable
    protected abstract ScratchFile createFile(@NotNull Project var1, @NotNull VirtualFile var2);

    @Nullable
    protected abstract SequentialScratchExecutor createReplExecutor(@NotNull ScratchFile var1);

    @Nullable
    protected abstract ScratchExecutor createCompilingExecutor(@NotNull ScratchFile var1);

    static {
        Companion = new Companion(null);
        EXTENSION = new LanguageExtension("org.jetbrains.kotlin.scratchFileLanguageProvider");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFileLanguageProvider$Companion;", "", "()V", "EXTENSION", "Lcom/intellij/lang/LanguageExtension;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFileLanguageProvider;", "get", "language", "Lcom/intellij/lang/Language;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "kotlin.jvm"})
    public static final class Companion {
        @Nullable
        public final ScratchFileLanguageProvider get(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            return (ScratchFileLanguageProvider)EXTENSION.forLanguage(language);
        }

        @Nullable
        public final ScratchFileLanguageProvider get(@NotNull FileType fileType) {
            ScratchFileLanguageProvider scratchFileLanguageProvider;
            LanguageFileType languageFileType;
            Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
            FileType fileType2 = fileType;
            if (!(fileType2 instanceof LanguageFileType)) {
                fileType2 = null;
            }
            if ((languageFileType = (LanguageFileType)fileType2) != null && (languageFileType = languageFileType.getLanguage()) != null) {
                LanguageFileType languageFileType2 = languageFileType;
                boolean bl = false;
                boolean bl2 = false;
                LanguageFileType it = languageFileType2;
                boolean bl3 = false;
                LanguageFileType languageFileType3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)languageFileType3, (String)"it");
                scratchFileLanguageProvider = Companion.get((Language)languageFileType3);
            } else {
                scratchFileLanguageProvider = null;
            }
            return scratchFileLanguageProvider;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

