/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0005J\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "", "project", "Lcom/intellij/openapi/project/Project;", "groupDisplayId", "", "title", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "messages", "Ljava/util/ArrayList;", "resultMessage", "getResultMessage", "()Ljava/lang/String;", "addMessage", "message", "showNotification", "", "kotlin.jvm"})
public class NotificationMessageCollector {
    private final ArrayList<String> messages;
    private final Project project;
    private final String groupDisplayId;
    private final String title;

    @NotNull
    public final NotificationMessageCollector addMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.messages.add(message);
        return this;
    }

    public final void showNotification() {
        if (this.messages.isEmpty()) {
            return;
        }
        Notifications.Bus.notify((Notification)new Notification(this.groupDisplayId, this.title, this.getResultMessage(), NotificationType.INFORMATION), (Project)this.project);
    }

    private final String getResultMessage() {
        String singleMessage = (String)CollectionsKt.singleOrNull((List)this.messages);
        if (singleMessage != null) {
            return singleMessage;
        }
        return CollectionsKt.joinToString$default((Iterable)this.messages, (CharSequence)"<br/><br/>", null, null, (int)0, null, null, (int)62, null);
    }

    public NotificationMessageCollector(@NotNull Project project, @NotNull String groupDisplayId, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)groupDisplayId, (String)"groupDisplayId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.project = project;
        this.groupDisplayId = groupDisplayId;
        this.title = title;
        this.messages = new ArrayList();
    }
}

