/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManagerKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider;
import org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider$Companion$createSetupSdkPanel$;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMapKt;
import org.jetbrains.kotlin.idea.configuration.ui.KotlinConfigurationCheckerService;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.SuppressNotificationState;
import org.jetbrains.kotlin.idea.versions.UnsupportedAbiVersionNotificationPanelProvider;
import org.jetbrains.kotlin.idea.versions.UnsupportedAbiVersionNotificationPanelProviderKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinSetupEnvironmentNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getKey", "Lcom/intellij/openapi/util/Key;", "Companion", "kotlin.jvm"})
public final class KotlinSetupEnvironmentNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private final Project myProject;
    private static final Key<EditorNotificationPanel> KEY;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        if (Intrinsics.areEqual((Object)file.getFileType(), (Object)KotlinFileType.INSTANCE) ^ true) {
            return null;
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile == null) {
            return null;
        }
        KtFile psiFile3 = ktFile;
        if (psiFile3.getLanguage() != KotlinLanguage.INSTANCE) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile3));
        if (module == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026t(psiFile) ?: return null");
        Module module2 = module;
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        if (!moduleRootManager.getFileIndex().isInSourceContent(file)) {
            return null;
        }
        ModuleRootManager moduleRootManager2 = ModuleRootManager.getInstance((Module)module2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager2, (String)"ModuleRootManager.getInstance(module)");
        if (moduleRootManager2.getSdk() == null && JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetector.getPlatform((KtFile)psiFile3))) {
            return KotlinSetupEnvironmentNotificationProvider.Companion.createSetupSdkPanel(this.myProject, (PsiFile)psiFile3);
        }
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        KotlinConfigurationCheckerService configurationChecker = KotlinConfigurationCheckerService.Companion.getInstance(project);
        if (!configurationChecker.isSyncing() && ConfigureKotlinInProjectUtilsKt.isNotConfiguredNotificationRequired(ModuleSourceRootMapKt.toModuleGroup((Module)module2)) && !ConfigureKotlinInProjectUtilsKt.hasAnyKotlinRuntimeInScope(module2) && UnsupportedAbiVersionNotificationPanelProvider.Companion.collectBadRoots(module2).isEmpty()) {
            return KotlinSetupEnvironmentNotificationProvider.Companion.createKotlinNotConfiguredPanel(module2);
        }
        return null;
    }

    public KotlinSetupEnvironmentNotificationProvider(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"Setup SDK");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<EditorNotificationPanel>(\"Setup SDK\")");
        KEY = key;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinSetupEnvironmentNotificationProvider$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ui/EditorNotificationPanel;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "createConfiguratorsPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "project", "Lcom/intellij/openapi/project/Project;", "configurators", "", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "createKotlinNotConfiguredPanel", "module", "Lcom/intellij/openapi/module/Module;", "createSetupSdkPanel", "file", "Lcom/intellij/psi/PsiFile;", "apply", "", "kotlin.jvm"})
    public static final class Companion {
        private final EditorNotificationPanel createSetupSdkPanel(Project project, PsiFile file) {
            EditorNotificationPanel editorNotificationPanel = new EditorNotificationPanel();
            boolean bl = false;
            boolean bl2 = false;
            EditorNotificationPanel $this$apply = editorNotificationPanel;
            boolean bl3 = false;
            $this$apply.setText(JavaUiBundle.message((String)"project.sdk.not.defined", (Object[])new Object[0]));
            $this$apply.createActionLabel(ProjectBundle.message((String)"project.sdk.setup", (Object[])new Object[0]), new Runnable(project, file){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ PsiFile $file$inlined;
                {
                    this.$project$inlined = project;
                    this.$file$inlined = psiFile2;
                }

                public final void run() {
                    if (ProjectSettingsService.getInstance((Project)this.$project$inlined).chooseAndSetSdk() == null) {
                        return;
                    }
                    ApplicationUtilsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ Companion$createSetupSdkPanel$$inlined$apply$lambda$1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }

                        public final void invoke() {
                            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)this.this$0.$file$inlined));
                            if (module != null) {
                                ModuleRootModificationUtil.setSdkInherited((Module)module);
                            }
                        }
                    }));
                }
            });
            return editorNotificationPanel;
        }

        private final EditorNotificationPanel createKotlinNotConfiguredPanel(Module module) {
            EditorNotificationPanel editorNotificationPanel = new EditorNotificationPanel();
            boolean bl = false;
            boolean bl2 = false;
            EditorNotificationPanel $this$apply = editorNotificationPanel;
            boolean bl3 = false;
            $this$apply.setText(KotlinJvmBundle.message("kotlin.not.configured", new Object[0]));
            List configurators = CollectionsKt.toList((Iterable)ConfigureKotlinInProjectUtilsKt.getAbleToRunConfigurators(module));
            Collection collection = configurators;
            boolean bl4 = false;
            if (!collection.isEmpty()) {
                UnsupportedAbiVersionNotificationPanelProviderKt.createComponentActionLabel($this$apply, KotlinJvmBundle.message("action.text.configure", new Object[0]), (Function1<? super HyperlinkLabel, Unit>)((Function1)new Function1<HyperlinkLabel, Unit>(configurators, module){
                    final /* synthetic */ List $configurators;
                    final /* synthetic */ Module $module$inlined;
                    {
                        this.$configurators = list;
                        this.$module$inlined = module;
                        super(1);
                    }

                    public final void invoke(@NotNull HyperlinkLabel label) {
                        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
                        KotlinProjectConfigurator singleConfigurator = (KotlinProjectConfigurator)CollectionsKt.singleOrNull((List)this.$configurators);
                        if (singleConfigurator != null) {
                            Project project = this.$module$inlined.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
                            org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider$Companion.access$apply(KotlinSetupEnvironmentNotificationProvider.Companion, singleConfigurator, project);
                        } else {
                            Project project = this.$module$inlined.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
                            ListPopup configuratorsPopup = KotlinSetupEnvironmentNotificationProvider.Companion.createConfiguratorsPopup(project, this.$configurators);
                            configuratorsPopup.showUnderneathOf((Component)label);
                        }
                    }
                }));
                UnsupportedAbiVersionNotificationPanelProviderKt.createComponentActionLabel($this$apply, KotlinJvmBundle.message("action.text.ignore", new Object[0]), (Function1<? super HyperlinkLabel, Unit>)((Function1)new Function1<HyperlinkLabel, Unit>(module){
                    final /* synthetic */ Module $module$inlined;
                    {
                        this.$module$inlined = module;
                        super(1);
                    }

                    public final void invoke(@NotNull HyperlinkLabel it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        SuppressNotificationState.Companion.suppressKotlinNotConfigured(this.$module$inlined);
                        EditorNotifications.getInstance((Project)this.$module$inlined.getProject()).updateAllNotifications();
                    }
                }));
            }
            return editorNotificationPanel;
        }

        private final void apply(KotlinProjectConfigurator $this$apply, Project project) {
            $this$apply.configure(project, CollectionsKt.emptyList());
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
            ConfigureKotlinNotificationManagerKt.checkHideNonConfiguredNotifications(project);
        }

        @NotNull
        public final ListPopup createConfiguratorsPopup(@NotNull Project project, @NotNull List<? extends KotlinProjectConfigurator> configurators) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(configurators, (String)"configurators");
            BaseListPopupStep<KotlinProjectConfigurator> step2 = new BaseListPopupStep<KotlinProjectConfigurator>(project, configurators, KotlinJvmBundle.message("title.choose.configurator", new Object[0]), configurators){
                final /* synthetic */ Project $project;
                final /* synthetic */ List $configurators;

                @NotNull
                public String getTextFor(@Nullable KotlinProjectConfigurator value) {
                    Object object = value;
                    if (object == null || (object = object.getPresentableText()) == null) {
                        object = "<none>";
                    }
                    return object;
                }

                @Nullable
                public PopupStep<?> onChosen(@Nullable KotlinProjectConfigurator selectedValue, boolean finalChoice) {
                    return this.doFinalStep(new Runnable(this, selectedValue){
                        final /* synthetic */ createConfiguratorsPopup.step.1 this$0;
                        final /* synthetic */ KotlinProjectConfigurator $selectedValue;

                        public final void run() {
                            block0: {
                                KotlinProjectConfigurator kotlinProjectConfigurator = this.$selectedValue;
                                if (kotlinProjectConfigurator == null) break block0;
                                org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider$Companion.access$apply(KotlinSetupEnvironmentNotificationProvider.Companion, kotlinProjectConfigurator, this.this$0.$project);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$selectedValue = kotlinProjectConfigurator;
                        }
                    });
                }
                {
                    this.$project = $captured_local_variable$0;
                    this.$configurators = $captured_local_variable$1;
                    super($super_call_param$2, $super_call_param$3);
                }
            };
            ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
            Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"JBPopupFactory.getInstance().createListPopup(step)");
            return listPopup;
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$apply(Companion $this, KotlinProjectConfigurator $this$access_u24apply, Project project) {
            $this.apply($this$access_u24apply, project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

