/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.ProjectTopics;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/JvmStartupActivity;", "Lcom/intellij/openapi/startup/StartupActivity;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.jvm"})
public final class JvmStartupActivity
implements StartupActivity {
    public void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect()");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(project){
            final /* synthetic */ Project $project;

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EditorNotifications.getInstance((Project)this.$project).updateAllNotifications();
            }
            {
                this.$project = $captured_local_variable$0;
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(project){
            final /* synthetic */ Project $project;

            public void enteredDumbMode() {
            }

            public void exitDumbMode() {
                EditorNotifications.getInstance((Project)this.$project).updateAllNotifications();
            }
            {
                this.$project = $captured_local_variable$0;
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(project){
            final /* synthetic */ Project $project;

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileMoveEvent)) continue;
                    VirtualFile virtualFile = ((VFileMoveEvent)vFileEvent).getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                    if (!Intrinsics.areEqual((Object)virtualFile.getFileType(), (Object)JavaFileType.INSTANCE)) continue;
                    EditorNotifications.getInstance((Project)this.$project).updateNotifications(((VFileMoveEvent)vFileEvent).getFile());
                }
            }
            {
                this.$project = $captured_local_variable$0;
            }
        });
    }
}

