/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.util.List;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CliArgumentStringBuilder$WhenMappings;
import org.jetbrains.kotlin.config.LanguageFeature;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0012\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004J\f\u0010\u0015\u001a\u00020\u0007*\u00020\u000bH\u0002JL\u0010\u0016\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u00042\b\b\u0002\u0010\u0019\u001a\u00020\u00042\b\b\u0002\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n\u0018\u00010\t*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u0004*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/cli/common/arguments/CliArgumentStringBuilder;", "", "()V", "LANGUAGE_FEATURE_DEDICATED_FLAG_PREFIX", "", "LANGUAGE_FEATURE_FLAG_PREFIX", "versionRegex", "Lkotlin/text/Regex;", "dedicatedFlagInfo", "Lkotlin/Pair;", "Lkotlin/KotlinVersion;", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "getDedicatedFlagInfo", "(Lorg/jetbrains/kotlin/config/LanguageFeature;)Lkotlin/Pair;", "sign", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "getSign", "(Lorg/jetbrains/kotlin/config/LanguageFeature$State;)Ljava/lang/String;", "buildArgumentString", "state", "kotlinVersion", "getFeatureMentionInCompilerArgsRegex", "replaceLanguageFeature", "feature", "prefix", "postfix", "separator", "quoted", "", "kotlin.jvm"})
public final class CliArgumentStringBuilder {
    private static final String LANGUAGE_FEATURE_FLAG_PREFIX = "-XXLanguage:";
    private static final String LANGUAGE_FEATURE_DEDICATED_FLAG_PREFIX = "-X";
    private static final Regex versionRegex;
    @NotNull
    public static final CliArgumentStringBuilder INSTANCE;

    private final Pair<String, KotlinVersion> getDedicatedFlagInfo(LanguageFeature $this$dedicatedFlagInfo) {
        Pair pair;
        switch (CliArgumentStringBuilder$WhenMappings.$EnumSwitchMapping$0[$this$dedicatedFlagInfo.ordinal()]) {
            case 1: {
                pair = new Pair((Object)"inline-classes", (Object)new KotlinVersion(1, 3, 50));
                break;
            }
            default: {
                pair = null;
            }
        }
        return pair;
    }

    private final String getSign(LanguageFeature.State $this$sign) {
        String string;
        switch (CliArgumentStringBuilder$WhenMappings.$EnumSwitchMapping$1[$this$sign.ordinal()]) {
            case 1: {
                string = "+";
                break;
            }
            case 2: {
                string = "-";
                break;
            }
            case 3: {
                string = "+";
                break;
            }
            case 4: {
                string = "-";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final Regex getFeatureMentionInCompilerArgsRegex(LanguageFeature $this$getFeatureMentionInCompilerArgsRegex) {
        String string;
        String basePattern = "-XXLanguage:(?:-|\\+)" + $this$getFeatureMentionInCompilerArgsRegex.name();
        if (this.getDedicatedFlagInfo($this$getFeatureMentionInCompilerArgsRegex) != null) {
            StringBuilder stringBuilder = new StringBuilder().append("(?:").append(basePattern).append(")|-X");
            Pair<String, KotlinVersion> pair = this.getDedicatedFlagInfo($this$getFeatureMentionInCompilerArgsRegex);
            Intrinsics.checkNotNull(pair);
            string = stringBuilder.append((String)pair.getFirst()).toString();
        } else {
            string = basePattern;
        }
        String fullPattern = string;
        return new Regex(fullPattern);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String buildArgumentString(@NotNull LanguageFeature $this$buildArgumentString, @NotNull LanguageFeature.State state, @Nullable String kotlinVersion) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$buildArgumentString, (String)"$this$buildArgumentString");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        boolean shouldBeFeatureEnabled = state == LanguageFeature.State.ENABLED || state == LanguageFeature.State.ENABLED_WITH_WARNING;
        Pair<String, KotlinVersion> pair = this.getDedicatedFlagInfo($this$buildArgumentString);
        if (pair != null) {
            void xFlag;
            Pair<String, KotlinVersion> pair2 = pair;
            boolean bl = false;
            boolean bl2 = false;
            Pair<String, KotlinVersion> $this$run = pair2;
            boolean bl3 = false;
            Pair<String, KotlinVersion> pair3 = $this$run;
            String string = (String)pair3.component1();
            KotlinVersion xFlagSinceVersion = (KotlinVersion)pair3.component2();
            if (kotlinVersion == null) {
                object = xFlag;
            } else {
                MatchResult matchResult = Regex.find$default((Regex)versionRegex, (CharSequence)kotlinVersion, (int)0, (int)2, null);
                if (matchResult == null) {
                    object = xFlag;
                } else {
                    void minor;
                    void major;
                    MatchResult parsedVersion = matchResult;
                    MatchResult.Destructured destructured = parsedVersion.getDestructured();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    MatchResult.Destructured $dstr$major$minor$patch = destructured;
                    boolean bl6 = false;
                    Object object2 = $dstr$major$minor$patch;
                    boolean bl7 = false;
                    String string2 = (String)object2.getMatch().getGroupValues().get(1);
                    object2 = $dstr$major$minor$patch;
                    bl7 = false;
                    String string3 = (String)object2.getMatch().getGroupValues().get(2);
                    object2 = $dstr$major$minor$patch;
                    bl7 = false;
                    String patch = (String)object2.getMatch().getGroupValues().get(3);
                    object2 = major;
                    bl7 = false;
                    int n = Integer.parseInt((String)object2);
                    object2 = minor;
                    bl7 = false;
                    int n2 = Integer.parseInt((String)object2);
                    object2 = patch;
                    bl7 = false;
                    boolean isAtLeastSpecifiedVersion = new KotlinVersion(n, n2, Integer.parseInt((String)object2)).compareTo(xFlagSinceVersion) >= 0;
                    object = isAtLeastSpecifiedVersion ? xFlag : null;
                }
            }
        } else {
            object = null;
        }
        Object dedicatedFlag = object;
        return shouldBeFeatureEnabled && dedicatedFlag != null ? LANGUAGE_FEATURE_DEDICATED_FLAG_PREFIX + dedicatedFlag : LANGUAGE_FEATURE_FLAG_PREFIX + this.getSign(state) + $this$buildArgumentString.name();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String replaceLanguageFeature(@NotNull String $this$replaceLanguageFeature, @NotNull LanguageFeature feature, @NotNull LanguageFeature.State state, @Nullable String kotlinVersion, @NotNull String prefix, @NotNull String postfix, @NotNull String separator, boolean quoted) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$replaceLanguageFeature, (String)"$this$replaceLanguageFeature");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        String quote = quoted ? "\"" : "";
        String featureArgumentString = this.buildArgumentString(feature, state, kotlinVersion);
        MatchResult existingFeatureMatchResult = Regex.find$default((Regex)this.getFeatureMentionInCompilerArgsRegex(feature), (CharSequence)$this$replaceLanguageFeature, (int)0, (int)2, null);
        if (existingFeatureMatchResult != null) {
            string = StringsKt.replace$default((String)$this$replaceLanguageFeature, (String)existingFeatureMatchResult.getValue(), (String)featureArgumentString, (boolean)false, (int)4, null);
        } else {
            List splitText;
            CharSequence charSequence = postfix;
            boolean bl = false;
            List list = splitText = charSequence.length() > 0 ? StringsKt.split$default((CharSequence)$this$replaceLanguageFeature, (String[])new String[]{postfix}, (boolean)false, (int)0, (int)6, null) : CollectionsKt.listOf((Object[])new String[]{$this$replaceLanguageFeature, ""});
            if (splitText.size() != 2) {
                string = prefix + quote + featureArgumentString + quote + postfix;
            } else {
                void mainPart;
                List list2;
                List list3 = list2 = splitText;
                boolean bl2 = false;
                charSequence = (String)list3.get(0);
                list3 = list2;
                bl2 = false;
                String commentPart = (String)list3.get(1);
                string = (String)mainPart + separator + quote + featureArgumentString + quote + postfix + commentPart;
            }
        }
        return string;
    }

    public static /* synthetic */ String replaceLanguageFeature$default(CliArgumentStringBuilder cliArgumentStringBuilder, String string, LanguageFeature languageFeature, LanguageFeature.State state, String string2, String string3, String string4, String string5, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = "";
        }
        if ((n & 0x10) != 0) {
            string4 = "";
        }
        if ((n & 0x20) != 0) {
            string5 = ", ";
        }
        if ((n & 0x40) != 0) {
            bl = true;
        }
        return cliArgumentStringBuilder.replaceLanguageFeature(string, languageFeature, state, string2, string3, string4, string5, bl);
    }

    private CliArgumentStringBuilder() {
    }

    static {
        CliArgumentStringBuilder cliArgumentStringBuilder;
        INSTANCE = cliArgumentStringBuilder = new CliArgumentStringBuilder();
        versionRegex = new Regex("^(\\d+)\\.(\\d+)\\.(\\d+)");
    }
}

