/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.utils.model;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.data.commons.model.jam.SpringRepositoryDefinition;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class RepositoriesSearchUtil {
    public static List<CommonSpringBean> getAllRepositories(@NotNull Module module) {
        if (module == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(0);
        }
        if (module.isDisposed()) {
            return Collections.emptyList();
        }
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(RepositoriesSearchUtil.getAllRepositories(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)true), module, "org.springframework.data.repository.Repository"), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public static List<CommonSpringBean> getAllRepositories(@NotNull GlobalSearchScope scope, @NotNull Module module, @NotNull String repositoryBaseClassName) {
        PsiClass repositoryClass;
        if (scope == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(1);
        }
        if (module == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(2);
        }
        if (repositoryBaseClassName == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(3);
        }
        return (repositoryClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(repositoryBaseClassName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)true))) == null ? Collections.emptyList() : RepositoriesSearchUtil.getRepositoriesCustomBeans(scope, repositoryClass, module.getProject());
    }

    private static List<CommonSpringBean> getRepositoriesCustomBeans(@NotNull GlobalSearchScope scope, @NotNull PsiClass repositoryClass, @NotNull Project project) {
        if (scope == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(4);
        }
        if (repositoryClass == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(5);
        }
        if (project == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(6);
        }
        ArrayList<CommonSpringBean> beans = new ArrayList<CommonSpringBean>();
        beans.addAll(RepositoriesSearchUtil.getRepositoryInterfaceInheritors(scope, repositoryClass));
        beans.addAll(RepositoriesSearchUtil.getRepositoryDefinitions(scope, project));
        return beans;
    }

    private static List<CommonSpringBean> getRepositoryInterfaceInheritors(GlobalSearchScope scope, PsiClass repositoryClass) {
        CommonProcessors.CollectProcessor<PsiClass> collectProcessor = new CommonProcessors.CollectProcessor<PsiClass>(){

            protected boolean accept(PsiClass psiClass) {
                return !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.springframework.data.repository.NoRepositoryBean", (int)0) && !SpringCommonUtils.isStereotypeComponentOrMeta((PsiClass)psiClass);
            }
        };
        ClassInheritorsSearch.search((PsiClass)repositoryClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).forEach((Processor)collectProcessor);
        return ContainerUtil.map((Collection)collectProcessor.getResults(), CustomSpringComponent::new);
    }

    @NotNull
    public static List<SpringRepositoryDefinition> getRepositoryDefinitions(@NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (scope == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(8);
        }
        JamService service = JamService.getJamService((Project)project);
        List list = service.getJamClassElements(SpringRepositoryDefinition.META, "org.springframework.data.repository.RepositoryDefinition", scope);
        if (list == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryBaseClassName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryClass";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/utils/model/RepositoriesSearchUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/utils/model/RepositoriesSearchUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllRepositories";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoriesCustomBeans";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryDefinitions";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

