/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.view.panels;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.data.commons.view.SpringRepositoriesView;
import com.intellij.spring.data.commons.view.panels.SpringRepositoryMethodPanel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamPsiClassSpringBean;
import com.intellij.spring.toolWindow.SpringBeanPointerPanelBase;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringRepositoriesPanel
extends SpringBeanPointerPanelBase {
    private final Module[] myModules;

    public SpringRepositoriesPanel(Project project) {
        super(project, "SpringRepository");
        this.myModules = ModuleManager.getInstance((Project)project).getModules();
    }

    public SpringRepositoriesPanel(FinderRecursivePanel<Module> parent, @NotNull Module module) {
        if (module == null) {
            SpringRepositoriesPanel.$$$reportNull$$$0(0);
        }
        super(parent);
        this.myModules = new Module[]{module};
    }

    @NotNull
    protected List<SpringBeanPointer<?>> getListItems() {
        HashSet allModulePointers = new HashSet();
        for (Module module : this.myModules) {
            ContainerUtil.addAllNotNull(allModulePointers, SpringRepositoriesView.getRepositoryPointers(module));
        }
        ArrayList pointers = new ArrayList(allModulePointers);
        pointers.sort(Comparator.comparing(arg_0 -> ((SpringRepositoriesPanel)this).getItemText(arg_0), NaturalComparator.INSTANCE));
        ArrayList arrayList = pointers;
        if (arrayList == null) {
            SpringRepositoriesPanel.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    protected Icon getItemIcon(@NotNull SpringBeanPointer<?> springBeanPointer) {
        if (springBeanPointer == null) {
            SpringRepositoriesPanel.$$$reportNull$$$0(2);
        }
        if (!springBeanPointer.isValid()) {
            return null;
        }
        CommonSpringBean bean = springBeanPointer.getSpringBean();
        if (bean instanceof JamPsiClassSpringBean) {
            return ((JamPsiClassSpringBean)bean).getPsiElement().getIcon(2);
        }
        return springBeanPointer.isValid() ? SpringPresentationProvider.getSpringIcon(springBeanPointer) : null;
    }

    protected boolean hasChildren(@NotNull SpringBeanPointer<?> springBeanPointer) {
        if (springBeanPointer == null) {
            SpringRepositoriesPanel.$$$reportNull$$$0(3);
        }
        return SpringRepositoriesPanel.hasRepositoryMethods(springBeanPointer);
    }

    private static boolean hasRepositoryMethods(SpringBeanPointer springBeanPointer) {
        PsiClass psiClass = springBeanPointer.getBeanClass();
        return psiClass != null && SpringRepositoryMethodPanel.getRepositoryMethods(psiClass).size() > 0;
    }

    protected void doCustomizeCellRenderer(@NotNull SimpleColoredComponent comp, @NotNull JList list, @NotNull SpringBeanPointer<?> value, int index, boolean selected, boolean hasFocus) {
        if (comp == null) {
            SpringRepositoriesPanel.$$$reportNull$$$0(4);
        }
        if (list == null) {
            SpringRepositoriesPanel.$$$reportNull$$$0(5);
        }
        if (value == null) {
            SpringRepositoriesPanel.$$$reportNull$$$0(6);
        }
        if (!value.isValid()) {
            return;
        }
        comp.clear();
        comp.setIcon(this.getItemIcon(value));
        PsiClass beanClass = value.getBeanClass();
        CommonSpringBean bean = value.getSpringBean();
        if (beanClass != null && bean instanceof JamPsiClassSpringBean && beanClass.getQualifiedName() != null) {
            String qualifiedName = beanClass.getQualifiedName();
            comp.append(StringUtilRt.getShortName((String)qualifiedName));
            if (StringUtil.isNotEmpty((String)qualifiedName)) {
                comp.append(" (" + StringUtil.getPackageName((String)qualifiedName) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        } else {
            comp.append(this.getItemText(value));
            comp.append(" (" + value.getContainingFile().getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    protected JComponent createRightComponent(@NotNull SpringBeanPointer<?> springBeanPointer) {
        PsiClass beanClass;
        if (springBeanPointer == null) {
            SpringRepositoriesPanel.$$$reportNull$$$0(7);
        }
        if ((beanClass = springBeanPointer.getBeanClass()) == null) {
            return super.createRightComponent(springBeanPointer);
        }
        if (SpringRepositoriesPanel.hasRepositoryMethods(springBeanPointer)) {
            return new SpringRepositoryMethodPanel(this, beanClass);
        }
        return this.getDocumentationComponent((PsiElement)beanClass);
    }

    public DocumentationComponent getDocumentationComponent(PsiElement element) {
        return DocumentationComponent.createAndFetch((Project)this.getProject(), (PsiElement)element, (Disposable)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/view/panels/SpringRepositoriesPanel";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBeanPointer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/view/panels/SpringRepositoriesPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasChildren";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doCustomizeCellRenderer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRightComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

