/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.ql;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.DefaultQlModel;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.injection.MultiHostRegistrarPlaceholderHelper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.spring.data.commons.ql.domain.SpringDataDomainModel;
import com.intellij.spring.data.commons.ql.language.SpringDataQLLanguage;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.el.SpringELLanguage;
import com.intellij.spring.el.SpringElTemplateParser;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.expressions.UInjectionHost;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;
import org.jetbrains.uast.util.ClassSet;

public class SpringDataQLInjector
implements MultiHostInjector {
    public static final Set<String> QUERY_ANNOTATIONS = ContainerUtil.immutableSet((Object[])new String[]{"org.springframework.data.jpa.repository.Query"});
    private final ClassSet<PsiElement> myPsiSourceTypes = UastFacade.INSTANCE.getPossiblePsiSourceTypes(new Class[]{UInjectionHost.class, UPolyadicExpression.class});

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List list = this.myPsiSourceTypes.toList();
        if (list == null) {
            SpringDataQLInjector.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    private UStringConcatenationsFacade getConcatenationsFacade(@NotNull PsiElement context) {
        UExpression uElement;
        if (context == null) {
            SpringDataQLInjector.$$$reportNull$$$0(1);
        }
        if ((uElement = (UExpression)UastContextKt.toUElementOfExpectedTypes((PsiElement)context, (Class[])new Class[]{UInjectionHost.class, UPolyadicExpression.class})) == null) {
            return null;
        }
        if (uElement.getSourcePsi() != context) {
            return null;
        }
        if (UastLiteralUtils.isConcatenation((UElement)uElement.getUastParent())) {
            return null;
        }
        if (uElement instanceof UInjectionHost) {
            return UStringConcatenationsFacade.createFromUExpression((UExpression)uElement, (boolean)false);
        }
        return UStringConcatenationsFacade.createFromUExpression((UExpression)uElement, (boolean)true);
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            SpringDataQLInjector.$$$reportNull$$$0(2);
        }
        if (context == null) {
            SpringDataQLInjector.$$$reportNull$$$0(3);
        }
        if (!this.myPsiSourceTypes.contains(context.getClass())) {
            return;
        }
        Project project = context.getProject();
        if (!SpringCommonUtils.hasSpringFacets((Project)project)) {
            return;
        }
        if (!SpringDataUtil.hasSpringDataSupport(project)) {
            return;
        }
        UStringConcatenationsFacade concatenationsFacade = this.getConcatenationsFacade(context);
        if (concatenationsFacade == null) {
            return;
        }
        if (!concatenationsFacade.getUastOperands().iterator().hasNext()) {
            return;
        }
        Sequence hosts = concatenationsFacade.getPsiLanguageInjectionHosts();
        PsiLanguageInjectionHost theFirstHost = (PsiLanguageInjectionHost)SequencesKt.firstOrNull((Sequence)hosts);
        if (theFirstHost != null && this.isQueryAnnotationHost((PsiElement)theFirstHost)) {
            Language languageToInject = SpringDataQLInjector.getLanguageToInject(theFirstHost);
            HashMap<PsiLanguageInjectionHost, List> spElTextRangeMap = new HashMap<PsiLanguageInjectionHost, List>();
            MultiHostRegistrarPlaceholderHelper qlHostRegistrar = new MultiHostRegistrarPlaceholderHelper(registrar).startInjecting(languageToInject);
            qlHostRegistrar.addGlobalPlaceholders((Iterable)concatenationsFacade.getPlaceholders());
            for (PsiLanguageInjectionHost psiLanguageInjectionHost : SequencesKt.asIterable((Sequence)hosts)) {
                String text = psiLanguageInjectionHost.getText();
                List spElTextRanges = SpringElTemplateParser.parse((String)text);
                if (spElTextRanges.size() != 0) {
                    spElTextRangeMap.put(psiLanguageInjectionHost, spElTextRanges);
                }
                List spEls = ContainerUtil.map((Collection)spElTextRanges, range -> new Pair(range, (Object)SpringDataQLInjector.getSuffixString(text, range)));
                qlHostRegistrar.addHostPlaces(psiLanguageInjectionHost, spEls);
            }
            qlHostRegistrar.doneInjecting();
            for (Map.Entry entry : spElTextRangeMap.entrySet()) {
                PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)entry.getKey();
                for (TextRange range2 : (List)entry.getValue()) {
                    registrar.startInjecting((Language)SpringELLanguage.INSTANCE).addPlace(null, null, host, range2).doneInjecting();
                }
            }
            theFirstHost.putUserData(QlFile.PERSISTENCE_MODEL_KEY, (Object)SpringDataQLInjector.getQlModel((PsiElement)theFirstHost));
        }
    }

    public boolean isQueryAnnotationHost(@NotNull PsiElement host) {
        String annotationParamName;
        Pair annotationEntry;
        if (host == null) {
            SpringDataQLInjector.$$$reportNull$$$0(4);
        }
        if (host instanceof PsiLanguageInjectionHost && (annotationEntry = UAnnotationUtils.getContainingAnnotationEntry((UElement)UastContextKt.toUElement((PsiElement)host))) != null && ((annotationParamName = (String)annotationEntry.getSecond()) == null || "value".equals(annotationParamName) || "countQuery".equals(annotationParamName))) {
            PsiAnnotation annotation = (PsiAnnotation)annotationEntry.getFirst();
            return !annotation.getProject().isDefault() && SpringDataQLInjector.isQueryAnnotation(annotation);
        }
        return false;
    }

    private static boolean isQueryAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            SpringDataQLInjector.$$$reportNull$$$0(5);
        }
        return QUERY_ANNOTATIONS.contains(psiAnnotation.getQualifiedName());
    }

    private static Language getLanguageToInject(PsiLanguageInjectionHost host) {
        return SpringDataQLInjector.isNativeQuery(host) ? SqlLanguage.INSTANCE : SpringDataQLLanguage.INSTANCE;
    }

    private static boolean isNativeQuery(PsiLanguageInjectionHost host) {
        Pair annotationEntry = UAnnotationUtils.getContainingAnnotationEntry((UElement)UastContextKt.toUElement((PsiElement)host));
        if (annotationEntry == null) {
            return false;
        }
        PsiAnnotation annotation = (PsiAnnotation)annotationEntry.getFirst();
        if (annotation.getProject().isDefault()) {
            return false;
        }
        PsiAnnotationMemberValue nativeQueryMemberValue = annotation.findAttributeValue("nativeQuery");
        if (nativeQueryMemberValue == null) {
            return false;
        }
        Boolean value = (Boolean)JamCommonUtil.getObjectValue((PsiElement)nativeQueryMemberValue, Boolean.class);
        return value != null && value != false;
    }

    @NotNull
    private static String getSuffixString(String text, TextRange qlRange) {
        return qlRange.substring(text).trim().endsWith("?") ? "0" : "SpEl";
    }

    @NotNull
    private static QlModel getQlModel(PsiElement host) {
        PsiElement originalElement = host.getOriginalElement();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        if (module != null && JpaUtil.getJpaFacet((Module)module) != null) {
            return new DefaultQlModel(false, module);
        }
        return new SpringDataDomainModel(originalElement);
    }

    static {
        SpringDataQLLanguage.INSTANCE.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/ql/SpringDataQLInjector";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/ql/SpringDataQLInjector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getConcatenationsFacade";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isQueryAnnotationHost";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isQueryAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

