/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.projection;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.data.commons.projection.SpringDataProjectionUtil;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.utils.SpringDataBundle;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringDataProjectionAnnotator
extends RelatedItemLineMarkerProvider {
    public String getId() {
        return "SpringDataProjectionAnnotator";
    }

    public String getName() {
        return SpringDataBundle.message("spring.data.projections.annotator", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.InfrastructureBean;
        if (icon == null) {
            SpringDataProjectionAnnotator.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @Nullable
    private PsiElement getElementToProcess(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            SpringDataProjectionAnnotator.$$$reportNull$$$0(1);
        }
        if (psiElement instanceof PsiIdentifier) {
            return psiElement.getParent();
        }
        return null;
    }

    @NotNull
    private static PsiElement getElementToAnnotate(@NotNull PsiElement psiElement) {
        PsiElement nameIdentifier;
        if (psiElement == null) {
            SpringDataProjectionAnnotator.$$$reportNull$$$0(2);
        }
        if (psiElement instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)psiElement).getNameIdentifier()) != null) {
            PsiElement psiElement2 = nameIdentifier;
            if (psiElement2 == null) {
                SpringDataProjectionAnnotator.$$$reportNull$$$0(3);
            }
            return psiElement2;
        }
        PsiElement psiElement3 = psiElement;
        if (psiElement3 == null) {
            SpringDataProjectionAnnotator.$$$reportNull$$$0(4);
        }
        return psiElement3;
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            SpringDataProjectionAnnotator.$$$reportNull$$$0(5);
        }
        if (result == null) {
            SpringDataProjectionAnnotator.$$$reportNull$$$0(6);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringDataUtil.hasSpringDataSupport(psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        Set<PsiMember> members;
        PsiElement element;
        if (psiElement == null) {
            SpringDataProjectionAnnotator.$$$reportNull$$$0(7);
        }
        if (result == null) {
            SpringDataProjectionAnnotator.$$$reportNull$$$0(8);
        }
        if ((element = this.getElementToProcess(psiElement)) instanceof PsiClass && ((PsiClass)element).isInterface()) {
            Set<PsiClass> domainClasses = SpringDataProjectionUtil.getDomainProjectionClasses((PsiClass)element);
            if (domainClasses.size() > 0) {
                SpringDataProjectionAnnotator.annotateProjectionInterface((PsiClass)element, result, domainClasses);
            }
        } else if (element instanceof PsiMethod && (members = SpringDataProjectionUtil.getDomainProjectionMembers((PsiMethod)element)).size() > 0) {
            SpringDataProjectionAnnotator.annotateProjectionMethod((PsiMethod)element, result, members);
        }
    }

    private static void annotateProjectionInterface(PsiClass projectionInterfacesiElement, Collection<? super RelatedItemLineMarkerInfo<?>> result, @NotNull Set<? extends PsiClass> domainClasses) {
        if (domainClasses == null) {
            SpringDataProjectionAnnotator.$$$reportNull$$$0(9);
        }
        SpringGutterIconBuilder builder = SpringGutterIconBuilder.createBuilder((Icon)SpringApiIcons.Gutter.InfrastructureBean);
        builder.setPopupTitle(SpringDataBundle.message("spring.data.domain.class.select", new Object[0])).setEmptyPopupText(SpringDataBundle.message("spring.data.domain.class.from.projection", new Object[0])).setTooltipText(SpringDataBundle.message("spring.data.domain.class.from.projection", new Object[0])).setTargets(NotNullLazyValue.lazy(() -> domainClasses));
        PsiIdentifier identifier = projectionInterfacesiElement.getNameIdentifier();
        if (identifier != null) {
            result.add(builder.createSpringRelatedMergeableLineMarkerInfo((PsiElement)identifier));
        }
    }

    private static void annotateProjectionMethod(PsiMethod projectionMethod, Collection<? super RelatedItemLineMarkerInfo<?>> result, @NotNull Set<? extends PsiMember> psiMembers) {
        if (psiMembers == null) {
            SpringDataProjectionAnnotator.$$$reportNull$$$0(10);
        }
        SpringGutterIconBuilder builder = SpringGutterIconBuilder.createBuilder((Icon)SpringApiIcons.Gutter.SpringBeanMethod);
        builder.setPopupTitle(SpringDataBundle.message("spring.data.domain.class.member.select", new Object[0])).setEmptyPopupText(SpringDataBundle.message("spring.data.domain.member.from.projection", new Object[0])).setTooltipText(SpringDataBundle.message("spring.data.domain.member.from.projection", new Object[0])).setTargets(NotNullLazyValue.lazy(() -> psiMembers));
        PsiIdentifier identifier = projectionMethod.getNameIdentifier();
        if (identifier != null) {
            result.add(builder.createSpringRelatedMergeableLineMarkerInfo((PsiElement)identifier));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/projection/SpringDataProjectionAnnotator";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClasses";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/projection/SpringDataProjectionAnnotator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToAnnotate";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementToProcess";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementToAnnotate";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "annotateProjectionInterface";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "annotateProjectionMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

