/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.jpa.frameworks.data.util.inspections.PartTreeInconsistencyUtils;
import com.intellij.jpa.frameworks.data.util.parser.PartTree;
import com.intellij.jpa.frameworks.data.util.parser.PartTreeParserContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.data.commons.inspections.SpringDataRepositoriesInspection;
import com.intellij.spring.data.commons.projection.SpringDataProjectionUtil;
import com.intellij.spring.data.commons.util.SpringDataPartTreeParserContext;
import com.intellij.spring.data.utils.SpringDataBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;

public final class SpringDataRepositoryMethodReturnTypeInspection
extends SpringDataRepositoriesInspection {
    @Override
    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, @NotNull UClass repositoryClass, @NotNull UMethod uMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(0);
        }
        if (repositoryClass == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(1);
        }
        if (uMethod == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(2);
        }
        if (module == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(3);
        }
        if (typePair == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(4);
        }
        PsiMethod psiMethod = uMethod.getJavaPsi();
        PsiClass domainType = (PsiClass)typePair.first;
        if (domainType == null) {
            return;
        }
        PsiType returnType = psiMethod.getReturnType();
        if (returnType == null) {
            return;
        }
        PartTree.Subject subject = SpringDataRepositoryMethodReturnTypeInspection.getSubject(psiMethod, domainType);
        if (subject.isExistsProjection()) {
            if (!returnType.isAssignableFrom((PsiType)PsiType.BOOLEAN)) {
                SpringDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, SpringDataBundle.message("incorrect.method.of.explicit.subject.return.type", PsiType.BOOLEAN.getName()));
            }
        } else if (!SpringDataRepositoryMethodReturnTypeInspection.isAssignableReturnType(domainType, repositoryClass.getJavaPsi(), psiMethod, subject)) {
            SpringDataRepositoryMethodReturnTypeInspection.registerProblem(holder, uMethod, SpringDataBundle.message("incorrect.method.return.type", domainType.getName()));
        }
    }

    @NotNull
    private static PartTree.Subject getSubject(@NotNull PsiMethod psiMethod, PsiClass domainType) {
        if (psiMethod == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(5);
        }
        String name = psiMethod.getName();
        PartTree partTree = new PartTree(name, domainType, (PartTreeParserContext)SpringDataPartTreeParserContext.create());
        PartTree.Subject subject = partTree.getSubject();
        if (subject == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(6);
        }
        return subject;
    }

    private static void registerProblem(@NotNull ProblemsHolder holder, @NotNull UMethod psiMethod, @InspectionMessage String message) {
        UTypeReferenceExpression returnTypeRef;
        if (holder == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(7);
        }
        if (psiMethod == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(8);
        }
        if ((returnTypeRef = SpringDataRepositoryMethodReturnTypeInspection.getReturnTypeRef(psiMethod)) == null) {
            return;
        }
        PsiElement identifier = returnTypeRef.getSourcePsi();
        if (identifier == null) {
            return;
        }
        TextRange textRange = identifier.getTextRange();
        if (textRange == null || textRange.isEmpty()) {
            return;
        }
        holder.registerProblem(identifier, message, new LocalQuickFix[0]);
    }

    private static UTypeReferenceExpression getReturnTypeRef(@NotNull UMethod psiMethod) {
        PsiElement sourcePsi;
        if (psiMethod == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(9);
        }
        if ((sourcePsi = psiMethod.getSourcePsi()) == null) {
            return null;
        }
        for (PsiElement child : sourcePsi.getChildren()) {
            UTypeReferenceExpression expression = (UTypeReferenceExpression)UastContextKt.toUElement((PsiElement)child, UTypeReferenceExpression.class);
            if (expression == null) continue;
            return expression;
        }
        return null;
    }

    public static boolean isAssignableReturnType(@NotNull PsiClass domainClass, @NotNull PsiClass repositoryClass, @NotNull PsiMethod psiMethod, PartTree.Subject subject) {
        PsiType returnType;
        if (domainClass == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(10);
        }
        if (repositoryClass == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(11);
        }
        if (psiMethod == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(12);
        }
        if ((returnType = psiMethod.getReturnType()) == null) {
            return false;
        }
        if ((subject.isDelete().booleanValue() || subject.isCountProjection()) && returnType.isAssignableFrom((PsiType)PsiType.LONG)) {
            return true;
        }
        if (returnType instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)returnType) != null) {
            return true;
        }
        PsiClassType type = PsiTypesUtil.getClassType((PsiClass)domainClass);
        if (SpringDataRepositoryMethodReturnTypeInspection.isAssignableTypeOrProjectionType(type, returnType, repositoryClass)) {
            return true;
        }
        PsiType genericType = SpringDataRepositoryMethodReturnTypeInspection.substituteGeoResultsTypeParameter(returnType);
        genericType = genericType != null ? genericType : PsiUtil.extractIterableTypeParameter((PsiType)returnType, (boolean)false);
        PsiType psiType = genericType = genericType != null ? genericType : SpringDataRepositoryMethodReturnTypeInspection.getSubstitutedTypeParameters(returnType);
        if (genericType != null) {
            if (SpringDataRepositoryMethodReturnTypeInspection.isAssignableTypeOrProjectionType(type, genericType, repositoryClass)) {
                return true;
            }
            PsiType iterableTypeParameter = PsiUtil.extractIterableTypeParameter((PsiType)genericType, (boolean)false);
            if (iterableTypeParameter != null && SpringDataRepositoryMethodReturnTypeInspection.isAssignableTypeOrProjectionType(type, iterableTypeParameter, repositoryClass)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignableTypeOrProjectionType(@NotNull PsiClassType domainType, @NotNull PsiType methodReturnType, @NotNull PsiClass repositoryClass) {
        if (domainType == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(13);
        }
        if (methodReturnType == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(14);
        }
        if (repositoryClass == null) {
            SpringDataRepositoryMethodReturnTypeInspection.$$$reportNull$$$0(15);
        }
        if (methodReturnType.isAssignableFrom((PsiType)domainType)) {
            return true;
        }
        if (methodReturnType instanceof PsiClassType) {
            PsiClass projectionClass = ((PsiClassType)methodReturnType).resolve();
            PsiClass domainClass = domainType.resolve();
            if (projectionClass != null && domainClass != null) {
                if (projectionClass instanceof PsiTypeParameter) {
                    return true;
                }
                if (InheritanceUtil.isInheritor((PsiClass)projectionClass, (String)"java.lang.Iterable")) {
                    return false;
                }
                if (SpringDataProjectionUtil.isExplicitProjectionType(projectionClass, domainClass, repositoryClass)) {
                    return true;
                }
                if (SpringDataProjectionUtil.hasProjectionMethods(projectionClass, domainClass)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static PsiType substituteGeoResultsTypeParameter(PsiType returnType) {
        return PartTreeInconsistencyUtils.getSubstitutedTypeParameters((PsiType)returnType, (String[])new String[]{"org.springframework.data.geo.GeoResults"});
    }

    @Nullable
    public static PsiType getSubstitutedTypeParameters(@Nullable PsiType returnType) {
        return PartTreeInconsistencyUtils.getSubstitutedTypeParameters((PsiType)returnType, (String[])new String[]{"java.util.Optional", "java.util.stream.Stream", "com.google.common.base.Optional", "com.google.common.util.concurrent.ListenableFuture", "java.util.concurrent.Future", "java.util.concurrent.CompletableFuture", "org.springframework.util.concurrent.ListenableFuture", "org.springframework.data.geo.GeoResult", "org.springframework.data.geo.GeoPage", "rx.Observable", "rx.Single", "reactor.core.publisher.Mono", "reactor.core.publisher.Flux"});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePair";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodReturnTypeInspection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodReturnTypeInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkRepositoryMethod";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSubject";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeRef";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableReturnType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableTypeOrProjectionType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

