/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.starter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.ide.starters.JavaStartersBundle;
import com.intellij.ide.starters.remote.WebStarterContext;
import com.intellij.ide.starters.remote.WebStarterDependency;
import com.intellij.ide.starters.remote.WebStarterDependencyCategory;
import com.intellij.ide.starters.remote.WebStarterFrameworkVersion;
import com.intellij.ide.starters.remote.WebStarterModuleBuilder;
import com.intellij.ide.starters.remote.WebStarterServerOptions;
import com.intellij.ide.starters.remote.WebStarterSettings;
import com.intellij.ide.starters.shared.CustomizedMessages;
import com.intellij.ide.starters.shared.LibraryLink;
import com.intellij.ide.starters.shared.LibraryLinkType;
import com.intellij.ide.starters.shared.StarterLanguage;
import com.intellij.ide.starters.shared.StarterLanguageLevel;
import com.intellij.ide.starters.shared.StarterProjectType;
import com.intellij.openapi.util.Key;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.QuarkusIcons;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018H\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0018H\u0014J\b\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020$2\u0006\u0010\b\u001a\u00020\u0005H\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/quarkus/starter/QuarkusModuleBuilder;", "Lcom/intellij/ide/starters/remote/WebStarterModuleBuilder;", "()V", "KOTLIN_DEPENDENCY_ID", "Lcom/intellij/openapi/util/Key;", "", "composeGeneratorUrl", "Lcom/intellij/util/Url;", "serverUrl", "starterContext", "Lcom/intellij/ide/starters/remote/WebStarterContext;", "extractGeneratorResult", "", "tempZipFile", "Ljava/io/File;", "contentEntryDir", "getBuilderId", "getCustomizedMessages", "Lcom/intellij/ide/starters/shared/CustomizedMessages;", "getDefaultLanguageLevel", "Lcom/intellij/ide/starters/shared/StarterLanguageLevel;", "getDefaultServerUrl", "getDescription", "getFilePathsToOpen", "", "getHelpId", "getLanguages", "Lcom/intellij/ide/starters/shared/StarterLanguage;", "getNodeIcon", "Ljavax/swing/Icon;", "getPresentableName", "getProjectTypes", "Lcom/intellij/ide/starters/shared/StarterProjectType;", "isExampleCodeProvided", "", "loadServerOptions", "Lcom/intellij/ide/starters/remote/WebStarterServerOptions;", "QuarkusDependencyCategory", "intellij.quarkus"})
public final class QuarkusModuleBuilder
extends WebStarterModuleBuilder {
    private final Key<String> KOTLIN_DEPENDENCY_ID;

    @NotNull
    public String getDefaultServerUrl() {
        return "https://code.quarkus.io";
    }

    @NotNull
    public String getBuilderId() {
        return "quarkus";
    }

    @NotNull
    public Icon getNodeIcon() {
        Icon icon = QuarkusIcons.Quarkus;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"QuarkusIcons.Quarkus");
        return icon;
    }

    @NotNull
    public String getPresentableName() {
        return "Quarkus";
    }

    @NotNull
    public String getDescription() {
        return QuarkusBundle.message("description.for.quarkus.project.starter", new Object[0]);
    }

    @NotNull
    public String getHelpId() {
        return "quarkus.project";
    }

    @NotNull
    protected StarterLanguageLevel getDefaultLanguageLevel() {
        return new StarterLanguageLevel("11", "11", "11");
    }

    protected boolean isExampleCodeProvided() {
        return true;
    }

    @NotNull
    protected List<StarterLanguage> getLanguages() {
        return CollectionsKt.listOf((Object[])new StarterLanguage[]{new StarterLanguage("java", "Java", "JAVA", false, null, 24, null), new StarterLanguage("kotlin", "Kotlin", "kotlin", false, null, 24, null)});
    }

    @NotNull
    protected List<StarterProjectType> getProjectTypes() {
        return CollectionsKt.listOf((Object[])new StarterProjectType[]{new StarterProjectType("MAVEN", "Maven", null, 4, null), new StarterProjectType("GRADLE", "Gradle", null, 4, null)});
    }

    @NotNull
    protected List<String> getFilePathsToOpen() {
        return CollectionsKt.listOf((Object)"README.md");
    }

    @NotNull
    protected CustomizedMessages getCustomizedMessages() {
        CustomizedMessages customizedMessages = new CustomizedMessages();
        boolean bl = false;
        boolean bl2 = false;
        CustomizedMessages $this$apply = customizedMessages;
        boolean bl3 = false;
        $this$apply.setProjectTypeLabel(JavaStartersBundle.message((String)"title.project.build.system.label", (Object[])new Object[0]));
        $this$apply.setDependenciesLabel(QuarkusBundle.message("quarkus.starter.extensions.label", new Object[0]));
        $this$apply.setSelectedDependenciesLabel(QuarkusBundle.message("quarkus.starter.selected.extensions.label", new Object[0]));
        $this$apply.setNoDependenciesSelectedLabel(QuarkusBundle.message("quarkus.starter.select.extensions.hint", new Object[0]));
        $this$apply.setFrameworkVersionLabel(QuarkusBundle.message("quarkus.starter.version.label", new Object[0]));
        return customizedMessages;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected WebStarterServerOptions loadServerOptions(@NotNull String serverUrl) {
        Object quarkusVersion;
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        JsonArray extensionsRoot = WebStarterModuleBuilder.loadJsonData$default((WebStarterModuleBuilder)this, (String)(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/") + "/api/extensions"), null, (int)2, null).getAsJsonArray();
        boolean bl = false;
        Map categories = new LinkedHashMap();
        String kotlinDependencyId = null;
        Iterator iterator = extensionsRoot.iterator();
        while (iterator.hasNext()) {
            Object object;
            String key$iv;
            void $this$getOrPut$iv;
            Object object2;
            boolean isDefault;
            String description;
            String name;
            String shortId;
            JsonObject dependencyObject;
            block9: {
                block8: {
                    JsonElement jsonElement;
                    JsonElement jsonElement2 = jsonElement = (JsonElement)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"jsonElement");
                    dependencyObject = jsonElement2.getAsJsonObject();
                    JsonElement jsonElement3 = dependencyObject.get("shortId");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement3, (String)"dependencyObject.get(\"shortId\")");
                    shortId = jsonElement3.getAsString();
                    JsonElement jsonElement4 = dependencyObject.get("name");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement4, (String)"dependencyObject.get(\"name\")");
                    name = jsonElement4.getAsString();
                    if (StringsKt.equals((String)name, (String)"Kotlin", (boolean)true)) {
                        kotlinDependencyId = shortId;
                    }
                    if (StringsKt.equals((String)name, (String)"Kotlin", (boolean)true) || StringsKt.equals((String)name, (String)"Scala", (boolean)true)) continue;
                    JsonObject jsonObject = dependencyObject;
                    Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"dependencyObject");
                    JsonElement jsonElement5 = this.getNullable(jsonObject, "description");
                    description = jsonElement5 != null ? jsonElement5.getAsString() : null;
                    JsonElement jsonElement6 = this.getNullable(dependencyObject, "default");
                    isDefault = jsonElement6 != null ? jsonElement6.getAsBoolean() : false;
                    JsonElement jsonElement7 = this.getNullable(dependencyObject, "guide");
                    String guideLink = jsonElement7 != null ? jsonElement7.getAsString() : null;
                    object2 = guideLink;
                    if (object2 == null) break block8;
                    String string = object2;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String it = string;
                    boolean bl4 = false;
                    object2 = CollectionsKt.listOf((Object)new LibraryLink(LibraryLinkType.GUIDE, guideLink, null, 4, null));
                    if (object2 != null) break block9;
                }
                object2 = CollectionsKt.emptyList();
            }
            Object links = object2;
            JsonElement jsonElement = dependencyObject.get("category");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"dependencyObject.get(\"category\")");
            String categoryName = jsonElement.getAsString();
            if (StringsKt.equals((String)categoryName, (String)"Alternative languages", (boolean)true)) continue;
            Map map2 = categories;
            Intrinsics.checkNotNullExpressionValue((Object)categoryName, (String)"categoryName");
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl5 = false;
                QuarkusDependencyCategory answer$iv = new QuarkusDependencyCategory(categoryName, null, 2, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            QuarkusDependencyCategory category = (QuarkusDependencyCategory)((Object)object);
            List<WebStarterDependency> list = category.getExtensions();
            String string = shortId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortId");
            String string2 = name;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
            list.add(new WebStarterDependency(string, string2, description, (List)links, isDefault, false, 32, null));
        }
        JsonObject configRoot = WebStarterModuleBuilder.loadJsonData$default((WebStarterModuleBuilder)this, (String)(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/") + "/api/config"), null, (int)2, null).getAsJsonObject();
        Object object = configRoot.get("quarkusVersion");
        if (object == null || (object = object.getAsString()) == null) {
            JsonElement jsonElement = configRoot.get("quarkusPlatformVersion");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"configRoot.get(\"quarkusPlatformVersion\")");
            object = jsonElement.getAsString();
        }
        Object object3 = quarkusVersion = object;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"quarkusVersion");
        WebStarterServerOptions options = new WebStarterServerOptions(CollectionsKt.listOf((Object)new WebStarterFrameworkVersion((String)object3, (String)quarkusVersion, true)), CollectionsKt.toList((Iterable)categories.values()));
        options.putUserData(this.KOTLIN_DEPENDENCY_ID, (Object)kotlinDependencyId);
        return options;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Url composeGeneratorUrl(@NotNull String serverUrl, @NotNull WebStarterContext starterContext) {
        boolean bl;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter((Object)starterContext, (String)"starterContext");
        Url url = Urls.newFromEncoded((String)(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/") + "/api/download"));
        StarterProjectType starterProjectType = starterContext.getProjectType();
        Intrinsics.checkNotNull((Object)starterProjectType);
        String projectType = starterProjectType.getId();
        if (Intrinsics.areEqual((Object)projectType, (Object)"GRADLE") && Intrinsics.areEqual((Object)starterContext.getLanguage().getId(), (Object)"kotlin")) {
            projectType = "GRADLE_KOTLIN_DSL";
        }
        Url url2 = url.addParameters(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"g", (Object)starterContext.getGroup()), TuplesKt.to((Object)"a", (Object)starterContext.getArtifact()), TuplesKt.to((Object)"b", (Object)projectType), TuplesKt.to((Object)"v", (Object)starterContext.getVersion()), TuplesKt.to((Object)"c", (Object)(starterContext.getGroup() + ".ExampleResource")), TuplesKt.to((Object)"p", (Object)"/hello")}));
        Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"url.addParameters(mapOf(\u2026   \"p\" to \"/hello\"\n    ))");
        url = url2;
        if (!starterContext.getIncludeExamples()) {
            Url url3 = url.addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"ne", (Object)"true")));
            Intrinsics.checkNotNullExpressionValue((Object)url3, (String)"url.addParameters(mapOf(\"ne\" to \"true\"))");
            url = url3;
        }
        Iterable $this$map$iv = starterContext.getDependencies();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WebStarterDependency webStarterDependency = (WebStarterDependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string = it.getId();
            collection.add(string);
        }
        Set selectedDependencyIds = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        if (Intrinsics.areEqual((Object)starterContext.getLanguage().getId(), (Object)"kotlin")) {
            String string = (String)starterContext.getServerOptions().getUserData(this.KOTLIN_DEPENDENCY_ID);
            if (string != null) {
                object = string;
                bl = false;
                boolean bl3 = false;
                Object it = object;
                boolean bl4 = false;
                Object object2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it");
                selectedDependencyIds.add(object2);
            }
        }
        object = selectedDependencyIds;
        bl = false;
        if (!object.isEmpty()) {
            Url url4 = url.addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"s", (Object)CollectionsKt.joinToString$default((Iterable)selectedDependencyIds, (CharSequence)".", null, null, (int)0, null, null, (int)62, null))));
            Intrinsics.checkNotNullExpressionValue((Object)url4, (String)"url.addParameters(mapOf(\u2026cyIds.joinToString(\".\")))");
            url = url4;
        }
        return url;
    }

    protected void extractGeneratorResult(@NotNull File tempZipFile, @NotNull File contentEntryDir) {
        Intrinsics.checkNotNullParameter((Object)tempZipFile, (String)"tempZipFile");
        Intrinsics.checkNotNullParameter((Object)contentEntryDir, (String)"contentEntryDir");
        WebStarterSettings.unzipSubfolder((File)tempZipFile, (File)contentEntryDir);
    }

    public QuarkusModuleBuilder() {
        Key key = Key.create((String)"QUARKUS_KOTLIN_DEPENDENCY_ID");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"QUARKUS_KOTLIN_DEPENDENCY_ID\")");
        this.KOTLIN_DEPENDENCY_ID = key;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/quarkus/starter/QuarkusModuleBuilder$QuarkusDependencyCategory;", "Lcom/intellij/ide/starters/remote/WebStarterDependencyCategory;", "title", "", "extensions", "", "Lcom/intellij/ide/starters/remote/WebStarterDependency;", "(Ljava/lang/String;Ljava/util/List;)V", "getExtensions", "()Ljava/util/List;", "intellij.quarkus"})
    private static final class QuarkusDependencyCategory
    extends WebStarterDependencyCategory {
        @NotNull
        private final List<WebStarterDependency> extensions;

        @NotNull
        public final List<WebStarterDependency> getExtensions() {
            return this.extensions;
        }

        public QuarkusDependencyCategory(@NotNull String title, @NotNull List<WebStarterDependency> extensions) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
            super(title, extensions);
            this.extensions = extensions;
        }

        public /* synthetic */ QuarkusDependencyCategory(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                boolean bl = false;
                list = new ArrayList();
            }
            this(string, list);
        }
    }
}

