/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run.gradle;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.run.QsDebugState;
import com.intellij.quarkus.run.gradle.QsGradleRunConfigurationSettingsEditor;
import com.intellij.quarkus.run.gradle.QsGradleState;
import com.intellij.util.SmartList;
import com.intellij.util.net.NetUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u000e\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/quarkus/run/gradle/QsGradleRunConfiguration;", "Lorg/jetbrains/plugins/gradle/service/execution/GradleRunConfiguration;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration;", "getDefaultLanguageRuntimeType", "Lcom/intellij/execution/target/LanguageRuntimeType;", "getDefaultTargetName", "", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "setDefaultTargetName", "", "targetName", "setTasks", "intellij.quarkus"})
public final class QsGradleRunConfiguration
extends GradleRunConfiguration {
    private final Module module;

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.setTasks();
        if (executor instanceof DefaultDebugExecutor) {
            int port = NetUtils.findAvailableSocketPort();
            ExternalSystemTaskExecutionSettings debugSettings = new ExternalSystemTaskExecutionSettings();
            debugSettings.setFrom(this.getSettings());
            String debugParameter = "-Ddebug=" + port;
            String scriptParameters = debugSettings.getScriptParameters();
            CharSequence charSequence = scriptParameters;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                debugSettings.setScriptParameters(debugParameter);
            } else {
                debugSettings.setScriptParameters(debugParameter + ' ' + scriptParameters);
            }
            QsGradleState state = new QsGradleState(debugSettings, this.module, (ExternalSystemRunConfiguration)this, environment);
            this.copyUserDataTo((UserDataHolderBase)state);
            RemoteConnection remoteConnection = new RemoteConnection(true, "127.0.0.1", String.valueOf(port), false);
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            TargetEnvironmentAwareRunProfileState targetEnvironmentAwareRunProfileState = state;
            String string = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            return (RunProfileState)new QsDebugState(project, remoteConnection, targetEnvironmentAwareRunProfileState, string);
        }
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = this.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskExecutionSettings, (String)"settings");
        QsGradleState state = new QsGradleState(externalSystemTaskExecutionSettings, this.module, (ExternalSystemRunConfiguration)this, environment);
        this.copyUserDataTo((UserDataHolderBase)state);
        return (RunProfileState)state;
    }

    @NotNull
    public SettingsEditor<ExternalSystemRunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(QuarkusBundle.message("run.configuration.configuration.tab", new Object[0]), (SettingsEditor)new QsGradleRunConfigurationSettingsEditor());
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        return (SettingsEditor)group;
    }

    private final void setTasks() {
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = this.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskExecutionSettings, (String)"settings");
        externalSystemTaskExecutionSettings.setTaskNames((List)new SmartList((Object)"quarkusDev"));
    }

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        return null;
    }

    @Nullable
    public String getDefaultTargetName() {
        return null;
    }

    public void setDefaultTargetName(@Nullable String targetName) {
    }

    public QsGradleRunConfiguration(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        GradleExternalTaskConfigurationType gradleExternalTaskConfigurationType = GradleExternalTaskConfigurationType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)gradleExternalTaskConfigurationType, (String)"GradleExternalTaskConfigurationType.getInstance()");
        super(project, gradleExternalTaskConfigurationType.getConfigurationFactories()[0], "");
        this.module = module;
    }
}

