/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.quarkus.run.QsRunConfiguration;
import com.intellij.quarkus.run.QsRunConfigurationService;
import com.intellij.quarkus.run.QsServerConfiguration;
import com.intellij.ui.SimpleTextAttributes;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/quarkus/run/QsRunDashboardCustomizer;", "Lcom/intellij/execution/dashboard/RunDashboardCustomizer;", "()V", "isApplicable", "", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "descriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "updatePresentation", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "node", "Lcom/intellij/execution/dashboard/RunDashboardRunConfigurationNode;", "ApplicationLinkListener", "intellij.quarkus"})
public final class QsRunDashboardCustomizer
extends RunDashboardCustomizer {
    public boolean isApplicable(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return settings.getConfiguration() instanceof QsRunConfiguration;
    }

    public boolean updatePresentation(@NotNull PresentationData presentation, @NotNull RunDashboardRunConfigurationNode node) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = node.getConfigurationSettings();
        Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"node.configurationSettings");
        if (!(runnerAndConfigurationSettings.getConfiguration() instanceof QsRunConfiguration)) {
            return false;
        }
        node.putUserData(RunDashboardCustomizer.NODE_LINKS, null);
        RunContentDescriptor runContentDescriptor = node.getDescriptor();
        if (runContentDescriptor == null || (runContentDescriptor = runContentDescriptor.getProcessHandler()) == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)runContentDescriptor, (String)"node.descriptor?.processHandler ?: return true");
        RunContentDescriptor handler = runContentDescriptor;
        if (!handler.isProcessTerminated()) {
            QsServerConfiguration qsServerConfiguration = (QsServerConfiguration)handler.getUserData(QsRunConfigurationService.Companion.getSERVER_CONFIGURATION_KEY());
            if (qsServerConfiguration == null) {
                return true;
            }
            Intrinsics.checkNotNullExpressionValue((Object)qsServerConfiguration, (String)"handler.getUserData(QsRu\u2026ATION_KEY) ?: return true");
            QsServerConfiguration serverConfiguration = qsServerConfiguration;
            presentation.addText(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            String applicationLink = "" + ':' + serverConfiguration.getServerPort();
            presentation.addText(applicationLink, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            Map links = new HashMap();
            links.put(applicationLink, new ApplicationLinkListener(serverConfiguration));
            node.putUserData(RunDashboardCustomizer.NODE_LINKS, (Object)links);
        }
        return true;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\b\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/quarkus/run/QsRunDashboardCustomizer$ApplicationLinkListener;", "Ljava/lang/Runnable;", "serverConfiguration", "Lcom/intellij/quarkus/run/QsServerConfiguration;", "(Lcom/intellij/quarkus/run/QsServerConfiguration;)V", "component1", "copy", "equals", "", "other", "", "hashCode", "", "run", "", "toString", "", "intellij.quarkus"})
    private static final class ApplicationLinkListener
    implements Runnable {
        private final QsServerConfiguration serverConfiguration;

        @Override
        public void run() {
            BrowserUtil.browse((String)this.serverConfiguration.getApplicationUrl());
        }

        public ApplicationLinkListener(@NotNull QsServerConfiguration serverConfiguration) {
            Intrinsics.checkNotNullParameter((Object)serverConfiguration, (String)"serverConfiguration");
            this.serverConfiguration = serverConfiguration;
        }

        private final QsServerConfiguration component1() {
            return this.serverConfiguration;
        }

        @NotNull
        public final ApplicationLinkListener copy(@NotNull QsServerConfiguration serverConfiguration) {
            Intrinsics.checkNotNullParameter((Object)serverConfiguration, (String)"serverConfiguration");
            return new ApplicationLinkListener(serverConfiguration);
        }

        public static /* synthetic */ ApplicationLinkListener copy$default(ApplicationLinkListener applicationLinkListener, QsServerConfiguration qsServerConfiguration, int n, Object object) {
            if ((n & 1) != 0) {
                qsServerConfiguration = applicationLinkListener.serverConfiguration;
            }
            return applicationLinkListener.copy(qsServerConfiguration);
        }

        @NotNull
        public String toString() {
            return "ApplicationLinkListener(serverConfiguration=" + this.serverConfiguration + ")";
        }

        public int hashCode() {
            QsServerConfiguration qsServerConfiguration = this.serverConfiguration;
            return qsServerConfiguration != null ? ((Object)qsServerConfiguration).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ApplicationLinkListener)) break block3;
                    ApplicationLinkListener applicationLinkListener = (ApplicationLinkListener)object;
                    if (!Intrinsics.areEqual((Object)this.serverConfiguration, (Object)applicationLinkListener.serverConfiguration)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

