/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.config.QsConfigValueSearcher;
import com.intellij.quarkus.run.QsServerConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\"\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/quarkus/run/QsRunConfigurationUtils;", "", "()V", "findPropertyValue", "", "javaParams", "Lcom/intellij/execution/configurations/JavaParameters;", "module", "Lcom/intellij/openapi/module/Module;", "propertyKey", "findPropertyValueInConfigs", "getActiveProfile", "getServerConfiguration", "Lcom/intellij/quarkus/run/QsServerConfiguration;", "intellij.quarkus"})
public final class QsRunConfigurationUtils {
    @NotNull
    public static final QsRunConfigurationUtils INSTANCE;

    @Nullable
    public final QsServerConfiguration getServerConfiguration(@NotNull JavaParameters javaParams, @NotNull Module module) {
        int n;
        Intrinsics.checkNotNullParameter((Object)javaParams, (String)"javaParams");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!QuarkusUtils.INSTANCE.hasQuarkusHttpConfiguration(module)) {
            return null;
        }
        String string = this.findPropertyValue(javaParams, module, "quarkus.http.insecure-requests");
        if (string == null) {
            string = "enabled";
        }
        String insecureRequests = string;
        boolean sslEnabled = !StringsKt.equals((String)"enabled", (String)insecureRequests, (boolean)false);
        String portProperty = null;
        int defaultPort = 0;
        if (sslEnabled) {
            portProperty = "quarkus.http.ssl-port";
            defaultPort = 8443;
        } else {
            portProperty = "quarkus.http.port";
            defaultPort = 8080;
        }
        try {
            int n2;
            String string2 = this.findPropertyValue(javaParams, module, portProperty);
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                n2 = Integer.parseInt(string3);
            } else {
                n2 = defaultPort;
            }
            n = n2;
        }
        catch (NumberFormatException e) {
            n = defaultPort;
        }
        int serverPort = n;
        return new QsServerConfiguration(serverPort, sslEnabled);
    }

    private final String findPropertyValue(JavaParameters javaParams, Module module, String propertyKey) {
        String fromVmOptions = javaParams.getVMParametersList().getPropertyValue(propertyKey);
        if (fromVmOptions != null) {
            CharSequence charSequence = fromVmOptions;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                return fromVmOptions;
            }
        }
        return (String)ReadAction.compute((ThrowableComputable)new ThrowableComputable(javaParams, module, propertyKey){
            final /* synthetic */ JavaParameters $javaParams;
            final /* synthetic */ Module $module;
            final /* synthetic */ String $propertyKey;

            public final String compute() {
                return QsRunConfigurationUtils.access$findPropertyValueInConfigs(QsRunConfigurationUtils.INSTANCE, this.$javaParams, this.$module, this.$propertyKey);
            }
            {
                this.$javaParams = javaParameters;
                this.$module = module;
                this.$propertyKey = string;
            }
        });
    }

    private final String findPropertyValueInConfigs(JavaParameters javaParams, Module module, String propertyKey) {
        String activeProfile = this.getActiveProfile(javaParams);
        QsConfigValueSearcher searcher = new QsConfigValueSearcher(module, false, propertyKey, activeProfile);
        String value = searcher.findValueText();
        CharSequence charSequence = value;
        boolean bl = false;
        boolean bl2 = false;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : value;
    }

    private final String getActiveProfile(JavaParameters javaParams) {
        String value = javaParams.getVMParametersList().getPropertyValue("quarkus.profile");
        CharSequence charSequence = value;
        boolean bl = false;
        boolean bl2 = false;
        return charSequence == null || charSequence.length() == 0 ? "dev" : value;
    }

    private QsRunConfigurationUtils() {
    }

    static {
        QsRunConfigurationUtils qsRunConfigurationUtils;
        INSTANCE = qsRunConfigurationUtils = new QsRunConfigurationUtils();
    }

    public static final /* synthetic */ String access$findPropertyValueInConfigs(QsRunConfigurationUtils $this, JavaParameters javaParams, Module module, String propertyKey) {
        return $this.findPropertyValueInConfigs(javaParams, module, propertyKey);
    }
}

