/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run;

import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ConfigurationSettingsEditor;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.run.QsExternalSystemBridge;
import com.intellij.quarkus.run.QsRunConfiguration;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014J2\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00172\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\r\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/quarkus/run/QsRunConfigurationSettingEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/quarkus/run/QsRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "delegateEditor", "Lcom/intellij/quarkus/run/QsRunConfigurationSettingEditor$DelegateEditor;", "emptyEnvironmentPanel", "Ljavax/swing/JPanel;", "environmentSettingsPanel", "mainPanel", "moduleComponent", "Lcom/intellij/openapi/ui/LabeledComponent;", "Lcom/intellij/application/options/ModuleDescriptionsComboBox;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "moduleSelector", "Lcom/intellij/execution/ui/ConfigurationModuleSelector;", "applyEditorTo", "", "s", "createEditor", "Ljavax/swing/JComponent;", "installHideableDecorator", "panel", "content", "title", "", "expandPropertyKey", "defaultState", "", "resetEditorFrom", "DelegateEditor", "intellij.quarkus"})
public final class QsRunConfigurationSettingEditor
extends SettingsEditor<QsRunConfiguration> {
    private final JPanel mainPanel;
    private final LabeledComponent<ModuleDescriptionsComboBox> moduleComponent;
    private final ConfigurationModuleSelector moduleSelector;
    private final JPanel environmentSettingsPanel;
    private final JPanel emptyEnvironmentPanel;
    private DelegateEditor delegateEditor;
    private final Project project;

    protected void resetEditorFrom(@NotNull QsRunConfiguration s) {
        RunConfiguration delegateConfig;
        Intrinsics.checkNotNullParameter((Object)((Object)s), (String)"s");
        this.moduleSelector.reset((ModuleBasedConfiguration)s);
        DelegateEditor editor = this.delegateEditor;
        if (editor != null && (delegateConfig = s.getDelegateConfiguration()) != null) {
            RunManager runManager = RunManager.Companion.getInstance(this.project);
            ConfigurationFactory configurationFactory = delegateConfig.getFactory();
            Intrinsics.checkNotNull((Object)configurationFactory);
            Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"delegateConfig.factory!!");
            RunnerAndConfigurationSettings settings = runManager.createConfiguration(delegateConfig, configurationFactory);
            editor.getEditor().resetEditorFrom((Object)settings);
        }
    }

    protected void applyEditorTo(@NotNull QsRunConfiguration s) {
        Intrinsics.checkNotNullParameter((Object)((Object)s), (String)"s");
        s.setModule(this.moduleSelector.getModule());
        DelegateEditor editor = this.delegateEditor;
        if (editor != null) {
            editor.getEditor().applyEditorTo((Object)editor.getSettings());
            s.setDelegateConfiguration(editor.getSettings().getConfiguration());
        }
    }

    @NotNull
    protected JComponent createEditor() {
        return this.mainPanel;
    }

    private final void installHideableDecorator(JPanel panel2, JComponent content, @NlsContexts.Separator String title, String expandPropertyKey, boolean defaultState) {
        HideableDecorator hideableDecorator2 = new HideableDecorator(this, expandPropertyKey, defaultState, panel2, title, panel2, title, false){
            final /* synthetic */ QsRunConfigurationSettingEditor this$0;
            final /* synthetic */ String $expandPropertyKey;
            final /* synthetic */ boolean $defaultState;
            final /* synthetic */ JPanel $panel;
            final /* synthetic */ String $title;

            protected void on() {
                super.on();
                this.storeState();
            }

            protected void off() {
                super.off();
                this.storeState();
            }

            private final void storeState() {
                PropertiesComponent.getInstance((Project)QsRunConfigurationSettingEditor.access$getProject$p(this.this$0)).setValue(this.$expandPropertyKey, this.isExpanded(), this.$defaultState);
            }
            {
                this.this$0 = this$0;
                this.$expandPropertyKey = $captured_local_variable$1;
                this.$defaultState = $captured_local_variable$2;
                this.$panel = $captured_local_variable$3;
                this.$title = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
        hideableDecorator2.setOn(PropertiesComponent.getInstance((Project)this.project).getBoolean(expandPropertyKey, defaultState));
        hideableDecorator2.setContentComponent(content);
    }

    public QsRunConfigurationSettingEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.mainPanel = new JPanel(new BorderLayout());
        LabeledComponent labeledComponent = LabeledComponent.create((JComponent)((JComponent)new ModuleDescriptionsComboBox()), (String)QuarkusBundle.message("run.configuration.application.module", new Object[0]), (String)"West");
        Intrinsics.checkNotNullExpressionValue((Object)labeledComponent, (String)"LabeledComponent.create(\u2026       BorderLayout.WEST)");
        this.moduleComponent = labeledComponent;
        this.environmentSettingsPanel = new JPanel(new BorderLayout());
        this.emptyEnvironmentPanel = new JPanel(new BorderLayout());
        this.moduleSelector = new ConfigurationModuleSelector(this.project, (ModuleDescriptionsComboBox)this.moduleComponent.getComponent()){

            public boolean isModuleAccepted(@NotNull Module module) {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                return QuarkusUtils.INSTANCE.hasQuarkusLibrary(module);
            }
        };
        this.moduleSelector.reset();
        ((ModuleDescriptionsComboBox)this.moduleComponent.getComponent()).addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                DelegateEditor delegateEditor;
                RunConfiguration delegate;
                Component[] components = environmentSettingsPanel.getComponents();
                DelegateEditor oldEditor = delegateEditor;
                Module module = (moduleSelector).getModule();
                RunConfiguration runConfiguration = delegate = module == null ? null : QsExternalSystemBridge.Companion.findDelegate(module);
                if (delegate != null && Intrinsics.areEqual((Object)((delegateEditor = oldEditor) != null && (delegateEditor = delegateEditor.getSettings()) != null ? delegateEditor.getType() : null), (Object)delegate.getType())) {
                    Project project = delegate.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"delegate.project");
                    RunManager runManager = RunManager.Companion.getInstance(project);
                    ConfigurationFactory configurationFactory = delegate.getFactory();
                    Intrinsics.checkNotNull((Object)configurationFactory);
                    Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"delegate.factory!!");
                    oldEditor.setSettings(runManager.createConfiguration(delegate, configurationFactory));
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)components, (String)"components");
                Component[] componentArray = components;
                boolean bl = false;
                Component[] componentArray2 = componentArray;
                boolean bl2 = false;
                if (!(componentArray2.length == 0)) {
                    environmentSettingsPanel.remove(0);
                }
                if (delegate == null) {
                    environmentSettingsPanel.add((Component)emptyEnvironmentPanel, "Center");
                    delegateEditor = null;
                } else {
                    DelegateEditor newEditor = new DelegateEditor(delegate);
                    Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)newEditor.getEditor()));
                    environmentSettingsPanel.add((Component)newEditor.getEditor().getComponent(), "Center");
                    newEditor.getEditor().resetEditorFrom((Object)newEditor.getSettings());
                    delegateEditor = newEditor;
                }
                if (oldEditor != null) {
                    Disposer.dispose((Disposable)((Disposable)oldEditor.getEditor()));
                }
            }
        });
        this.mainPanel.add((Component)this.moduleComponent, "North");
        JPanel hideableEnvironmentSettingsPanel = new JPanel(new BorderLayout());
        this.installHideableDecorator(hideableEnvironmentSettingsPanel, this.environmentSettingsPanel, QuarkusBundle.message("run.configuration.environment", new Object[0]), "ExpandQuarkusEnvironmentOptionsPanel", false);
        this.mainPanel.add((Component)hideableEnvironmentSettingsPanel, "Center");
        this.emptyEnvironmentPanel.add((Component)new JBLabel(" "), "West");
        this.emptyEnvironmentPanel.add((Component)new JBLabel(" "), "East");
        this.emptyEnvironmentPanel.add((Component)new JBPanelWithEmptyText().withEmptyText(QuarkusBundle.message("run.configuration.no.module.selected", new Object[0])), "Center");
        this.environmentSettingsPanel.add((Component)this.emptyEnvironmentPanel, "Center");
    }

    public static final /* synthetic */ Project access$getProject$p(QsRunConfigurationSettingEditor $this) {
        return $this.project;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/quarkus/run/QsRunConfigurationSettingEditor$DelegateEditor;", "", "delegate", "Lcom/intellij/execution/configurations/RunConfiguration;", "(Lcom/intellij/execution/configurations/RunConfiguration;)V", "editor", "Lcom/intellij/execution/impl/ConfigurationSettingsEditor;", "getEditor", "()Lcom/intellij/execution/impl/ConfigurationSettingsEditor;", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "getSettings", "()Lcom/intellij/execution/RunnerAndConfigurationSettings;", "setSettings", "(Lcom/intellij/execution/RunnerAndConfigurationSettings;)V", "intellij.quarkus"})
    private static final class DelegateEditor {
        @NotNull
        private RunnerAndConfigurationSettings settings;
        @NotNull
        private final ConfigurationSettingsEditor editor;

        @NotNull
        public final RunnerAndConfigurationSettings getSettings() {
            return this.settings;
        }

        public final void setSettings(@NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
            Intrinsics.checkNotNullParameter((Object)runnerAndConfigurationSettings, (String)"<set-?>");
            this.settings = runnerAndConfigurationSettings;
        }

        @NotNull
        public final ConfigurationSettingsEditor getEditor() {
            return this.editor;
        }

        public DelegateEditor(@NotNull RunConfiguration delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            SettingsEditor settingsEditor = delegate.getConfigurationEditor();
            if (settingsEditor == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.options.SettingsEditor<com.intellij.execution.configurations.RunConfiguration>");
            }
            SettingsEditor delegateEditor = settingsEditor;
            Project project = delegate.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"delegate.project");
            RunManager runManager = RunManager.Companion.getInstance(project);
            ConfigurationFactory configurationFactory = delegate.getFactory();
            Intrinsics.checkNotNull((Object)configurationFactory);
            Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"delegate.factory!!");
            this.settings = runManager.createConfiguration(delegate, configurationFactory);
            this.editor = new ConfigurationSettingsEditor(this.settings, delegateEditor);
        }
    }
}

