/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.quarkus.run.QsRunConfiguration;
import com.intellij.quarkus.run.QsRunConfigurationType;
import com.intellij.quarkus.run.QsServerConfiguration;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/quarkus/run/QsRunConfigurationService;", "", "()V", "createRunConfiguration", "", "module", "Lcom/intellij/openapi/module/Module;", "doCreateRunConfiguration", "runManager", "Lcom/intellij/execution/RunManager;", "Companion", "intellij.quarkus"})
public final class QsRunConfigurationService {
    @NotNull
    private static final Key<QsServerConfiguration> SERVER_CONFIGURATION_KEY;
    @NotNull
    private static final Key<Integer> APPLICATION_SERVER_PORT_KEY;
    @NotNull
    public static final Companion Companion;

    public final void createRunConfiguration(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        VirtualFile[] virtualFileArray = moduleRootManager.getSourceRoots(false);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"moduleRootManager.getSourceRoots(false)");
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        boolean bl = false;
        if (virtualFileArray2.length == 0) {
            return;
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        RunManager runManager = RunManager.Companion.getInstance(project);
        List list = ContainerUtil.findAll((Collection)runManager.getConfigurationsList((ConfigurationType)QsRunConfigurationType.Companion.getInstance()), QsRunConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ContainerUtil.findAll(\n \u2026onfiguration::class.java)");
        List allConfigs = list;
        Iterator iterator = allConfigs.iterator();
        while (iterator.hasNext()) {
            QsRunConfiguration config;
            QsRunConfiguration qsRunConfiguration = config = (QsRunConfiguration)((Object)iterator.next());
            Intrinsics.checkNotNullExpressionValue((Object)((Object)qsRunConfiguration), (String)"config");
            RunConfigurationModule runConfigurationModule = qsRunConfiguration.getConfigurationModule();
            Intrinsics.checkNotNullExpressionValue((Object)runConfigurationModule, (String)"config.configurationModule");
            if (!Intrinsics.areEqual((Object)module, (Object)runConfigurationModule.getModule())) continue;
            return;
        }
        this.doCreateRunConfiguration(module, runManager);
    }

    private final void doCreateRunConfiguration(Module module, RunManager runManager) {
        try {
            RunnerAndConfigurationSettings settings = runManager.createConfiguration("", QsRunConfigurationType.Companion.getInstance().getConfigurationFactories()[0]);
            RunConfiguration runConfiguration = settings.getConfiguration();
            if (runConfiguration == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.quarkus.run.QsRunConfiguration");
            }
            QsRunConfiguration newRunConfig = (QsRunConfiguration)runConfiguration;
            newRunConfig.setModule(module);
            settings.setName(newRunConfig.suggestedName());
            runManager.setUniqueNameIfNeeded(settings);
            runManager.addConfiguration(settings);
            if (runManager.getAllSettings().size() == 1) {
                runManager.setSelectedConfiguration(settings);
            }
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Throwable t) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(QsRunConfigurationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("Error creating Quarkus run configuration for module " + module.getName(), t);
        }
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"QUARKUS_SERVER_CONFIGURATION");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"QUARKUS_SERVER_CONFIGURATION\")");
        SERVER_CONFIGURATION_KEY = key;
        Key key2 = Key.create((String)"QUARKUS_APPLICATION_SERVER_PORT");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create(\"QUARKUS_APPLICATION_SERVER_PORT\")");
        APPLICATION_SERVER_PORT_KEY = key2;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/quarkus/run/QsRunConfigurationService$Companion;", "", "()V", "APPLICATION_SERVER_PORT_KEY", "Lcom/intellij/openapi/util/Key;", "", "getAPPLICATION_SERVER_PORT_KEY", "()Lcom/intellij/openapi/util/Key;", "SERVER_CONFIGURATION_KEY", "Lcom/intellij/quarkus/run/QsServerConfiguration;", "getSERVER_CONFIGURATION_KEY", "getInstance", "Lcom/intellij/quarkus/run/QsRunConfigurationService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.quarkus"})
    public static final class Companion {
        @NotNull
        public final Key<QsServerConfiguration> getSERVER_CONFIGURATION_KEY() {
            return SERVER_CONFIGURATION_KEY;
        }

        @NotNull
        public final Key<Integer> getAPPLICATION_SERVER_PORT_KEY() {
            return APPLICATION_SERVER_PORT_KEY;
        }

        @NotNull
        public final QsRunConfigurationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(QsRunConfigurationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (QsRunConfigurationService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

