/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.run.QsExternalSystemBridge;
import com.intellij.quarkus.run.QsRunConfigurationSettingEditor;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\nH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\rH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0003H\u0016J\u0012\u0010)\u001a\u00020\u00172\b\u0010*\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010+\u001a\u00020\u00172\b\u0010,\u001a\u0004\u0018\u00010&H\u0016J\n\u0010-\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0003H\u0016R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006/"}, d2={"Lcom/intellij/quarkus/run/QsRunConfiguration;", "Lcom/intellij/execution/configurations/ModuleBasedConfiguration;", "Lcom/intellij/execution/configurations/RunConfigurationModule;", "Lorg/jdom/Element;", "Lcom/intellij/execution/target/TargetEnvironmentAwareRunProfile;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "delegateConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "getDelegateConfiguration", "()Lcom/intellij/execution/configurations/RunConfiguration;", "setDelegateConfiguration", "(Lcom/intellij/execution/configurations/RunConfiguration;)V", "canRunOn", "", "target", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "checkConfiguration", "", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "getDefaultLanguageRuntimeType", "Lcom/intellij/execution/target/LanguageRuntimeType;", "getDefaultTargetName", "getDelegate", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getValidModules", "", "Lcom/intellij/openapi/module/Module;", "readExternal", "element", "setDefaultTargetName", "targetName", "setModule", "module", "suggestedName", "writeExternal", "intellij.quarkus"})
public final class QsRunConfiguration
extends ModuleBasedConfiguration<RunConfigurationModule, Element>
implements TargetEnvironmentAwareRunProfile {
    @Nullable
    private volatile RunConfiguration delegateConfiguration;

    @Nullable
    public final RunConfiguration getDelegateConfiguration() {
        return this.delegateConfiguration;
    }

    public final void setDelegateConfiguration(@Nullable RunConfiguration runConfiguration) {
        this.delegateConfiguration = runConfiguration;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        RunConfiguration delegate;
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RunConfiguration runConfiguration = delegate = this.getDelegate();
        if (runConfiguration != null) {
            runConfiguration.setName(this.getName());
        }
        RunConfiguration runConfiguration2 = delegate;
        return runConfiguration2 != null ? runConfiguration2.getState(executor, environment) : null;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return new QsRunConfigurationSettingEditor(project);
    }

    @NotNull
    public Collection<Module> getValidModules() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (!QuarkusUtils.INSTANCE.hasQuarkusLibrary(project)) {
            return CollectionsKt.emptyList();
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] modules = moduleManager.getModules();
        ArrayList<Module> result = new ArrayList<Module>();
        Module[] moduleArray = modules;
        int n = moduleArray.length;
        for (int i = 0; i < n; ++i) {
            Module module;
            Module module2 = module = moduleArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
            if (!QuarkusUtils.INSTANCE.hasQuarkusLibrary(module2)) continue;
            result.add(module);
        }
        return result;
    }

    @Nullable
    public String suggestedName() {
        RunConfigurationModule runConfigurationModule = this.getConfigurationModule();
        Intrinsics.checkNotNullExpressionValue((Object)runConfigurationModule, (String)"configurationModule");
        Module module = runConfigurationModule.getModule();
        return module != null ? module.getName() : null;
    }

    public void setModule(@Nullable Module module) {
        super.setModule(module);
        if (module != null && this.delegateConfiguration == null) {
            this.delegateConfiguration = QsExternalSystemBridge.Companion.findDelegate(module);
        }
    }

    public void readExternal(@NotNull Element element) {
        RunConfiguration delegate;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        RunConfigurationModule runConfigurationModule = this.getConfigurationModule();
        Intrinsics.checkNotNullExpressionValue((Object)runConfigurationModule, (String)"configurationModule");
        Module module = runConfigurationModule.getModule();
        if (module == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"configurationModule.module ?: return");
        Module module2 = module;
        this.delegateConfiguration = delegate = QsExternalSystemBridge.Companion.findDelegate(module2);
        if (delegate != null) {
            Element element2 = element.getChild(delegate.getClass().getSimpleName());
            if (element2 == null) {
                return;
            }
            Element delegateElement = element2;
            delegate.readExternal(delegateElement);
        } else {
            for (QsExternalSystemBridge bridge : QsExternalSystemBridge.Companion.getEP_NAME().getExtensionList()) {
                delegate = bridge.createDelegateConfiguration(module2);
                Element element3 = element.getChild(delegate.getClass().getSimpleName());
                if (element3 == null) {
                    continue;
                }
                Element delegateElement = element3;
                delegate.readExternal(delegateElement);
                this.delegateConfiguration = delegate;
                return;
            }
        }
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        RunConfiguration delegate = this.delegateConfiguration;
        if (delegate == null) {
            return;
        }
        Element delegateElement = new Element(delegate.getClass().getSimpleName());
        delegate.writeExternal(delegateElement);
        element.addContent(delegateElement);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.validateRunTarget(this.getProject());
    }

    public boolean canRunOn(@NotNull TargetEnvironmentConfiguration target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        RunConfiguration delegate = this.getDelegate();
        return delegate instanceof TargetEnvironmentAwareRunProfile && ((TargetEnvironmentAwareRunProfile)delegate).canRunOn(target);
    }

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        RunConfiguration delegate = this.getDelegate();
        if (delegate instanceof TargetEnvironmentAwareRunProfile) {
            return ((TargetEnvironmentAwareRunProfile)delegate).getDefaultLanguageRuntimeType();
        }
        return null;
    }

    private final RunConfiguration getDelegate() {
        RunConfiguration delegate = this.delegateConfiguration;
        if (delegate != null) {
            return delegate;
        }
        RunConfigurationModule runConfigurationModule = this.getConfigurationModule();
        Intrinsics.checkNotNullExpressionValue((Object)runConfigurationModule, (String)"configurationModule");
        Module module = runConfigurationModule.getModule();
        if (module == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"configurationModule.module ?: return null");
        Module module2 = module;
        return QsExternalSystemBridge.Companion.findDelegate(module2);
    }

    @Nullable
    public String getDefaultTargetName() {
        return this.getOptions().getRemoteTarget();
    }

    public void setDefaultTargetName(@Nullable String targetName) {
        this.getOptions().setRemoteTarget(targetName);
    }

    public QsRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory2, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name, new RunConfigurationModule(project), factory2);
    }
}

