/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.providers;

import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/quarkus/providers/QsImplicitUsageProvider;", "Lcom/intellij/codeInsight/daemon/ImplicitUsageProvider;", "()V", "hasScheduledExecutionParameter", "", "method", "Lcom/intellij/psi/PsiMethod;", "isBeanCandidateClass", "containingClass", "Lcom/intellij/psi/PsiClass;", "isConfigSetterMethod", "isDeclaredInConfigPropertiesBean", "member", "Lcom/intellij/psi/PsiMember;", "isImplicitRead", "element", "Lcom/intellij/psi/PsiElement;", "isImplicitUsage", "isImplicitWrite", "isLocalizedClass", "isScheduledMethod", "intellij.quarkus"})
public final class QsImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitWrite(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof PsiField && this.isDeclaredInConfigPropertiesBean((PsiMember)element);
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return false;
    }

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PsiClass && this.isLocalizedClass((PsiClass)element)) {
            return true;
        }
        return element instanceof PsiMethod && !((PsiMethod)element).hasModifier(JvmModifier.STATIC) && (this.isConfigSetterMethod((PsiMethod)element) || this.isScheduledMethod((PsiMethod)element) || CdiInjectionUtils.isImplicitProducerMethod((PsiMethod)((PsiMethod)element)));
    }

    private final boolean isLocalizedClass(PsiClass element) {
        boolean bl;
        block2: {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (String)"io.quarkus.qute.i18n.Localized", (int)0)) {
                return false;
            }
            PsiClass[] psiClassArray = element.getSupers();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"element.supers");
            PsiClass[] $this$any$iv = psiClassArray;
            boolean $i$f$any = false;
            PsiClass[] psiClassArray2 = $this$any$iv;
            int n = psiClassArray2.length;
            for (int i = 0; i < n; ++i) {
                PsiClass element$iv;
                PsiClass it = element$iv = psiClassArray2[i];
                boolean bl2 = false;
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)it), (String)"io.quarkus.qute.i18n.MessageBundle", (int)0)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isConfigSetterMethod(PsiMethod method) {
        boolean bl;
        block4: {
            String string = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
            if (!StringsKt.startsWith$default((String)string, (String)"set", (boolean)false, (int)2, null)) {
                return false;
            }
            PsiParameterList psiParameterList = method.getParameterList();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"method.parameterList");
            int parametersCount = psiParameterList.getParametersCount();
            if (parametersCount != 1) {
                return false;
            }
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"method.containingClass ?: return false");
            PsiClass containingClass = psiClass;
            String string2 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"method.name");
            String fieldName = StringsKt.decapitalize((String)StringsKt.replaceFirst$default((String)string2, (String)"set", (String)"", (boolean)false, (int)4, null));
            PsiField[] psiFieldArray = containingClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"containingClass.fields");
            PsiField[] $this$any$iv = psiFieldArray;
            boolean $i$f$any = false;
            PsiField[] psiFieldArray2 = $this$any$iv;
            int n = psiFieldArray2.length;
            for (int i = 0; i < n; ++i) {
                PsiField element$iv;
                PsiField it = element$iv = psiFieldArray2[i];
                boolean bl2 = false;
                PsiField psiField = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiField, (String)"it");
                if (!Intrinsics.areEqual((Object)psiField.getName(), (Object)fieldName)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl && this.isDeclaredInConfigPropertiesBean((PsiMember)method);
    }

    private final boolean isDeclaredInConfigPropertiesBean(PsiMember member) {
        PsiClass psiClass = member.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"member.containingClass ?: return false");
        PsiClass containingClass = psiClass;
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)containingClass), (String)"io.quarkus.arc.config.ConfigProperties", (int)0)) {
            return true;
        }
        PsiElement classParent = containingClass.getParent();
        return classParent instanceof PsiClass && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)classParent), (String)"io.quarkus.arc.config.ConfigProperties", (int)0);
    }

    private final boolean isScheduledMethod(PsiMethod method) {
        return !method.hasModifier(JvmModifier.ABSTRACT) && !method.hasModifier(JvmModifier.STATIC) && !method.hasModifier(JvmModifier.PRIVATE) && Intrinsics.areEqual((Object)method.getReturnType(), (Object)PsiType.VOID) && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method), (String)"io.quarkus.scheduler.Scheduled", (int)1) && (!method.hasParameters() || this.hasScheduledExecutionParameter(method)) && this.isBeanCandidateClass(method.getContainingClass());
    }

    private final boolean isBeanCandidateClass(PsiClass containingClass) {
        if (containingClass == null || containingClass.hasModifier(JvmModifier.ABSTRACT) || containingClass.isEnum() || containingClass.isAnnotationType() || PsiUtil.isLocalOrAnonymousClass((PsiClass)containingClass)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)containingClass));
        if (module == null) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)containingClass), (Collection)CdiCommonUtils.getBeanDefiningAnnotations((Module)module), (int)0);
    }

    private final boolean hasScheduledExecutionParameter(PsiMethod method) {
        if (method.getParameters().length != 1) {
            return false;
        }
        PsiParameter psiParameter = method.getParameterList().getParameter(0);
        if (psiParameter == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiParameter, (String)"method.parameterList.get\u2026ameter(0) ?: return false");
        PsiParameter parameter = psiParameter;
        return method.getParameters().length == 1 && TypeUtils.typeEquals((String)"io.quarkus.scheduler.ScheduledExecution", (PsiType)parameter.getType());
    }
}

