/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.jam.cache;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.quarkus.QsLineMarkerBuilder;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.jam.cache.QsCacheLineMarker;
import com.intellij.quarkus.jam.cache.model.QsCacheBaseElement;
import com.intellij.quarkus.jam.cache.model.QsCacheInvalidate;
import com.intellij.quarkus.jam.cache.model.QsCacheInvalidateAll;
import com.intellij.quarkus.jam.cache.model.QsCacheInvalidateAllList;
import com.intellij.quarkus.jam.cache.model.QsCacheInvalidateList;
import com.intellij.quarkus.jam.cache.model.QsCacheList;
import com.intellij.quarkus.jam.cache.model.QsCacheResult;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemService;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Query;
import icons.JavaUltimateIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0014J4\u0010\u0003\u001a\u00020\u00042\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000b2\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0006\u0010\f\u001a\u00020\rH\u0016J,\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J$\u0010\u0017\u001a\u00020\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u0013H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/quarkus/jam/cache/QsCacheLineMarker;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerProvider;", "()V", "collectNavigationMarkers", "", "element", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "elements", "", "forNavigation", "", "doAnnotateCacheable", "elementToAnnotate", "cacheableElement", "Lcom/intellij/quarkus/jam/cache/model/QsCacheBaseElement;", "findCacheableWithTheSameName", "", "getId", "", "getName", "hasSameNames", "names1", "names2", "Companion", "intellij.quarkus"})
public final class QsCacheLineMarker
extends RelatedItemLineMarkerProvider {
    private static final NotNullFunction<QsCacheBaseElement, Collection<? extends PsiElement>> CACHEABLE_CONVERTOR;
    private static final Companion.CACHEABLE_CELL_RENDERER.1 CACHEABLE_CELL_RENDERER;
    private static final Set<Pair<String, SemKey<? extends QsCacheBaseElement>>> CACHE_ANNOTATIONS;
    private static final Set<Pair<String, SemKey<? extends QsCacheList>>> CACHE_OPS_ANNOTATIONS;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getId() {
        return "QsCacheLineMarker";
    }

    @NotNull
    public String getName() {
        return QuarkusBundle.message("quarkus.cache.line.marker.name", new Object[0]);
    }

    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                Intrinsics.checkNotNullParameter(result, (String)"result");
                PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
                if (psiElement == null) break block2;
                Project project = psiElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
                if (QuarkusUtils.INSTANCE.hasQuarkusCache(project)) break block3;
            }
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        UDeclaration elementToProcess = UAnnotationUtils.getIdentifierAnnotationOwner((PsiElement)element);
        if (!(elementToProcess instanceof UMethod) && !(elementToProcess instanceof UClass)) {
            return;
        }
        if (elementToProcess.getJavaPsi() == null) {
            return;
        }
        PsiElement psiElement = elementToProcess.getJavaPsi();
        Intrinsics.checkNotNull((Object)psiElement);
        Set<QsCacheBaseElement> cacheableElements = Companion.findAllCacheable(psiElement);
        Iterable $this$forEach$iv = cacheableElements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            QsCacheBaseElement cacheableElement = (QsCacheBaseElement)element$iv;
            boolean bl = false;
            this.doAnnotateCacheable(element, result, cacheableElement);
        }
    }

    private final void doAnnotateCacheable(PsiElement elementToAnnotate, Collection<? super RelatedItemLineMarkerInfo<?>> result, QsCacheBaseElement cacheableElement) {
        PsiElement psiAnnotationIdentifier = UAnnotationUtils.getNameElement((UElement)UastContextKt.toUElement((PsiElement)((PsiElement)cacheableElement.getAnnotation())));
        if (Intrinsics.areEqual((Object)psiAnnotationIdentifier, (Object)elementToAnnotate)) {
            Set<QsCacheBaseElement> cacheableElements = this.findCacheableWithTheSameName(cacheableElement);
            Collection collection = cacheableElements;
            boolean bl = false;
            if (!collection.isEmpty()) {
                Icon icon = JavaUltimateIcons.Cdi.Gutter.ShowCacheable;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"JavaUltimateIcons.Cdi.Gutter.ShowCacheable");
                QsLineMarkerBuilder.CustomNavigationGutterIconBuilder<QsCacheBaseElement> customNavigationGutterIconBuilder = QsLineMarkerBuilder.createCustomNavigationBuilder(icon, CACHEABLE_CONVERTOR, null);
                boolean bl2 = false;
                boolean bl3 = false;
                QsLineMarkerBuilder.CustomNavigationGutterIconBuilder<QsCacheBaseElement> $this$apply = customNavigationGutterIconBuilder;
                boolean bl4 = false;
                $this$apply.setTargets(cacheableElements).setCellRenderer((PsiElementListCellRenderer)CACHEABLE_CELL_RENDERER);
                $this$apply.setPopupTitle(QuarkusBundle.message("quarkus.cache.element.choose.title", new Object[0]));
                $this$apply.setTooltipText(QuarkusBundle.message("quarkus.cache.element.tooltip.text", new Object[0]));
                QsLineMarkerBuilder.CustomNavigationGutterIconBuilder<QsCacheBaseElement> builder = customNavigationGutterIconBuilder;
                result.add(builder.createMergeableLineMarkerInfo(psiAnnotationIdentifier));
            }
        }
    }

    private final Set<QsCacheBaseElement> findCacheableWithTheSameName(QsCacheBaseElement cacheableElement) {
        PsiAnnotation psiElement = cacheableElement.getAnnotation();
        HashSet<QsCacheBaseElement> cacheableElements = new HashSet<QsCacheBaseElement>();
        Set<String> set = cacheableElement.getCacheNames();
        Intrinsics.checkNotNullExpressionValue(set, (String)"cacheableElement.cacheNames");
        Set<String> cacheNames = set;
        Collection collection = cacheNames;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Set<QsCacheBaseElement> allCacheable = Companion.findAllCacheable((PsiElement)psiElement);
            for (QsCacheBaseElement element : allCacheable) {
                Set<String> names;
                if (Intrinsics.areEqual((Object)element, (Object)cacheableElement)) continue;
                Intrinsics.checkNotNullExpressionValue(element.getCacheNames(), (String)"element.cacheNames");
                if (!this.hasSameNames(names, cacheNames)) continue;
                cacheableElements.add(element);
            }
        }
        return cacheableElements;
    }

    private final boolean hasSameNames(Set<String> names1, Set<String> names2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = names2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!names1.contains(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        Companion = new Companion(null);
        CACHEABLE_CONVERTOR = Companion.CACHEABLE_CONVERTOR.1.INSTANCE;
        CACHEABLE_CELL_RENDERER = new DefaultPsiElementCellRenderer(){

            @NotNull
            public String getElementText(@Nullable PsiElement element) {
                String string = super.getElementText(this.getElement(element));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"super.getElementText(getElement(element))");
                return string;
            }

            @NotNull
            protected Icon getIcon(@Nullable PsiElement element) {
                Icon icon = super.getIcon(this.getElement(element));
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"super.getIcon(getElement(element))");
                return icon;
            }

            @Nullable
            public String getContainerText(@Nullable PsiElement element, @Nullable String name) {
                return super.getContainerText(this.getElement(element), name);
            }

            private final PsiElement getElement(PsiElement element) {
                PsiMember psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
                return psiMember != null ? (PsiElement)psiMember : element;
            }
        };
        CACHE_ANNOTATIONS = SetsKt.setOf((Object[])new Pair[]{TuplesKt.to((Object)"io.quarkus.cache.CacheResult", QsCacheResult.JAM_KEY), TuplesKt.to((Object)"io.quarkus.cache.CacheInvalidate", QsCacheInvalidate.REPEATABLE_JAM_KEY), TuplesKt.to((Object)"io.quarkus.cache.CacheInvalidateAll", QsCacheInvalidateAll.REPEATABLE_JAM_KEY)});
        CACHE_OPS_ANNOTATIONS = SetsKt.setOf((Object[])new Pair[]{TuplesKt.to((Object)"io.quarkus.cache.CacheInvalidate.List", QsCacheInvalidateList.JAM_KEY), TuplesKt.to((Object)"io.quarkus.cache.CacheInvalidateAll.List", QsCacheInvalidateAllList.JAM_KEY)});
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000A\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\nR\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\"\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RH\u0010\u000b\u001a<\u00128\u00126\u0012\u0004\u0012\u00020\u000e\u0012,\u0012*\u0012\u000e\b\u0001\u0012\n \u0010*\u0004\u0018\u00010\b0\b \u0010*\u0014\u0012\u000e\b\u0001\u0012\n \u0010*\u0004\u0018\u00010\b0\b\u0018\u00010\u000f0\u000f0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RH\u0010\u0011\u001a<\u00128\u00126\u0012\u0004\u0012\u00020\u000e\u0012,\u0012*\u0012\u000e\b\u0001\u0012\n \u0010*\u0004\u0018\u00010\u00120\u0012 \u0010*\u0014\u0012\u000e\b\u0001\u0012\n \u0010*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u000f0\u000f0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/quarkus/jam/cache/QsCacheLineMarker$Companion;", "", "()V", "CACHEABLE_CELL_RENDERER", "com/intellij/quarkus/jam/cache/QsCacheLineMarker$Companion$CACHEABLE_CELL_RENDERER$1", "Lcom/intellij/quarkus/jam/cache/QsCacheLineMarker$Companion$CACHEABLE_CELL_RENDERER$1;", "CACHEABLE_CONVERTOR", "Lcom/intellij/util/NotNullFunction;", "Lcom/intellij/quarkus/jam/cache/model/QsCacheBaseElement;", "", "Lcom/intellij/psi/PsiElement;", "CACHE_ANNOTATIONS", "", "Lkotlin/Pair;", "", "Lcom/intellij/semantic/SemKey;", "kotlin.jvm.PlatformType", "CACHE_OPS_ANNOTATIONS", "Lcom/intellij/quarkus/jam/cache/model/QsCacheList;", "findAllCacheable", "psiElement", "intellij.quarkus"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<QsCacheBaseElement> findAllCacheable(@Nullable PsiElement psiElement) {
            void $this$flatMapTo$iv$iv;
            Iterable anno;
            Object element$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Project project;
            if (psiElement == null) {
                return SetsKt.emptySet();
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            if (module == null) {
                return SetsKt.emptySet();
            }
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026ent) ?: return emptySet()");
            Module module2 = module;
            GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.module\u2026AndLibrariesScope(module)");
            GlobalSearchScope scope = globalSearchScope;
            Project project2 = module2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
            Project $this$service$iv = project = project2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(JavaPsiFacade.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            JavaPsiFacade javaPsiFacade = (JavaPsiFacade)object;
            LinkedHashSet result = new LinkedHashSet();
            Project $this$service$iv2 = project;
            boolean $i$f$service2 = false;
            Object object2 = $this$service$iv2.getService(JamService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getService(T::class.java)");
            JamService jamService = (JamService)object2;
            Project $this$service$iv3 = project;
            boolean $i$f$service3 = false;
            Object object3 = $this$service$iv3.getService(SemService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getService(T::class.java)");
            SemService semService = (SemService)object3;
            Function3 semElementsMapper2 = (Function3)new Function3<PsiModifierListOwner, String, SemKey<? extends QsCacheBaseElement>, List<? extends QsCacheBaseElement>>(semService){
                final /* synthetic */ SemService $semService;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<QsCacheBaseElement> invoke(@NotNull PsiModifierListOwner psiMember, @NotNull String anno, @NotNull SemKey<? extends QsCacheBaseElement> semKey) {
                    void $this$flatMapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)psiMember, (String)"psiMember");
                    Intrinsics.checkNotNullParameter((Object)anno, (String)"anno");
                    Intrinsics.checkNotNullParameter(semKey, (String)"semKey");
                    PsiAnnotation[] psiAnnotationArray = AnnotationUtil.findAnnotations((PsiModifierListOwner)psiMember, (Collection)CollectionsKt.listOf((Object)anno));
                    Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"AnnotationUtil.findAnnot\u2026(psiMember, listOf(anno))");
                    PsiAnnotation[] $this$flatMap$iv = psiAnnotationArray;
                    boolean $i$f$flatMap = false;
                    PsiAnnotation[] psiAnnotationArray2 = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    void var9_9 = $this$flatMapTo$iv$iv;
                    int n = ((void)var9_9).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv$iv;
                        void psiAnnotation = element$iv$iv = var9_9[i];
                        boolean bl = false;
                        Iterable list$iv$iv = this.$semService.getSemElements(semKey, (PsiElement)psiAnnotation);
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
                {
                    this.$semService = semService;
                    super(3);
                }
            };
            Collection collection = result;
            Iterable $this$mapNotNull$iv = CACHE_ANNOTATIONS;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                List list;
                Object element$iv$iv$iv;
                element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Pair $dstr$anno$key = (Pair)element$iv$iv;
                boolean bl2 = false;
                String string = (String)$dstr$anno$key.component1();
                SemKey key = (SemKey)$dstr$anno$key.component2();
                if (javaPsiFacade.findClass((String)((Object)anno), scope) == null) {
                    list = null;
                } else {
                    void $this$flatMapTo$iv$iv2;
                    void $this$flatMapTo$iv$iv3;
                    PsiClass annoClass;
                    Intrinsics.checkNotNullExpressionValue((Object)annoClass, (String)"javaPsiFacade.findClass(\u2026?: return@mapNotNull null");
                    Query query = AnnotatedElementsSearch.searchPsiClasses((PsiClass)annoClass, (SearchScope)((SearchScope)scope));
                    Intrinsics.checkNotNullExpressionValue((Object)query, (String)"AnnotatedElementsSearch.\u2026Classes(annoClass, scope)");
                    Iterable $this$flatMap$iv = (Iterable)query;
                    boolean $i$f$flatMap = false;
                    Iterable iterable2 = $this$flatMap$iv;
                    Iterable destination$iv$iv2 = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv2 : $this$flatMapTo$iv$iv3) {
                        PsiClass psiClass = (PsiClass)element$iv$iv2;
                        boolean bl3 = false;
                        PsiClass psiClass2 = psiClass;
                        Intrinsics.checkNotNullExpressionValue((Object)psiClass2, (String)"psiClass");
                        SemKey semKey = key;
                        Intrinsics.checkNotNullExpressionValue((Object)semKey, (String)"key");
                        Iterable list$iv$iv = (List)semElementsMapper2.invoke((Object)psiClass2, (Object)anno, (Object)semKey);
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    List classSemElements = (List)destination$iv$iv2;
                    Query query2 = AnnotatedElementsSearch.searchPsiMethods((PsiClass)annoClass, (SearchScope)((SearchScope)scope));
                    Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"AnnotatedElementsSearch.\u2026Methods(annoClass, scope)");
                    Iterable $this$flatMap$iv2 = (Iterable)query2;
                    boolean $i$f$flatMap2 = false;
                    destination$iv$iv2 = $this$flatMap$iv2;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$flatMapTo2 = false;
                    for (Object element$iv$iv3 : $this$flatMapTo$iv$iv2) {
                        PsiMethod psiMethod = (PsiMethod)element$iv$iv3;
                        boolean bl4 = false;
                        PsiMethod psiMethod2 = psiMethod;
                        Intrinsics.checkNotNullExpressionValue((Object)psiMethod2, (String)"psiMethod");
                        SemKey semKey = key;
                        Intrinsics.checkNotNullExpressionValue((Object)semKey, (String)"key");
                        Iterable list$iv$iv = (List)semElementsMapper2.invoke((Object)psiMethod2, (Object)anno, (Object)semKey);
                        CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                    }
                    List methodSemElements = (List)destination$iv$iv3;
                    list = CollectionsKt.plus((Collection)classSemElements, (Iterable)methodSemElements);
                }
                if (list == null) continue;
                List list2 = list;
                boolean bl5 = false;
                boolean bl6 = false;
                List it$iv$iv = list2;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            $i$f$mapNotNull = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)$this$mapNotNull$iv);
            collection = result;
            Iterable $this$flatMap$iv = CACHE_OPS_ANNOTATIONS;
            boolean $i$f$flatMap = false;
            $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv4 : $this$flatMapTo$iv$iv) {
                void $this$flatMapTo$iv$iv4;
                void anno2;
                Pair $dstr$anno$key = (Pair)element$iv$iv4;
                boolean bl = false;
                element$iv$iv = (String)$dstr$anno$key.component1();
                SemKey key = (SemKey)$dstr$anno$key.component2();
                List list = jamService.getJamMethodElements(key, (String)anno2, scope);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jamService.getJamMethodElements(key, anno, scope)");
                Iterable $this$flatMap$iv3 = list;
                boolean $i$f$flatMap3 = false;
                anno = $this$flatMap$iv3;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$flatMapTo3 = false;
                for (Object element$iv$iv5 : $this$flatMapTo$iv$iv4) {
                    QsCacheList it = (QsCacheList)element$iv$iv5;
                    boolean bl8 = false;
                    QsCacheList qsCacheList = it;
                    Intrinsics.checkNotNullExpressionValue((Object)qsCacheList, (String)"it");
                    Iterable list$iv$iv = qsCacheList.getListeners();
                    CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv4;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable iterable3 = (List)destination$iv$iv;
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable3);
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

