/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.quarkus.QuarkusBundle;
import com.intellij.quarkus.QuarkusConstantsKt;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.inspections.QsLocalInspectionTool;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.ws.rest.constants.RSAnnotations;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J-\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0010J-\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018J#\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u001bJ \u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/quarkus/inspections/QsUndeclaredPathMimeTypesInspection;", "Lcom/intellij/quarkus/inspections/QsLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkMethod", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "(Lorg/jetbrains/uast/UMethod;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "createFixes", "Lcom/intellij/codeInspection/LocalQuickFix;", "annotationFqn", "", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "containingClass", "(Ljava/lang/String;Lcom/intellij/psi/PsiModifierListOwner;Lcom/intellij/psi/PsiModifierListOwner;)[Lcom/intellij/codeInspection/LocalQuickFix;", "genValueAttr", "Lcom/intellij/psi/PsiNameValuePair;", "(Ljava/lang/String;Lcom/intellij/psi/PsiModifierListOwner;)[Lcom/intellij/psi/PsiNameValuePair;", "hasMimeAnnotation", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "Lcom/intellij/psi/PsiClass;", "AddMimeAnnotationFix", "intellij.quarkus"})
public final class QsUndeclaredPathMimeTypesInspection
extends QsLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
        if (module == null || !RSUtils.hasRestLibrary((Module)module)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return super.buildVisitor(holder, isOnTheFly);
    }

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull UMethod uMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor());
        if (psiElement == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiElement nameIdentifier = psiElement;
        PsiMethod psiMethod = uMethod.getJavaPsi();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiMethod));
        if (module == null || !QuarkusUtils.INSTANCE.hasQuarkusLibrary(module)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"psiMethod.containingClas\u2026lemDescriptor.EMPTY_ARRAY");
        PsiClass containingClass = psiClass;
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)containingClass), (String)RSAnnotations.PATH.javax(), (int)0)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiElement sourcePsi = uMethod.getSourcePsi();
        if (!(sourcePsi instanceof PsiModifierListOwner)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiAnnotation psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiModifierListOwner)psiMethod), (Collection)RSAnnotations.HTTP_ANNOTATIONS);
        if (psiAnnotation == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"AnnotationUtil.findAnnot\u2026lemDescriptor.EMPTY_ARRAY");
        PsiAnnotation annotation = psiAnnotation;
        ProblemsHolder holder = new ProblemsHolder(manager, nameIdentifier.getContainingFile(), isOnTheFly);
        String string = annotation.getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"annotation.qualifiedName!!");
        String annotationFqn = string;
        String consumesAnno = RSAnnotations.CONSUMES.fqn(module);
        if (QuarkusConstantsKt.getQUARKUS_CONSUMES_ANNOTATIONS().contains(annotationFqn)) {
            String string2 = consumesAnno;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"consumesAnno");
            if (!this.hasMimeAnnotation(psiMethod, containingClass, string2)) {
                Object[] objectArray = new Object[1];
                String string3 = StringUtil.getShortName((String)consumesAnno);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringUtil.getShortName(consumesAnno)");
                objectArray[0] = string3;
                LocalQuickFix[] localQuickFixArray = this.createFixes(consumesAnno, (PsiModifierListOwner)sourcePsi, (PsiModifierListOwner)containingClass);
                holder.registerProblem(nameIdentifier, QuarkusBundle.message("inspection.message.undeclared.path.mime.types", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
            }
        }
        String producesAnno = RSAnnotations.PRODUCES.fqn(module);
        if (QuarkusConstantsKt.getQUARKUS_PRODUCES_ANNOTATIONS().contains(annotationFqn)) {
            String string4 = producesAnno;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"producesAnno");
            if (!this.hasMimeAnnotation(psiMethod, containingClass, string4)) {
                Object[] objectArray = new Object[1];
                String string5 = StringUtil.getShortName((String)producesAnno);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringUtil.getShortName(producesAnno)");
                objectArray[0] = string5;
                LocalQuickFix[] localQuickFixArray = this.createFixes(producesAnno, (PsiModifierListOwner)sourcePsi, (PsiModifierListOwner)containingClass);
                holder.registerProblem(nameIdentifier, QuarkusBundle.message("inspection.message.undeclared.path.mime.types", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
            }
        }
        return holder.getResultsArray();
    }

    private final boolean hasMimeAnnotation(PsiMethod psiMethod, PsiClass containingClass, String annotationFqn) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)containingClass), (String)annotationFqn, (int)1) || AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiMethod), (String)annotationFqn, (int)0);
    }

    private final LocalQuickFix[] createFixes(String annotationFqn, PsiModifierListOwner owner, PsiModifierListOwner containingClass) {
        return (LocalQuickFix[])new AddMimeAnnotationFix[]{new AddMimeAnnotationFix(annotationFqn, owner, this.genValueAttr(annotationFqn, owner)), new AddMimeAnnotationFix(annotationFqn, containingClass, this.genValueAttr(annotationFqn, containingClass))};
    }

    private final PsiNameValuePair[] genValueAttr(String annotationFqn, PsiModifierListOwner owner) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)owner.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)javaPsiFacade, (String)"JavaPsiFacade.getInstance(owner.project)");
        PsiElementFactory psiElementFactory = javaPsiFacade.getElementFactory();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"JavaPsiFacade.getInstanc\u2026r.project).elementFactory");
        PsiElementFactory elementFactory = psiElementFactory;
        PsiAnnotation psiAnnotation = elementFactory.createAnnotationFromText('@' + annotationFqn + "(value = \"/\")", (PsiElement)owner);
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"elementFactory.createAnn\u2026}(value = \\\"/\\\")\", owner)");
        PsiAnnotation newAnnotation = psiAnnotation;
        PsiAnnotationParameterList psiAnnotationParameterList = newAnnotation.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationParameterList, (String)"newAnnotation.parameterList");
        PsiNameValuePair[] psiNameValuePairArray = psiAnnotationParameterList.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)psiNameValuePairArray, (String)"newAnnotation.parameterList.attributes");
        return psiNameValuePairArray;
    }

    public QsUndeclaredPathMimeTypesInspection() {
        super(UMethod.class);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0096\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/quarkus/inspections/QsUndeclaredPathMimeTypesInspection$AddMimeAnnotationFix;", "Lcom/intellij/codeInsight/intention/AddAnnotationFix;", "annotationFqn", "", "modifierListOwner", "Lcom/intellij/psi/PsiModifierListOwner;", "values", "", "Lcom/intellij/psi/PsiNameValuePair;", "(Ljava/lang/String;Lcom/intellij/psi/PsiModifierListOwner;[Lcom/intellij/psi/PsiNameValuePair;)V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.quarkus"})
    private static final class AddMimeAnnotationFix
    extends AddAnnotationFix {
        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            super.invoke(project, file, startElement, endElement);
            PsiAnnotation psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiModifierListOwner)startElement), (String[])new String[]{this.myAnnotation});
            if (psiAnnotation == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"AnnotationUtil.findAnnot\u2026, myAnnotation) ?: return");
            PsiAnnotation annotation = psiAnnotation;
            PsiNavigateUtil.navigate((PsiElement)((PsiElement)AnnotationUtil.findDeclaredAttribute((PsiAnnotation)annotation, (String)"value")));
        }

        public AddMimeAnnotationFix(@NotNull String annotationFqn, @NotNull PsiModifierListOwner modifierListOwner, @NotNull PsiNameValuePair[] values) {
            Intrinsics.checkNotNullParameter((Object)annotationFqn, (String)"annotationFqn");
            Intrinsics.checkNotNullParameter((Object)modifierListOwner, (String)"modifierListOwner");
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            super(annotationFqn, modifierListOwner, values, new String[0]);
        }
    }
}

