/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.yaml;

import com.intellij.microservices.config.MetaConfigKey;
import com.intellij.microservices.config.MetaConfigKeyReference;
import com.intellij.microservices.config.MicroservicesConfigUtils;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.hints.QsHintReferencesProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/quarkus/config/yaml/QsYamlValueReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "()V", "canHaveMultipleValues", "", "valueElement", "Lorg/jetbrains/yaml/psi/YAMLValue;", "key", "Lcom/intellij/microservices/config/MetaConfigKey;", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "intellij.quarkus"})
public final class QsYamlValueReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        List list;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class);
        if (yAMLKeyValue == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"PsiReference.EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"PsiTreeUtil.getParentOfT\u2026 PsiReference.EMPTY_ARRAY");
        YAMLKeyValue yamlKeyValue = yAMLKeyValue;
        YAMLScalar yamlScalar = (YAMLScalar)element;
        if (yamlScalar.isMultiline()) {
        }
        Object[] placeholderReferences = QsConfigUtils.INSTANCE.createPlaceholderReferences(element);
        MetaConfigKey metaConfigKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)((PsiElement)yamlKeyValue));
        if (metaConfigKey == null) {
            return placeholderReferences;
        }
        Intrinsics.checkNotNullExpressionValue((Object)metaConfigKey, (String)"MetaConfigKeyReference.g\u2026urn placeholderReferences");
        MetaConfigKey key = metaConfigKey;
        if (this.canHaveMultipleValues(yamlKeyValue.getValue(), key)) {
            List list2 = MicroservicesConfigUtils.getListValueRanges((PsiElement)element);
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"MicroservicesConfigUtils\u2026tListValueRanges(element)");
        } else {
            list = CollectionsKt.listOf((Object)ElementManipulators.getValueTextRange((PsiElement)element));
        }
        List valueTextRanges = list;
        Object[] providerReferences = QsHintReferencesProvider.INSTANCE.getValueReferences(key, null, element, valueTextRanges, context);
        Object[] objectArray = ArrayUtil.mergeArrays((Object[])providerReferences, (Object[])placeholderReferences);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ArrayUtil.mergeArrays(pr\u2026s, placeholderReferences)");
        return (PsiReference[])objectArray;
    }

    private final boolean canHaveMultipleValues(YAMLValue valueElement, MetaConfigKey key) {
        if (valueElement instanceof YAMLSequence) {
            return false;
        }
        if (key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
            return false;
        }
        if (key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.INDEXED})) {
            return true;
        }
        PsiType psiType = key.getEffectiveValueType();
        if (psiType == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"key.effectiveValueType ?: return false");
        PsiType mapValueType = psiType;
        MetaConfigKey.AccessType mapValueAccessType = MetaConfigKey.AccessType.forPsiType((PsiType)mapValueType);
        return mapValueAccessType == MetaConfigKey.AccessType.INDEXED;
    }
}

